import httpRequest from "@/services/common";
import { userUrlConfig, authUrlConfig } from '@/services/config';
import { store } from '@/store/index'
import { LoginParm, LoginResult, UserInfo } from "@/services/types/user/userModel";
import { request } from '../config';

export async function getImagApi() {
    //获取验证码接口
    return await httpRequest.getImage(userUrlConfig["imageCode"])
}

//登录
export async function loginApi(params: LoginParm) {
    return await httpRequest.login<LoginResult>(userUrlConfig.login, params)
}

//获取用户信息
export const getInfoApi = async () => {
    return await httpRequest.post<UserInfo>(userUrlConfig.getUserInfo, {})
}

//添加用户
export const addUser = async (params: any) => {
    return await httpRequest.post(userUrlConfig['addUser'], params)
}

//编辑用户
export const editUser = async (params: any) => {
    return await httpRequest.put(userUrlConfig['editUser'], params)
}

//删除用户
export const deleteUser = async (params: any) => {
    return await httpRequest.delete(userUrlConfig['deleteUser'], params)
}

//查询用户(区别与上面的获取用户信息)
export const getUserInfo = async (params: any) => {
    return await httpRequest.get(userUrlConfig['getUser'], params)
}

//查询所有角色
export const getAllRole = async () => {
    return await httpRequest.get(authUrlConfig['getAllRole'])
}

//查询当前用户的角色
export const findRoleByUser = async (params: any) => {
    return await httpRequest.get(authUrlConfig['findRoleByUser'], params)
}

// 启用与禁用
export const userEnabled = (userId: number) => {
    return request({
        url: '/userAccount/enabled',
        method: 'post',
        data: { userId }
    })
}

