import { request } from '@/utils/request';

// 分类初始数据 /wx/catalog/index
export const getCatalogIndex = () => request('/wx/catalog/index', 'GET');

// 分类数据
export const getCatalogCurrent = (data: any) => request('/wx/catalog/current', 'GET', data);

// 分类详情数据
export const getGoodsCategory = (data: any) => request('/wx/goods/category', 'GET', data);

// 分类详情数据列表
export const getGoodsList = (data: any) => request('/wx/goods/list', 'GET', data);

// 专题精选数据列表
export const getTopicList = (data: any) => request('/wx/topic/list', 'GET', data);

// 专题精选数据列表
export const getTopicDetail = (id: number) => request('/wx/topic/detail', 'GET', { id });
