import { request } from '@/utils/request';

// 购物车初始数据
export const getCartIndex = (data: any) => request('/wx/cart/index', 'GET', data);

// 选择或取消商品
export const cartChecked = (data: any) => request('/wx/cart/checked', 'POST', data);

// 删除商品
export const cartDelete = (data: any) => request('/wx/cart/delete', 'POST', data);

// 更新商品
export const cartUpdate = (data: any) => request('/wx/cart/update', 'POST', data);

// 更新商品
export const downloadPdf = (data: string) => request('/wx/storage/download/' + data, 'GET');

// 查询pdf详细数据
export const getOrderPdf = (data: any) => request('/wx/order/orderPdfSource', 'GET', data);

// 报价-准备报价
export const quotationInit = (data: any) => request('/wx/quotation/init', 'GET', data);

// 报价-重新准备
export const quotationInitAgain = (data: any) => request('/wx/quotation/init_again', 'GET', data);

// 报价单-订单查询
export const quotationOrder = (data: any) => request('/wx/quotation/order', 'GET', data);

// 报价单-用户列表查询
export const quotationList = (data: any) => request('/wx/quotation/list', 'GET', data);

// 报价-填报报价
export const fillQuotation = (data: any) => request('/wx/quotation/filling', 'POST', data);

// 报价单-逻辑删除
export const deleteQuotation = (data: any) => request('/wx/quotation/delete', 'DELETE', data);

// 报价单-详细
export const quotationDetail = (data: any) => request('/wx/quotation/detail', 'POST', data);

// 报价单-execl下载
export const quotationDownload = (data: any) => request('/wx/quotation/download', 'GET', data);

// 报价单-是否存在
export const quotationExist = (data: any) => request('/wx/quotation/exist', 'GET', data);

// 再次加入购物车
export const orderCartAgain = (data: any) => request('/wx/order/cart/again', 'GET', data);

// 报价单-交货地址集合
export const getQuotationDelivery = () => request('/wx/quotation/delivery', 'GET');

// 报价单-收款条件集合
export const getQuotationPayment = () => request('/wx/quotation/payment', 'GET');