import { request } from '@/utils/request';

// 购物车初始数据
export const getCartIndex = () => request('/wx/cart/index', 'GET');

// 选择或取消商品
export const cartChecked = (data: any) => request('/wx/cart/checked', 'POST', data);

// 删除商品
export const cartDelete = (data: any) => request('/wx/cart/delete', 'POST', data);

// 更新商品
export const cartUpdate = (data: any) => request('/wx/cart/update', 'POST', data);

// 更新商品
export const downloadPdf = (data: string) => request('/wx/storage/download/' + data, 'GET');
