import { request } from '@/utils/request';

// 用户信息
export const getAuthInfo = () => request('/wx/auth/info', 'GET');

// 更新用户名
export const resetNickName = (data: any) => request('/wx/auth/reset_nick_name', 'POST', data);

// 更新手机号更新密码
export const resetByMobile = (data: any) => request('/wx/auth/reset_by_mobile', 'POST', data);

// 更新邮箱
export const resetEmail = (data: any) => request('/wx/auth/reset_mail', 'POST', data);

// 更新头像
export const resetAvatar = (data: any) => request('/wx/auth/reset_avatar', 'POST', data);

// 客户-收货人
export const consigneeList = (data?: any) => request('/wx/address/consignee', 'GET', data);

// 查询每个状态订单数
export const orderCount = () => request('/wx/user/index', 'GET');

// 更新发货地址
export const resetWorkAddr = (data: any) => request('/wx/auth/reset_work_addr', 'POST', data);

// 更新手机号
export const resetMobile = (data: any) => request('/wx/auth/reset_mobile', 'POST', data);

// 添加客户名称
export const addConsignee = (data: any) => request('/wx/address/consignee', 'POST', data);

// 删除客户
export const deleteConsignee = (data: any) => request('/wx/address/consignee/delete', 'POST', data);
