export const TokenKey: string = 'X-Litemall-Admin-Token';

// 获取指定缓存
export const getCache = (key: string) => {
	uni.getStorage({
		key: key,
		success: (res: any) => {
			return res.data;
		}
	});
};

// 获取缓存信息
export const getAllCache = () => {
	uni.getStorageInfo({
		success: (res: any) => {
			return res;
		}
	});
};

// 修改指定缓存
export const setCache = (key: string, data: any) => {
	uni.setStorage({
		key: key,
		data
	});
};

// 移除制定缓存
export const renoveCache = (key: any) => {
	uni.removeStorage({
		key
	});
};

// 清除本地缓存
export const clearCache = () => {
	uni.clearStorage();
};