import { request } from '@/utils/request';

// 主页数据
export const homeIndex = () => request('/wx/home/index', 'GET');

// 商品详情
export const indexDetails = (data: any) => request('/wx/goods/detail', 'GET', data);

// 加入购物车
export const addCart = (data: any) => request('/wx/cart/add', 'POST', data)

// 立即购买
export const fastaddCart = (data: any) => request('/wx/cart/fastadd', 'POST', data)

// 获取购买页面信息，地址，规格
export const checkoutCart = (data: any) => request('/wx/cart/checkout', 'GET', data)

// 地址
export const addressList = () => request('/wx/address/list', 'GET')

// 设置地址
export const cartCheckout = (data: any) => request('/wx/cart/checkout', 'GET', data)

// 提交订单
export const orderSubmit = (data: any) => request('/wx/order/submit', 'POST', data)

// 提交订单详细信息
export const orderDetail = (data: any) => request('/wx/order/detail', 'POST', data)