import { defineConfig } from "vite";
import uni from "@dcloudio/vite-plugin-uni";
// import pxtovw from 'postcss-px-to-viewport'
import { resolve } from 'path';
export default defineConfig({
  plugins: [uni()],
  resolve: {
    alias: {
      '@': resolve(__dirname, './src')
    }
  },
  css: {
    preprocessorOptions: {
      scss: {
        additionalData: `@import "@/uni.scss";`
      },
    },
    postcss: {
      // plugins: [loder_pxtovw]
    }
  },
  assetsInclude: '@dcloudio/uni-ui',
  build: {
    minify: 'terser',
    terserOptions: {
      compress: {
        drop_console: true, // 生产环境移除console
        drop_debugger: true, // 生产环境移除debugger
      },
    },
  },
});
