import { request } from '@/utils/request';

// 主页数据
export const homeIndex = () => request('/wx/home/index', 'GET');

// 商品详情
export const indexDetails = (data: any) => request('/wx/goods/detail', 'GET', data);

// 加入购物车
export const addCart = (data: any) => request('/wx/cart/add', 'POST', data);

// 加入购物车后重新选择规格
export const readdCart = (data: any) => request('/wx/cart/readd', 'POST', data);

// 立即购买
export const fastaddCart = (data: any) => request('/wx/cart/fastadd', 'POST', data);

// 获取购买页面信息，地址，规格
export const checkoutCart = (data: any) => request('/wx/cart/checkout', 'GET', data);

// 地址
export const addressList = () => request('/wx/address/list', 'GET');

// 设置地址
export const cartCheckout = (data: any) => request('/wx/cart/checkout', 'GET', data);

// 保存地址
export const saveAddress = (data: any) => request('/wx/address/save', 'POST', data);

// 删除地址
export const deleteAddress = (id: any) => request('/wx/address/delete', 'POST', { id });

// 提交订单
export const orderSubmit = (data: any) => request('/wx/order/submit', 'POST', data);

// 提交订单详细信息
export const orderDetail = (data: any) => request('/wx/order/detail', 'GET', data);

// 提交订单详细信息
export const getOrderData = (data: any) => request('/wx/order/list', 'GET', data);

// 删除订单 /wx/order/delete
export const orderDelete = (data: any) => request('/wx/order/delete', 'POST', data);

// 收藏详细信息
export const getCollectList = (data: any) => request('/wx/collect/list', 'GET', data);

// 添加或取消收藏
export const collectAddordelete = (data: any) => request('/wx/collect/addordelete', 'POST', data);

// 删除收藏
export const deleteCollect = (data: any) => request('/wx/collect/addordelete', 'POST', data);

// 查询税率
export const getTax = () => request('/wx/config/tax', 'GET');

// 推送订单
export const pushOrder = (data: any) => request('/wx/order/push', 'GET', data);

// 获取商品配件
export const goodsParts = (data: any) => request('/wx/goods/parts', 'GET', data);

// 查询商品参数属性 ?productId=1
export const orderAttribute = (data: any) => request('/wx/cart/attribute', 'GET', data);

// 查询地区信息
export const getAddrList = () => request('/wx/region/list', 'GET')