package org.jeecg.common.exception;

import lombok.Data;
import org.jeecg.modules.base.service.BaseCommonService;
import org.jeecg.common.exception.ConnectConstant.KingDeeConstant;

/*金蝶云连接异常*/
@Data
public class KingdeeConnectException extends RuntimeException {
    private String result;
    public KingdeeConnectException(String message) {
        super(message);
        this.result=message;
    }

    public KingdeeConnectException(String message,BaseCommonService baseCommonService) {
        super(message);
        this.result=message;
        baseCommonService.addLog(KingDeeConstant.URL,2,null);
    }
    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

}
