package org.jeecg.modules.iost.ims.Util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.ErrorsInside;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.ResponseStatus;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.SuccessEntitysInside;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

public class KingdeeResultParseUtil {

    public static Result parseAddResult(String result)
    {
        JSONObject jsonObject = JSON.parseObject(result);
        JSONObject result1 = (JSONObject)jsonObject.get("Result");
        String id = String.valueOf(result1.get("Id"));
        String number = String.valueOf(result1.get("Number"));
        JSONObject responseStatus = (JSONObject)result1.get("ResponseStatus");
        List<JSONObject> Errors = (List<JSONObject>) responseStatus.get("Errors");
        List<ErrorsInside> ErrorsObject=new ArrayList<>();
        for (JSONObject error : Errors) {
            ErrorsInside e=new ErrorsInside();
            if(!ObjectUtils.isEmpty(error.get("FieldName")))
            {
                e.setFieldName(String.valueOf(error.get("FieldName")));;
            }
            if(!ObjectUtils.isEmpty(error.get("Message")))
            {
                e.setMessage(String.valueOf(error.get("Message")));;
            }
            ErrorsObject.add(e);
        }

        List<JSONObject> successEntitys = (List<JSONObject>) responseStatus.get("SuccessEntitys");
        List<SuccessEntitysInside> successEntitysInsides=new ArrayList<>();
        for (JSONObject successEntity : successEntitys) {
            SuccessEntitysInside s=new SuccessEntitysInside();
            if(!ObjectUtils.isEmpty(successEntity.get("Id")))
            {
                s.setId(String.valueOf(successEntity.get("Id")));;
            }
            if(!ObjectUtils.isEmpty(successEntity.get("Number")))
            {
                s.setNumber(String.valueOf(successEntity.get("Number")));;
            }
            successEntitysInsides.add(s);
        }

        Boolean isSuccess = (Boolean)responseStatus.get("IsSuccess");
        Result R=new Result();

        ResponseStatus responseStatusObject=new ResponseStatus();
        responseStatusObject.setIsSuccess(isSuccess);
        responseStatusObject.setErrors(ErrorsObject);
        responseStatusObject.setSuccessEntitys(successEntitysInsides);
        R.setId(id);
        R.setNumber(number);
        R.setResponseStatus(responseStatusObject);
        return R;
    }
}
