package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.ims.entity.ImsInitConnectParm;
import org.jeecg.modules.iost.ims.service.IImsInitConnectParmService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

/**
* @Description: ims_init_connect_parm
* @Author: jeecg-boot
* @Date:   2021-10-26
* @Version: V1.0
*/
@Api(tags="ims_init_connect_parm")
@RestController
@RequestMapping("/org.jeecg.modules.iost.basedata.entity/imsInitConnectParm")
@Slf4j
public class ImsInitConnectParmController extends JeecgController<ImsInitConnectParm, IImsInitConnectParmService> {
   @Autowired
   private IImsInitConnectParmService imsInitConnectParmService;

   /**
    * 分页列表查询
    *
    * @param imsInitConnectParm
    * @param pageNo
    * @param pageSize
    * @param req
    * @return
    */
   @AutoLog(value = "ims_init_connect_parm-分页列表查询")
   @ApiOperation(value="ims_init_connect_parm-分页列表查询", notes="ims_init_connect_parm-分页列表查询")
   @GetMapping(value = "/list")
   public Result<?> queryPageList(ImsInitConnectParm imsInitConnectParm,
                                  @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
                                  @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
                                  HttpServletRequest req) {
       QueryWrapper<ImsInitConnectParm> queryWrapper = QueryGenerator.initQueryWrapper(imsInitConnectParm, req.getParameterMap());
       Page<ImsInitConnectParm> page = new Page<ImsInitConnectParm>(pageNo, pageSize);
       IPage<ImsInitConnectParm> pageList = imsInitConnectParmService.page(page, queryWrapper);
       return Result.OK(pageList);
   }

   /**
    *   添加
    *
    * @param imsInitConnectParm
    * @return
    */
   @AutoLog(value = "ims_init_connect_parm-添加")
   @ApiOperation(value="ims_init_connect_parm-添加", notes="ims_init_connect_parm-添加")
   @PostMapping(value = "/add")
   public Result<?> add(@RequestBody ImsInitConnectParm imsInitConnectParm) {
       imsInitConnectParmService.save(imsInitConnectParm);
       return Result.OK("添加成功！");
   }

   /**
    *  编辑
    *
    * @param imsInitConnectParm
    * @return
    */
   @AutoLog(value = "ims_init_connect_parm-编辑")
   @ApiOperation(value="ims_init_connect_parm-编辑", notes="ims_init_connect_parm-编辑")
   @PutMapping(value = "/edit")
   public Result<?> edit(@RequestBody ImsInitConnectParm imsInitConnectParm) {
       imsInitConnectParmService.updateById(imsInitConnectParm);
       return Result.OK("编辑成功!");
   }

   /**
    *   通过id删除
    *
    * @param id
    * @return
    */
   @AutoLog(value = "ims_init_connect_parm-通过id删除")
   @ApiOperation(value="ims_init_connect_parm-通过id删除", notes="ims_init_connect_parm-通过id删除")
   @DeleteMapping(value = "/delete")
   public Result<?> delete(@RequestParam(name="id",required=true) String id) {
       imsInitConnectParmService.removeById(id);
       return Result.OK("删除成功!");
   }

   /**
    *  批量删除
    *
    * @param ids
    * @return
    */
   @AutoLog(value = "ims_init_connect_parm-批量删除")
   @ApiOperation(value="ims_init_connect_parm-批量删除", notes="ims_init_connect_parm-批量删除")
   @DeleteMapping(value = "/deleteBatch")
   public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
       this.imsInitConnectParmService.removeByIds(Arrays.asList(ids.split(",")));
       return Result.OK("批量删除成功!");
   }

   /**
    * 通过id查询
    *
    * @param id
    * @return
    */
   @AutoLog(value = "ims_init_connect_parm-通过id查询")
   @ApiOperation(value="ims_init_connect_parm-通过id查询", notes="ims_init_connect_parm-通过id查询")
   @GetMapping(value = "/queryById")
   public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
       ImsInitConnectParm imsInitConnectParm = imsInitConnectParmService.getById(id);
       if(imsInitConnectParm==null) {
           return Result.error("未找到对应数据");
       }
       return Result.OK(imsInitConnectParm);
   }

   /**
   * 导出excel
   *
   * @param request
   * @param imsInitConnectParm
   */
   @RequestMapping(value = "/exportXls")
   public ModelAndView exportXls(HttpServletRequest request, ImsInitConnectParm imsInitConnectParm) {
       return super.exportXls(request, imsInitConnectParm, ImsInitConnectParm.class, "ims_init_connect_parm");
   }

   /**
     * 通过excel导入数据
   *
   * @param request
   * @param response
   * @return
   */
   @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
   public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
       return super.importExcel(request, response, ImsInitConnectParm.class);
   }

}
