package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.ims.entity.ImsRejectionConfirm;
import org.jeecg.modules.iost.ims.service.IImsRejectionConfirmService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

/**
 * @Description: 拒收确认
 * @Author: jeecg-boot
 * @Date: 2021-12-24
 * @Version: V1.0
 */
@Api(tags = "拒收确认")
@RestController
@RequestMapping("/org.jeecg.modules.iost.ims.entity/imsRejectionConfirm")
@Slf4j
public class ImsRejectionConfirmController extends JeecgController<ImsRejectionConfirm, IImsRejectionConfirmService> {
    @Autowired
    private IImsRejectionConfirmService imsRejectionConfirmService;

    /**
     * 分页列表查询
     *
     * @param imsRejectionConfirm
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "拒收确认-分页列表查询")
    @ApiOperation(value = "拒收确认-分页列表查询", notes = "拒收确认-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(ImsRejectionConfirm imsRejectionConfirm,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   String dateString, String codeString, String queueId,
                                   HttpServletRequest req) {
        QueryWrapper<ImsRejectionConfirm> queryWrapper = QueryGenerator.initQueryWrapper(imsRejectionConfirm, req.getParameterMap());
        if (StringUtils.isNotBlank(dateString)) {
            String[] split = dateString.split(",");
            queryWrapper.between("trx_date", split[0] + " 00:00:00", split[1] + " 00:00:00");
        }
        if (StringUtils.isNotBlank(codeString)) {
            queryWrapper.eq("fbill_no", codeString);
        }
        Page<ImsRejectionConfirm> page = new Page<ImsRejectionConfirm>(pageNo, pageSize);
        IPage<ImsRejectionConfirm> pageList = imsRejectionConfirmService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param imsRejectionConfirm
     * @return
     */
    @AutoLog(value = "拒收确认-添加")
    @ApiOperation(value = "拒收确认-添加", notes = "拒收确认-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody ImsRejectionConfirm imsRejectionConfirm) {
        imsRejectionConfirmService.save(imsRejectionConfirm);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param imsRejectionConfirm
     * @return
     */
    @AutoLog(value = "拒收确认-编辑")
    @ApiOperation(value = "拒收确认-编辑", notes = "拒收确认-编辑")
    @PutMapping(value = "/edit")
    public Result<?> edit(@RequestBody ImsRejectionConfirm imsRejectionConfirm) {
        imsRejectionConfirmService.updateById(imsRejectionConfirm);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "拒收确认-通过id删除")
    @ApiOperation(value = "拒收确认-通过id删除", notes = "拒收确认-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name = "id", required = true) String id) {
        imsRejectionConfirmService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "拒收确认-批量删除")
    @ApiOperation(value = "拒收确认-批量删除", notes = "拒收确认-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.imsRejectionConfirmService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    @AutoLog(value = "拒收确认-通过id查询")
    @ApiOperation(value = "拒收确认-通过id查询", notes = "拒收确认-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<?> queryById(@RequestParam(name = "id", required = true) String id) {
        ImsRejectionConfirm imsRejectionConfirm = imsRejectionConfirmService.getById(id);
        if (imsRejectionConfirm == null) {
            return Result.error("未找到对应数据");
        }
        return Result.OK(imsRejectionConfirm);
    }

    /**
     * 导出excel
     *
     * @param request
     * @param imsRejectionConfirm
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ImsRejectionConfirm imsRejectionConfirm) {
        return super.exportXls(request, imsRejectionConfirm, ImsRejectionConfirm.class, "拒收确认");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ImsRejectionConfirm.class);
    }

}
