package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.*;

/**
 * 查询金蝶云物料分组基础信息
 */
@Component
public class BsMtrlTypeKingdeeApi implements web_api {
    /**操作的单据体名称*/
    private String sFormId = "BD_MATERIAL";//物料基础信息
    @Autowired
    private CategoryDao categoryDao;
    private Map<String,String> key = new LinkedHashMap<>();
    public BsMtrlTypeKingdeeApi(){
        /*查询字段*/
        key.put("FMATERIALID","FMATERIALID");//单据头实体主键
        key.put("FCreateOrgId.FNumber","FCreateOrgId.FNumber");//创建组织
        key.put("FMaterialGroup.Fnumber","FMaterialGroup.Fnumber");//物料分组
        key.put("FMaterialGroup.Fname","FMaterialGroup.Fname");//物料分组
    }

    @Override
    public String add(Map<String, Object> maps) {
        return null;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        List<List<Object>> list = categoryDao.select(sFormId, key,map,"物料分类基础信息");
        return PojoToIMS(list);
    }
    /**
     * 将查询到的数据封装成本地字段
     * @return
     */
    private List<Map<String,String>> PojoToIMS(List<List<Object>> list){
        List<Map<String,String>> salesorderlist = new ArrayList<>();
        if(!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("orgId", list1.get(1).toString());
                    if(null==list1.get(2)||"".equals(list1.get(2).toString())){
                        salesordermap.put("mtypeCode","");
                        salesordermap.put("mtypeName", "");
                    }else {
                        salesordermap.put("mtypeCode", list1.get(2).toString());
                        salesordermap.put("mtypeName", list1.get(3).toString());
                    }
                    salesorderlist.add(salesordermap);
                }
            }else {
                //如果有错误信息则返回
                Map<String,Object> o = (Map<String, Object>) list.get(0).get(0);
                Object errors = o.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }
    @Override
    public String update(Object object) {
        return null;
    }
}
