package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @author Inori
 */
@Component
public class ImsPickingListKingdeeApi {

    private static final String S_FORM_ID = "LQKJ_ContrastRecord";

    private Map<String, String> key = new LinkedHashMap<>();

    @Autowired
    private CategoryDao categoryDao;


    public ImsPickingListKingdeeApi() {
        /*查询字段*/
        /* 单据头实体主键 */
        key.put("FID", "FID");
        /* 采购编码 */
        key.put("F_LQKJ_Purchase", "F_LQKJ_Purchase");
        /* 物料编码 */
        key.put("F_LQKJ_FMaterial.Fnumber", "F_LQKJ_FMaterial.Fnumber");
        /* 要求送货数量 */
        key.put("F_LQKJ_PurchaseQty", "F_LQKJ_PurchaseQty");
        /* 供应商编码 */
        key.put("F_LQKJ_Supplier", "F_LQKJ_Supplier");
        /* 分析单 */
        key.put("F_LQKJ_NowLack", "F_LQKJ_NowLack");
        /* 单位 */
        key.put("F_LQKJ_Fstockunitid", "F_LQKJ_Fstockunitid");
        /* 采购订单行号 */
        key.put("F_LQKJ_PurchaseFsq", "F_LQKJ_PurchaseFsq");
        /* 需求日期 */
        key.put("F_LQKJ_NeedDate", "F_LQKJ_NeedDate");
        /* 源单单号 */
        key.put("F_LQKJ_XqBillno", "F_LQKJ_XqBillno");
        /* 源单物料 */
        key.put("F_LQKJ_XqMaterial", "F_LQKJ_XqMaterial");
    }

    public List<Map<String, String>> select(Map<String, String> map) {
        List<List<Object>> list = categoryDao.select(S_FORM_ID, key, map, "提料分析单");
        return pojoToIms(list);
    }

    /**
     * 将查询到的数据封装成本地字段
     */
    private List<Map<String, String>> pojoToIms(List<List<Object>> list) {
        List<Map<String, String>> result = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                Map<String, String> map = new HashMap<>(15);
                map.put("fid", list.get(0).toString());
                map.put("poCode", list.get(1).toString());
                map.put("mtrlCode", list.get(2).toString());
                map.put("deliverableQty", list.get(3).toString());
                map.put("supCde", list.get(4).toString());
                map.put("supMtrlDtAnalNo", list.get(5).toString());
                map.put("mUnit", list.get(6).toString());
                map.put("poSeq", list.get(7).toString());
                map.put("demandDate", list.get(8).toString());
                map.put("sdlNo", list.get(9).toString());
                map.put("sdlMtrl", list.get(10).toString());
                result.add(map);
            } else {
                //如果有错误信息则返回
                Map<String, Object> map = (Map<String, Object>) list.get(0).get(0);
                Object errors = map.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                result.add(salesordermap);
            }
        }
        return result;
    }


}
