package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @author Inori
 */
@Component
public class PurchaseWarehousingKingdeeApi {

    @Autowired
    private CategoryDao categoryDao;

    private static final String S_FORM_ID = "PRD_MO";

    private Map<String, String> key = new LinkedHashMap<>();

    public PurchaseWarehousingKingdeeApi() {
        /*查询字段*/
        /* 单据头实体主键 */
        key.put("FID", "FID");
        /* 单据编号 */
        key.put("FBillNo", "FBillNo");
        /* 单据类型 */
        key.put("FBillTypeID.Fname", "FBillTypeID.Fname");
        /* 行号 */
        key.put("FInStockEntry_FSeq", "FInStockEntry_FSeq");
        /* 供应商 */
        key.put("FSupplierId.Fnumber", "FSupplierId.Fnumber");
        /* 入库时间 */
        key.put("FDate", "FDate");
        /* 税额 */
        key.put("FBillTaxAmount", "FBillTaxAmount");
        /* 未税金额 */
        key.put("FBillAmount", "FBillAmount");
        /* 含税否 */
        key.put("FIsIncludedTax", "FIsIncludedTax");
        /* 汇率 */
        key.put("FExchangeRate", "FExchangeRate");
        /* 税价合计 */
        key.put("FBillAllAmount", "FBillAllAmount");
        /* 付款条件 */
        key.put("FPayConditionId.Fname", "FPayConditionId.Fname");
        /* 币别 */
        key.put("FSettleCurrId.Fname", "FSettleCurrId.Fname");
        /* 结算方式 */
        key.put("FSettleTypeId.Fname", "FSettleTypeId.Fname");
        /* 物料编码 */
        key.put("FMaterialId.Fnumber", "FMaterialId.Fnumber");
        /* 实收数量 */
        key.put("FRealQty", "FRealQty");
        /* 单价 */
        key.put("FPrice", "FPrice");
        /* 含税单价 */
        key.put("FTaxPrice", "FTaxPrice");
        /* 库存单位 */
        key.put("FUnitID.Fname", "FUnitID.Fname");
    }

    /**
     * 获取金蝶云数据
     */
    public List<Map<String, String>> selectAndLog(Map<String, String> map, String name) {
        List<List<Object>> list = categoryDao.selectAndLog(S_FORM_ID, key, map, name);
        return purchaseWarehousing(list);
    }

    /**
     * 查询采购订单编号+行号
     */
    public List<List<Object>> getPurchaseOrder(String id) {
        List<List<Object>> lists = categoryDao.select("PRD_PPBOM", new LinkedHashMap<String, String>() {{
            put("FPOOrderEntry_FSeq", "FPOOrderEntry_FSeq");
            put("FBillNo", "FBillNo");
        }}, new HashMap<String, String>() {{
            put("FPOOrderEntry_FEntryID", id);
        }});
        if (CollectionUtils.isEmpty(lists)) {
            return new ArrayList<>();
        }
        return lists;
    }

    List<Map<String, String>> purchaseWarehousing(List<List<Object>> list) {
        List<Map<String, String>> result = new ArrayList<>();
        if (!list.get(0).get(0).toString().contains("Errors")) {

        } else {
            //如果有错误信息则返回
            Map<String, Object> o = (Map<String, Object>) list.get(0).get(0);
            Object errors = o.get("Errors");
            List parse3 = (List) JSON.parse(errors.toString());
            Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
            Object message = parse4.get("Message");
            Map<String, String> salesordermap = new HashMap<>();
            salesordermap.put("false", message.toString());
            result.add(salesordermap);
        }
        return result;
    }


}
