package org.jeecg.modules.iost.ims.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsBsMtrlType;
import org.jeecg.modules.iost.ims.kingdeeapi.BsMtrlTypeKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsBsMtrlTypeMapper;
import org.jeecg.modules.iost.ims.service.IImsBsMtrlTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.*;

/**
 * @Description: 物料分类基础信息
 * @Author: jeecg-boot
 * @Date:   2021-12-16
 * @Version: V1.0
 */
@Service
public class ImsBsMtrlTypeServiceImpl extends ServiceImpl<ImsBsMtrlTypeMapper, ImsBsMtrlType> implements IImsBsMtrlTypeService {
    @Autowired
    IMSApi imsApi;
    @Autowired
    BsMtrlTypeKingdeeApi kingdeeApi;
    @Override
    public Boolean synchronization(Object object,LoginUser sysUser) throws ParseException {
        //追加参数(上下文对象)
        String kingdeeLogOZTName = "物料分类基础信息";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName",kingdeeLogOZTName);

        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<ImsBsMtrlType> pojolist=new ArrayList<>();
        List<Map<String, String>> list=new ArrayList<>();
        List<Map<String, Object>> imsList=new ArrayList<>();
        Boolean success = false;
        Map<String,String> idmap=new HashMap<>();
        //设置需要同步的主键
        idmap.put("FMATERIALID",object.toString());
        //将对应信息请求金蝶云
        list=kingdeeApi.select(idmap,null);

        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if(data.containsKey("false")){
                return success;
            }
            //将实体信息记录下来
            ImsBsMtrlType pojo = new ImsBsMtrlType();
            pojo.setFid(data.get("fid"));
            pojo.setOrgId(data.get("orgId"));
            pojo.setMtypeCode(data.get("mtypeCode"));
            pojo.setMtypeName(data.get("mtypeName"));
            pojo.setCreateTime(new Date());
            if(sysUser!=null){
                pojo.setCreateBy(sysUser.getUsername());
                pojo.setSysOrgCode(sysUser.getOrgCode());
            }
            pojolist.add(pojo);
            //封装成IMS格式
            Map<String,Object> datalist=new HashMap<>();
            datalist.put("org_id",data.get("orgId"));
            datalist.put("mtype_code",data.get("mtypeCode"));
            datalist.put("mtype_name",data.get("mtypeName"));
            datalist.put("remark","");
            imsList.add(datalist);
        }
        this.saveBatch(pojolist);
        //将数据包装成IMS格式
        Map<String,Object> map=new HashMap<>();
        map.put("docType","BS_MTRL_TYPE");
        map.put("updateType","UPDATE");
        map.put("data",imsList);
        String mapjson = JsonUtil.Mapjson(map);
        String result = imsApi.add(mapjson, "物料分类信息","BS_MTRL_TYPE");
        //记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(mapjson,result, "物料分类信息","BS_MTRL_TYPE",null);
        //设置同步成功状态
        success=flag;
        return success;
    }
}
