package org.jeecg.modules.iost.ims.service.impl;

import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsBsWplan;
import org.jeecg.modules.iost.ims.entity.ImsBsWplanouts;
import org.jeecg.modules.iost.ims.kingdeeapi.BsWplanOutsKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsBsWplanoutsMapper;
import org.jeecg.modules.iost.ims.service.IImsBsWplanoutsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.text.ParseException;
import java.util.*;

/**
 * @Description: 主计划委外表
 * @Author: jeecg-boot
 * @Date:   2021-12-27
 * @Version: V1.0
 */
@Service
public class ImsBsWplanoutsServiceImpl extends ServiceImpl<ImsBsWplanoutsMapper, ImsBsWplanouts> implements IImsBsWplanoutsService {
    @Autowired
    BsWplanOutsKingdeeApi kingdeeApi;
    @Autowired
    IMSApi imsApi;
    @Override
    public Boolean synchronization(Object object, LoginUser sysUser) throws ParseException {
        //追加参数(上下文对象)
        String kingdeeLogOZTName = "主计划基础信息";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName",kingdeeLogOZTName);

        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<ImsBsWplanouts> pojolist=new ArrayList<>();
        List<Map<String, String>> list=new ArrayList<>();
        List<Map<String, Object>> imsList=new ArrayList<>();
        Boolean success = false;
        Map<String,String> bs_wplan_mn_mtrl=new HashMap<>();
        Map<String,Object> datalist=new HashMap<>();
        Map<String,String> idmap=new HashMap<>();
        //设置需要同步的主键
        idmap.put("FID",object.toString());
        //将对应信息请求金蝶云
        list=kingdeeApi.select(idmap,null);

        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if(data.containsKey("false")){
                return success;
            }
            //将实体信息记录下来
            ImsBsWplanouts pojo = new ImsBsWplanouts();
            pojo.setFid(data.get("fid"));
            pojo.setSupCode(data.get("supCode"));
            pojo.setOrgId(data.get("orgId"));
            pojo.setWplanCode(data.get("wplanCode"));
            pojo.setErpMo(data.get("erpMo"));
            pojo.setProdCode(data.get("prodCode"));
            pojo.setPqty(data.get("pqty"));
            pojo.setPbDate(data.get("pbDate"));
            pojo.setPeDate(data.get("peDate"));
            pojo.setMtrlCode(data.get("mtrlCode"));
            pojo.setBsWplanMnMtrlEx1(data.get("bsWplanMnMtrlEx1"));
            pojo.setBsWplanMnMtrlEx2(data.get("bsWplanMnMtrlEx2"));
            pojo.setCreateTime(new Date());
            if(sysUser!=null){
                pojo.setCreateBy(sysUser.getUsername());
                pojo.setSysOrgCode(sysUser.getOrgCode());
            }
            pojolist.add(pojo);
            //封装成IMS格式
            bs_wplan_mn_mtrl.put("mtrl_code",data.get("mtrlCode"));
            bs_wplan_mn_mtrl.put("is_main",data.get("isMain"));
            bs_wplan_mn_mtrl.put("main_code",data.get("mainCode"));
            bs_wplan_mn_mtrl.put("bs_wplan_mn_mtrl_ex1",data.get("bsWplanMnMtrlEx1"));
            bs_wplan_mn_mtrl.put("bs_wplan_mn_mtrl_ex2",data.get("bsWplanMnMtrlEx2"));
            datalist.put("org_id",data.get("orgId"));
            datalist.put("wplan_code",data.get("wplanCode"));
            datalist.put("erp_mo",data.get("erpMo"));
            datalist.put("prod_code",data.get("prodCode"));
            datalist.put("p_qty",data.get("pqty"));
            datalist.put("pb_date",data.get("pbDate"));
            datalist.put("pe_date",data.get("peDate"));
            datalist.put("bs_wplan_mn_mtrl",bs_wplan_mn_mtrl);
            datalist.put("remark","");
            imsList.add(datalist);
        }
        this.saveBatch(pojolist);
        //将数据包装成IMS格式
        Map<String,Object> map=new HashMap<>();
        map.put("docType","BS_WPLAN");
        map.put("updateType","UPDATE");
        map.put("data",imsList);
        String mapjson = JsonUtil.Mapjson(map);
        String result = imsApi.add(mapjson, "委外订单","BS_WPLAN");
        //记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(mapjson,result, "委外订单","BS_WPLAN",null);
        //设置同步成功状态
        success=flag;
        return success;
    }
}
