package org.jeecg.modules.iost.ims.service.impl;

import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.PurchaseWarehousingKingdeeApi;
import org.jeecg.modules.iost.ims.service.IImsPurchaseWarehousingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
@Service
public class ImsPurchaseWarehousingServiceImpl implements IImsPurchaseWarehousingService {

    @Autowired
    private PurchaseWarehousingKingdeeApi purchaseWarehousingKingdeeApi;


    @Override
    public Map<String, String> getData(Map<String, Object> map) {
        //记录IMS日志
        new ImsLogUtil().ImsRequestLog(JsonUtil.toString(map), "采购入库", "采购入库单查询", "STK_InStock");

        Map<String, String> keyMap = new HashMap<>(4);
        if (map.containsKey("FBillNo")) {
            keyMap.put("FBillNo", map.get("FBillNo").toString());
        }
        if (map.containsKey("FSupplierId")) {
            keyMap.put("FSupplierId.Fnumber", map.get("FSupplierId").toString());
        }
        if (map.containsKey("FDate")) {
            keyMap.put("FDate", map.get("FDate").toString());
        }
        if (map.containsKey("FMaterialId")) {
            keyMap.put("FMaterialId.Fumber", map.get("FMaterialId").toString());
        }
        List<Map<String, String>> list = purchaseWarehousingKingdeeApi.selectAndLog(keyMap, "");

        Map<String, String> result = new HashMap<>();
        result.put("true", JsonUtil.toString(list));
        return result;
    }


}
