package org.jeecg.modules.iost.ims.service.impl;

import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsWmsAllot;
import org.jeecg.modules.iost.ims.kingdeeapi.WmsAllotKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsWmsAllotMapper;
import org.jeecg.modules.iost.ims.service.IImsWmsAllotService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;

/**
 * @Description: 调拨单信息
 * @Author: jeecg-boot
 * @Date: 2021-12-15
 * @Version: V1.0
 */
@Service
public class ImsWmsAllotServiceImpl extends ServiceImpl<ImsWmsAllotMapper, ImsWmsAllot> implements IImsWmsAllotService {
    @Autowired
    IMSApi imsApi;
    @Autowired
    WmsAllotKingdeeApi kingdeeApi;

    @Override
    public Boolean synchronization(Object object, LoginUser sysUser) throws ParseException {
        //追加参数(上下文对象)
        String kingdeeLogOZTName = "调拨单信息";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingdeeLogOZTName);

        ImsLogUtil imsLogUtil = new ImsLogUtil();
        List<ImsWmsAllot> pojolist = new ArrayList<>();
        List<Map<String, String>> list = new ArrayList<>();
        List<Map<String, Object>> imsList = new ArrayList<>();
        Boolean success = false;
        Map<String, String> idmap = new HashMap<>();
        //设置需要同步的主键
        idmap.put("FID", object.toString());
        //将对应信息请求金蝶云
        list = kingdeeApi.select(idmap, null);

        List<Map<String, Object>> bsList = new ArrayList<>();
        Map<String, Object> datalist = new HashMap<>();
        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if (data.containsKey("false")) {
                return success;
            }
            //将实体信息记录下来
            ImsWmsAllot pojo = new ImsWmsAllot();
            pojo.setFid(data.get("fid"));
            pojo.setOrgId(data.get("orgId"));
            pojo.setAllotCode(data.get("allotCode"));
            pojo.setSrcStoreCode(data.get("srcStoreCode"));
            pojo.setToOrgId(data.get("toOrgId"));
            pojo.setToStoreCode(data.get("toStoreCode"));
            pojo.setAllotType(data.get("allotType"));
            pojo.setMtrlCode(data.get("mtrlCode"));
            pojo.setAllotQty(Double.parseDouble(data.get("allotQty")));
            pojo.setRemark(data.get("remark"));
            pojo.setCreateTime(new Date());
            if (sysUser != null) {
                pojo.setCreateBy(sysUser.getUsername());
                pojo.setSysOrgCode(sysUser.getOrgCode());
            }
            pojolist.add(pojo);
            //封装成IMS格式

            Map<String, Object> wms_allot_mtrl = new HashMap<>();
            wms_allot_mtrl.put("mtrl_code", data.get("mtrlCode"));
            wms_allot_mtrl.put("allot_qty", new BigDecimal(data.get("allotQty")));
            wms_allot_mtrl.put("uncmp_qty", new BigDecimal(data.get("allotQty")));
            wms_allot_mtrl.put("src_store_code", data.get("srcStoreCode"));
            wms_allot_mtrl.put("to_store_code", data.get("toStoreCode"));
            wms_allot_mtrl.put("third_rwn", data.get("thirdRwn"));
            bsList.add(wms_allot_mtrl);

            datalist.put("org_id", data.get("orgId"));
            datalist.put("allot_code", data.get("allotCode"));
            datalist.put("to_org_id", data.get("toOrgId"));
            datalist.put("allot_type",/*data.get("allotType")*/1);
            datalist.put("remark", data.get("remark"));
        }
        datalist.put("wms_allot_mtrl", bsList);
        imsList.add(datalist);

        this.saveBatch(pojolist);
        //将数据包装成IMS格式
        Map<String, Object> map = new HashMap<>();
        map.put("docType", "WMS_ALLOT");
        map.put("updateType", "UPDATE");
        map.put("data", imsList);
        String mapjson = JsonUtil.toString(map);
        String result = imsApi.add(mapjson, "调拨申请单", "WMS_ALLOT");
        //记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(mapjson, result, "调拨申请单", "WMS_ALLOT", null);
        //设置同步成功状态
        success = flag;
        return success;
    }
}
