package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.ims.entity.ImsReturnMaterialDefectiveProducts;
import org.jeecg.modules.iost.ims.service.IImsReturnMaterialDefectiveProductsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

/**
 * @Description: 不良品退料
 * @Author: jeecg-boot
 * @Date: 2021-12-02
 * @Version: V1.0
 */
@Api(tags = "不良品退料")
@RestController
@RequestMapping("/ims/returnMaterialDefectiveProducts")
@Slf4j
public class ImsReturnMaterialDefectiveProductsController extends JeecgController<ImsReturnMaterialDefectiveProducts, IImsReturnMaterialDefectiveProductsService> {
    @Autowired
    private IImsReturnMaterialDefectiveProductsService returnMaterialDefectiveProductsService;

    /**
     * 分页列表查询
     *
     * @param returnMaterialDefectiveProducts
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "不良品退料-分页列表查询")
    @ApiOperation(value = "不良品退料-分页列表查询", notes = "不良品退料-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(ImsReturnMaterialDefectiveProducts returnMaterialDefectiveProducts,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   String dateString, String codeString, String queueId,
                                   HttpServletRequest req) {
        QueryWrapper<ImsReturnMaterialDefectiveProducts> queryWrapper = QueryGenerator.initQueryWrapper(returnMaterialDefectiveProducts, req.getParameterMap());
        if (StringUtils.isNotBlank(dateString)) {
            String[] split = dateString.split(",");
            queryWrapper.between("trx_date", split[0] + " 00:00:00", split[1] + " 00:00:00");
        }
        if (StringUtils.isNotBlank(codeString)) {
            queryWrapper.eq("fbill_no", codeString);
        }
        Page<ImsReturnMaterialDefectiveProducts> page = new Page<ImsReturnMaterialDefectiveProducts>(pageNo, pageSize);
        IPage<ImsReturnMaterialDefectiveProducts> pageList = returnMaterialDefectiveProductsService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param returnMaterialDefectiveProducts
     * @return
     */
    @AutoLog(value = "不良品退料-添加")
    @ApiOperation(value = "不良品退料-添加", notes = "不良品退料-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody ImsReturnMaterialDefectiveProducts returnMaterialDefectiveProducts) {
        returnMaterialDefectiveProductsService.save(returnMaterialDefectiveProducts);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param returnMaterialDefectiveProducts
     * @return
     */
    @AutoLog(value = "不良品退料-编辑")
    @ApiOperation(value = "不良品退料-编辑", notes = "不良品退料-编辑")
    @PutMapping(value = "/edit")
    public Result<?> edit(@RequestBody ImsReturnMaterialDefectiveProducts returnMaterialDefectiveProducts) {
        returnMaterialDefectiveProductsService.updateById(returnMaterialDefectiveProducts);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "不良品退料-通过id删除")
    @ApiOperation(value = "不良品退料-通过id删除", notes = "不良品退料-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name = "id", required = true) String id) {
        returnMaterialDefectiveProductsService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "不良品退料-批量删除")
    @ApiOperation(value = "不良品退料-批量删除", notes = "不良品退料-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.returnMaterialDefectiveProductsService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    @AutoLog(value = "不良品退料-通过id查询")
    @ApiOperation(value = "不良品退料-通过id查询", notes = "不良品退料-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<?> queryById(@RequestParam(name = "id", required = true) String id) {
        ImsReturnMaterialDefectiveProducts returnMaterialDefectiveProducts = returnMaterialDefectiveProductsService.getById(id);
        if (returnMaterialDefectiveProducts == null) {
            return Result.error("未找到对应数据");
        }
        return Result.OK(returnMaterialDefectiveProducts);
    }

    /**
     * 导出excel
     *
     * @param request
     * @param returnMaterialDefectiveProducts
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ImsReturnMaterialDefectiveProducts returnMaterialDefectiveProducts) {
        return super.exportXls(request, returnMaterialDefectiveProducts, ImsReturnMaterialDefectiveProducts.class, "不良品退料");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ImsReturnMaterialDefectiveProducts.class);
    }

}
