package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.entity.Kingdeelog;
import org.jeecg.modules.iost.ims.entity.Syn;
import org.jeecg.modules.iost.ims.service.ISynService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @Description: ims金蝶日志
 * @Author: jeecg-boot
 * @Date:   2021-09-03
 * @Version: V1.0
 */
@Api(tags="同步信息")
@RestController
@RequestMapping("/syn")
@Slf4j
public class SynController extends JeecgController<Syn, ISynService> {

    @Autowired
    ISynService synService;
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    CategoryDao categoryDao;
    /**
     * 分页列表查询
     *
     * @param syn
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "ims金蝶日志-分页列表查询")
    @ApiOperation(value="ims金蝶日志-分页列表查询", notes="ims金蝶日志-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(Syn syn,
                                   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
                                   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
                                   HttpServletRequest req,String date) {
        QueryWrapper<Syn> queryWrapper = QueryGenerator.initQueryWrapper(syn, req.getParameterMap()).orderByDesc("createtime");
        Page<Syn> page = new Page<Syn>(pageNo, pageSize);
        if(!"null".equals(date)){
            SimpleDateFormat sdf1 =new SimpleDateFormat("yyyy-MM-dd" );
            Date parse = null;
            try {
                parse = sdf1.parse(date);
            } catch (ParseException e) {
                e.printStackTrace();
            }
            //根据查询日期拿到明天
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(parse);
            calendar.add(Calendar.DATE,1);
            String parse1=sdf1.format(calendar.getTime());
            queryWrapper.gt("createtime",parse);
            queryWrapper.lt("createtime",parse1);
        }
        IPage<Syn> pageList = synService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    @Autowired
    WebApi webApi;
    /**
     * 手动同步
     *
     * @return
     * @throws ParseException
     */
    @AutoLog(value = "同步信息API-同步")
    @ApiOperation(value = "同步信息API-同步", notes = "同步信息API-同步")
    @PostMapping(value = "/synchronization")
    public Result<?> synchronization(HttpServletRequest req) throws ParseException {
        webApi.Kingdeelogin();
        //获取当前用户
        String token = req.getHeader(CommonConstant.X_ACCESS_TOKEN);
        String username = JwtUtil.getUsername(token);
        LoginUser sysUser = sysBaseAPI.getUserByName(username);
        Boolean flag=synService.Manualsynchronization(sysUser);
        if(flag){
            return Result.OK("同步成功");
        }
        return Result.error("同步失败");
    }

}
