package org.jeecg.modules.iost.ims.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 主计划基础信息
 * @Author: jeecg-boot
 * @Date:   2021-12-21
 * @Version: V1.0
 */
@Data
@TableName("ims_bs_wplan")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="ims_bs_wplan对象", description="主计划基础信息")
public class ImsBsWplan implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private java.lang.String sysOrgCode;
	/**组织代码*/
	@Excel(name = "组织代码", width = 15)
    @ApiModelProperty(value = "组织代码")
    private java.lang.String orgId;
	/**主计划编码*/
	@Excel(name = "主计划编码", width = 15)
    @ApiModelProperty(value = "主计划编码")
    private java.lang.String wplanCode;
	/**工单编码*/
	@Excel(name = "工单编码", width = 15)
    @ApiModelProperty(value = "工单编码")
    private java.lang.String erpMo;
	/**成品编码*/
	@Excel(name = "成品编码", width = 15)
    @ApiModelProperty(value = "成品编码")
    private java.lang.String prodCode;
	/**工单类型*/
	@Excel(name = "工单类型", width = 15)
    @ApiModelProperty(value = "工单类型")
    private java.lang.String moType;
	/**计划数量*/
	@Excel(name = "计划数量", width = 15)
    @ApiModelProperty(value = "计划数量")
    private java.lang.String pqty;
	/**计划开始时间*/
	@Excel(name = "计划开始时间", width = 15)
    @ApiModelProperty(value = "计划开始时间")
    private java.lang.String pbDate;
	/**计划结束时间*/
	@Excel(name = "计划结束时间", width = 15)
    @ApiModelProperty(value = "计划结束时间")
    private java.lang.String peDate;
	/**工艺段编码*/
	@Excel(name = "工艺段编码", width = 15)
    @ApiModelProperty(value = "工艺段编码")
    private java.lang.String phaseCode;
	/**客户编码*/
	@Excel(name = "客户编码", width = 15)
    @ApiModelProperty(value = "客户编码")
    private java.lang.String custCode;
	/**供应商编码*/
	@Excel(name = "供应商编码", width = 15)
    @ApiModelProperty(value = "供应商编码")
    private java.lang.String supCode;
	/**车间编码*/
	@Excel(name = "车间编码", width = 15)
    @ApiModelProperty(value = "车间编码")
    private java.lang.String ptCode;
	/**外协*/
	@Excel(name = "外协", width = 15)
    @ApiModelProperty(value = "外协")
    private java.lang.String isOuts;
	/**保税*/
	@Excel(name = "保税", width = 15)
    @ApiModelProperty(value = "保税")
    private java.lang.String isBonded;
	/**生产批次*/
	@Excel(name = "生产批次", width = 15)
    @ApiModelProperty(value = "生产批次")
    private java.lang.String lotno;
	/**交货日期*/
	@Excel(name = "交货日期", width = 15)
    @ApiModelProperty(value = "交货日期")
    private java.lang.String deliveryDate;
	/**备注*/
	@Excel(name = "备注", width = 15)
    @ApiModelProperty(value = "备注")
    private java.lang.String remark;
	/**物料编码*/
	@Excel(name = "物料编码", width = 15)
    @ApiModelProperty(value = "物料编码")
    private java.lang.String mtrlCode;
	/**是否主料*/
	@Excel(name = "是否主料", width = 15)
    @ApiModelProperty(value = "是否主料")
    private java.lang.String isMain;
	/**主料编码*/
	@Excel(name = "主料编码", width = 15)
    @ApiModelProperty(value = "主料编码")
    private java.lang.String mainCode;
	/**用量*/
	@Excel(name = "用量", width = 15)
    @ApiModelProperty(value = "用量")
    private java.lang.String dosage;
	/**净需求数量*/
	@Excel(name = "净需求数量", width = 15)
    @ApiModelProperty(value = "净需求数量")
    private java.lang.String nnQty;
	/**实际需求数量*/
	@Excel(name = "实际需求数量", width = 15)
    @ApiModelProperty(value = "实际需求数量")
    private java.lang.String tnQty;
	/**明细内码(用料清单明细内码)*/
	@Excel(name = "明细内码(用料清单明细内码)", width = 15)
    @ApiModelProperty(value = "明细内码(用料清单明细内码)")
    private java.lang.String bsWplanMnMtrlEx1;
	/**行号*/
	@Excel(name = "行号", width = 15)
    @ApiModelProperty(value = "行号")
    private java.lang.String bsWplanMnMtrlEx2;
    /**主键ID*/
    @Excel(name = "主键ID", width = 15)
    @ApiModelProperty(value = "主键ID")
    private java.lang.String fid;
}
