package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.*;

/**
 * 查询金蝶云BOM
 */
@Component
public class BsBomKingdeeApi implements web_api {
    /**
     * 操作的单据体名称
     */
    private String sFormId = "ENG_BOM";//物料清单
    @Autowired
    private CategoryDao categoryDao;
    private Map<String, String> key = new LinkedHashMap<>();

    public BsBomKingdeeApi() {
        /*查询字段*/
        key.put("FID", "FID");//单据头实体主键
        key.put("FCreateOrgId.Fnumber", "FCreateOrgId.Fnumber");//组织编码
        key.put("FMATERIALID.Fnumber", "FMATERIALID.Fnumber");//父项物料编码
        key.put("FNumber", "FNumber");//BOM版本
        key.put("FMATERIALIDCHILD.Fnumber", "FMATERIALIDCHILD.Fnumber");//子项物料编码
        key.put("FIskeyItem", "FIskeyItem");//替代主料
        key.put("FNUMERATOR", "FNUMERATOR");//子项明细-用量分子
        key.put("FDENOMINATOR", "FDENOMINATOR");//子项明细-用量分母
        key.put("FPOSITIONNO", "FPOSITIONNO");//位置号
        key.put("FMEMO ", "FMEMO ");//备注
        key.put("FParentRowId", "FParentRowId");//父级行主键
        key.put("FTreeEntity_FENTRYID", "FTreeEntity_FENTRYID");//行内码
    }

    @Override
    public String add(Map<String, Object> maps) {
        return null;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        List<List<Object>> list = categoryDao.select(sFormId, key, map, "物料清单");
        return PojoToIMS(list);
    }

    /**
     * 查询父级的子项物料编码
     *
     * @param id
     * @return
     */
    public List<List<Object>> getMaterid(String id) {
        List<List<Object>> lists = categoryDao.selectByIds("ENG_BOM", new HashMap<String, String>() {{
            //根据单据编码查询子项物料编码
            put("FMATERIALIDCHILD.Fnumber", "FMATERIALIDCHILD.Fnumber");
            put("FROWID", "FROWID");
        }}, new HashMap<String, String>() {{
            put("FROWID", id);
        }});
        if (lists.isEmpty() || ("").equals(lists.get(0).get(0).toString())) {
            return null;
        } else if (lists.get(0).get(0).toString().contains("Errors")) {
            return null;
        }
        return lists;
    }

    /**
     * 将查询到的数据封装成本地字段
     *
     * @return
     */
    private List<Map<String, String>> PojoToIMS(List<List<Object>> list) {
        List<Map<String, String>> salesorderlist = new ArrayList<>();
        if (!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                Map<String, List<String>> MaterList = new HashMap<>();
                String Mater = "";
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("orgId", list1.get(1).toString());
                    salesordermap.put("prodCode", list1.get(2).toString());
                    salesordermap.put("bomVer", list1.get(3).toString());
                    salesordermap.put("mtrlCode", list1.get(4).toString());

                    salesordermap.put("isMain", "true".equals(list1.get(5).toString()) ? "N" : "Y");
                    if (null != list1.get(10).toString() && !" ".equals(list1.get(10).toString())) {
                        //将主键ID和物料编码存入集合
                        List<String> idList = new ArrayList<>();
                        //行内码
                        idList.add(list1.get(10).toString());
                        //主键ID
                        MaterList.put(list1.get(11).toString(), idList);
                        //拼接id做批量查询
                        Mater = "'" + list1.get(10).toString() + "'," + Mater;
                    } else {
                        salesordermap.put("mainCode", list1.get(4).toString());
                    }

//                    Object materid = getMaterid(list1.get(10).toString());
//                    salesordermap.put("mainCode",materid.toString());

                    Double a = Double.valueOf(list1.get(6).toString());
                    Double b = Double.valueOf(list1.get(7).toString());
                    double v = a / b;
                    salesordermap.put("dosage", Double.toString(v));

                    salesordermap.put("pointStr", list1.get(8).toString());
                    salesordermap.put("FParentRowId", list1.get(10).toString());
                    salesordermap.put("FTreeEntity_FENTRYID", list1.get(11).toString());
//                    salesordermap.put("remark", list1.get(9).toString());
                    salesorderlist.add(salesordermap);
                }
                //批量查出所有生产用料清单的数据
                if (StringUtils.isNotBlank(Mater)) {
                    Mater = Mater.substring(0, Mater.length() - 1);
                }
                List<List<Object>> materid = getMaterid(Mater);
                if (null == materid || "".equals(materid.toString())) {
                    for (Map<String, String> salesordermap : salesorderlist) {
                        salesordermap.put("mainCode", "");
                    }
                } else {
                    //将集合赋值
                    for (String fid : MaterList.keySet()) {
                        for (List materList : materid) {
                            //如果对应的行内码相同
                            if (MaterList.get(fid).get(0).equals(materList.get(0).toString())) {
                                //将信息添加到集合
                                MaterList.get(fid).add(materList.get(1).toString());
                            }
                        }
                    }
                    //将对应的信息写入到大集合
                    for (Map<String, String> salesordermap : salesorderlist) {
                        for (String fid : MaterList.keySet()) {
                            //如果行内码与父级ID都相同
                            if (fid.equals(salesordermap.get("FTreeEntity_FENTRYID")) && MaterList.get(fid).get(0).equals(salesordermap.get("FParentRowId"))) {
                                //如果对应的编码不为空
                                if (null != MaterList.get(fid).get(1)) {
                                    salesordermap.put("mainCode", MaterList.get(fid).get(1));
                                } else {
                                    salesordermap.put("mainCode", "");
                                }
                            }
                        }
                    }
                }
            } else {
                //如果有错误信息则返回
                Map<String, Object> o = (Map<String, Object>) list.get(0).get(0);
                Object errors = o.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }

    @Override
    public String update(Object object) {
        return null;
    }
}
