package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import lombok.Data;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeResultParseUtil;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description: ImsProduceOrderCloseController  工单关单
 * @Author: jeecg-boot
 * @Date: 2021-12-02
 * @Version: V1.0
 */
@Component
@Data
public class ImsProduceOrderCloseApi implements web_api {
    @Autowired
    private CategoryDao categoryDao;

    private String sFormId;
    private String Father_FEnrtyID;
    private String KingdeeLogPushName;
    private String KingdeeLogName;
    private String Father_sFormId;
    private String push_Rule;
    private String Son_FEnrtyID;
    private String SeqName;
    private String KingdeeLogOZTName;

    public ImsProduceOrderCloseApi() {
        sFormId = "PRD_MO";  //子单据Formid
        KingdeeLogName = "生产订单关闭";    //金蝶云修改操作日志-nam
        KingdeeLogOZTName = "工单关单";    //金蝶云修改操作日志对应欧智通-name
    }

    @Override
    public String add(Map<String, Object> maps) {
        return null;
    }

    public List<Map<String, String>> addTwo(List<Map<String, Object>> lists) {
        String result = new String();
        Map<String, Object> stringStringMap = ImsToKingdee(lists);
        JSONObject responseStatus = categoryDao.addReturn(KingdeeLogName, sFormId, JsonUtil.Mapjson(stringStringMap));
        List<JSONObject> successEntitys = (List<JSONObject>) responseStatus.get("SuccessEntitys");
        Boolean isSuccess = (Boolean) responseStatus.get("IsSuccess");
        String successEntitysString = JSON.toJSONString(successEntitys);
        if (isSuccess == false) {
            String message = new String();
            List<JSONObject> Errors = (List<JSONObject>) responseStatus.get("Errors");
            for (JSONObject error : Errors) {
                JSONObject messags = Errors.get(0);
                message = message + " " + String.valueOf(messags.get("Message"));
            }
            result = String.valueOf(message);
        }
        List<Map<String, String>> list = new ArrayList<>();
        if (!ObjectUtils.isEmpty(successEntitys)) {
            for (JSONObject successEntity : successEntitys) {
                String FID = successEntity.get("Id").toString();
                String FBillNo = successEntity.get("Number").toString();
                Map<String, String> map = new HashMap<>();
                map.put("FID", FID);
                map.put("FBILL_NO", FBillNo);
                map.put("result", result);
                list.add(map);
            }
        } else {
            Map<String, String> map = new HashMap<>();
            map.put("result", result);
            list.add(map);
        }
        return list;
    }

    public Map<String, String> addReturnResult(List<Map<String, Object>> lists) {
        /*Map<String, Object> stringStringMap = ImsToKingdee(lists);
        String result = categoryDao.addNoSubmit(KingdeeLogName, sFormId, JsonUtil.Mapjson(stringStringMap));
        Result result1 = KingdeeResultParseUtil.parseAddResult(result);*/

        Map<String, String> map = new HashMap<>();
        String fBillNo = (String) lists.stream().filter(m -> m.containsKey("MO_CODE")).map(m -> m.get("MO_CODE")).findFirst().orElse("");
        String[] split = fBillNo.split("_");
        Map<String, String> key = new HashMap<>();
        //单据头实体主键
        key.put("FID", "FID");
        List<List<Object>> fList = categoryDao.select("PRD_MO", key, new HashMap<String, String>() {{
            put("FBillNo", split[0]);
        }});
        map.put("FID", String.valueOf(fList.get(0).get(0)));
        map.put("FBillNo", fBillNo);

        // 通过主键修改IMS状态
        String result = categoryDao.updateImsStatus(String.valueOf(fList.get(0).get(0)), Integer.parseInt(split[1]));
        map.put("result", result);
        return map;
    }

    public Result AutoSubmit(String fid) {
        String result = categoryDao.AutoSubmit(sFormId, fid, KingdeeLogName);
        Result result1 = KingdeeResultParseUtil.parseAddResult(result);
        return result1;
    }

    /*ims字段转换成金蝶云待添加(其实都是下推后修改)字段*/
    public Map<String, Object> ImsToKingdee(List<Map<String, Object>> lists) {
        List<Map<String, Object>> list = new ArrayList<>();
        Map<String, Object> ModelMap = new HashMap<>();
        for (Map<String, Object> maps : lists) {
            Map<String, Object> FEntityMap = new HashMap<>();
            //字段转化
            FEntityMap.put("FMaterialId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("MTRL_CODE"));
            }}); //物料编码
            FEntityMap.put("FQty", maps.get("QUANTITY")); //数量
            FEntityMap.put("FMemoItem", maps.get("REMARK")); //备注
            list.add(FEntityMap);
            ModelMap.put("FApproverId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("USER_CODE"));
            }}); //仓管员
            ModelMap.put("FPrdOrgId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("ORG_ID"));
            }}); //生产组织
            ModelMap.put("FDate", maps.get("TRX_DATE"));  //交易时间
        }
        ModelMap.put("FTreeEntity", list);
        return ModelMap;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }

    /*根据FID查询FEntity_FEntryId*/
    public String select(String seq, String FID) {
        if (ObjectUtils.isEmpty(FID)) {
            FID = new String();
        }
        String FEntity_FEntryId = categoryDao.Son_FindFentryId(SeqName, Son_FEnrtyID, Integer.valueOf(seq), FID, sFormId);
        return FEntity_FEntryId;
    }

    @Override
    public String update(
            Object object) {
        return null;
    }


}
