package org.jeecg.modules.iost.ims.service.impl;

import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsImsNestingAnalysis;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsNestingAnalysisKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsImsNestingAnalysisMapper;
import org.jeecg.modules.iost.ims.service.IImsImsNestingAnalysisService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.text.ParseException;
import java.util.*;

/**
 * @Description: 齐套分析
 * @Author: jeecg-boot
 * @Date:   2021-12-27
 * @Version: V1.0
 */
@Service
public class ImsImsNestingAnalysisServiceImpl extends ServiceImpl<ImsImsNestingAnalysisMapper, ImsImsNestingAnalysis> implements IImsImsNestingAnalysisService {
    @Autowired
    IMSApi imsApi;
    @Autowired
    ImsNestingAnalysisKingdeeApi kingdeeApi;
    @Override
    public Boolean synchronization(Object object, LoginUser sysUser) throws ParseException {
        //追加参数(上下文对象)
        String kingdeeLogOZTName = "齐套分析";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName",kingdeeLogOZTName);

        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<ImsImsNestingAnalysis> pojolist=new ArrayList<>();
        List<Map<String, String>> list=new ArrayList<>();
        List<Map<String, Object>> imsList=new ArrayList<>();
        Boolean success = false;
        Map<String,String> wms_allot_mtrl=new HashMap<>();
        Map<String,String> idmap=new HashMap<>();
        //设置需要同步的主键
        idmap.put("FID",object.toString());
        //将对应信息请求金蝶云
        list=kingdeeApi.select(idmap,null);

        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if(data.containsKey("false")){
                return success;
            }
            //将实体信息记录下来
            ImsImsNestingAnalysis pojo = new ImsImsNestingAnalysis();
            pojo.setFid(data.get("fid"));
            pojo.setOrgId(data.get("orgId"));
            pojo.setMtrlCode(data.get("mtrlCode"));
            pojo.setMissingmtrlQty(data.get("missingmtrlQty"));
            pojo.setCreateTime(new Date());
            if(sysUser!=null){
                pojo.setCreateBy(sysUser.getUsername());
                pojo.setSysOrgCode(sysUser.getOrgCode());
            }
            pojolist.add(pojo);
            //封装成IMS格式
            Map<String,Object> datalist=new HashMap<>();
            datalist.put("org_id",data.get("orgId"));
            datalist.put("mtrl_code",data.get("mtrlCode"));
            datalist.put("missingmtrl_qty",data.get("missingmtrlQty"));
            imsList.add(datalist);
        }
        this.saveBatch(pojolist);
        //将数据包装成IMS格式
        Map<String,Object> map=new HashMap<>();
        map.put("docType","IMS_NESTING_ANALYSIS");
        map.put("updateType","UPDATE");
        map.put("data",imsList);
        String mapjson = JsonUtil.Mapjson(map);
        String result = imsApi.add(mapjson, "生产齐套分析单","IMS_NESTING_ANALYSIS");
        //记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(mapjson,result, "生产齐套分析单","IMS_NESTING_ANALYSIS",null);
        //设置同步成功状态
        success=flag;
        return success;
    }

}
