package org.jeecg.modules.iost.ims.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsPickingListKingdeeApi;
import org.jeecg.modules.iost.ims.service.IImsPickingListService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
@Service
public class ImsPickingListServiceImpl implements IImsPickingListService {

    @Autowired
    private IMSApi imsApi;

    @Autowired
    private ImsPickingListKingdeeApi imsPickingListKingdeeApi;


    @Override
    public Boolean synchronization(Object object, LoginUser sysUser) {
        //追加参数(上下文对象)
        String kingDeeLogOZTName = "提料分析";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingDeeLogOZTName);

        //设置需要同步的主键
        Map<String, String> whereMap = new HashMap<>();
        whereMap.put("FID", object.toString());
        List<Map<String, String>> list = imsPickingListKingdeeApi.select(whereMap);

        Boolean flag;
        List<Map<String, Object>> imsList = new ArrayList<>();
        for (Map<String, String> map : list) {
            if (map.containsKey("false")) {
                return false;
            }

            Map<String, Object> imsMap = new HashMap<>(11);
            imsMap.put("po_code", map.get("poCode"));
            imsMap.put("mtrl_code", map.get("mtrlCode"));
            imsMap.put("deliverable_qty", new BigDecimal(map.get("deliverableQty")));
            imsMap.put("sup_code", map.get("supCde"));
            imsMap.put("sup_mtrl_dt_anal_no", map.get("supMtrlDtAnalNo"));
            imsMap.put("m_unit", map.get("mUnit"));
            int poSeq = 0;
            if (StringUtils.isNotBlank(map.get("poSeq"))) {
                poSeq = Integer.parseInt(map.get("poSeq"));
            }
            imsMap.put("po_seq", poSeq);
            imsMap.put("demand_date", map.get("demandDate"));
            imsMap.put("sdl_no", map.get("sdlNo"));
            imsMap.put("sdl_mtrl", map.get("sdlMtrl"));
            imsList.add(imsMap);
        }

        //将数据包装成IMS格式
        Map<String, Object> map = new HashMap<>();
        map.put("docType", "SUP_MTRL_DT_DATA");
        map.put("updateType", "UPDATE");
        map.put("data", imsList);
        String json = JsonUtil.toString(map);
        String result = imsApi.add(json, "提料分析单", "SUP_MTRL_DT_DATA");
        //记录IMS日志
        flag = new ImsLogUtil().ImsLog(json, result, "提料分析单", "SUP_MTRL_DT_DATA", null);
        return flag;
    }


}
