package org.jeecg.common.util;

import java.util.Map;


public class ThreadLocalConfig {

    // jdk建议将 ThreadLocal 定义为 private static ，这样就不会有弱引用，内存泄漏的问题了
    private static ThreadLocal<Map> mapThreadLocal = new ThreadLocal<>();

    //获取当前线程的存的变量
    public static Map get() {
        return mapThreadLocal.get();
    }

    //设置当前线程的存的变量
    public static void set(Map map) {
        ThreadLocalConfig.mapThreadLocal.set(map);
    }

    //移除当前线程的存的变量
    public static void remove() {
        ThreadLocalConfig.mapThreadLocal.remove();
    }


}

