package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.ims.entity.ImsProcessScrapReceipt;
import org.jeecg.modules.iost.ims.service.IImsProcessScrapReceiptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

 /**
 * @Description: 过程报废收料确认
 * @Author: LY
 * @Date:   2021-12-09
 * @Version: V1.0
 */
@Api(tags="过程报废收料确认")
@RestController
@RequestMapping("/ims/imsProcessScrapReceipt")
@Slf4j
public class ImsProcessScrapReceiptController extends JeecgController<ImsProcessScrapReceipt, IImsProcessScrapReceiptService> {
	@Autowired
	private IImsProcessScrapReceiptService imsProcessScrapReceiptService;
	
	/**
	 * 分页列表查询
	 *
	 * @param imsProcessScrapReceipt
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "过程报废收料确认-分页列表查询")
	@ApiOperation(value="过程报废收料确认-分页列表查询", notes="过程报废收料确认-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(ImsProcessScrapReceipt imsProcessScrapReceipt,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
                                   String dateString, String codeString, String queueId,
								   HttpServletRequest req) {
		QueryWrapper<ImsProcessScrapReceipt> queryWrapper = QueryGenerator.initQueryWrapper(imsProcessScrapReceipt, req.getParameterMap());
        if (StringUtils.isNotBlank(dateString)) {
            String[] split = dateString.split(",");
            queryWrapper.between("trx_date", split[0] + " 00:00:00", split[1] + " 00:00:00");
        }
        if (StringUtils.isNotBlank(codeString)) {
            queryWrapper.eq("fbill_no", codeString);
        }
		Page<ImsProcessScrapReceipt> page = new Page<ImsProcessScrapReceipt>(pageNo, pageSize);
		IPage<ImsProcessScrapReceipt> pageList = imsProcessScrapReceiptService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param imsProcessScrapReceipt
	 * @return
	 */
	@AutoLog(value = "过程报废收料确认-添加")
	@ApiOperation(value="过程报废收料确认-添加", notes="过程报废收料确认-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody ImsProcessScrapReceipt imsProcessScrapReceipt) {
		imsProcessScrapReceiptService.save(imsProcessScrapReceipt);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param imsProcessScrapReceipt
	 * @return
	 */
	@AutoLog(value = "过程报废收料确认-编辑")
	@ApiOperation(value="过程报废收料确认-编辑", notes="过程报废收料确认-编辑")
	@PutMapping(value = "/edit")
	public Result<?> edit(@RequestBody ImsProcessScrapReceipt imsProcessScrapReceipt) {
		imsProcessScrapReceiptService.updateById(imsProcessScrapReceipt);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "过程报废收料确认-通过id删除")
	@ApiOperation(value="过程报废收料确认-通过id删除", notes="过程报废收料确认-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		imsProcessScrapReceiptService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "过程报废收料确认-批量删除")
	@ApiOperation(value="过程报废收料确认-批量删除", notes="过程报废收料确认-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.imsProcessScrapReceiptService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "过程报废收料确认-通过id查询")
	@ApiOperation(value="过程报废收料确认-通过id查询", notes="过程报废收料确认-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		ImsProcessScrapReceipt imsProcessScrapReceipt = imsProcessScrapReceiptService.getById(id);
		if(imsProcessScrapReceipt==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(imsProcessScrapReceipt);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param imsProcessScrapReceipt
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ImsProcessScrapReceipt imsProcessScrapReceipt) {
        return super.exportXls(request, imsProcessScrapReceipt, ImsProcessScrapReceipt.class, "过程报废收料确认");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ImsProcessScrapReceipt.class);
    }

}
