package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.ims.entity.ImsProduceOrderReady;
import org.jeecg.modules.iost.ims.service.IImsProduceOrderReadyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

/**
 * @Description: 工单备料
 * @Author: jeecg-boot
 * @Date: 2022-01-10
 * @Version: V1.0
 */
@Api(tags = "工单备料")
@RestController
@RequestMapping("/org.jeecg.modules.iost.ims.entity/imsProduceOrderReady")
@Slf4j
public class ImsProduceOrderReadyController extends JeecgController<ImsProduceOrderReady, IImsProduceOrderReadyService> {
    @Autowired
    private IImsProduceOrderReadyService imsProduceOrderReadyService;

    /**
     * 分页列表查询
     *
     * @param imsProduceOrderReady
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "工单备料-分页列表查询")
    @ApiOperation(value = "工单备料-分页列表查询", notes = "工单备料-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(ImsProduceOrderReady imsProduceOrderReady,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   String dateString, String codeString, String queueId,
                                   HttpServletRequest req) {
        QueryWrapper<ImsProduceOrderReady> queryWrapper = QueryGenerator.initQueryWrapper(imsProduceOrderReady, req.getParameterMap());
        if (StringUtils.isNotBlank(dateString)) {
            String[] split = dateString.split(",");
            queryWrapper.between("trx_date", split[0] + " 00:00:00", split[1] + " 00:00:00");
        }
        if (StringUtils.isNotBlank(codeString)) {
            queryWrapper.eq("fbill_no", codeString);
        }
        Page<ImsProduceOrderReady> page = new Page<ImsProduceOrderReady>(pageNo, pageSize);
        IPage<ImsProduceOrderReady> pageList = imsProduceOrderReadyService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param imsProduceOrderReady
     * @return
     */
    @AutoLog(value = "工单备料-添加")
    @ApiOperation(value = "工单备料-添加", notes = "工单备料-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody ImsProduceOrderReady imsProduceOrderReady) {
        imsProduceOrderReadyService.save(imsProduceOrderReady);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param imsProduceOrderReady
     * @return
     */
    @AutoLog(value = "工单备料-编辑")
    @ApiOperation(value = "工单备料-编辑", notes = "工单备料-编辑")
    @PutMapping(value = "/edit")
    public Result<?> edit(@RequestBody ImsProduceOrderReady imsProduceOrderReady) {
        imsProduceOrderReadyService.updateById(imsProduceOrderReady);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "工单备料-通过id删除")
    @ApiOperation(value = "工单备料-通过id删除", notes = "工单备料-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name = "id", required = true) String id) {
        imsProduceOrderReadyService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "工单备料-批量删除")
    @ApiOperation(value = "工单备料-批量删除", notes = "工单备料-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.imsProduceOrderReadyService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    @AutoLog(value = "工单备料-通过id查询")
    @ApiOperation(value = "工单备料-通过id查询", notes = "工单备料-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<?> queryById(@RequestParam(name = "id", required = true) String id) {
        ImsProduceOrderReady imsProduceOrderReady = imsProduceOrderReadyService.getById(id);
        if (imsProduceOrderReady == null) {
            return Result.error("未找到对应数据");
        }
        return Result.OK(imsProduceOrderReady);
    }

    /**
     * 导出excel
     *
     * @param request
     * @param imsProduceOrderReady
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ImsProduceOrderReady imsProduceOrderReady) {
        return super.exportXls(request, imsProduceOrderReady, ImsProduceOrderReady.class, "工单备料");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ImsProduceOrderReady.class);
    }

}
