package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.entity.Imslog;
import org.jeecg.modules.iost.ims.service.IImslogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @Description: ims响应日志
 * @Author: jeecg-boot
 * @Date: 2021-09-03
 * @Version: V1.0
 */
@Api(tags = "ims日志")
@RestController
@RequestMapping("/imslog")
@Slf4j
public class ImslogController extends JeecgController<Imslog, IImslogService> {
    @Autowired
    private IImslogService imslogService;
    @Autowired
    private ISysBaseAPI sysBaseAPI;

    /**
     * 分页列表查询
     *
     * @param imslog
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "ims响应日志-分页列表查询")
    @ApiOperation(value = "ims响应日志-分页列表查询", notes = "ims响应日志-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(Imslog imslog,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   HttpServletRequest req,
                                   @RequestParam(name = "successStatus") String status,
                                   String dateString, String codeString, String queueId,
                                   @RequestParam(name = "date") String date) throws ParseException {
        QueryWrapper<Imslog> queryWrapper = QueryGenerator.initQueryWrapper(imslog, req.getParameterMap());
        Page<Imslog> page = new Page<Imslog>(pageNo, pageSize);
        if (!"null".equals(date)) {
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
            Date parse = sdf1.parse(date);
            //根据查询日期拿到明天
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(parse);
            calendar.add(Calendar.DATE, 1);
            String parse1 = sdf1.format(calendar.getTime());
            queryWrapper.gt("create_time", parse);
            queryWrapper.lt("create_time", parse1);
        }
        if (StringUtils.isNotBlank(dateString)) {
            String[] split = dateString.split(",");
            queryWrapper.between("create_time", split[0] + " 00:00:00", split[1] + " 00:00:00");
        }
        if ("1".equals(status)) {
            queryWrapper.eq("success", "true");
        } else if ("2".equals(status)) {
            queryWrapper.eq("success", "false");
        } else if ("3".equals(status)) {
            queryWrapper.eq("success", "Partial success");
        }
        queryWrapper.orderByDesc("create_time");
        IPage<Imslog> pageList = imslogService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param imslog
     * @return
     */
    @AutoLog(value = "ims响应日志-添加")
    @ApiOperation(value = "ims响应日志-添加", notes = "ims响应日志-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody Imslog imslog) {
        imslogService.save(imslog);
        return Result.OK("添加成功！");
    }


    /**
     * 导出excel
     *
     * @param request
     * @param imslog
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, Imslog imslog) {
        return super.exportXls(request, imslog, Imslog.class, "ims响应日志");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, Imslog.class);
    }

    /**
     * 同步
     *
     * @return
     * @throws ParseException
     */
    @AutoLog(value = "IMS手动同步API")
    @ApiOperation(value = "IMS手动同步API", notes = "IMS手动同步API")
    @GetMapping(value = "/synchronization")
    public Result<?> synchronization(@RequestParam(name = "id", required = true) String id, HttpServletRequest req) throws ParseException {
        //获取当前用户
        String token = req.getHeader(CommonConstant.X_ACCESS_TOKEN);
        String username = JwtUtil.getUsername(token);
        LoginUser sysUser = sysBaseAPI.getUserByName(username);
        Boolean flag = imslogService.synchronization(id, sysUser);
        if (flag) {
            return Result.OK("同步成功");
        }
        return Result.error("同步失败");
    }

}
