package org.jeecg.modules.iost.ims.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 调拨单信息
 * @Author: jeecg-boot
 * @Date:   2021-12-15
 * @Version: V1.0
 */
@Data
@TableName("ims_wms_allot")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="ims_wms_allot对象", description="调拨单信息")
public class ImsWmsAllot implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private java.lang.String sysOrgCode;
	/**组织代码*/
	@Excel(name = "组织代码", width = 15)
    @ApiModelProperty(value = "组织代码")
    private java.lang.String orgId;
	/**调拨单编码*/
	@Excel(name = "调拨单编码", width = 15)
    @ApiModelProperty(value = "调拨单编码")
    private java.lang.String allotCode;
	/**源仓库编码*/
	@Excel(name = "源仓库编码", width = 15)
    @ApiModelProperty(value = "源仓库编码")
    private java.lang.String srcStoreCode;
	/**目的组织代码*/
	@Excel(name = "目的组织代码", width = 15)
    @ApiModelProperty(value = "目的组织代码")
    private java.lang.String toOrgId;
	/**目的仓库编码*/
	@Excel(name = "目的仓库编码", width = 15)
    @ApiModelProperty(value = "目的仓库编码")
    private java.lang.String toStoreCode;
	/**调拨类型*/
	@Excel(name = "调拨类型", width = 15)
    @ApiModelProperty(value = "调拨类型")
    private java.lang.String allotType;
	/**出库规则*/
	@Excel(name = "出库规则", width = 15)
    @ApiModelProperty(value = "出库规则")
    private java.lang.String flRule;
	/**是否超调拨*/
	@Excel(name = "是否超调拨", width = 15)
    @ApiModelProperty(value = "是否超调拨")
    private java.lang.String isOfAllot;
	/**物料编码*/
	@Excel(name = "物料编码", width = 15)
    @ApiModelProperty(value = "物料编码")
    private java.lang.String mtrlCode;
	/**调拨数量*/
	@Excel(name = "调拨数量", width = 15)
    @ApiModelProperty(value = "调拨数量")
    private java.lang.Double allotQty;
	/**SKU编码*/
	@Excel(name = "SKU编码", width = 15)
    @ApiModelProperty(value = "SKU编码")
    private java.lang.String skuCode;
	/**批次*/
	@Excel(name = "批次", width = 15)
    @ApiModelProperty(value = "批次")
    private java.lang.String lotno;
	/**出库粒度*/
	@Excel(name = "出库粒度", width = 15)
    @ApiModelProperty(value = "出库粒度")
    private java.lang.String plDay;
	/**备注*/
	@Excel(name = "备注", width = 15)
    @ApiModelProperty(value = "备注")
    private java.lang.String remark;
	/**主键ID*/
	@Excel(name = "主键ID", width = 15)
    @ApiModelProperty(value = "主键ID")
    private java.lang.String fid;
}
