package org.jeecg.modules.iost.ims.kingdeeapi;

import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @author Inori
 */
@Component
public class DeductionFormKingdeeApi {

    @Autowired
    private CategoryDao categoryDao;

    private static final String FORM_ID = "AP_Payable";

    private static final String KING_DEE_LOG_NAME = "扣款单";


    public String addTwo(List<Map<String, Object>> lists) {
        String add = null;
        for (Map<String, Object> map : lists) {
            Map<String, Object> stringStringMap = imsToKingDee(map);
            add = categoryDao.add(KING_DEE_LOG_NAME, FORM_ID, JsonUtil.Mapjson(stringStringMap));
        }
        return add == null ? "添加成功!" : "";
    }

    public LinkedHashMap<String, Object> imsToKingDee(Map<String, Object> map) {
        //转换成金蝶云格式
        /* 单据头 */
        LinkedHashMap<String, Object> modelMap = new LinkedHashMap<>();
        //单据类型
        modelMap.put("FBillTypeID", new HashMap<String, Object>() {{
            put("FNumber", "YFD02_SYS");
        }});
        //单据编码
        modelMap.put("FBillNo", map.get("SUP_DEDUCTIONS_CODE"));
        //业务类型
        modelMap.put("FBUSINESSTYPE", "FY");
        //立账类型
        modelMap.put("FSetAccountType", "3");
        //备注
        modelMap.put("FAP_Remark", map.get("REMARK"));
        //日期
        modelMap.put("FDATE", map.get("REVIEW_DATE"));
        //供应商编码
        modelMap.put("FSUPPLIERID", new HashMap<String, Object>() {{
            put("FNumber", map.get("SUP_CODE"));
        }});

        /* 明细 */
        List<Map<String, Object>> list = new ArrayList<>();
        LinkedHashMap<String, Object> fEntityMap = new LinkedHashMap<>();
        //扣款类型
        fEntityMap.put("FCOSTID", new HashMap<String, Object>() {{
            put("FNumber", "fy52");
        }});
        //计价数量
        fEntityMap.put("FPriceQty", "-1");
        //实际扣款金额
        fEntityMap.put("FTaxPrice", map.get("ACTUAL_DEMONY"));
        //备注
        fEntityMap.put("FEntrtyMemo", map.get("APPEAL_REASON"));
        list.add(fEntityMap);
        modelMap.put("FEntityDetail", list);

        return modelMap;

    }


}
