/*
SQLyog Community
MySQL - 8.0.27 : Database - oztsystem
*********************************************************************
*/

/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`oztsystem` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `oztsystem`;

/*Table structure for table `ces_field_kongj` */

DROP TABLE IF EXISTS `ces_field_kongj`;

CREATE TABLE `ces_field_kongj` (
  `id` varchar(36) NOT NULL COMMENT '主键',
  `create_by` varchar(50) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) DEFAULT NULL COMMENT '所属部门',
  `name` varchar(32) DEFAULT NULL COMMENT '用户名',
  `sex` varchar(32) DEFAULT NULL COMMENT '下拉框',
  `radio` varchar(32) DEFAULT NULL COMMENT 'radio',
  `checkbox` varchar(32) DEFAULT NULL COMMENT 'checkbox',
  `sel_mut` varchar(32) DEFAULT NULL COMMENT '下拉多选',
  `sel_search` varchar(32) DEFAULT NULL COMMENT '下拉搜索',
  `birthday` datetime DEFAULT NULL COMMENT '时间',
  `pic` varchar(1000) DEFAULT NULL COMMENT '图片',
  `files` varchar(1000) DEFAULT NULL COMMENT '文件',
  `remakr` text COMMENT 'markdown',
  `fuwenb` text COMMENT '富文本',
  `user_sel` varchar(200) DEFAULT NULL COMMENT '选择用户',
  `dep_sel` varchar(200) DEFAULT NULL COMMENT '选择部门',
  `ddd` double(10,0) DEFAULT NULL COMMENT 'DD类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `ces_field_kongj` */

insert  into `ces_field_kongj`(`id`,`create_by`,`create_time`,`update_by`,`update_time`,`sys_org_code`,`name`,`sex`,`radio`,`checkbox`,`sel_mut`,`sel_search`,`birthday`,`pic`,`files`,`remakr`,`fuwenb`,`user_sel`,`dep_sel`,`ddd`) values 
('1260185893546840066','admin','2020-05-12 20:31:44','admin','2020-09-11 17:02:30','A01','A011','2','2','1,2','','',NULL,'','','','','zhagnxiao','A01',NULL),
('1260185911146139650','admin','2020-05-12 20:31:49','admin','2020-07-20 17:10:05','A01','A011',NULL,'1','1,2',NULL,'admin',NULL,'d52a2834349b033b6d20d5cc16ce36d3d539bd7f_1594438138364.jpg','','',NULL,'admin','A01',NULL),
('1285112866127577089','admin','2020-07-20 15:22:38','admin','2020-09-11 14:07:22','A01','张三2','','2','','','',NULL,'','','','','','',NULL);

/*Table structure for table `ces_order_customer` */

DROP TABLE IF EXISTS `ces_order_customer`;

CREATE TABLE `ces_order_customer` (
  `id` varchar(36) NOT NULL,
  `create_by` varchar(50) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) DEFAULT NULL COMMENT '所属部门',
  `name` varchar(32) DEFAULT NULL COMMENT '客户名字',
  `sex` varchar(1) DEFAULT NULL COMMENT '客户性别',
  `birthday` datetime DEFAULT NULL COMMENT '客户生日',
  `age` int DEFAULT NULL COMMENT '年龄',
  `address` varchar(300) DEFAULT NULL COMMENT '常用地址',
  `order_main_id` varchar(32) DEFAULT NULL COMMENT '订单ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `ces_order_customer` */

insert  into `ces_order_customer`(`id`,`create_by`,`create_time`,`update_by`,`update_time`,`sys_org_code`,`name`,`sex`,`birthday`,`age`,`address`,`order_main_id`) values 
('1281792646935842818','admin','2020-07-11 11:29:16',NULL,NULL,'A01',NULL,NULL,NULL,NULL,NULL,'1260135645520654338'),
('1281794386984779777','admin','2020-07-11 11:36:11',NULL,NULL,'A01','管理员','1','2018-12-05 00:00:00',NULL,NULL,'1281794386716344321'),
('15889531549290863128','admin','2020-05-08 23:54:00',NULL,NULL,'A01','小王','1','2020-05-08 00:00:00',1,'','1258787241599250433'),
('15889531551231672264','admin','2020-05-08 23:54:00',NULL,NULL,'A01','校长','2','2020-05-23 00:00:00',2,'','1258787241599250433'),
('15889531554322486243','admin','2020-05-08 23:54:00',NULL,NULL,'A01','小明','2','2020-05-03 00:00:00',3,'','1258787241599250433'),
('15892741044590530487','admin','2020-05-12 17:02:32',NULL,NULL,'A01A05','111','1','2020-05-12 00:00:00',NULL,'','1260133243631562754'),
('15892741436981375151','admin','2020-05-12 17:02:32',NULL,NULL,'A01A05','11','1','2020-05-14 00:00:00',NULL,'','1260133243631562754');

/*Table structure for table `ces_order_goods` */

DROP TABLE IF EXISTS `ces_order_goods`;

CREATE TABLE `ces_order_goods` (
  `id` varchar(36) NOT NULL,
  `create_by` varchar(50) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) DEFAULT NULL COMMENT '所属部门',
  `good_name` varchar(32) DEFAULT NULL COMMENT '商品名字',
  `price` double DEFAULT NULL COMMENT '价格',
  `num` int DEFAULT NULL COMMENT '数量',
  `zong_price` double DEFAULT NULL COMMENT '单品总价',
  `order_main_id` varchar(32) DEFAULT NULL COMMENT '订单ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `ces_order_goods` */

insert  into `ces_order_goods`(`id`,`create_by`,`create_time`,`update_by`,`update_time`,`sys_org_code`,`good_name`,`price`,`num`,`zong_price`,`order_main_id`) values 
('15889531536650244013','admin','2020-05-08 23:54:00',NULL,NULL,'A01','显示器',11,1,11,'1258787241599250433'),
('15889531538491119218','admin','2020-05-08 23:54:00',NULL,NULL,'A01','鼠标',22,2,44,'1258787241599250433'),
('15889532051192650399','admin','2020-05-08 23:54:00',NULL,NULL,'A01','键盘',33,3,99,'1258787241599250433'),
('15892741033410312304','admin','2020-05-12 17:02:32',NULL,NULL,'A01A05','雷蛇键盘',200,2,NULL,'1260133243631562754'),
('15892741162151118866','admin','2020-05-12 17:02:32',NULL,NULL,'A01A05','樱桃键盘',200,4,NULL,'1260133243631562754'),
('15892747180850346324','admin','2020-07-11 11:29:16',NULL,NULL,'A01','11',11,NULL,NULL,'1260135645520654338'),
('15892934593221167669','admin','2020-07-11 11:29:16',NULL,NULL,'A01','',NULL,NULL,NULL,'1260135645520654338'),
('15892934594762635052','admin','2020-07-11 11:29:16',NULL,NULL,'A01','',NULL,NULL,NULL,'1260135645520654338'),
('15944385645060861881','admin','2020-07-11 11:36:11',NULL,NULL,'A01','11',NULL,NULL,NULL,'1281794386716344321'),
('15944385663981814101','admin','2020-07-11 11:36:11',NULL,NULL,'A01','22',NULL,NULL,NULL,'1281794386716344321');

/*Table structure for table `ces_order_main` */

DROP TABLE IF EXISTS `ces_order_main`;

CREATE TABLE `ces_order_main` (
  `id` varchar(36) NOT NULL,
  `create_by` varchar(50) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) DEFAULT NULL COMMENT '所属部门',
  `order_code` varchar(32) DEFAULT NULL COMMENT '订单编码',
  `xd_date` datetime DEFAULT NULL COMMENT '下单时间',
  `money` double DEFAULT NULL COMMENT '订单总额',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `ces_order_main` */

insert  into `ces_order_main`(`id`,`create_by`,`create_time`,`update_by`,`update_time`,`sys_org_code`,`order_code`,`xd_date`,`money`,`remark`) values 
('1258787241599250433','admin','2020-05-08 23:54:00',NULL,NULL,'A01','20200508-0001','2020-05-08 23:52:32',50000,NULL),
('1260133243631562754','admin','2020-05-12 17:02:32',NULL,NULL,'A01A05','202005120001','2020-05-12 17:01:39',NULL,NULL),
('1260135645520654338','admin','2020-05-12 17:12:04','admin','2020-07-11 11:29:16','A01','JDFX2020051217115656','2020-07-11 11:29:12',NULL,NULL),
('1281794386716344321','admin','2020-07-11 11:36:11',NULL,NULL,'A01','CN2020071111360067','2020-07-11 11:36:00',NULL,NULL);

/*Table structure for table `ces_shop_goods` */

DROP TABLE IF EXISTS `ces_shop_goods`;

CREATE TABLE `ces_shop_goods` (
  `id` varchar(36) NOT NULL COMMENT '主键',
  `create_by` varchar(50) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) DEFAULT NULL COMMENT '所属部门',
  `name` varchar(32) DEFAULT NULL COMMENT '商品名字',
  `price` decimal(10,5) DEFAULT NULL COMMENT '价格',
  `chuc_date` datetime DEFAULT NULL COMMENT '出厂时间',
  `contents` text COMMENT '商品简介',
  `good_type_id` varchar(32) DEFAULT NULL COMMENT '商品分类',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `ces_shop_goods` */

insert  into `ces_shop_goods`(`id`,`create_by`,`create_time`,`update_by`,`update_time`,`sys_org_code`,`name`,`price`,`chuc_date`,`contents`,`good_type_id`) values 
('1258408897326149634','admin','2020-05-07 22:50:35','admin','2020-05-07 22:52:17','A01','华为手机note',5000.00000,'2020-05-07 00:00:00','<div class=\"page1-content\" style=\"margin: 0px 0px 20px; padding: 0px; display: flex; justify-content: space-around; color: #2c3e50; font-family: Avenir, Helvetica, Arial, sans-serif; text-align: center; background-color: #eeeeee;\">\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(166, 55, 112, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/soo.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">快速开发</span></div>\n</div>\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(191, 188, 21, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/rule.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">数据权限</span></div>\n</div>\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(73, 101, 166, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/bpm2.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">工作流</span></div>\n</div>\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(135, 85, 255, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/report1.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">丰富组件库</span></div>\n</div>\n</div>\n<div class=\"page1-content\" style=\"margin: 0px; padding: 0px; display: flex; justify-content: space-around; color: #2c3e50; font-family: Avenir, Helvetica, Arial, sans-serif; text-align: center; background-color: #eeeeee;\">\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(166, 55, 112, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/icon1.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">代码生成器</span></div>\n</div>\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(191, 188, 21, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/Automation.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">Online在线开发</span></div>\n</div>\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(73, 101, 166, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/form2.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">表单设计器</span></div>\n</div>\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(135, 85, 255, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/bpm3.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">流程设计器</span></div>\n</div>\n</div>','1258408044439597058'),
('1258783909887422466','admin','2020-05-08 23:40:45','admin','2020-05-08 23:43:03','A01','雷蛇鼠标',500.00000,'2020-05-08 00:00:00','','1258408003595464706'),
('1285114089585082370','admin','2020-07-20 15:27:29',NULL,NULL,'A01',NULL,NULL,NULL,NULL,NULL);

/*Table structure for table `ces_shop_type` */

DROP TABLE IF EXISTS `ces_shop_type`;

CREATE TABLE `ces_shop_type` (
  `id` varchar(36) NOT NULL,
  `create_by` varchar(50) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) DEFAULT NULL COMMENT '所属部门',
  `name` varchar(32) DEFAULT NULL COMMENT '分类名字',
  `content` varchar(200) DEFAULT NULL COMMENT '描述',
  `pics` varchar(500) DEFAULT NULL COMMENT '图片',
  `pid` varchar(32) DEFAULT NULL COMMENT '父级节点',
  `has_child` varchar(3) DEFAULT NULL COMMENT '是否有子节点',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `ces_shop_type` */

insert  into `ces_shop_type`(`id`,`create_by`,`create_time`,`update_by`,`update_time`,`sys_org_code`,`name`,`content`,`pics`,`pid`,`has_child`) values 
('1258408003595464706','admin','2020-05-07 22:47:02',NULL,NULL,'A01','衣服',NULL,'e1fe9925bc315c60addea1b98eb1cb1349547719_1588862821565.jpg','0','0'),
('1258408044439597058','admin','2020-05-07 22:47:12',NULL,NULL,'A01','鞋子',NULL,'jeewxshop测试号_1588862831749.jpg','0','1'),
('1258408076693794818','admin','2020-05-07 22:47:20','admin','2020-07-10 16:51:10','A01','耐克',NULL,'d52a2834349b033b6d20d5cc16ce36d3d539bd7f_1594371069797.jpg','1258408044439597058','0'),
('1258408105487691777','admin','2020-05-07 22:47:27','admin','2020-05-12 22:24:35','A01','阿迪',NULL,'temp/20180607175028Fn1Lq7zw_1589293474710.png','1258408044439597058','0');

/*Table structure for table `demo` */

DROP TABLE IF EXISTS `demo`;

CREATE TABLE `demo` (
  `id` varchar(50) NOT NULL COMMENT '主键ID',
  `name` varchar(30) DEFAULT NULL COMMENT '姓名',
  `key_word` varchar(255) DEFAULT NULL COMMENT '关键词',
  `punch_time` datetime DEFAULT NULL COMMENT '打卡时间',
  `salary_money` decimal(10,3) DEFAULT NULL COMMENT '工资',
  `bonus_money` double(10,2) DEFAULT NULL COMMENT '奖金',
  `sex` varchar(2) DEFAULT NULL COMMENT '性别 {男:1,女:2}',
  `age` int DEFAULT NULL COMMENT '年龄',
  `birthday` date DEFAULT NULL COMMENT '生日',
  `email` varchar(50) DEFAULT NULL COMMENT '邮箱',
  `content` varchar(1000) DEFAULT NULL COMMENT '个人简介',
  `create_by` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `sys_org_code` varchar(64) DEFAULT NULL COMMENT '所属部门编码',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;

/*Data for the table `demo` */

insert  into `demo`(`id`,`name`,`key_word`,`punch_time`,`salary_money`,`bonus_money`,`sex`,`age`,`birthday`,`email`,`content`,`create_by`,`create_time`,`update_by`,`update_time`,`sys_org_code`) values 
('1260935385049055234','111','111',NULL,NULL,NULL,NULL,20,NULL,NULL,NULL,'jeecg','2020-05-14 22:09:57','admin','2020-09-10 17:19:44','A02A01'),
('1260935402346364930','22','222',NULL,NULL,NULL,NULL,19,NULL,NULL,NULL,'jeecg','2020-05-14 22:10:02','admin','2020-09-10 17:19:39','A02A01'),
('1c2ba51b29a42d9de02bbd708ea8121a','777777','777','2018-12-07 19:43:17',NULL,NULL,NULL,7,'2018-12-07',NULL,NULL,NULL,NULL,'admin','2019-02-21 18:26:04',NULL),
('1dc29e80be14d1400f165b5c6b30c707','zhang daihao',NULL,NULL,NULL,NULL,'2',NULL,NULL,'zhangdaiscott@163.com',NULL,NULL,NULL,NULL,NULL,NULL),
('304e651dc769d5c9b6e08fb30457a602','小白兔',NULL,NULL,NULL,NULL,'2',28,NULL,NULL,NULL,'scott','2019-01-19 13:12:53','qinfeng','2019-01-19 13:13:12',NULL),
('4','Sandy','开源，很好','2018-12-15 00:00:00',NULL,NULL,'2',21,'2018-12-15','test4@baomidou.com','聪明00',NULL,NULL,'admin','2019-02-25 16:29:27',NULL),
('4436302a0de50bb83025286bc414d6a9','zhang daihao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'zhangdaiscott@163.com',NULL,'admin','2019-01-19 15:39:04',NULL,NULL,NULL),
('4981637bf71b0c1ed1365241dfcfa0ea','小虎',NULL,NULL,NULL,NULL,'2',28,NULL,NULL,NULL,'scott5','2019-01-19 13:12:53','qinfeng','2019-01-19 13:13:12','A02'),
('7','zhangdaiscott',NULL,NULL,NULL,NULL,'1',NULL,'2019-01-03',NULL,NULL,NULL,NULL,NULL,NULL,'A02A01A01'),
('73bc58611012617ca446d8999379e4ac','郭靖','777','2018-12-07 00:00:00',NULL,NULL,'1',NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-28 18:16:39','admin','2020-05-02 18:14:14','A02A01A02'),
('917e240eaa0b1b2d198ae869b64a81c3','zhang daihao',NULL,NULL,NULL,NULL,'2',0,'2018-11-29','zhangdaiscott@163.com',NULL,NULL,NULL,NULL,NULL,'A02'),
('94420c5d8fc4420dde1e7196154b3a24','秦风',NULL,NULL,NULL,NULL,'2',NULL,NULL,NULL,NULL,'scott','2019-01-19 12:54:58','admin','2020-05-02 18:14:33',NULL),
('b86897900c770503771c7bb88e5d1e9b','scott1','开源、很好、hello',NULL,NULL,NULL,'1',NULL,NULL,'zhangdaiscott@163.com',NULL,'scott','2019-01-19 12:22:34',NULL,NULL,NULL),
('c28fa8391ef81d6fabd8bd894a7615aa','小麦',NULL,NULL,NULL,NULL,'2',NULL,NULL,'zhangdaiscott@163.com',NULL,'jeecg-boot','2019-04-04 17:18:09',NULL,NULL,NULL),
('c2c0d49e3c01913067cf8d1fb3c971d2','zhang daihao',NULL,NULL,NULL,NULL,'2',NULL,NULL,'zhangdaiscott@163.com',NULL,'admin','2019-01-19 23:37:18','admin','2019-01-21 16:49:06',NULL),
('c96279c666b4b82e3ef1e4e2978701ce','报名时间',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-28 18:00:52',NULL,NULL,NULL),
('d24668721446e8478eeeafe4db66dcff','zhang daihao999',NULL,NULL,NULL,NULL,'1',NULL,NULL,'zhangdaiscott@163.com',NULL,NULL,NULL,NULL,NULL,NULL),
('eaa6c1116b41dc10a94eae34cf990133','zhang daihao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'zhangdaiscott@163.com',NULL,NULL,NULL,NULL,NULL,NULL);

/*Table structure for table `demo_field_def_val_main` */

DROP TABLE IF EXISTS `demo_field_def_val_main`;

CREATE TABLE `demo_field_def_val_main` (
  `id` varchar(36) NOT NULL,
  `code` varchar(200) DEFAULT NULL COMMENT '编码',
  `name` varchar(200) DEFAULT NULL COMMENT '姓名',
  `sex` varchar(200) DEFAULT NULL COMMENT '性别',
  `address` varchar(200) DEFAULT NULL COMMENT '地址',
  `address_param` varchar(32) DEFAULT NULL COMMENT '地址（传参）',
  `create_by` varchar(50) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) DEFAULT NULL COMMENT '所属部门',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `demo_field_def_val_main` */

insert  into `demo_field_def_val_main`(`id`,`code`,`name`,`sex`,`address`,`address_param`,`create_by`,`create_time`,`update_by`,`update_time`,`sys_org_code`) values 
('1256548579457114114','q','q','1','q','q','admin','2020-05-02 19:38:21','admin','2020-05-03 01:02:51','A01');

/*Table structure for table `demo_field_def_val_sub` */

DROP TABLE IF EXISTS `demo_field_def_val_sub`;

CREATE TABLE `demo_field_def_val_sub` (
  `id` varchar(36) NOT NULL,
  `code` varchar(200) DEFAULT NULL COMMENT '编码',
  `name` varchar(200) DEFAULT NULL COMMENT '名称',
  `date` varchar(200) DEFAULT NULL COMMENT '日期',
  `main_id` varchar(200) DEFAULT NULL COMMENT '主表ID',
  `create_by` varchar(50) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) DEFAULT NULL COMMENT '所属部门',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `demo_field_def_val_sub` */

insert  into `demo_field_def_val_sub`(`id`,`code`,`name`,`date`,`main_id`,`create_by`,`create_time`,`update_by`,`update_time`,`sys_org_code`) values 
('15884194974080425602','133','管理员','2020-05-02','1256548579457114114','admin','2020-05-03 01:02:51',NULL,NULL,'A01'),
('15884194979201535108','1144','管理员','2020-05-02','1256548579457114114','admin','2020-05-03 01:02:51',NULL,NULL,'A01');

/*Table structure for table `grid_error` */

DROP TABLE IF EXISTS `grid_error`;

CREATE TABLE `grid_error` (
  `id` varchar(32) NOT NULL,
  `status` int NOT NULL COMMENT '报错代码',
  `message` varchar(100) NOT NULL COMMENT '返回信息',
  `createTime` datetime NOT NULL COMMENT '创建日期',
  `requestjson` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '传入国网数据',
  `responsejson` text COMMENT '国网响应数据',
  `synchronization` int NOT NULL COMMENT '数据同步:成功:1,失败:2',
  `successagain` int DEFAULT NULL COMMENT '是否已成功:失败:0,成功:1',
  `business_no` int DEFAULT NULL COMMENT '业务编号',
  `business_name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '传入的业务',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

/*Data for the table `grid_error` */

insert  into `grid_error`(`id`,`status`,`message`,`createTime`,`requestjson`,`responsejson`,`synchronization`,`successagain`,`business_no`,`business_name`) values 
('1428286017646919682',0,'成功','2021-08-19 17:21:38','{\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"SCRK00009879\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\"}','1428286017357496321',1,NULL,NULL,NULL),
('1428286481192980482',0,'成功','2021-08-19 17:23:28','{\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"SCRK00009879\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\"}','1428286480740007937',1,NULL,NULL,NULL),
('1428286981468606465',0,'成功','2021-08-19 17:25:27','{\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"SCRK00009879\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\"}','1428286980373889026',1,NULL,NULL,NULL),
('1428288358802558977',0,'成功','2021-08-19 17:30:56','{\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"SCRK00009879\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\"}','1428288358303416322',1,NULL,NULL,NULL),
('1428288731835650049',0,'成功','2021-08-19 17:32:25','{\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"SCRK00009879\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\"}','1428288731336425474',1,NULL,NULL,NULL),
('1428289002091438082',0,'成功','2021-08-19 17:33:29','{\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"SCRK00009879\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\"}','1428289001629958146',1,NULL,NULL,NULL),
('1428289269427875842',0,'成功','2021-08-19 17:34:33','{\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"SCRK00009879\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\"}','1428289268891009025',1,NULL,NULL,NULL),
('1428289571203956737',0,'成功','2021-08-19 17:35:45','{\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"SCRK00009879\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\"}','1428289570750873602',1,NULL,NULL,NULL),
('1428291447869681665',0,'成功','2021-08-19 17:43:12','{\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"SCRK00009879\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\"}','1428291447307649026',1,NULL,NULL,NULL),
('1428291682314498050',0,'成功','2021-08-19 17:44:08','{\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"SCRK00009879\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\"}','1428291682020900866',1,NULL,NULL,NULL),
('1428292411678818305',0,'成功','2021-08-19 17:47:02','{\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"SCRK00009879\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\"}','1428292411162902530',1,NULL,NULL,NULL),
('1428293006234058754',0,'成功','2021-08-19 17:49:24','{\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"SCRK00009879\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\"}','1428293005755826178',1,NULL,NULL,NULL),
('1428293660520280066',0,'成功','2021-08-19 17:52:00','{\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"SCRK00009879\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\"}','1428293660004335617',1,NULL,NULL,NULL),
('1428293818398015490',0,'成功','2021-08-19 17:52:37','{\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"SCRK00009879\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\"}','1428293817894715394',1,NULL,NULL,NULL),
('1428294034400477186',0,'成功','2021-08-19 17:53:29','{\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"SCRK00009879\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\"}','1428294033721016322',1,NULL,NULL,NULL),
('1428294077333372930',0,'成功','2021-08-19 17:53:39','{\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"SCRK00009879\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\"}','1428294076968484866',1,NULL,NULL,NULL),
('1428294366383898625',0,'成功','2021-08-19 17:54:48','{\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"SCRK00009879\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\"}','1428294365784064001',1,NULL,NULL,NULL),
('1428294678427582466',0,'成功','2021-08-19 17:56:02','{\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"SCRK00009879\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\"}','1428294677685092354',1,NULL,NULL,NULL),
('1428298607831896065',0,'成功','2021-08-19 18:11:39','{\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"SCRK00009880\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\"}','1428298607315927042',1,NULL,NULL,NULL),
('1428298608393932801',0,'成功','2021-08-19 18:11:39','{\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"SCRK00009880\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\"}','1428298607970238465',1,NULL,NULL,NULL),
('1428541668419756033',0,'成功','2021-08-20 10:17:29','{\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"SCRK00009882\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\"}','1428541668830744578',1,NULL,NULL,NULL),
('1428635629645737986',0,'成功','2021-08-20 16:30:52','{\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"SCRK00009882\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\"}','1428635631344422914',1,NULL,NULL,NULL),
('1428635681319563266',0,'成功','2021-08-20 16:31:04','{\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"SCRK00009882\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\"}','1428635682988888065',1,NULL,NULL,NULL),
('1428899816892645378',0,'成功','2021-08-21 10:00:39','{\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"SCRK00009883\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\"}','1428899820268949506',1,NULL,NULL,NULL),
('1428903387969208321',0,'成功','2021-08-21 10:14:50','{\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"SCRK00009884\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\"}','1428903391588782081',1,NULL,NULL,NULL),
('1428907075999756290',0,'成功','2021-08-21 10:29:29','{\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"SCRK00009883\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\"}','1428907079573180418',1,NULL,NULL,NULL),
('1428907076339494913',0,'成功','2021-08-21 10:29:29','{\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"SCRK00009884\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\"}','1428907079996805122',1,NULL,NULL,NULL),
('1428914727160909825',0,'成功','2021-08-21 10:59:54','{\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"SCRK00009883\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\"}','1428914730931589122',1,NULL,NULL,NULL),
('1428914727668420610',0,'成功','2021-08-21 10:59:54','{\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"datasource\":\"0\",\"openid\":\"string\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"SCRK00009884\",\"purchaserhqcode\":\"SGCC\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\"}','1428914731548151809',1,NULL,NULL,NULL),
('1428964772279300098',0,'成功','2021-08-21 14:18:45','{\"FID\":\"SCRK00009883\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1428964776737771521',1,NULL,NULL,NULL),
('1428965026491871234',0,'成功','2021-08-21 14:19:46','{\"FID\":\"SCRK00009883\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1428965031076171778',1,NULL,NULL,NULL),
('1428965371909533698',0,'成功','2021-08-21 14:21:08','{\"FID\":\"SCRK00009883\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1428965376468717570',1,NULL,NULL,NULL),
('1428965372438016001',0,'成功','2021-08-21 14:21:08','{\"FID\":\"SCRK00009884\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1428965376955256833',1,NULL,NULL,NULL),
('1428965880770883586',0,'成功','2021-08-21 14:23:10','{\"FID\":\"SCRK00009883\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1428965885346844673',1,NULL,NULL,NULL),
('1428965881056096257',0,'成功','2021-08-21 14:23:10','{\"FID\":\"SCRK00009884\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1428965885627863041',1,NULL,NULL,NULL),
('1428966964029673473',0,'成功','2021-08-21 14:27:28','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1428966968626515970',1,NULL,NULL,NULL),
('1428966964516212737',0,'成功','2021-08-21 14:27:28','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1428966969113055234',1,NULL,NULL,NULL),
('1429739726901907458',0,'成功','2021-08-23 17:38:09','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739731108761602',1,NULL,NULL,NULL),
('1429739727661076482',0,'成功','2021-08-23 17:38:09','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739732018925569',1,NULL,NULL,NULL),
('1429739727984037889',0,'成功','2021-08-23 17:38:09','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739732362858497',1,NULL,NULL,NULL),
('1429739728290222082',0,'成功','2021-08-23 17:38:09','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739732656459777',1,NULL,NULL,NULL),
('1429739728600600578',0,'成功','2021-08-23 17:38:09','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739732966838273',1,NULL,NULL,NULL),
('1429739728902590465',0,'成功','2021-08-23 17:38:09','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739733281411073',1,NULL,NULL,NULL),
('1429739729229746178',0,'成功','2021-08-23 17:38:09','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739733604372482',1,NULL,NULL,NULL),
('1429739729519153153',0,'成功','2021-08-23 17:38:09','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739733889585153',1,NULL,NULL,NULL),
('1429739729837920258',0,'成功','2021-08-23 17:38:10','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739734212546562',1,NULL,NULL,NULL),
('1429739730110550017',0,'成功','2021-08-23 17:38:10','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739734489370626',1,NULL,NULL,NULL),
('1429739730387374081',0,'成功','2021-08-23 17:38:10','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739734757806081',1,NULL,NULL,NULL),
('1429739773374795778',0,'成功','2021-08-23 17:38:20','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739777745227778',1,NULL,NULL,NULL),
('1429739773647425537',0,'成功','2021-08-23 17:38:20','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739778026246145',1,NULL,NULL,NULL),
('1429739773907472385',0,'成功','2021-08-23 17:38:20','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739778282098689',1,NULL,NULL,NULL),
('1429739774255599618',0,'成功','2021-08-23 17:38:20','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739778634420226',1,NULL,NULL,NULL),
('1429739774545006594',0,'成功','2021-08-23 17:38:20','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739778919632898',1,NULL,NULL,NULL),
('1429739774813442049',0,'成功','2021-08-23 17:38:20','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739779192262657',1,NULL,NULL,NULL),
('1429739775098654721',0,'成功','2021-08-23 17:38:20','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739779477475329',1,NULL,NULL,NULL),
('1429739776755404802',0,'成功','2021-08-23 17:38:21','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739779884322817',1,NULL,NULL,NULL),
('1429739777053200385',0,'成功','2021-08-23 17:38:21','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739781427826690',1,NULL,NULL,NULL),
('1429739777330024450',0,'成功','2021-08-23 17:38:21','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739781700456449',1,NULL,NULL,NULL),
('1429739777606848514',0,'成功','2021-08-23 17:38:21','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739781973086209',1,NULL,NULL,NULL),
('1429739777862701058',0,'成功','2021-08-23 17:38:21','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739782237327361',1,NULL,NULL,NULL),
('1429739778131136513',0,'成功','2021-08-23 17:38:21','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739782514151426',1,NULL,NULL,NULL),
('1429739778416349186',0,'成功','2021-08-23 17:38:21','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739782761615361',1,NULL,NULL,NULL),
('1429739778684784642',0,'成功','2021-08-23 17:38:21','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429739783059410945',1,NULL,NULL,NULL),
('1429982825725104130',0,'成功','2021-08-24 09:44:08','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429982831332823041',1,NULL,NULL,NULL),
('1429982826278752257',0,'成功','2021-08-24 09:44:08','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429982832293318657',1,NULL,NULL,NULL),
('1429982826693988354',0,'成功','2021-08-24 09:44:08','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429982832700166146',1,NULL,NULL,NULL),
('1429982827117613057',0,'成功','2021-08-24 09:44:08','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429982833081847810',1,NULL,NULL,NULL),
('1429982829650972674',0,'成功','2021-08-24 09:44:09','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429982833518055426',1,NULL,NULL,NULL),
('1429982829994905601',0,'成功','2021-08-24 09:44:09','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429982836017860609',1,NULL,NULL,NULL),
('1429982830317867009',0,'成功','2021-08-24 09:44:09','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429982836378570754',1,NULL,NULL,NULL),
('1429982830603079682',0,'成功','2021-08-24 09:44:09','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429982836663783426',1,NULL,NULL,NULL),
('1429982830888292354',0,'成功','2021-08-24 09:44:09','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429982836944801794',1,NULL,NULL,NULL),
('1429982831165116417',0,'成功','2021-08-24 09:44:09','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429982837230014466',1,NULL,NULL,NULL),
('1429982831446134786',0,'成功','2021-08-24 09:44:09','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429982837511032834',1,NULL,NULL,NULL),
('1429982831756513282',0,'成功','2021-08-24 09:44:10','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429982837817217026',1,NULL,NULL,NULL),
('1429982832058503170',0,'成功','2021-08-24 09:44:10','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429982838110818306',1,NULL,NULL,NULL),
('1429982832343715841',0,'成功','2021-08-24 09:44:10','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429982838404419585',1,NULL,NULL,NULL),
('1429982832637317122',0,'成功','2021-08-24 09:44:10','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1429982838693826562',1,NULL,NULL,NULL),
('1430112360172924929',0,'成功','2021-08-24 18:18:52','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112361137573889',1,NULL,NULL,NULL),
('1430112361250861058',0,'成功','2021-08-24 18:18:52','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112362580414465',1,NULL,NULL,NULL),
('1430112361594793986',0,'成功','2021-08-24 18:18:52','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112362957901825',1,NULL,NULL,NULL),
('1430112361997447169',0,'成功','2021-08-24 18:18:52','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112363347972098',1,NULL,NULL,NULL),
('1430112362316214273',0,'成功','2021-08-24 18:18:52','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112363666739202',1,NULL,NULL,NULL),
('1430112362639175681',0,'成功','2021-08-24 18:18:52','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112364006477825',1,NULL,NULL,NULL),
('1430112362970525698',0,'成功','2021-08-24 18:18:52','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112364342022146',1,NULL,NULL,NULL),
('1430112363268321282',0,'成功','2021-08-24 18:18:52','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112364627234817',1,NULL,NULL,NULL),
('1430112363587088386',0,'成功','2021-08-24 18:18:52','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112364958584834',1,NULL,NULL,NULL),
('1430112363914244098',0,'成功','2021-08-24 18:18:52','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112365252186114',1,NULL,NULL,NULL),
('1430112364186873857',0,'成功','2021-08-24 18:18:52','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112365554176002',1,NULL,NULL,NULL),
('1430112364455309314',0,'成功','2021-08-24 18:18:53','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112365831000066',1,NULL,NULL,NULL),
('1430112364719550465',0,'成功','2021-08-24 18:18:53','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112366082658306',1,NULL,NULL,NULL),
('1430112365000568834',0,'成功','2021-08-24 18:18:53','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112366372065282',1,NULL,NULL,NULL),
('1430112365285781506',0,'成功','2021-08-24 18:18:53','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112366661472258',1,NULL,NULL,NULL),
('1430112456386064386',0,'成功','2021-08-24 18:19:14','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112457753366530',1,NULL,NULL,NULL),
('1430112456839049217',0,'成功','2021-08-24 18:19:15','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112458181185537',1,NULL,NULL,NULL),
('1430112457300422657',0,'成功','2021-08-24 18:19:15','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112458642558978',1,NULL,NULL,NULL),
('1430112457715658754',0,'成功','2021-08-24 18:19:15','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112459099738113',1,NULL,NULL,NULL),
('1430112457992482818',0,'成功','2021-08-24 18:19:15','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112459368173570',1,NULL,NULL,NULL),
('1430112458239946753',0,'成功','2021-08-24 18:19:15','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112459619831809',1,NULL,NULL,NULL),
('1430112458508382210',0,'成功','2021-08-24 18:19:15','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112459884072962',1,NULL,NULL,NULL),
('1430112458755846145',0,'成功','2021-08-24 18:19:15','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112460135731202',1,NULL,NULL,NULL),
('1430112459015892994',0,'成功','2021-08-24 18:19:15','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112460391583746',1,NULL,NULL,NULL),
('1430112459305299969',0,'成功','2021-08-24 18:19:15','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112460664213506',1,NULL,NULL,NULL),
('1430112459548569602',0,'成功','2021-08-24 18:19:15','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112460928454658',1,NULL,NULL,NULL),
('1430112459821199362',0,'成功','2021-08-24 18:19:15','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112461188501506',1,NULL,NULL,NULL),
('1430112460102217729',0,'成功','2021-08-24 18:19:15','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112461473714177',1,NULL,NULL,NULL),
('1430112460530036737',0,'成功','2021-08-24 18:19:15','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112461746343937',1,NULL,NULL,NULL),
('1430112460953661442',0,'成功','2021-08-24 18:19:16','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112462316769281',1,NULL,NULL,NULL),
('1430112858124890113',0,'成功','2021-08-24 18:20:50','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112859496386562',1,NULL,NULL,NULL),
('1430112858456240129',0,'成功','2021-08-24 18:20:50','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112859810959361',1,NULL,NULL,NULL),
('1430112858770812929',0,'成功','2021-08-24 18:20:50','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112860146503681',1,NULL,NULL,NULL),
('1430112859056025602',0,'成功','2021-08-24 18:20:50','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112860423327746',1,NULL,NULL,NULL),
('1430112859358015490',0,'成功','2021-08-24 18:20:51','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112860716929025',1,NULL,NULL,NULL),
('1430112859626450945',0,'成功','2021-08-24 18:20:51','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112861002141698',1,NULL,NULL,NULL),
('1430112859907469313',0,'成功','2021-08-24 18:20:51','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112861283160065',1,NULL,NULL,NULL),
('1430112860159127553',0,'成功','2021-08-24 18:20:51','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112861539012610',1,NULL,NULL,NULL),
('1430112860427563009',0,'成功','2021-08-24 18:20:51','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112861811642369',1,NULL,NULL,NULL),
('1430112860687609857',0,'成功','2021-08-24 18:20:51','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112862063300610',1,NULL,NULL,NULL),
('1430112860972822529',0,'成功','2021-08-24 18:20:51','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112862331736065',1,NULL,NULL,NULL),
('1430112861316755458',0,'成功','2021-08-24 18:20:51','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112862688251906',1,NULL,NULL,NULL),
('1430112861597773825',0,'成功','2021-08-24 18:20:51','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112862986047489',1,NULL,NULL,NULL),
('1430112861832654849',0,'成功','2021-08-24 18:20:51','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112863220928513',1,NULL,NULL,NULL),
('1430112862075924482',0,'成功','2021-08-24 18:20:51','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112863460003842',1,NULL,NULL,NULL),
('1430112994162946050',0,'成功','2021-08-24 18:21:23','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112995479916546',1,NULL,NULL,NULL),
('1430112994448158722',0,'成功','2021-08-24 18:21:23','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112995823849474',1,NULL,NULL,NULL),
('1430112994724982785',0,'成功','2021-08-24 18:21:23','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112996104867841',1,NULL,NULL,NULL),
('1430112994976641026',0,'成功','2021-08-24 18:21:23','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112996360720386',1,NULL,NULL,NULL),
('1430112995253465090',0,'成功','2021-08-24 18:21:23','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112996637544450',1,NULL,NULL,NULL),
('1430112995517706241',0,'成功','2021-08-24 18:21:23','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112996893396993',1,NULL,NULL,NULL),
('1430112995786141698',0,'成功','2021-08-24 18:21:23','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112997178609665',1,NULL,NULL,NULL),
('1430112996096520193',0,'成功','2021-08-24 18:21:23','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112997484793857',1,NULL,NULL,NULL),
('1430112996339789826',0,'成功','2021-08-24 18:21:23','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112997732257794',1,NULL,NULL,NULL),
('1430112996599836674',0,'成功','2021-08-24 18:21:23','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112997983916034',1,NULL,NULL,NULL),
('1430112996847300610',0,'成功','2021-08-24 18:21:23','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112998227185665',1,NULL,NULL,NULL),
('1430112997182844930',0,'成功','2021-08-24 18:21:23','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112998541758465',1,NULL,NULL,NULL),
('1430112997455474689',0,'成功','2021-08-24 18:21:23','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112998843748354',1,NULL,NULL,NULL),
('1430112997715521538',0,'成功','2021-08-24 18:21:24','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112999099600898',1,NULL,NULL,NULL),
('1430112997967179778',0,'成功','2021-08-24 18:21:24','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430112999351259137',1,NULL,NULL,NULL),
('1430114637944320002',0,'成功','2021-08-24 18:27:55','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114639340900354',1,NULL,NULL,NULL),
('1430114638363750402',0,'成功','2021-08-24 18:27:55','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114639768719361',1,NULL,NULL,NULL),
('1430114638678323202',0,'成功','2021-08-24 18:27:55','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114640079097858',1,NULL,NULL,NULL),
('1430114639026450434',0,'成功','2021-08-24 18:27:55','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114640427225090',1,NULL,NULL,NULL),
('1430114639445880833',0,'成功','2021-08-24 18:27:55','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114640842461185',1,NULL,NULL,NULL),
('1430114639835951105',0,'成功','2021-08-24 18:27:55','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114641219948545',1,NULL,NULL,NULL),
('1430114640179884033',0,'成功','2021-08-24 18:27:55','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114641580658689',1,NULL,NULL,NULL),
('1430114640498651137',0,'成功','2021-08-24 18:27:55','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114641899425793',1,NULL,NULL,NULL),
('1430114640838389761',0,'成功','2021-08-24 18:27:55','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114642239164417',1,NULL,NULL,NULL),
('1430114641148768258',0,'成功','2021-08-24 18:27:55','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114642524377089',1,NULL,NULL,NULL),
('1430114641480118274',0,'成功','2021-08-24 18:27:55','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114642885087233',1,NULL,NULL,NULL),
('1430114641756942337',0,'成功','2021-08-24 18:27:55','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114643149328386',1,NULL,NULL,NULL),
('1430114642021183490',0,'成功','2021-08-24 18:27:56','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114643430346753',1,NULL,NULL,NULL),
('1430114642310590466',0,'成功','2021-08-24 18:27:56','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114643702976514',1,NULL,NULL,NULL),
('1430114642604191746',0,'成功','2021-08-24 18:27:56','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114643988189186',1,NULL,NULL,NULL),
('1430114755791679489',0,'成功','2021-08-24 18:28:23','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114757104373762',1,NULL,NULL,NULL),
('1430114756144001025',0,'成功','2021-08-24 18:28:23','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114757511221249',1,NULL,NULL,NULL),
('1430114756475351041',0,'成功','2021-08-24 18:28:23','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114757838376962',1,NULL,NULL,NULL),
('1430114756827672577',0,'成功','2021-08-24 18:28:23','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114758194892801',1,NULL,NULL,NULL),
('1430114757138051073',0,'成功','2021-08-24 18:28:23','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114758530437122',1,NULL,NULL,NULL),
('1430114757456818177',0,'成功','2021-08-24 18:28:23','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114758865981442',1,NULL,NULL,NULL),
('1430114757909803009',0,'成功','2021-08-24 18:28:23','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114759272828929',1,NULL,NULL,NULL),
('1430114758236958722',0,'成功','2021-08-24 18:28:23','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114759616761857',1,NULL,NULL,NULL),
('1430114758492811265',0,'成功','2021-08-24 18:28:23','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114759948111874',1,NULL,NULL,NULL),
('1430114758819966978',0,'成功','2021-08-24 18:28:23','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114760245907458',1,NULL,NULL,NULL),
('1430114759147122690',0,'成功','2021-08-24 18:28:23','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114760552091649',1,NULL,NULL,NULL),
('1430114759474278401',0,'成功','2021-08-24 18:28:24','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114760875053057',1,NULL,NULL,NULL),
('1430114759730130946',0,'成功','2021-08-24 18:28:24','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114761160265730',1,NULL,NULL,NULL),
('1430114760053092353',0,'成功','2021-08-24 18:28:24','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114761474838529',1,NULL,NULL,NULL),
('1430114760384442370',0,'成功','2021-08-24 18:28:24','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114761793605634',1,NULL,NULL,NULL),
('1430114842211119106',0,'成功','2021-08-24 18:28:43','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114843590922241',1,NULL,NULL,NULL),
('1430114842571829250',0,'成功','2021-08-24 18:28:43','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114843960020994',1,NULL,NULL,NULL),
('1430114842966093825',0,'成功','2021-08-24 18:28:43','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114844316536833',1,NULL,NULL,NULL),
('1430114843330998273',0,'成功','2021-08-24 18:28:44','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114844706607105',1,NULL,NULL,NULL),
('1430114843624599554',0,'成功','2021-08-24 18:28:44','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114845033762818',1,NULL,NULL,NULL),
('1430114843922395138',0,'成功','2021-08-24 18:28:44','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114845339947010',1,NULL,NULL,NULL),
('1430114844249550850',0,'成功','2021-08-24 18:28:44','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114845662908418',1,NULL,NULL,NULL),
('1430114844627038210',0,'成功','2021-08-24 18:28:44','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114846032007169',1,NULL,NULL,NULL),
('1430114844895473665',0,'成功','2021-08-24 18:28:44','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114846292054017',1,NULL,NULL,NULL),
('1430114845205852162',0,'成功','2021-08-24 18:28:44','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114846623404034',1,NULL,NULL,NULL),
('1430114845516230658',0,'成功','2021-08-24 18:28:44','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114846933782529',1,NULL,NULL,NULL),
('1430114845814026241',0,'成功','2021-08-24 18:28:44','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114847231578113',1,NULL,NULL,NULL),
('1430114846090850306',0,'成功','2021-08-24 18:28:44','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114847504207874',1,NULL,NULL,NULL),
('1430114846443171842',0,'成功','2021-08-24 18:28:44','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114847852335105',1,NULL,NULL,NULL),
('1430114846782910466',0,'成功','2021-08-24 18:28:44','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430114848179490817',1,NULL,NULL,NULL),
('1430115070087626753',0,'成功','2021-08-24 18:29:38','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115071492624385',1,NULL,NULL,NULL),
('1430115070444142593',0,'成功','2021-08-24 18:29:38','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115071861723137',1,NULL,NULL,NULL),
('1430115070720966658',0,'成功','2021-08-24 18:29:38','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115072130158593',1,NULL,NULL,NULL),
('1430115070993596418',0,'成功','2021-08-24 18:29:38','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115072398594050',1,NULL,NULL,NULL),
('1430115071245254658',0,'成功','2021-08-24 18:29:38','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115072654446594',1,NULL,NULL,NULL),
('1430115071492718594',0,'成功','2021-08-24 18:29:38','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115072901910530',1,NULL,NULL,NULL),
('1430115071790514177',0,'成功','2021-08-24 18:29:38','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115073182928898',1,NULL,NULL,NULL),
('1430115072109281281',0,'成功','2021-08-24 18:29:38','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115073514278913',1,NULL,NULL,NULL),
('1430115072369328129',0,'成功','2021-08-24 18:29:38','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115073786908673',1,NULL,NULL,NULL),
('1430115072688095234',0,'成功','2021-08-24 18:29:38','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115074080509953',1,NULL,NULL,NULL),
('1430115072973307906',0,'成功','2021-08-24 18:29:38','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115074382499842',1,NULL,NULL,NULL),
('1430115073304657921',0,'成功','2021-08-24 18:29:38','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115074684489730',1,NULL,NULL,NULL),
('1430115073631813633',0,'成功','2021-08-24 18:29:38','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115075007451138',1,NULL,NULL,NULL),
('1430115073925414913',0,'成功','2021-08-24 18:29:39','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115075330412546',1,NULL,NULL,NULL),
('1430115074219016193',0,'成功','2021-08-24 18:29:39','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115075607236610',1,NULL,NULL,NULL),
('1430115598288826369',0,'成功','2021-08-24 18:31:44','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115599685521409',1,NULL,NULL,NULL),
('1430115598628564993',0,'成功','2021-08-24 18:31:44','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115600042037250',1,NULL,NULL,NULL),
('1430115598930554882',0,'成功','2021-08-24 18:31:44','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115600339832833',1,NULL,NULL,NULL),
('1430115599240933378',0,'成功','2021-08-24 18:31:44','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115600662794242',1,NULL,NULL,NULL),
('1430115599534534657',0,'成功','2021-08-24 18:31:44','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115600948006914',1,NULL,NULL,NULL),
('1430115599802970114',0,'成功','2021-08-24 18:31:44','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115601203859457',1,NULL,NULL,NULL),
('1430115600083988482',0,'成功','2021-08-24 18:31:44','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115601493266433',1,NULL,NULL,NULL),
('1430115600553750529',0,'成功','2021-08-24 18:31:44','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115601900113922',1,NULL,NULL,NULL),
('1430115600801214465',0,'成功','2021-08-24 18:31:44','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115602223075330',1,NULL,NULL,NULL),
('1430115601069649921',0,'成功','2021-08-24 18:31:44','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115602487316481',1,NULL,NULL,NULL),
('1430115601317113858',0,'成功','2021-08-24 18:31:44','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115602722197506',1,NULL,NULL,NULL),
('1430115601560383489',0,'成功','2021-08-24 18:31:44','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115602986438658',1,NULL,NULL,NULL),
('1430115601820430338',0,'成功','2021-08-24 18:31:44','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115603212931073',1,NULL,NULL,NULL),
('1430115602097254402',0,'成功','2021-08-24 18:31:44','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115603510726657',1,NULL,NULL,NULL),
('1430115602386661378',0,'成功','2021-08-24 18:31:45','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430115603795939329',1,NULL,NULL,NULL),
('1430376017809141762',0,'成功','2021-08-25 11:46:32','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430376020803850242',1,NULL,NULL,NULL),
('1430376532920045570',0,'成功','2021-08-25 11:48:35','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430376536116039682',1,NULL,NULL,NULL),
('1430378335770284034',0,'成功','2021-08-25 11:55:45','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430378338920173569',1,NULL,NULL,NULL),
('1430378424844718081',0,'成功','2021-08-25 11:56:06','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430378428103659522',1,NULL,NULL,NULL),
('1430378954526572546',0,'成功','2021-08-25 11:58:13','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430378957781340161',1,NULL,NULL,NULL),
('1430378979038085122',0,'成功','2021-08-25 11:58:18','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430378982313824258',1,NULL,NULL,NULL),
('1430379029273264129',0,'成功','2021-08-25 11:58:30','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430379032557391873',1,NULL,NULL,NULL),
('1430379035610857473',0,'成功','2021-08-25 11:58:32','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430379038894985217',1,NULL,NULL,NULL),
('1430379040560136193',0,'成功','2021-08-25 11:58:33','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430379043848458242',1,NULL,NULL,NULL),
('1430379050114760706',0,'成功','2021-08-25 11:58:35','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430379053398888450',1,NULL,NULL,NULL),
('1430379054564917250',0,'成功','2021-08-25 11:58:36','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430379057853239297',1,NULL,NULL,NULL),
('1430379059791020034',0,'成功','2021-08-25 11:58:38','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430379063079342082',1,NULL,NULL,NULL),
('1430379104066093057',0,'成功','2021-08-25 11:58:48','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1430379107350220801',1,NULL,NULL,NULL),
('1430827398126964737',200,'操作成功！','2021-08-26 17:40:10','{\"fid\":\"102239\",\"productmodel\":\" \",\"amount\":\"13.0\",\"planfinishdate\":\"2021-08-26 17:22:36\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"5\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-08-26 17:22:36\",\"workshopname\":\"356054\",\"ipono\":\"MO002101\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:28:30\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"611495bb9679e9\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','添加成功！',0,NULL,4,'推送生产订单'),
('1430827399787909121',200,'操作成功！','2021-08-26 17:40:10','{\"fid\":\"106399\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:34:36\",\"purchaserhqcode\":\"SGCC\"}','添加成功！',0,NULL,5,'推送排产计划'),
('1430827402845556737',200,'操作成功！','2021-08-26 17:40:11','{\"fid\":\"110727\",\"productamount\":\"13.0\",\"datasourcecreatetime\":\"2021-08-26 17:40:10\",\"spareproductcode\":\"3901528\",\"fbillno\":\"SCRK00009885\",\"productdec\":\"物料子项2\"}','添加成功！',0,NULL,9,'产成品'),
('1430827404280008705',200,'操作成功！','2021-08-26 17:40:11','{\"fid\":\"192451\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-08-26 17:03:30\",\"sono\":\"SEORD130483\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','添加成功！',0,NULL,3,'推送销售订单'),
('1430827404460363778',200,'操作成功！','2021-08-26 17:40:11','{\"fid\":\"192452\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"21.0\",\"datasourcecreatetime\":\"2021-08-26 17:12:34\",\"sono\":\"SEORD130484\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','添加成功！',0,NULL,3,'推送销售订单'),
('1430827404644913154',200,'操作成功！','2021-08-26 17:40:11','{\"fid\":\"192453\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"13.0\",\"datasourcecreatetime\":\"2021-08-26 17:22:36\",\"sono\":\"SEORD130485\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','添加成功！',0,NULL,3,'推送销售订单'),
('1430827653035790337',200,'操作成功！','2021-08-26 17:41:11','{\"fid\":\"102239\",\"productmodel\":\" \",\"amount\":\"13.0\",\"planfinishdate\":\"2021-08-26 17:22:36\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"5\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-08-26 17:22:36\",\"workshopname\":\"356054\",\"ipono\":\"MO002101\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:28:30\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"611495bb9679e9\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','添加成功！',0,NULL,4,'推送生产订单'),
('1430827654398939137',200,'操作成功！','2021-08-26 17:41:11','{\"fid\":\"106399\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:34:36\",\"purchaserhqcode\":\"SGCC\"}','添加成功！',0,NULL,5,'推送排产计划'),
('1430827656919715842',200,'操作成功！','2021-08-26 17:41:12','{\"fid\":\"110727\",\"productamount\":\"13.0\",\"datasourcecreatetime\":\"2021-08-26 17:41:11\",\"spareproductcode\":\"3901528\",\"fbillno\":\"SCRK00009885\",\"productdec\":\"物料子项2\"}','添加成功！',0,NULL,9,'产成品'),
('1430827658270281730',200,'操作成功！','2021-08-26 17:41:12','{\"fid\":\"192451\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-08-26 17:03:30\",\"sono\":\"SEORD130483\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','添加成功！',0,NULL,3,'推送销售订单'),
('1430827658471608322',200,'操作成功！','2021-08-26 17:41:12','{\"fid\":\"192452\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"21.0\",\"datasourcecreatetime\":\"2021-08-26 17:12:34\",\"sono\":\"SEORD130484\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','添加成功！',0,NULL,3,'推送销售订单'),
('1430827658647769089',200,'操作成功！','2021-08-26 17:41:12','{\"fid\":\"192453\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"13.0\",\"datasourcecreatetime\":\"2021-08-26 17:22:36\",\"sono\":\"SEORD130485\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','添加成功！',0,NULL,3,'推送销售订单'),
('1430828009631371266',200,'操作成功！','2021-08-26 17:42:36','{\"fid\":\"102239\",\"productmodel\":\" \",\"amount\":\"13.0\",\"planfinishdate\":\"2021-08-26 17:22:36\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"5\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-08-26 17:22:36\",\"workshopname\":\"356054\",\"ipono\":\"MO002101\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:28:30\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"611495bb9679e9\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','添加成功！',0,NULL,4,'推送生产订单'),
('1430828011132932098',200,'操作成功！','2021-08-26 17:42:36','{\"fid\":\"106399\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:34:36\",\"purchaserhqcode\":\"SGCC\"}','添加成功！',0,NULL,5,'推送排产计划'),
('1430828013892784129',200,'操作成功！','2021-08-26 17:42:37','{\"fid\":\"110727\",\"productamount\":\"13.0\",\"datasourcecreatetime\":\"2021-08-26 17:42:36\",\"spareproductcode\":\"3901528\",\"fbillno\":\"SCRK00009885\",\"productdec\":\"物料子项2\"}','添加成功！',0,NULL,9,'产成品'),
('1430828015553728513',200,'操作成功！','2021-08-26 17:42:37','{\"fid\":\"192451\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-08-26 17:03:30\",\"sono\":\"SEORD130483\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','添加成功！',0,NULL,3,'推送销售订单'),
('1430828015725694978',200,'操作成功！','2021-08-26 17:42:37','{\"fid\":\"192452\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"21.0\",\"datasourcecreatetime\":\"2021-08-26 17:12:34\",\"sono\":\"SEORD130484\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','添加成功！',0,NULL,3,'推送销售订单'),
('1430828015901855746',200,'操作成功！','2021-08-26 17:42:37','{\"fid\":\"192453\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"13.0\",\"datasourcecreatetime\":\"2021-08-26 17:22:36\",\"sono\":\"SEORD130485\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','添加成功！',0,NULL,3,'推送销售订单'),
('1432617392734732289',0,'成功','2021-08-31 16:12:58','{\"FID\":\"110711\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9869\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-13T10:02:35.013\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009869\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-13 10:10:07\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617385344372737',1,NULL,7,'推送实物ID信息'),
('1432617393577787393',0,'成功','2021-08-31 16:12:58','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617394638950401',1,NULL,7,'推送实物ID信息'),
('1432617393976246274',0,'成功','2021-08-31 16:12:58','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617395054186497',1,NULL,7,'推送实物ID信息'),
('1432617394466979841',0,'成功','2021-08-31 16:12:58','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617395586863106',1,NULL,7,'推送实物ID信息'),
('1432617394848661506',0,'成功','2021-08-31 16:12:58','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617395947573249',1,NULL,7,'推送实物ID信息'),
('1432617395368755201',0,'成功','2021-08-31 16:12:58','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617396450889730',1,NULL,7,'推送实物ID信息'),
('1432617395763019777',0,'成功','2021-08-31 16:12:59','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617396861931522',1,NULL,7,'推送实物ID信息'),
('1432617396140507137',0,'成功','2021-08-31 16:12:59','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617397252001793',1,NULL,7,'推送实物ID信息'),
('1432617396513800193',0,'成功','2021-08-31 16:12:59','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617397616906242',1,NULL,7,'推送实物ID信息'),
('1432617396840955905',0,'成功','2021-08-31 16:12:59','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617397969227778',1,NULL,7,'推送实物ID信息'),
('1432617397210054657',0,'成功','2021-08-31 16:12:59','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617398321549313',1,NULL,7,'推送实物ID信息'),
('1432617397541404673',0,'成功','2021-08-31 16:12:59','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617398682259458',1,NULL,7,'推送实物ID信息'),
('1432617398145384449',0,'成功','2021-08-31 16:12:59','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617399143632897',1,NULL,7,'推送实物ID信息'),
('1432617398556426241',0,'成功','2021-08-31 16:12:59','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617399680503809',1,NULL,7,'推送实物ID信息'),
('1432617398845833217',0,'成功','2021-08-31 16:12:59','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617399995076609',1,NULL,7,'推送实物ID信息'),
('1432617399219126274',0,'成功','2021-08-31 16:12:59','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617400343203841',1,NULL,7,'推送实物ID信息'),
('1432617399680499714',0,'成功','2021-08-31 16:12:59','{\"FID\":\"110727\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9885\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-26T17:36:45.437\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009885\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:44:33\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617400758439937',1,NULL,7,'推送实物ID信息'),
('1432617725867413505',0,'成功','2021-08-31 16:14:17','{\"FID\":\"110711\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9869\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-13T10:02:35.013\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009869\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-13 10:10:07\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617726781689857',1,NULL,7,'推送实物ID信息'),
('1432617726483976194',0,'成功','2021-08-31 16:14:17','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617727612162049',1,NULL,7,'推送实物ID信息'),
('1432617726836297730',0,'成功','2021-08-31 16:14:17','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617727947706370',1,NULL,7,'推送实物ID信息'),
('1432617727167647746',0,'成功','2021-08-31 16:14:18','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617728283250690',1,NULL,7,'推送实物ID信息'),
('1432617727469637634',0,'成功','2021-08-31 16:14:18','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617728597823489',1,NULL,7,'推送实物ID信息'),
('1432617727855513601',0,'成功','2021-08-31 16:14:18','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617728987893762',1,NULL,7,'推送实物ID信息'),
('1432617728170086401',0,'成功','2021-08-31 16:14:18','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617729294077954',1,NULL,7,'推送实物ID信息'),
('1432617728480464898',0,'成功','2021-08-31 16:14:18','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617729591873537',1,NULL,7,'推送实物ID信息'),
('1432617729038307330',0,'成功','2021-08-31 16:14:18','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617730170687489',1,NULL,7,'推送实物ID信息'),
('1432617729369657345',0,'成功','2021-08-31 16:14:18','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617730485260289',1,NULL,7,'推送实物ID信息'),
('1432617729793282050',0,'成功','2021-08-31 16:14:18','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617730908884994',1,NULL,7,'推送实物ID信息'),
('1432617730153992193',0,'成功','2021-08-31 16:14:18','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617731244429313',1,NULL,7,'推送实物ID信息'),
('1432617730451787778',0,'成功','2021-08-31 16:14:18','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617731592556545',1,NULL,7,'推送实物ID信息'),
('1432617730980270082',0,'成功','2021-08-31 16:14:18','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617731986821121',1,NULL,7,'推送实物ID信息'),
('1432617731466809346',0,'成功','2021-08-31 16:14:19','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617732485943298',1,NULL,7,'推送实物ID信息'),
('1432617731793965057',0,'成功','2021-08-31 16:14:19','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617732930539522',1,NULL,7,'推送实物ID信息'),
('1432617732083372033',0,'成功','2021-08-31 16:14:19','{\"FID\":\"110727\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9885\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-26T17:36:45.437\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009885\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:44:33\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432617733232529410',1,NULL,7,'推送实物ID信息'),
('1432618270011170818',0,'成功','2021-08-31 16:16:27','{\"FID\":\"110711\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9869\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-13T10:02:35.013\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009869\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-13 10:10:07\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432618268673183745',1,NULL,7,'推送实物ID信息'),
('1432618270577401858',0,'成功','2021-08-31 16:16:27','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432618271714054145',1,NULL,7,'推送实物ID信息'),
('1432618270921334786',0,'成功','2021-08-31 16:16:27','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432618272074764289',1,NULL,7,'推送实物ID信息'),
('1432618271202353153',0,'成功','2021-08-31 16:16:27','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432618272364171266',1,NULL,7,'推送实物ID信息'),
('1432618271542091777',0,'成功','2021-08-31 16:16:27','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432618272674549761',1,NULL,7,'推送实物ID信息'),
('1432618271886024705',0,'成功','2021-08-31 16:16:27','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432618273043648513',1,NULL,7,'推送实物ID信息'),
('1432618272192208897',0,'成功','2021-08-31 16:16:28','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432618273337249794',1,NULL,7,'推送实物ID信息'),
('1432618272494198786',0,'成功','2021-08-31 16:16:28','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432618273656016898',1,NULL,7,'推送实物ID信息'),
('1432618272846520322',0,'成功','2021-08-31 16:16:28','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432618273958006786',1,NULL,7,'推送实物ID信息'),
('1432618273144315906',0,'成功','2021-08-31 16:16:28','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432618274301939714',1,NULL,7,'推送实物ID信息'),
('1432618273555357698',0,'成功','2021-08-31 16:16:28','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432618274679427074',1,NULL,7,'推送实物ID信息'),
('1432618273890902017',0,'成功','2021-08-31 16:16:28','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432618275035942914',1,NULL,7,'推送实物ID信息'),
('1432618274188697601',0,'成功','2021-08-31 16:16:28','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432618275346321410',1,NULL,7,'推送实物ID信息'),
('1432618274473910274',0,'成功','2021-08-31 16:16:28','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432618275618951170',1,NULL,7,'推送实物ID信息'),
('1432618274805260289',0,'成功','2021-08-31 16:16:28','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432618275962884097',1,NULL,7,'推送实物ID信息'),
('1432618275136610306',0,'成功','2021-08-31 16:16:28','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432618276264873985',1,NULL,7,'推送实物ID信息'),
('1432618275442794497',0,'成功','2021-08-31 16:16:28','{\"FID\":\"110727\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9885\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-26T17:36:45.437\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009885\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:44:33\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432618276592029697',1,NULL,7,'推送实物ID信息'),
('1432622006066569217',0,'成功','2021-08-31 16:31:18','{\"FID\":\"110711\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9869\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-13T10:02:35.013\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009869\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-13 10:10:07\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622006913732610',1,NULL,7,'推送实物ID信息'),
('1432622006720880642',0,'成功','2021-08-31 16:31:18','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622007895199745',1,NULL,7,'推送实物ID信息'),
('1432622007110950914',0,'成功','2021-08-31 16:31:18','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622008289464322',1,NULL,7,'推送实物ID信息'),
('1432622007492632578',0,'成功','2021-08-31 16:31:18','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622008692117505',1,NULL,7,'推送实物ID信息'),
('1432622007815593985',0,'成功','2021-08-31 16:31:18','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622008998301698',1,NULL,7,'推送实物ID信息'),
('1432622008146944002',0,'成功','2021-08-31 16:31:18','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622009325457409',1,NULL,7,'推送实物ID信息'),
('1432622008474099713',0,'成功','2021-08-31 16:31:18','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622009681973250',1,NULL,7,'推送实物ID信息'),
('1432622008813838338',0,'成功','2021-08-31 16:31:18','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622010013323266',1,NULL,7,'推送实物ID信息'),
('1432622009237463041',0,'成功','2021-08-31 16:31:18','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622010361450497',1,NULL,7,'推送实物ID信息'),
('1432622009635921921',0,'成功','2021-08-31 16:31:19','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622010785075201',1,NULL,7,'推送实物ID信息'),
('1432622009942106114',0,'成功','2021-08-31 16:31:19','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622011154173953',1,NULL,7,'推送实物ID信息'),
('1432622010231513089',0,'成功','2021-08-31 16:31:19','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622011439386625',1,NULL,7,'推送实物ID信息'),
('1432622010588028929',0,'成功','2021-08-31 16:31:19','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622011795902466',1,NULL,7,'推送实物ID信息'),
('1432622010898407425',0,'成功','2021-08-31 16:31:19','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622012118863873',1,NULL,7,'推送实物ID信息'),
('1432622011196203010',0,'成功','2021-08-31 16:31:19','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622012399882241',1,NULL,7,'推送实物ID信息'),
('1432622011481415682',0,'成功','2021-08-31 16:31:19','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622012697677826',1,NULL,7,'推送实物ID信息'),
('1432622011837931521',0,'成功','2021-08-31 16:31:19','{\"FID\":\"110727\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9885\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-26T17:36:45.437\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009885\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:44:33\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622013020639233',1,NULL,7,'推送实物ID信息'),
('1432622824555659266',0,'成功','2021-08-31 16:34:33','{\"FID\":\"110711\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9869\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-13T10:02:35.013\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009869\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-13 10:10:07\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622825541210113',1,NULL,7,'推送实物ID信息'),
('1432622825117696001',0,'成功','2021-08-31 16:34:33','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622826342322178',1,NULL,7,'推送实物ID信息'),
('1432622825453240321',0,'成功','2021-08-31 16:34:33','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622826673672194',1,NULL,7,'推送实物ID信息'),
('1432622825843310594',0,'成功','2021-08-31 16:34:33','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622827021799426',1,NULL,7,'推送实物ID信息'),
('1432622826199826433',0,'成功','2021-08-31 16:34:33','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622827424452609',1,NULL,7,'推送实物ID信息'),
('1432622826556342273',0,'成功','2021-08-31 16:34:33','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622827764191234',1,NULL,7,'推送实物ID信息'),
('1432622826908663809',0,'成功','2021-08-31 16:34:33','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622828108124161',1,NULL,7,'推送实物ID信息'),
('1432622827265179649',0,'成功','2021-08-31 16:34:34','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622828468834306',1,NULL,7,'推送实物ID信息'),
('1432622827785273345',0,'成功','2021-08-31 16:34:34','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622828972150786',1,NULL,7,'推送实物ID信息'),
('1432622828116623362',0,'成功','2021-08-31 16:34:34','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622829324472321',1,NULL,7,'推送实物ID信息'),
('1432622828447973378',0,'成功','2021-08-31 16:34:34','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622829655822337',1,NULL,7,'推送实物ID信息'),
('1432622828787712001',0,'成功','2021-08-31 16:34:34','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622830008143873',1,NULL,7,'推送实物ID信息'),
('1432622829161005057',0,'成功','2021-08-31 16:34:34','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622830326910978',1,NULL,7,'推送实物ID信息'),
('1432622829580435458',0,'成功','2021-08-31 16:34:34','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622830725369857',1,NULL,7,'推送实物ID信息'),
('1432622829995671553',0,'成功','2021-08-31 16:34:34','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622831169966081',1,NULL,7,'推送实物ID信息'),
('1432622830368964610',0,'成功','2021-08-31 16:34:34','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622831581007874',1,NULL,7,'推送实物ID信息'),
('1432622830742257666',0,'成功','2021-08-31 16:34:34','{\"FID\":\"110727\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9885\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-26T17:36:45.437\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009885\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:44:33\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432622831903969282',1,NULL,7,'推送实物ID信息'),
('1432623350907265025',0,'成功','2021-08-31 16:36:38','{\"FID\":\"110711\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9869\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-13T10:02:35.013\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009869\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-13 10:10:07\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432623351934750721',1,NULL,7,'推送实物ID信息'),
('1432623351544799233',0,'成功','2021-08-31 16:36:39','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432623352765222914',1,NULL,7,'推送实物ID信息'),
('1432623351817428994',0,'成功','2021-08-31 16:36:39','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432623353054629889',1,NULL,7,'推送实物ID信息'),
('1432623352165556225',0,'成功','2021-08-31 16:36:39','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432623353331453953',1,NULL,7,'推送实物ID信息'),
('1432623352496906241',0,'成功','2021-08-31 16:36:39','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432623353675386881',1,NULL,7,'推送实物ID信息'),
('1432623352866004994',0,'成功','2021-08-31 16:36:39','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432623354069651457',1,NULL,7,'推送实物ID信息'),
('1432623353167994882',0,'成功','2021-08-31 16:36:39','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432623354392612865',1,NULL,7,'推送实物ID信息'),
('1432623353436430337',0,'成功','2021-08-31 16:36:39','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432623354661048322',1,NULL,7,'推送实物ID信息'),
('1432623353755197442',0,'成功','2021-08-31 16:36:39','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432623354984009730',1,NULL,7,'推送实物ID信息'),
('1432623353998467073',0,'成功','2021-08-31 16:36:39','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432623355223085058',1,NULL,7,'推送实物ID信息'),
('1432623354296262658',0,'成功','2021-08-31 16:36:39','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432623355499909121',1,NULL,7,'推送实物ID信息'),
('1432623354577281025',0,'成功','2021-08-31 16:36:39','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432623355806093314',1,NULL,7,'推送实物ID信息'),
('1432623354841522178',0,'成功','2021-08-31 16:36:39','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432623356070334465',1,NULL,7,'推送实物ID信息'),
('1432623355093180417',0,'成功','2021-08-31 16:36:39','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432623356321992705',1,NULL,7,'推送实物ID信息'),
('1432623355416141825',0,'成功','2021-08-31 16:36:39','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432623356632371202',1,NULL,7,'推送实物ID信息'),
('1432623355697160193',0,'成功','2021-08-31 16:36:40','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432623356905000961',1,NULL,7,'推送实物ID信息'),
('1432623356007538690',0,'成功','2021-08-31 16:36:40','{\"FID\":\"110727\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9885\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-26T17:36:45.437\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009885\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:44:33\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432623357206990849',1,NULL,7,'推送实物ID信息'),
('1432625950243201026',0,'成功','2021-08-31 16:46:58','{\"FID\":\"110711\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9869\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-13T10:02:35.013\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009869\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-13 10:10:07\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432625951350460417',1,NULL,7,'推送实物ID信息'),
('1432625950859763713',0,'成功','2021-08-31 16:46:58','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432625952113823745',1,NULL,7,'推送实物ID信息'),
('1432625951149170690',0,'成功','2021-08-31 16:46:58','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432625952407425026',1,NULL,7,'推送实物ID信息'),
('1432625951430189058',0,'成功','2021-08-31 16:46:58','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432625952675860481',1,NULL,7,'推送实物ID信息'),
('1432625951702818818',0,'成功','2021-08-31 16:46:58','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432625952948490241',1,NULL,7,'推送实物ID信息'),
('1432625952034168834',0,'成功','2021-08-31 16:46:59','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432625953263063042',1,NULL,7,'推送实物ID信息'),
('1432625952315187202',0,'成功','2021-08-31 16:46:59','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432625953565052929',1,NULL,7,'推送实物ID信息'),
('1432625952612982785',0,'成功','2021-08-31 16:46:59','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432625953862848514',1,NULL,7,'推送实物ID信息'),
('1432625952956915713',0,'成功','2021-08-31 16:46:59','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432625954210975745',1,NULL,7,'推送实物ID信息'),
('1432625953267294210',0,'成功','2021-08-31 16:46:59','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432625954521354242',1,NULL,7,'推送实物ID信息'),
('1432625953539923970',0,'成功','2021-08-31 16:46:59','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432625954793984002',1,NULL,7,'推送实物ID信息'),
('1432625953820942337',0,'成功','2021-08-31 16:46:59','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432625955087585282',1,NULL,7,'推送实物ID信息'),
('1432625954114543618',0,'成功','2021-08-31 16:46:59','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432625955364409346',1,NULL,7,'推送实物ID信息'),
('1432625954424922114',0,'成功','2021-08-31 16:46:59','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432625955683176449',1,NULL,7,'推送实物ID信息'),
('1432625954756272130',0,'成功','2021-08-31 16:46:59','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432625955997749249',1,NULL,7,'推送实物ID信息'),
('1432625955028901889',0,'成功','2021-08-31 16:46:59','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432625956282961922',1,NULL,7,'推送实物ID信息'),
('1432625955301531649',0,'成功','2021-08-31 16:46:59','{\"FID\":\"110727\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9885\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-26T17:36:45.437\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009885\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:44:33\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432625956568174594',1,NULL,7,'推送实物ID信息'),
('1432626462032220161',0,'成功','2021-08-31 16:49:00','{\"FID\":\"110711\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9869\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-13T10:02:35.013\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009869\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-13 10:10:07\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626463051354113',1,NULL,7,'推送实物ID信息'),
('1432626462757834753',0,'成功','2021-08-31 16:49:00','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626464003461121',1,NULL,7,'推送实物ID信息'),
('1432626463076601858',0,'成功','2021-08-31 16:49:00','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626464322228225',1,NULL,7,'推送实物ID信息'),
('1432626463391174658',0,'成功','2021-08-31 16:49:00','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626464657772546',1,NULL,7,'推送实物ID信息'),
('1432626463718330369',0,'成功','2021-08-31 16:49:01','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626464972345345',1,NULL,7,'推送实物ID信息'),
('1432626464070651905',0,'成功','2021-08-31 16:49:01','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626465312083969',1,NULL,7,'推送实物ID信息'),
('1432626464456527874',0,'成功','2021-08-31 16:49:01','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626465664405505',1,NULL,7,'推送实物ID信息'),
('1432626464796266497',0,'成功','2021-08-31 16:49:01','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626466050281474',1,NULL,7,'推送实物ID信息'),
('1432626465152782338',0,'成功','2021-08-31 16:49:01','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626466415185922',1,NULL,7,'推送实物ID信息'),
('1432626465559629825',0,'成功','2021-08-31 16:49:01','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626466809450497',1,NULL,7,'推送实物ID信息'),
('1432626465953894402',0,'成功','2021-08-31 16:49:01','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626467203715074',1,NULL,7,'推送实物ID信息'),
('1432626466276855810',0,'成功','2021-08-31 16:49:01','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626467535065089',1,NULL,7,'推送实物ID信息'),
('1432626466612400129',0,'成功','2021-08-31 16:49:01','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626467870609410',1,NULL,7,'推送实物ID信息'),
('1432626466947944449',0,'成功','2021-08-31 16:49:01','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626468176793602',1,NULL,7,'推送实物ID信息'),
('1432626467266711553',0,'成功','2021-08-31 16:49:01','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626468512337922',1,NULL,7,'推送实物ID信息'),
('1432626467614838785',0,'成功','2021-08-31 16:49:01','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626468868853761',1,NULL,7,'推送实物ID信息'),
('1432626467912634369',0,'成功','2021-08-31 16:49:02','{\"FID\":\"110727\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9885\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-26T17:36:45.437\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009885\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:44:33\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626469175037953',1,NULL,7,'推送实物ID信息'),
('1432626947661250562',0,'成功','2021-08-31 16:50:56','{\"FID\":\"110711\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9869\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-13T10:02:35.013\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009869\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-13 10:10:07\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626948718202881',1,NULL,7,'推送实物ID信息'),
('1432626948265230337',0,'成功','2021-08-31 16:50:56','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626949502537729',1,NULL,7,'推送实物ID信息'),
('1432626948542054401',0,'成功','2021-08-31 16:50:56','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626949796139010',1,NULL,7,'推送实物ID信息'),
('1432626948923736066',0,'成功','2021-08-31 16:50:56','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626950186209282',1,NULL,7,'推送实物ID信息'),
('1432626949234114562',0,'成功','2021-08-31 16:50:56','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626950513364994',1,NULL,7,'推送实物ID信息'),
('1432626949544493058',0,'成功','2021-08-31 16:50:56','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626950815354882',1,NULL,7,'推送实物ID信息'),
('1432626949934563330',0,'成功','2021-08-31 16:50:56','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626951155093505',1,NULL,7,'推送实物ID信息'),
('1432626950274301953',0,'成功','2021-08-31 16:50:57','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626951532580865',1,NULL,7,'推送实物ID信息'),
('1432626950605651969',0,'成功','2021-08-31 16:50:57','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626951880708098',1,NULL,7,'推送实物ID信息'),
('1432626950978945026',0,'成功','2021-08-31 16:50:57','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626952228835329',1,NULL,7,'推送实物ID信息'),
('1432626951247380481',0,'成功','2021-08-31 16:50:57','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626952514048001',1,NULL,7,'推送实物ID信息'),
('1432626951557758978',0,'成功','2021-08-31 16:50:57','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626952841203714',1,NULL,7,'推送实物ID信息'),
('1432626951830388738',0,'成功','2021-08-31 16:50:57','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626953109639169',1,NULL,7,'推送实物ID信息'),
('1432626952157544449',0,'成功','2021-08-31 16:50:57','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626953428406274',1,NULL,7,'推送实物ID信息'),
('1432626952438562817',0,'成功','2021-08-31 16:50:57','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626953713618946',1,NULL,7,'推送实物ID信息'),
('1432626952702803969',0,'成功','2021-08-31 16:50:57','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626953982054401',1,NULL,7,'推送实物ID信息'),
('1432626952962850818',0,'成功','2021-08-31 16:50:57','{\"FID\":\"110727\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9885\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-26T17:36:45.437\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009885\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:44:33\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432626954242101249',1,NULL,7,'推送实物ID信息'),
('1432627559417368578',0,'成功','2021-08-31 16:53:22','{\"FID\":\"110711\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9869\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-13T10:02:35.013\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009869\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-13 10:10:07\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627560490995714',1,NULL,7,'推送实物ID信息'),
('1432627560021348353',0,'成功','2021-08-31 16:53:22','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627561296302081',1,NULL,7,'推送实物ID信息'),
('1432627560323338241',0,'成功','2021-08-31 16:53:22','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627561594097665',1,NULL,7,'推送实物ID信息'),
('1432627560621133826',0,'成功','2021-08-31 16:53:22','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627561908670466',1,NULL,7,'推送实物ID信息'),
('1432627560952483842',0,'成功','2021-08-31 16:53:22','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627562231631874',1,NULL,7,'推送实物ID信息'),
('1432627561329971201',0,'成功','2021-08-31 16:53:22','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627562579759105',1,NULL,7,'推送实物ID信息'),
('1432627561631961090',0,'成功','2021-08-31 16:53:22','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627562915303426',1,NULL,7,'推送实物ID信息'),
('1432627561912979457',0,'成功','2021-08-31 16:53:22','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627563204710402',1,NULL,7,'推送实物ID信息'),
('1432627562265300994',0,'成功','2021-08-31 16:53:22','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627563536060417',1,NULL,7,'推送实物ID信息'),
('1432627562592456706',0,'成功','2021-08-31 16:53:23','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627563871604738',1,NULL,7,'推送实物ID信息'),
('1432627562923806722',0,'成功','2021-08-31 16:53:23','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627564190371842',1,NULL,7,'推送实物ID信息'),
('1432627563242573825',0,'成功','2021-08-31 16:53:23','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627564517527553',1,NULL,7,'推送实物ID信息'),
('1432627563536175105',0,'成功','2021-08-31 16:53:23','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627564811128834',1,NULL,7,'推送实物ID信息'),
('1432627563821387777',0,'成功','2021-08-31 16:53:23','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627565096341506',1,NULL,7,'推送实物ID信息'),
('1432627564144349185',0,'成功','2021-08-31 16:53:23','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627565419302914',1,NULL,7,'推送实物ID信息'),
('1432627564446339074',0,'成功','2021-08-31 16:53:23','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627565729681410',1,NULL,7,'推送实物ID信息'),
('1432627564731551746',0,'成功','2021-08-31 16:53:23','{\"FID\":\"110727\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9885\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-26T17:36:45.437\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009885\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:44:33\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627566010699777',1,NULL,7,'推送实物ID信息'),
('1432627818356920322',0,'成功','2021-08-31 16:54:23','{\"FID\":\"110711\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9869\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-13T10:02:35.013\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009869\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-13 10:10:07\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627819640262658',1,NULL,7,'推送实物ID信息'),
('1432627818684076033',0,'成功','2021-08-31 16:54:24','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627819946446850',1,NULL,7,'推送实物ID信息'),
('1432627818977677314',0,'成功','2021-08-31 16:54:24','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627820265213954',1,NULL,7,'推送实物ID信息'),
('1432627819288055809',0,'成功','2021-08-31 16:54:24','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627820571398146',1,NULL,7,'推送实物ID信息'),
('1432627819615211522',0,'成功','2021-08-31 16:54:24','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627820894359554',1,NULL,7,'推送实物ID信息'),
('1432627819971727361',0,'成功','2021-08-31 16:54:24','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627821225709570',1,NULL,7,'推送实物ID信息'),
('1432627820298883074',0,'成功','2021-08-31 16:54:24','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627821582225409',1,NULL,7,'推送实物ID信息'),
('1432627820613455874',0,'成功','2021-08-31 16:54:24','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627821884215297',1,NULL,7,'推送实物ID信息'),
('1432627820949000193',0,'成功','2021-08-31 16:54:24','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627822223953922',1,NULL,7,'推送实物ID信息'),
('1432627821267767298',0,'成功','2021-08-31 16:54:24','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627822525943810',1,NULL,7,'推送实物ID信息'),
('1432627821561368577',0,'成功','2021-08-31 16:54:24','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627822853099521',1,NULL,7,'推送实物ID信息'),
('1432627821867552769',0,'成功','2021-08-31 16:54:24','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627823146700802',1,NULL,7,'推送实物ID信息'),
('1432627822295371777',0,'成功','2021-08-31 16:54:24','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627823553548289',1,NULL,7,'推送实物ID信息'),
('1432627822580584450',0,'成功','2021-08-31 16:54:24','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627823868121089',1,NULL,7,'推送实物ID信息'),
('1432627822882574338',0,'成功','2021-08-31 16:54:25','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627824161722370',1,NULL,7,'推送实物ID信息'),
('1432627823205535745',0,'成功','2021-08-31 16:54:25','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627824484683778',1,NULL,7,'推送实物ID信息'),
('1432627823532691458',0,'成功','2021-08-31 16:54:25','{\"FID\":\"110727\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9885\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-26T17:36:45.437\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009885\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:44:33\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627824807645185',1,NULL,7,'推送实物ID信息'),
('1432627955317719041',0,'成功','2021-08-31 16:54:56','{\"FID\":\"110711\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9869\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-13T10:02:35.013\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009869\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-13 10:10:07\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627956424904706',1,NULL,7,'推送实物ID信息'),
('1432627955871367169',0,'成功','2021-08-31 16:54:56','{\"FID\":\"110712\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9870\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-16T17:33:43.313\",\"entitycode\":\"3901553\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009870\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-16 17:47:27\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627957154713602',1,NULL,7,'推送实物ID信息'),
('1432627956160774146',0,'成功','2021-08-31 16:54:56','{\"FID\":\"110713\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9871\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T16:44:14.513\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009871\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 16:50:03\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627957448314881',1,NULL,7,'推送实物ID信息'),
('1432627956496318466',0,'成功','2021-08-31 16:54:56','{\"FID\":\"110714\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9872\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-17T17:30:04.053\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009872\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-17 17:38:53\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627957779664897',1,NULL,7,'推送实物ID信息'),
('1432627956852834305',0,'成功','2021-08-31 16:54:57','{\"FID\":\"110715\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9873\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T09:51:21.187\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009873\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 09:52:38\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627958119403521',1,NULL,7,'推送实物ID信息'),
('1432627957280653314',0,'成功','2021-08-31 16:54:57','{\"FID\":\"110716\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9874\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:34:10.937\",\"entitycode\":\"3901527\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009874\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:35:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627958509473794',1,NULL,7,'推送实物ID信息'),
('1432627957628780545',0,'成功','2021-08-31 16:54:57','{\"FID\":\"110717\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9875\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T11:53:16.847\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009875\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 11:54:37\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627958912126977',1,NULL,7,'推送实物ID信息'),
('1432627958018850817',0,'成功','2021-08-31 16:54:57','{\"FID\":\"110718\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9876\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T15:51:02.357\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009876\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:01:17\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627959256059905',1,NULL,7,'推送实物ID信息'),
('1432627958434086913',0,'成功','2021-08-31 16:54:57','{\"FID\":\"110719\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9877\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:26:41.977\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009877\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:40:43\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627959675490306',1,NULL,7,'推送实物ID信息'),
('1432627958798991362',0,'成功','2021-08-31 16:54:57','{\"FID\":\"110720\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9878\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-18T16:45:44.203\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009878\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-18 16:46:01\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627960082337793',1,NULL,7,'推送实物ID信息'),
('1432627959205838850',0,'成功','2021-08-31 16:54:57','{\"FID\":\"110721\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9879\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:32:39.15\",\"entitycode\":\"3901554\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009879\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:33:24\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627960472408065',1,NULL,7,'推送实物ID信息'),
('1432627959755292673',0,'成功','2021-08-31 16:54:57','{\"FID\":\"110722\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9880\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T11:52:12.98\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009880\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 11:59:47\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627960984113153',1,NULL,7,'推送实物ID信息'),
('1432627960271192066',0,'成功','2021-08-31 16:54:57','{\"FID\":\"110723\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9881\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-19T15:34:45.413\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009881\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-19 15:34:06\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627961546149889',1,NULL,7,'推送实物ID信息'),
('1432627960715788289',0,'成功','2021-08-31 16:54:57','{\"FID\":\"110724\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9882\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-20T10:17:09.593\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009882\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-20 10:18:15\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627961986551810',1,NULL,7,'推送实物ID信息'),
('1432627961084887042',0,'成功','2021-08-31 16:54:58','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627962326290434',1,NULL,7,'推送实物ID信息'),
('1432627961453985794',0,'成功','2021-08-31 16:54:58','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627962728943617',1,NULL,7,'推送实物ID信息'),
('1432627961869221889',0,'成功','2021-08-31 16:54:58','{\"FID\":\"110727\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9885\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-26T17:36:45.437\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009885\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:44:33\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1432627963102236674',1,NULL,7,'推送实物ID信息'),
('1433000631504752641',0,'成功','2021-09-01 17:35:49','{\"FID\":\"110725\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9883\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:00:35.643\",\"entitycode\":\"3901529\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009883\",\"poItemId\":\"\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:00:46\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1433000631227912194',1,NULL,7,'推送实物ID信息'),
('1433000632280698882',0,'成功','2021-09-01 17:35:49','{\"FID\":\"110726\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9884\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-21T10:14:21.043\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009884\",\"poItemId\":\"\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-21 10:15:29\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1433000632872079362',1,NULL,7,'推送实物ID信息'),
('1433000632586883074',0,'成功','2021-09-01 17:35:49','{\"FID\":\"110727\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9885\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-26T17:36:45.437\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009885\",\"poItemId\":\"\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:44:33\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1433000633182457858',1,NULL,7,'推送实物ID信息'),
('1436146419521032193',0,'成功','2021-09-10 09:56:03','{\"FID\":\"110727\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9885\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-26T17:36:45.437\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009885\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:44:33\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1436146417654566914',1,NULL,7,'推送实物ID信息'),
('1436146459014598657',0,'成功','2021-09-10 09:56:13','{\"FID\":\"110727\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9885\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-26T17:36:45.437\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009885\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:44:33\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1436146458813272066',1,NULL,7,'推送实物ID信息'),
('1436146592238276610',0,'成功','2021-09-10 09:56:45','{\"FID\":\"110727\",\"openid\":\"string\",\"remark\":\"\",\"ownerid\":\"9885\",\"entitystatus\":\"2\",\"FApproveDate\":\"2021-08-26T17:36:45.437\",\"entitycode\":\"3901528\",\"suppliername\":\"灵清科技\",\"FBILLNO\":\"SCRK00009885\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-08-26 17:44:33\",\"suppliercode\":\"linqin\",\"purchaserhqcode\":\"SGCC\"}','1436146591944675329',1,NULL,7,'推送实物ID信息'),
('1436212879501037569',0,'成功','2021-09-10 14:20:09','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436212878905446401',1,NULL,3,'推送销售订单'),
('1436213133071880194',0,'成功','2021-09-10 14:21:09','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436213132962828289',1,NULL,3,'推送销售订单'),
('1436213133285789697',0,'成功','2021-09-10 14:21:09','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436213133197709314',1,NULL,3,'推送销售订单'),
('1436213386642722817',0,'成功','2021-09-10 14:22:10','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436213386542059522',1,NULL,3,'推送销售订单'),
('1436213386760163330',0,'成功','2021-09-10 14:22:10','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436213386705637377',1,NULL,3,'推送销售订单'),
('1436213386965684225',0,'成功','2021-09-10 14:22:10','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436213386898575362',1,NULL,3,'推送销售订单'),
('1436213639689277442',0,'成功','2021-09-10 14:23:10','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436213639622168577',1,NULL,3,'推送销售订单'),
('1436213639836078082',0,'成功','2021-09-10 14:23:10','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436213639764774914',1,NULL,3,'推送销售订单'),
('1436213639987073026',0,'成功','2021-09-10 14:23:10','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436213639907381249',1,NULL,3,'推送销售订单'),
('1436213640121290754',0,'成功','2021-09-10 14:23:10','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436213640062570497',1,NULL,3,'推送销售订单'),
('1436213892903604226',0,'成功','2021-09-10 14:24:10','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436213892823912450',1,NULL,3,'推送销售订单'),
('1436213893067182081',0,'成功','2021-09-10 14:24:10','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436213892966518786',1,NULL,3,'推送销售订单'),
('1436213893377560577',0,'成功','2021-09-10 14:24:10','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436213893218177025',1,NULL,3,'推送销售订单'),
('1436213893725687810',0,'成功','2021-09-10 14:24:10','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436213893549527041',1,NULL,3,'推送销售订单'),
('1436213893985734658',0,'成功','2021-09-10 14:24:11','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436213893914431490',1,NULL,3,'推送销售订单'),
('1436214146738688001',0,'成功','2021-09-10 14:25:11','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214146692550658',1,NULL,3,'推送销售订单'),
('1436214146826768385',0,'成功','2021-09-10 14:25:11','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214146780631042',1,NULL,3,'推送销售订单'),
('1436214146927431682',0,'成功','2021-09-10 14:25:11','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214146881294338',1,NULL,3,'推送销售订单'),
('1436214147019706369',0,'成功','2021-09-10 14:25:11','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214146981957633',1,NULL,3,'推送销售订单'),
('1436214147111981058',0,'成功','2021-09-10 14:25:11','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214147053260802',1,NULL,3,'推送销售订单'),
('1436214147204255746',0,'成功','2021-09-10 14:25:11','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214147162312706',1,NULL,3,'推送销售订单'),
('1436214399869128705',0,'成功','2021-09-10 14:26:11','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214399760076802',1,NULL,3,'推送销售订单'),
('1436214399936237570',0,'成功','2021-09-10 14:26:11','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214399885905922',1,NULL,3,'推送销售订单'),
('1436214399994957825',0,'成功','2021-09-10 14:26:11','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214399957209089',1,NULL,3,'推送销售订单'),
('1436214400057872385',0,'成功','2021-09-10 14:26:11','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214400024317953',1,NULL,3,'推送销售订单'),
('1436214400150147073',0,'成功','2021-09-10 14:26:11','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214400099815426',1,NULL,3,'推送销售订单'),
('1436214400204673026',0,'成功','2021-09-10 14:26:11','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214400175312898',1,NULL,3,'推送销售订单'),
('1436214400275976194',0,'成功','2021-09-10 14:26:11','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214400229838849',1,NULL,3,'推送销售订单'),
('1436214653519663105',0,'成功','2021-09-10 14:27:12','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214653200896001',1,NULL,3,'推送销售订单'),
('1436214653695823874',0,'成功','2021-09-10 14:27:12','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214653649686529',1,NULL,3,'推送销售订单'),
('1436214653783904257',0,'成功','2021-09-10 14:27:12','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214653733572610',1,NULL,3,'推送销售订单'),
('1436214653892956161',0,'成功','2021-09-10 14:27:12','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214653838430209',1,NULL,3,'推送销售订单'),
('1436214654035562498',0,'成功','2021-09-10 14:27:12','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214653947482113',1,NULL,3,'推送销售订单'),
('1436214654245277697',0,'成功','2021-09-10 14:27:12','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214654115254273',1,NULL,3,'推送销售订单'),
('1436214654626959361',0,'成功','2021-09-10 14:27:12','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214654505324545',1,NULL,3,'推送销售订单'),
('1436214655012835330',0,'成功','2021-09-10 14:27:12','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214654748594177',1,NULL,3,'推送销售订单'),
('1436214908122304513',0,'成功','2021-09-10 14:28:12','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214908013252609',1,NULL,3,'推送销售订单'),
('1436214908361379842',0,'成功','2021-09-10 14:28:12','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214908210384897',1,NULL,3,'推送销售订单'),
('1436214908642398210',0,'成功','2021-09-10 14:28:12','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214908462043137',1,NULL,3,'推送销售订单'),
('1436214908881473538',0,'成功','2021-09-10 14:28:13','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214908722089985',1,NULL,3,'推送销售订单'),
('1436214909141520385',0,'成功','2021-09-10 14:28:13','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214908956971010',1,NULL,3,'推送销售订单'),
('1436214909414150146',0,'成功','2021-09-10 14:28:13','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214909217017858',1,NULL,3,'推送销售订单'),
('1436214909653225474',0,'成功','2021-09-10 14:28:13','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214909489647618',1,NULL,3,'推送销售订单'),
('1436214909900689409',0,'成功','2021-09-10 14:28:13','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436214909762277378',1,NULL,3,'推送销售订单'),
('1436214910156541953',0,'成功','2021-09-10 14:28:13','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"B\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436214909980381185',1,NULL,3,'推送销售订单'),
('1436215163135987713',0,'成功','2021-09-10 14:29:13','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215163010158593',1,NULL,3,'推送销售订单'),
('1436215163366674434',0,'成功','2021-09-10 14:29:13','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215163224068098',1,NULL,3,'推送销售订单'),
('1436215163635109889',0,'成功','2021-09-10 14:29:13','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215163425394690',1,NULL,3,'推送销售订单'),
('1436215164025180161',0,'成功','2021-09-10 14:29:13','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215163731578881',1,NULL,3,'推送销售订单'),
('1436215164889206786',0,'成功','2021-09-10 14:29:14','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215164281032705',1,NULL,3,'推送销售订单'),
('1436215165199585281',0,'成功','2021-09-10 14:29:14','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215165010841601',1,NULL,3,'推送销售订单'),
('1436215165472215041',0,'成功','2021-09-10 14:29:14','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215165325414401',1,NULL,3,'推送销售订单'),
('1436215169507135489',0,'成功','2021-09-10 14:29:15','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215169360334849',1,NULL,3,'推送销售订单'),
('1436215169674907649',0,'成功','2021-09-10 14:29:15','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436215169557467138',1,NULL,3,'推送销售订单'),
('1436215169851068417',0,'成功','2021-09-10 14:29:15','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436215169733627905',1,NULL,3,'推送销售订单'),
('1436215408536326145',0,'成功','2021-09-10 14:30:12','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436215405344460801',1,NULL,4,'推送生产订单'),
('1436215422704685057',0,'成功','2021-09-10 14:30:15','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215422494969857',1,NULL,3,'推送销售订单'),
('1436215422968926210',0,'成功','2021-09-10 14:30:15','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215422780182529',1,NULL,3,'推送销售订单'),
('1436215423187030018',0,'成功','2021-09-10 14:30:15','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215423027646466',1,NULL,3,'推送销售订单'),
('1436215423505797122',0,'成功','2021-09-10 14:30:15','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215423275110402',1,NULL,3,'推送销售订单'),
('1436215423694540802',0,'成功','2021-09-10 14:30:15','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215423568711681',1,NULL,3,'推送销售订单'),
('1436215423946199042',0,'成功','2021-09-10 14:30:15','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215423786815489',1,NULL,3,'推送销售订单'),
('1436215424193662977',0,'成功','2021-09-10 14:30:15','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215424051056641',1,NULL,3,'推送销售订单'),
('1436215424428544001',0,'成功','2021-09-10 14:30:15','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215424269160450',1,NULL,3,'推送销售订单'),
('1436215425024135169',0,'成功','2021-09-10 14:30:16','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436215424646647809',1,NULL,3,'推送销售订单'),
('1436215425737166849',0,'成功','2021-09-10 14:30:16','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436215425267404801',1,NULL,3,'推送销售订单'),
('1436215426081099777',0,'成功','2021-09-10 14:30:16','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436215425821052930',1,NULL,3,'推送销售订单'),
('1436215662216220674',0,'成功','2021-09-10 14:31:12','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436215662048448513',1,NULL,4,'推送生产订单'),
('1436215678875996162',0,'成功','2021-09-10 14:31:16','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215678733389825',1,NULL,3,'推送销售订单'),
('1436215679106682882',0,'成功','2021-09-10 14:31:16','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215678951493634',1,NULL,3,'推送销售订单'),
('1436215679316398081',0,'成功','2021-09-10 14:31:16','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215679169597441',1,NULL,3,'推送销售订单'),
('1436215679521918977',0,'成功','2021-09-10 14:31:16','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215679358341121',1,NULL,3,'推送销售订单'),
('1436215679714856962',0,'成功','2021-09-10 14:31:16','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215679589027841',1,NULL,3,'推送销售订单'),
('1436215679941349378',0,'成功','2021-09-10 14:31:16','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215679823908865',1,NULL,3,'推送销售订单'),
('1436215680130093058',0,'成功','2021-09-10 14:31:16','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215680012652545',1,NULL,3,'推送销售订单'),
('1436215680453054465',0,'成功','2021-09-10 14:31:16','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215680193007618',1,NULL,3,'推送销售订单'),
('1436215680645992450',0,'成功','2021-09-10 14:31:17','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436215680549523457',1,NULL,3,'推送销售订单'),
('1436215680952176642',0,'成功','2021-09-10 14:31:17','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436215680721489922',1,NULL,3,'推送销售订单'),
('1436215681203834882',0,'成功','2021-09-10 14:31:17','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436215681052839938',1,NULL,3,'推送销售订单'),
('1436215681430327297',0,'成功','2021-09-10 14:31:17','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436215681275138049',1,NULL,3,'推送销售订单'),
('1436215915426353153',0,'成功','2021-09-10 14:32:12','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436215915317301249',1,NULL,4,'推送生产订单'),
('1436215934111977474',0,'成功','2021-09-10 14:32:17','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215933973565441',1,NULL,3,'推送销售订单'),
('1436215934296526850',0,'成功','2021-09-10 14:32:17','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215934162309122',1,NULL,3,'推送销售订单'),
('1436215934514630657',0,'成功','2021-09-10 14:32:17','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215934359441409',1,NULL,3,'推送销售订单'),
('1436215934766288898',0,'成功','2021-09-10 14:32:17','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215934594322434',1,NULL,3,'推送销售订单'),
('1436215934996975618',0,'成功','2021-09-10 14:32:17','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215934837592065',1,NULL,3,'推送销售订单'),
('1436215935231856641',0,'成功','2021-09-10 14:32:17','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215935072473090',1,NULL,3,'推送销售订单'),
('1436215935433183233',0,'成功','2021-09-10 14:32:17','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215935290576897',1,NULL,3,'推送销售订单'),
('1436215935676452865',0,'成功','2021-09-10 14:32:17','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436215935491903490',1,NULL,3,'推送销售订单'),
('1436215935890362369',0,'成功','2021-09-10 14:32:17','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436215935739367425',1,NULL,3,'推送销售订单'),
('1436215936112660481',0,'成功','2021-09-10 14:32:17','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436215935957471234',1,NULL,3,'推送销售订单'),
('1436215936305598465',0,'成功','2021-09-10 14:32:17','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436215936158797826',1,NULL,3,'推送销售订单'),
('1436215936536285185',0,'成功','2021-09-10 14:32:18','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436215936385290242',1,NULL,3,'推送销售订单'),
('1436215936754388993',0,'成功','2021-09-10 14:32:18','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436215936607588353',1,NULL,3,'推送销售订单'),
('1436216168183500801',0,'成功','2021-09-10 14:33:13','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436216168049283074',1,NULL,4,'推送生产订单'),
('1436216189641560065',0,'成功','2021-09-10 14:33:18','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216189507342337',1,NULL,3,'推送销售订单'),
('1436216189859663874',0,'成功','2021-09-10 14:33:18','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216189704474626',1,NULL,3,'推送销售订单'),
('1436216190094544897',0,'成功','2021-09-10 14:33:18','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216189943549953',1,NULL,3,'推送销售订单'),
('1436216190346203138',0,'成功','2021-09-10 14:33:18','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216190170042370',1,NULL,3,'推送销售订单'),
('1436216190576889858',0,'成功','2021-09-10 14:33:18','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216190413312002',1,NULL,3,'推送销售订单'),
('1436216190857908226',0,'成功','2021-09-10 14:33:18','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216190660775938',1,NULL,3,'推送销售订单'),
('1436216191063429121',0,'成功','2021-09-10 14:33:18','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216190929211394',1,NULL,3,'推送销售订单'),
('1436216191243784193',0,'成功','2021-09-10 14:33:18','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216191117955073',1,NULL,3,'推送销售订单'),
('1436216191466082306',0,'成功','2021-09-10 14:33:18','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216191327670274',1,NULL,3,'推送销售订单'),
('1436216191914872833',0,'成功','2021-09-10 14:33:18','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216191558356994',1,NULL,3,'推送销售订单'),
('1436216192137170946',0,'成功','2021-09-10 14:33:18','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216192002953217',1,NULL,3,'推送销售订单'),
('1436216192325914626',0,'成功','2021-09-10 14:33:19','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216192212668418',1,NULL,3,'推送销售订单'),
('1436216192502075393',0,'成功','2021-09-10 14:33:19','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216192388829186',1,NULL,3,'推送销售订单'),
('1436216192674041857',0,'成功','2021-09-10 14:33:19','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216192556601346',1,NULL,3,'推送销售订单'),
('1436216420848373762',0,'成功','2021-09-10 14:34:13','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436216420718350338',1,NULL,4,'推送生产订单'),
('1436216445452161026',0,'成功','2021-09-10 14:34:19','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216445250834434',1,NULL,3,'推送销售订单'),
('1436216445745762305',0,'成功','2021-09-10 14:34:19','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216445607350273',1,NULL,3,'推送销售订单'),
('1436216446005809153',0,'成功','2021-09-10 14:34:19','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216445842231297',1,NULL,3,'推送销售订单'),
('1436216446169387009',0,'成功','2021-09-10 14:34:19','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216446068723713',1,NULL,3,'推送销售订单'),
('1436216446601400322',0,'成功','2021-09-10 14:34:19','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216446316187650',1,NULL,3,'推送销售订单'),
('1436216446932750338',0,'成功','2021-09-10 14:34:19','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216446785949697',1,NULL,3,'推送销售订单'),
('1436216447113105410',0,'成功','2021-09-10 14:34:19','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216446991470594',1,NULL,3,'推送销售订单'),
('1436216447410900993',0,'成功','2021-09-10 14:34:19','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216447184408578',1,NULL,3,'推送销售订单'),
('1436216447649976322',0,'成功','2021-09-10 14:34:19','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216447511564290',1,NULL,3,'推送销售订单'),
('1436216455304581122',0,'成功','2021-09-10 14:34:21','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216454675435521',1,NULL,3,'推送销售订单'),
('1436216455875006465',0,'成功','2021-09-10 14:34:21','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216455719817217',1,NULL,3,'推送销售订单'),
('1436216455996641281',0,'成功','2021-09-10 14:34:21','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216455916949506',1,NULL,3,'推送销售订单'),
('1436216456109887490',0,'成功','2021-09-10 14:34:21','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216456026001409',1,NULL,3,'推送销售订单'),
('1436216456269271042',0,'成功','2021-09-10 14:34:21','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216456160219137',1,NULL,3,'推送销售订单'),
('1436216456428654594',0,'成功','2021-09-10 14:34:21','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216456315408385',1,NULL,3,'推送销售订单'),
('1436216674113032194',0,'成功','2021-09-10 14:35:13','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436216673869762562',1,NULL,4,'推送生产订单'),
('1436216709072556033',0,'成功','2021-09-10 14:35:22','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216708967698434',1,NULL,3,'推送销售订单'),
('1436216709236133889',0,'成功','2021-09-10 14:35:22','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216709131276289',1,NULL,3,'推送销售订单'),
('1436216709395517441',0,'成功','2021-09-10 14:35:22','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216709294854145',1,NULL,3,'推送销售订单'),
('1436216709588455426',0,'成功','2021-09-10 14:35:22','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216709479403522',1,NULL,3,'推送销售订单'),
('1436216709731061762',0,'成功','2021-09-10 14:35:22','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216709638787073',1,NULL,3,'推送销售订单'),
('1436216709894639618',0,'成功','2021-09-10 14:35:22','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216709781393410',1,NULL,3,'推送销售订单'),
('1436216710058217474',0,'成功','2021-09-10 14:35:22','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216709949165570',1,NULL,3,'推送销售订单'),
('1436216710225989633',0,'成功','2021-09-10 14:35:22','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216710108549121',1,NULL,3,'推送销售订单'),
('1436216710356013058',0,'成功','2021-09-10 14:35:22','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216710267932674',1,NULL,3,'推送销售订单'),
('1436216710469259265',0,'成功','2021-09-10 14:35:22','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216710385373186',1,NULL,3,'推送销售订单'),
('1436216710582505473',0,'成功','2021-09-10 14:35:22','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216710507008002',1,NULL,3,'推送销售订单'),
('1436216710720917505',0,'成功','2021-09-10 14:35:22','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216710611865601',1,NULL,3,'推送销售订单'),
('1436216710838358017',0,'成功','2021-09-10 14:35:22','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216710767054850',1,NULL,3,'推送销售订单'),
('1436216710955798530',0,'成功','2021-09-10 14:35:22','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216710892883969',1,NULL,3,'推送销售订单'),
('1436216711069044737',0,'成功','2021-09-10 14:35:22','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216710985158657',1,NULL,3,'推送销售订单'),
('1436216711614304258',0,'成功','2021-09-10 14:35:22','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216711241011201',1,NULL,3,'推送销售订单'),
('1436216926882762754',0,'成功','2021-09-10 14:36:14','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436216926786293762',1,NULL,4,'推送生产订单'),
('1436216964358868994',0,'成功','2021-09-10 14:36:23','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216964254011393',1,NULL,3,'推送销售订单'),
('1436216964539224065',0,'成功','2021-09-10 14:36:23','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216964417589249',1,NULL,3,'推送销售订单'),
('1436216964732162050',0,'成功','2021-09-10 14:36:23','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216964606332930',1,NULL,3,'推送销售订单'),
('1436216964904128513',0,'成功','2021-09-10 14:36:23','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216964807659522',1,NULL,3,'推送销售订单'),
('1436216965038346241',0,'成功','2021-09-10 14:36:23','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216964954460161',1,NULL,3,'推送销售订单'),
('1436216965210312706',0,'成功','2021-09-10 14:36:23','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216965097066497',1,NULL,3,'推送销售订单'),
('1436216965403250689',0,'成功','2021-09-10 14:36:23','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216965298393090',1,NULL,3,'推送销售订单'),
('1436216965558439938',0,'成功','2021-09-10 14:36:23','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436216965482942465',1,NULL,3,'推送销售订单'),
('1436216965726212097',0,'成功','2021-09-10 14:36:23','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216965642326018',1,NULL,3,'推送销售订单'),
('1436216965873012738',0,'成功','2021-09-10 14:36:23','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216965797515265',1,NULL,3,'推送销售订单'),
('1436216965977870337',0,'成功','2021-09-10 14:36:23','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216965902372865',1,NULL,3,'推送销售订单'),
('1436216966166614018',0,'成功','2021-09-10 14:36:23','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216966065950722',1,NULL,3,'推送销售订单'),
('1436216966422466562',0,'成功','2021-09-10 14:36:23','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216966267277313',1,NULL,3,'推送销售订单'),
('1436216966728650754',0,'成功','2021-09-10 14:36:23','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216966569267201',1,NULL,3,'推送销售订单'),
('1436216967210995713',0,'成功','2021-09-10 14:36:23','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216966850285569',1,NULL,3,'推送销售订单'),
('1436216967345213442',0,'成功','2021-09-10 14:36:23','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216967278104578',1,NULL,3,'推送销售订单'),
('1436216967424905217',0,'成功','2021-09-10 14:36:23','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436216967378767873',1,NULL,3,'推送销售订单'),
('1436217181028225026',0,'成功','2021-09-10 14:37:14','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436217180864647170',1,NULL,4,'推送生产订单'),
('1436217220425322497',0,'成功','2021-09-10 14:37:24','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217220362407938',1,NULL,3,'推送销售订单'),
('1436217220593094658',0,'成功','2021-09-10 14:37:24','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217220479848449',1,NULL,3,'推送销售订单'),
('1436217220827975681',0,'成功','2021-09-10 14:37:24','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217220681175041',1,NULL,3,'推送销售订单'),
('1436217221041885185',0,'成功','2021-09-10 14:37:24','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217220903473153',1,NULL,3,'推送销售订单'),
('1436217221201268737',0,'成功','2021-09-10 14:37:24','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217221117382657',1,NULL,3,'推送销售订单'),
('1436217221327097857',0,'成功','2021-09-10 14:37:24','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217221259988994',1,NULL,3,'推送销售订单'),
('1436217221570367489',0,'成功','2021-09-10 14:37:24','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217221427761153',1,NULL,3,'推送销售订单'),
('1436217221767499777',0,'成功','2021-09-10 14:37:24','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217221671030786',1,NULL,3,'推送销售订单'),
('1436217221943660545',0,'成功','2021-09-10 14:37:24','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217221838802946',1,NULL,3,'推送销售订单'),
('1436217222128209921',0,'成功','2021-09-10 14:37:24','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217222019158018',1,NULL,3,'推送销售订单'),
('1436217222509891585',0,'成功','2021-09-10 14:37:24','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217222186930178',1,NULL,3,'推送销售订单'),
('1436217223042568193',0,'成功','2021-09-10 14:37:24','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217222652497922',1,NULL,3,'推送销售订单'),
('1436217223482970113',0,'成功','2021-09-10 14:37:24','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217223361335298',1,NULL,3,'推送销售订单'),
('1436217223659130882',0,'成功','2021-09-10 14:37:24','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217223566856194',1,NULL,3,'推送销售订单'),
('1436217223847874561',0,'成功','2021-09-10 14:37:24','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217223713656834',1,NULL,3,'推送销售订单'),
('1436217224007258114',0,'成功','2021-09-10 14:37:24','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217223927566337',1,NULL,3,'推送销售订单'),
('1436217224837730306',0,'成功','2021-09-10 14:37:25','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217224779010050',1,NULL,3,'推送销售订单'),
('1436217224942587905',0,'成功','2021-09-10 14:37:25','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217224904839169',1,NULL,3,'推送销售订单'),
('1436217433898618882',0,'成功','2021-09-10 14:38:15','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436217433835704321',1,NULL,4,'推送生产订单'),
('1436217477984948226',0,'成功','2021-09-10 14:38:25','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217477926227969',1,NULL,3,'推送销售订单'),
('1436217478073028610',0,'成功','2021-09-10 14:38:25','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217478014308354',1,NULL,3,'推送销售订单'),
('1436217478173691906',0,'成功','2021-09-10 14:38:25','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217478119165953',1,NULL,3,'推送销售订单'),
('1436217478286938113',0,'成功','2021-09-10 14:38:25','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217478224023553',1,NULL,3,'推送销售订单'),
('1436217478383407105',0,'成功','2021-09-10 14:38:25','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217478328881154',1,NULL,3,'推送销售订单'),
('1436217478479876098',0,'成功','2021-09-10 14:38:25','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217478433738753',1,NULL,3,'推送销售订单'),
('1436217478572150786',0,'成功','2021-09-10 14:38:25','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217478526013441',1,NULL,3,'推送销售订单'),
('1436217478656036865',0,'成功','2021-09-10 14:38:25','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217478601510914',1,NULL,3,'推送销售订单'),
('1436217478765088769',0,'成功','2021-09-10 14:38:25','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217478706368514',1,NULL,3,'推送销售订单'),
('1436217478861557761',0,'成功','2021-09-10 14:38:25','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217478819614722',1,NULL,3,'推送销售订单'),
('1436217478970609665',0,'成功','2021-09-10 14:38:25','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217478903500802',1,NULL,3,'推送销售订单'),
('1436217479054495746',0,'成功','2021-09-10 14:38:25','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217478995775489',1,NULL,3,'推送销售订单'),
('1436217479146770434',0,'成功','2021-09-10 14:38:25','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217479088050177',1,NULL,3,'推送销售订单'),
('1436217479255822337',0,'成功','2021-09-10 14:38:25','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217479201296385',1,NULL,3,'推送销售订单'),
('1436217479335514113',0,'成功','2021-09-10 14:38:25','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217479285182465',1,NULL,3,'推送销售订单'),
('1436217479423594497',0,'成功','2021-09-10 14:38:25','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217479369068545',1,NULL,3,'推送销售订单'),
('1436217479503286274',0,'成功','2021-09-10 14:38:25','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217479457148930',1,NULL,3,'推送销售订单'),
('1436217479562006529',0,'成功','2021-09-10 14:38:25','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217479520063489',1,NULL,3,'推送销售订单'),
('1436217479654281218',0,'成功','2021-09-10 14:38:25','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217479595560961',1,NULL,3,'推送销售订单'),
('1436217686429274113',0,'成功','2021-09-10 14:39:15','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436217686378942466',1,NULL,4,'推送生产订单'),
('1436217732432400385',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217732386263041',1,NULL,3,'推送销售订单'),
('1436217732495314945',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217732453371905',1,NULL,3,'推送销售订单'),
('1436217732570812418',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217732520480769',1,NULL,3,'推送销售订单'),
('1436217732688252929',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217732608561153',1,NULL,3,'推送销售订单'),
('1436217732759556097',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217732717613058',1,NULL,3,'推送销售订单'),
('1436217732826664962',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217732784721921',1,NULL,3,'推送销售订单'),
('1436217732914745346',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217732868608002',1,NULL,3,'推送销售订单'),
('1436217732990242818',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217732939911170',1,NULL,3,'推送销售订单'),
('1436217733065740289',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217733023797250',1,NULL,3,'推送销售订单'),
('1436217733132849154',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217733090906113',1,NULL,3,'推送销售订单'),
('1436217733199958018',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217733162209281',1,NULL,3,'推送销售订单'),
('1436217733275455489',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217733225123841',1,NULL,3,'推送销售订单'),
('1436217733397090306',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217733313204225',1,NULL,3,'推送销售订单'),
('1436217733506142210',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217733443227650',1,NULL,3,'推送销售订单'),
('1436217733610999810',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217733556473858',1,NULL,3,'推送销售订单'),
('1436217733682302977',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217733636165633',1,NULL,3,'推送销售订单'),
('1436217733770383361',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217733724246018',1,NULL,3,'推送销售订单'),
('1436217733833297921',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217733795549186',1,NULL,3,'推送销售订单'),
('1436217734038818818',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217733925572610',1,NULL,3,'推送销售订单'),
('1436217734181425153',0,'成功','2021-09-10 14:39:26','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217734076567554',1,NULL,3,'推送销售订单'),
('1436217939534548994',0,'成功','2021-09-10 14:40:15','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436217939488411650',1,NULL,4,'推送生产订单'),
('1436217987110539265',0,'成功','2021-09-10 14:40:26','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217987064401922',1,NULL,3,'推送销售订单'),
('1436217987198619649',0,'成功','2021-09-10 14:40:26','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217987127316482',1,NULL,3,'推送销售订单'),
('1436217987265728514',0,'成功','2021-09-10 14:40:26','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217987215396866',1,NULL,3,'推送销售订单'),
('1436217987337031681',0,'成功','2021-09-10 14:40:26','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217987282505729',1,NULL,3,'推送销售订单'),
('1436217987408334850',0,'成功','2021-09-10 14:40:26','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217987358003202',1,NULL,3,'推送销售订单'),
('1436217987483832321',0,'成功','2021-09-10 14:40:27','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217987425112065',1,NULL,3,'推送销售订单'),
('1436217987550941185',0,'成功','2021-09-10 14:40:27','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217987504803842',1,NULL,3,'推送销售订单'),
('1436217987618050049',0,'成功','2021-09-10 14:40:27','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436217987567718401',1,NULL,3,'推送销售订单'),
('1436217987680964610',0,'成功','2021-09-10 14:40:27','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217987634827266',1,NULL,3,'推送销售订单'),
('1436217987760656385',0,'成功','2021-09-10 14:40:27','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217987701936129',1,NULL,3,'推送销售订单'),
('1436217987819376642',0,'成功','2021-09-10 14:40:27','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217987777433602',1,NULL,3,'推送销售订单'),
('1436217987873902594',0,'成功','2021-09-10 14:40:27','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217987836153857',1,NULL,3,'推送销售订单'),
('1436217987941011457',0,'成功','2021-09-10 14:40:27','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217987899068418',1,NULL,3,'推送销售订单'),
('1436217988003926017',0,'成功','2021-09-10 14:40:27','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217987966177282',1,NULL,3,'推送销售订单'),
('1436217988062646273',0,'成功','2021-09-10 14:40:27','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217988024897538',1,NULL,3,'推送销售订单'),
('1436217988117172226',0,'成功','2021-09-10 14:40:27','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217988075229185',1,NULL,3,'推送销售订单'),
('1436217988180086785',0,'成功','2021-09-10 14:40:27','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217988138143746',1,NULL,3,'推送销售订单'),
('1436217988255584258',0,'成功','2021-09-10 14:40:27','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217988205252609',1,NULL,3,'推送销售订单'),
('1436217988322693121',0,'成功','2021-09-10 14:40:27','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217988276555777',1,NULL,3,'推送销售订单'),
('1436217988377219074',0,'成功','2021-09-10 14:40:27','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217988339470337',1,NULL,3,'推送销售订单'),
('1436217988440133633',0,'成功','2021-09-10 14:40:27','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436217988393996289',1,NULL,3,'推送销售订单'),
('1436218192295890946',0,'成功','2021-09-10 14:41:15','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436218192128118785',1,NULL,4,'推送生产订单'),
('1436218241264390146',0,'成功','2021-09-10 14:41:27','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218241188892673',1,NULL,3,'推送销售订单'),
('1436218241398607873',0,'成功','2021-09-10 14:41:27','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218241318916098',1,NULL,3,'推送销售订单'),
('1436218241474105346',0,'成功','2021-09-10 14:41:27','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218241419579393',1,NULL,3,'推送销售订单'),
('1436218241566380034',0,'成功','2021-09-10 14:41:27','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218241507659778',1,NULL,3,'推送销售订单'),
('1436218241654460418',0,'成功','2021-09-10 14:41:27','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218241604128770',1,NULL,3,'推送销售订单'),
('1436218241805455362',0,'成功','2021-09-10 14:41:27','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218241717374978',1,NULL,3,'推送销售订单'),
('1436218241914507265',0,'成功','2021-09-10 14:41:27','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218241868369921',1,NULL,3,'推送销售订单'),
('1436218242023559169',0,'成功','2021-09-10 14:41:27','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218241964838913',1,NULL,3,'推送销售订单'),
('1436218242145193986',0,'成功','2021-09-10 14:41:27','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218242073890817',1,NULL,3,'推送销售订单'),
('1436218242262634497',0,'成功','2021-09-10 14:41:27','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218242195525633',1,NULL,3,'推送销售订单'),
('1436218242354909186',0,'成功','2021-09-10 14:41:27','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218242291994625',1,NULL,3,'推送销售订单'),
('1436218242501709825',0,'成功','2021-09-10 14:41:27','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218242396852226',1,NULL,3,'推送销售订单'),
('1436218245567746050',0,'成功','2021-09-10 14:41:28','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218242589790210',1,NULL,3,'推送销售订单'),
('1436218245731323906',0,'成功','2021-09-10 14:41:28','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218245643243521',1,NULL,3,'推送销售订单'),
('1436218245823598593',0,'成功','2021-09-10 14:41:28','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218245781655553',1,NULL,3,'推送销售订单'),
('1436218245928456194',0,'成功','2021-09-10 14:41:28','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218245857153026',1,NULL,3,'推送销售订单'),
('1436218246167531522',0,'成功','2021-09-10 14:41:28','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218246037508097',1,NULL,3,'推送销售订单'),
('1436218246314332162',0,'成功','2021-09-10 14:41:28','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218246217863169',1,NULL,3,'推送销售订单'),
('1436218246423384066',0,'成功','2021-09-10 14:41:28','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218246356275202',1,NULL,3,'推送销售订单'),
('1436218246540824577',0,'成功','2021-09-10 14:41:28','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218246465327106',1,NULL,3,'推送销售订单'),
('1436218246675042306',0,'成功','2021-09-10 14:41:28','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218246637293570',1,NULL,3,'推送销售订单'),
('1436218246775705602',0,'成功','2021-09-10 14:41:28','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218246712791041',1,NULL,3,'推送销售订单'),
('1436218445023678466',0,'成功','2021-09-10 14:42:16','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436218444939792385',1,NULL,4,'推送生产订单'),
('1436218499792900098',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218499721596930',1,NULL,3,'推送销售订单'),
('1436218499893563393',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218499839037442',1,NULL,3,'推送销售订单'),
('1436218500002615298',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218499943895041',1,NULL,3,'推送销售订单'),
('1436218500103278593',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218500052946945',1,NULL,3,'推送销售订单'),
('1436218500229107713',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218500153610242',1,NULL,3,'推送销售订单'),
('1436218500447211521',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218500338159617',1,NULL,3,'推送销售订单'),
('1436218500577234946',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218500535291905',1,NULL,3,'推送销售订单'),
('1436218500707258369',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218500619177985',1,NULL,3,'推送销售订单'),
('1436218500891807745',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218500774367233',1,NULL,3,'推送销售订单'),
('1436218501051191298',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218500946333697',1,NULL,3,'推送销售订单'),
('1436218501151854594',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218501088940034',1,NULL,3,'推送销售订单'),
('1436218501265100801',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218501206380545',1,NULL,3,'推送销售订单'),
('1436218501411901441',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218501353181185',1,NULL,3,'推送销售订单'),
('1436218501512564738',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218501445455873',1,NULL,3,'推送销售订单'),
('1436218501625810945',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218501554507778',1,NULL,3,'推送销售订单'),
('1436218501755834370',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218501680336897',1,NULL,3,'推送销售订单'),
('1436218501911023617',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218501810360322',1,NULL,3,'推送销售订单'),
('1436218502028464129',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218501957160962',1,NULL,3,'推送销售订单'),
('1436218502162681857',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218502074601474',1,NULL,3,'推送销售订单'),
('1436218502292705281',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218502217207809',1,NULL,3,'推送销售订单'),
('1436218502426923010',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218502355619842',1,NULL,3,'推送销售订单'),
('1436218502527586306',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218502468866050',1,NULL,3,'推送销售订单'),
('1436218502670192642',0,'成功','2021-09-10 14:42:29','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218502586306561',1,NULL,3,'推送销售订单'),
('1436218697726300162',0,'成功','2021-09-10 14:43:16','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436218697663385601',1,NULL,4,'推送生产订单'),
('1436218755871936513',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218755746107393',1,NULL,3,'推送销售订单'),
('1436218756056485890',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218755934851074',1,NULL,3,'推送销售订单'),
('1436218756236840962',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218756111011841',1,NULL,3,'推送销售订单'),
('1436218756438167553',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218756295561217',1,NULL,3,'推送销售订单'),
('1436218756710797313',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218756551413762',1,NULL,3,'推送销售订单'),
('1436218756874375169',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218756786294786',1,NULL,3,'推送销售订单'),
('1436218756983427074',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218756916318210',1,NULL,3,'推送销售订单'),
('1436218757046341633',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436218757004398594',1,NULL,3,'推送销售订单'),
('1436218757121839106',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218757079896066',1,NULL,3,'推送销售订单'),
('1436218757247668225',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218757155393537',1,NULL,3,'推送销售订单'),
('1436218757356720129',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218757302194178',1,NULL,3,'推送销售订单'),
('1436218757490937858',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218757423828994',1,NULL,3,'推送销售订单'),
('1436218757620961281',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218757570629634',1,NULL,3,'推送销售订单'),
('1436218757738401794',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218757688070145',1,NULL,3,'推送销售订单'),
('1436218757826482177',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218757771956226',1,NULL,3,'推送销售订单'),
('1436218757960699905',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218757885202433',1,NULL,3,'推送销售订单'),
('1436218758094917634',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218758019420162',1,NULL,3,'推送销售订单'),
('1436218758208163842',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218758141054978',1,NULL,3,'推送销售订单'),
('1436218758359158785',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218758271078401',1,NULL,3,'推送销售订单'),
('1436218758556291073',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218758455627778',1,NULL,3,'推送销售订单'),
('1436218758703091714',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218758627594242',1,NULL,3,'推送销售订单'),
('1436218758862475265',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218758786977794',1,NULL,3,'推送销售订单'),
('1436218759143493633',0,'成功','2021-09-10 14:43:30','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218759013470210',1,NULL,3,'推送销售订单'),
('1436218759332237313',0,'成功','2021-09-10 14:43:31','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436218759227379713',1,NULL,3,'推送销售订单'),
('1436218950386978817',0,'成功','2021-09-10 14:44:16','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436218950256955394',1,NULL,4,'推送生产订单'),
('1436219012244574210',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219012169076737',1,NULL,3,'推送销售订单'),
('1436219012366209025',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219012290711554',1,NULL,3,'推送销售订单'),
('1436219012454289409',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219012395569154',1,NULL,3,'推送销售订单'),
('1436219012538175490',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219012492038145',1,NULL,3,'推送销售订单'),
('1436219012609478657',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219012563341314',1,NULL,3,'推送销售订单'),
('1436219012664004610',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219012622061569',1,NULL,3,'推送销售订单'),
('1436219012731113473',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219012689170434',1,NULL,3,'推送销售订单'),
('1436219012810805249',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219012756279297',1,NULL,3,'推送销售订单'),
('1436219012877914113',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219012831776769',1,NULL,3,'推送销售订单'),
('1436219012949217281',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219012907274242',1,NULL,3,'推送销售订单'),
('1436219013037297666',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219012991160322',1,NULL,3,'推送销售订单'),
('1436219013112795137',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219013070852097',1,NULL,3,'推送销售订单'),
('1436219013196681217',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219013137960961',1,NULL,3,'推送销售订单'),
('1436219013280567298',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219013238624257',1,NULL,3,'推送销售订单'),
('1436219013368647681',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219013305733121',1,NULL,3,'推送销售订单'),
('1436219013435756546',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219013389619202',1,NULL,3,'推送销售订单'),
('1436219013519642625',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219013465116673',1,NULL,3,'推送销售订单'),
('1436219013603528705',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219013549002753',1,NULL,3,'推送销售订单'),
('1436219013662248961',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219013620305922',1,NULL,3,'推送销售订单'),
('1436219013712580609',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219013674831873',1,NULL,3,'推送销售订单'),
('1436219013771300866',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219013733552130',1,NULL,3,'推送销售订单'),
('1436219013825826817',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219013783883777',1,NULL,3,'推送销售订单'),
('1436219013888741378',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219013850992641',1,NULL,3,'推送销售订单'),
('1436219013943267329',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219013909712898',1,NULL,3,'推送销售订单'),
('1436219014052319233',0,'成功','2021-09-10 14:44:31','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219013981016065',1,NULL,3,'推送销售订单'),
('1436219203068628993',0,'成功','2021-09-10 14:45:16','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436219203026685954',1,NULL,4,'推送生产订单'),
('1436219266843021314',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219266805272577',1,NULL,3,'推送销售订单'),
('1436219266905935873',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219266859798530',1,NULL,3,'推送销售订单'),
('1436219266977239042',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219266926907394',1,NULL,3,'推送销售订单'),
('1436219267040153601',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219267002404865',1,NULL,3,'推送销售订单'),
('1436219267111456769',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219267061125121',1,NULL,3,'推送销售订单'),
('1436219267165982722',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219267124039682',1,NULL,3,'推送销售订单'),
('1436219267224702978',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219267186954241',1,NULL,3,'推送销售订单'),
('1436219267296006146',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219267245674498',1,NULL,3,'推送销售订单'),
('1436219267346337794',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219267312783362',1,NULL,3,'推送销售订单'),
('1436219267442806786',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219267371503617',1,NULL,3,'推送销售订单'),
('1436219267514109954',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219267472166913',1,NULL,3,'推送销售订单'),
('1436219267572830209',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219267535081473',1,NULL,3,'推送销售订单'),
('1436219267635744770',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219267597996034',1,NULL,3,'推送销售订单'),
('1436219267702853633',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219267656716290',1,NULL,3,'推送销售订单'),
('1436219267790934017',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219267748990978',1,NULL,3,'推送销售订单'),
('1436219267849654274',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219267811905538',1,NULL,3,'推送销售订单'),
('1436219267912568833',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219267870625794',1,NULL,3,'推送销售订单'),
('1436219267971289090',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219267929346049',1,NULL,3,'推送销售订单'),
('1436219268059369473',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219268009037825',1,NULL,3,'推送销售订单'),
('1436219268113895425',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219268071952386',1,NULL,3,'推送销售订单'),
('1436219268181004289',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219268139061250',1,NULL,3,'推送销售订单'),
('1436219268248113154',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219268201975810',1,NULL,3,'推送销售订单'),
('1436219268315222018',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219268277473281',1,NULL,3,'推送销售订单'),
('1436219268373942273',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219268336193537',1,NULL,3,'推送销售订单'),
('1436219268432662529',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219268390719490',1,NULL,3,'推送销售订单'),
('1436219268499771394',0,'成功','2021-09-10 14:45:32','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219268462022658',1,NULL,3,'推送销售订单'),
('1436219455553146882',0,'成功','2021-09-10 14:46:17','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436219455515398145',1,NULL,4,'推送生产订单'),
('1436219521324027905',0,'成功','2021-09-10 14:46:32','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219521277890561',1,NULL,3,'推送销售订单'),
('1436219521391136769',0,'成功','2021-09-10 14:46:32','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219521349193730',1,NULL,3,'推送销售订单'),
('1436219521458245634',0,'成功','2021-09-10 14:46:32','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219521412108290',1,NULL,3,'推送销售订单'),
('1436219521525354497',0,'成功','2021-09-10 14:46:32','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219521479217154',1,NULL,3,'推送销售订单'),
('1436219521596657665',0,'成功','2021-09-10 14:46:32','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219521546326018',1,NULL,3,'推送销售订单'),
('1436219521663766529',0,'成功','2021-09-10 14:46:32','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219521621823490',1,NULL,3,'推送销售订单'),
('1436219521756041217',0,'成功','2021-09-10 14:46:32','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219521684738049',1,NULL,3,'推送销售订单'),
('1436219521835732994',0,'成功','2021-09-10 14:46:32','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219521781207041',1,NULL,3,'推送销售订单'),
('1436219521911230466',0,'成功','2021-09-10 14:46:32','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219521860898818',1,NULL,3,'推送销售订单'),
('1436219522003505153',0,'成功','2021-09-10 14:46:32','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219521944784897',1,NULL,3,'推送销售订单'),
('1436219522079002625',0,'成功','2021-09-10 14:46:32','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219522032865282',1,NULL,3,'推送销售订单'),
('1436219522167083010',0,'成功','2021-09-10 14:46:32','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219522104168449',1,NULL,3,'推送销售订单'),
('1436219522276134913',0,'成功','2021-09-10 14:46:32','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219522229997570',1,NULL,3,'推送销售订单'),
('1436219522343243777',0,'成功','2021-09-10 14:46:32','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219522305495042',1,NULL,3,'推送销售订单'),
('1436219522456489985',0,'成功','2021-09-10 14:46:32','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219522385186818',1,NULL,3,'推送销售订单'),
('1436219522544570370',0,'成功','2021-09-10 14:46:33','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219522490044417',1,NULL,3,'推送销售订单'),
('1436219522632650754',0,'成功','2021-09-10 14:46:33','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219522582319105',1,NULL,3,'推送销售订单'),
('1436219522716536833',0,'成功','2021-09-10 14:46:33','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219522666205185',1,NULL,3,'推送销售订单'),
('1436219522804617217',0,'成功','2021-09-10 14:46:33','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219522750091266',1,NULL,3,'推送销售订单'),
('1436219522909474817',0,'成功','2021-09-10 14:46:33','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219522842365953',1,NULL,3,'推送销售订单'),
('1436219522984972289',0,'成功','2021-09-10 14:46:33','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219522938834945',1,NULL,3,'推送销售订单'),
('1436219523156938753',0,'成功','2021-09-10 14:46:33','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219523014332417',1,NULL,3,'推送销售订单'),
('1436219523341488129',0,'成功','2021-09-10 14:46:33','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219523245019137',1,NULL,3,'推送销售订单'),
('1436219523488288769',0,'成功','2021-09-10 14:46:33','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219523391819778',1,NULL,3,'推送销售订单'),
('1436219523672838146',0,'成功','2021-09-10 14:46:33','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219523555397634',1,NULL,3,'推送销售订单'),
('1436219523802861570',0,'成功','2021-09-10 14:46:33','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219523723169793',1,NULL,3,'推送销售订单'),
('1436219523878359041',0,'成功','2021-09-10 14:46:33','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219523832221697',1,NULL,3,'推送销售订单'),
('1436219708142522370',0,'成功','2021-09-10 14:47:17','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436219708087996417',1,NULL,4,'推送生产订单'),
('1436219776643895297',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219776597757953',1,NULL,3,'推送销售订单'),
('1436219776702615553',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219776660672513',1,NULL,3,'推送销售订单'),
('1436219776769724418',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219776723587073',1,NULL,3,'推送销售订单'),
('1436219776853610498',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219776803278850',1,NULL,3,'推送销售订单'),
('1436219776937496577',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219776882970625',1,NULL,3,'推送销售订单'),
('1436219777042354177',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219776983633921',1,NULL,3,'推送销售订单'),
('1436219777151406081',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219777080102914',1,NULL,3,'推送销售订单'),
('1436219777247875074',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436219777201737730',1,NULL,3,'推送销售订单'),
('1436219777331761154',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219777277235202',1,NULL,3,'推送销售订单'),
('1436219777415647234',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219777365315585',1,NULL,3,'推送销售订单'),
('1436219777491144705',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219777449201666',1,NULL,3,'推送销售订单'),
('1436219777587613697',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219777533087746',1,NULL,3,'推送销售订单'),
('1436219777692471297',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219777642139649',1,NULL,3,'推送销售订单'),
('1436219777814106113',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219777742802946',1,NULL,3,'推送销售订单'),
('1436219777889603586',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219777843466241',1,NULL,3,'推送销售订单'),
('1436219777956712449',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219777910575106',1,NULL,3,'推送销售订单'),
('1436219778019627010',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219777977683970',1,NULL,3,'推送销售订单'),
('1436219778111901697',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219778048987138',1,NULL,3,'推送销售订单'),
('1436219778170621953',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219778132873218',1,NULL,3,'推送销售订单'),
('1436219778267090945',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219778199982081',1,NULL,3,'推送销售订单'),
('1436219778334199809',0,'成功','2021-09-10 14:47:33','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219778296451074',1,NULL,3,'推送销售订单'),
('1436219778401308673',0,'成功','2021-09-10 14:47:34','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219778355171329',1,NULL,3,'推送销售订单'),
('1436219778481000450',0,'成功','2021-09-10 14:47:34','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219778422280194',1,NULL,3,'推送销售订单'),
('1436219778548109314',0,'成功','2021-09-10 14:47:34','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219778506166273',1,NULL,3,'推送销售订单'),
('1436219778615218178',0,'成功','2021-09-10 14:47:34','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219778573275138',1,NULL,3,'推送销售订单'),
('1436219778736852994',0,'成功','2021-09-10 14:47:34','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219778640384002',1,NULL,3,'推送销售订单'),
('1436219778808156162',0,'成功','2021-09-10 14:47:34','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219778762018818',1,NULL,3,'推送销售订单'),
('1436219778896236546',0,'成功','2021-09-10 14:47:34','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436219778837516289',1,NULL,3,'推送销售订单'),
('1436219961369432066',0,'成功','2021-09-10 14:48:17','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436219961256185857',1,NULL,4,'推送生产订单'),
('1436220031783407617',0,'成功','2021-09-10 14:48:34','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220031703715841',1,NULL,3,'推送销售订单'),
('1436220032228003842',0,'成功','2021-09-10 14:48:34','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220031959568386',1,NULL,3,'推送销售订单'),
('1436220032727126017',0,'成功','2021-09-10 14:48:34','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220032458690562',1,NULL,3,'推送销售订单'),
('1436220032957812737',0,'成功','2021-09-10 14:48:34','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220032865538049',1,NULL,3,'推送销售订单'),
('1436220033071058945',0,'成功','2021-09-10 14:48:34','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220033003950082',1,NULL,3,'推送销售订单'),
('1436220033297551361',0,'成功','2021-09-10 14:48:34','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220033175916546',1,NULL,3,'推送销售订单'),
('1436220033427574785',0,'成功','2021-09-10 14:48:34','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220033339494402',1,NULL,3,'推送销售订单'),
('1436220033612124162',0,'成功','2021-09-10 14:48:34','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220033528238081',1,NULL,3,'推送销售订单'),
('1436220033775702018',0,'成功','2021-09-10 14:48:34','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220033658261506',1,NULL,3,'推送销售订单'),
('1436220034035748866',0,'成功','2021-09-10 14:48:34','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220033834422274',1,NULL,3,'推送销售订单'),
('1436220034304184322',0,'成功','2021-09-10 14:48:35','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220034161577985',1,NULL,3,'推送销售订单'),
('1436220034484539393',0,'成功','2021-09-10 14:48:35','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220034375487489',1,NULL,3,'推送销售订单'),
('1436220038649483266',0,'成功','2021-09-10 14:48:36','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220034539065345',1,NULL,3,'推送销售订单'),
('1436220038842421250',0,'成功','2021-09-10 14:48:36','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220038737563649',1,NULL,3,'推送销售订单'),
('1436220039068913665',0,'成功','2021-09-10 14:48:36','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220038938890242',1,NULL,3,'推送销售订单'),
('1436220039282823169',0,'成功','2021-09-10 14:48:36','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220039190548482',1,NULL,3,'推送销售订单'),
('1436220039475761154',0,'成功','2021-09-10 14:48:36','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220039349932034',1,NULL,3,'推送销售订单'),
('1436220039660310530',0,'成功','2021-09-10 14:48:36','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220039530287106',1,NULL,3,'推送销售订单'),
('1436220039878414337',0,'成功','2021-09-10 14:48:36','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220039719030785',1,NULL,3,'推送销售订单'),
('1436220040075546625',0,'成功','2021-09-10 14:48:36','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220039945523202',1,NULL,3,'推送销售订单'),
('1436220040281067522',0,'成功','2021-09-10 14:48:36','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220040159432706',1,NULL,3,'推送销售订单'),
('1436220040453033985',0,'成功','2021-09-10 14:48:36','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220040323010562',1,NULL,3,'推送销售订单'),
('1436220040666943490',0,'成功','2021-09-10 14:48:36','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220040583057409',1,NULL,3,'推送销售订单'),
('1436220040780189698',0,'成功','2021-09-10 14:48:36','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220040713080834',1,NULL,3,'推送销售订单'),
('1436220040964739073',0,'成功','2021-09-10 14:48:36','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220040834715649',1,NULL,3,'推送销售订单'),
('1436220041094762498',0,'成功','2021-09-10 14:48:36','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220041027653633',1,NULL,3,'推送销售订单'),
('1436220041749073921',0,'成功','2021-09-10 14:48:36','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220041153482754',1,NULL,3,'推送销售订单'),
('1436220042441134081',0,'成功','2021-09-10 14:48:36','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220042277556226',1,NULL,3,'推送销售订单'),
('1436220042650849281',0,'成功','2021-09-10 14:48:37','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220042520825857',1,NULL,3,'推送销售订单'),
('1436220214227243010',0,'成功','2021-09-10 14:49:17','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436220214063665154',1,NULL,4,'推送生产订单'),
('1436220295689015298',0,'成功','2021-09-10 14:49:37','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220295567380482',1,NULL,3,'推送销售订单'),
('1436220295814844418',0,'成功','2021-09-10 14:49:37','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220295743541249',1,NULL,3,'推送销售订单'),
('1436220295957450753',0,'成功','2021-09-10 14:49:37','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220295860981761',1,NULL,3,'推送销售订单'),
('1436220296095862786',0,'成功','2021-09-10 14:49:37','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220295999393793',1,NULL,3,'推送销售订单'),
('1436220296406241281',0,'成功','2021-09-10 14:49:37','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220296150388738',1,NULL,3,'推送销售订单'),
('1436220296934723585',0,'成功','2021-09-10 14:49:37','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220296548847618',1,NULL,3,'推送销售订单'),
('1436220297261879297',0,'成功','2021-09-10 14:49:37','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220297022803970',1,NULL,3,'推送销售订单'),
('1436220297538703362',0,'成功','2021-09-10 14:49:37','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220297358348290',1,NULL,3,'推送销售订单'),
('1436220297823916033',0,'成功','2021-09-10 14:49:37','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220297622589442',1,NULL,3,'推送销售订单'),
('1436220298121711617',0,'成功','2021-09-10 14:49:37','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220297920385025',1,NULL,3,'推送销售订单'),
('1436220298427895809',0,'成功','2021-09-10 14:49:37','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220298251735041',1,NULL,3,'推送销售订单'),
('1436220298633416705',0,'成功','2021-09-10 14:49:38','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220298532753409',1,NULL,3,'推送销售订单'),
('1436220298784411650',0,'成功','2021-09-10 14:49:38','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220298696331265',1,NULL,3,'推送销售订单'),
('1436220298947989505',0,'成功','2021-09-10 14:49:38','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220298838937601',1,NULL,3,'推送销售订单'),
('1436220299115761666',0,'成功','2021-09-10 14:49:38','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220299006709761',1,NULL,3,'推送销售订单'),
('1436220299220619266',0,'成功','2021-09-10 14:49:38','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220299174481921',1,NULL,3,'推送销售订单'),
('1436220299333865473',0,'成功','2021-09-10 14:49:38','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220299275145218',1,NULL,3,'推送销售订单'),
('1436220302219546626',0,'成功','2021-09-10 14:49:38','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220302093717505',1,NULL,3,'推送销售订单'),
('1436220302517342209',0,'成功','2021-09-10 14:49:38','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220302425067522',1,NULL,3,'推送销售订单'),
('1436220302693502977',0,'成功','2021-09-10 14:49:39','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220302592839681',1,NULL,3,'推送销售订单'),
('1436220302861275137',0,'成功','2021-09-10 14:49:39','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220302756417538',1,NULL,3,'推送销售订单'),
('1436220303024852993',0,'成功','2021-09-10 14:49:39','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220302924189698',1,NULL,3,'推送销售订单'),
('1436220303217790978',0,'成功','2021-09-10 14:49:39','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220303133904897',1,NULL,3,'推送销售订单'),
('1436220303335231489',0,'成功','2021-09-10 14:49:39','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220303268122625',1,NULL,3,'推送销售订单'),
('1436220303440089090',0,'成功','2021-09-10 14:49:39','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220303381368833',1,NULL,3,'推送销售订单'),
('1436220303544946689',0,'成功','2021-09-10 14:49:39','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220303486226434',1,NULL,3,'推送销售订单'),
('1436220303695941633',0,'成功','2021-09-10 14:49:39','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220303637221378',1,NULL,3,'推送销售订单'),
('1436220303784022018',0,'成功','2021-09-10 14:49:39','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220303725301761',1,NULL,3,'推送销售订单'),
('1436220303922434050',0,'成功','2021-09-10 14:49:39','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220303846936578',1,NULL,3,'推送销售订单'),
('1436220304065040385',0,'成功','2021-09-10 14:49:39','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220304006320129',1,NULL,3,'推送销售订单'),
('1436220468477562881',0,'成功','2021-09-10 14:50:18','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436220468364316674',1,NULL,4,'推送生产订单'),
('1436220557073846273',0,'成功','2021-09-10 14:50:39','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220556985765889',1,NULL,3,'推送销售订单'),
('1436220557241618433',0,'成功','2021-09-10 14:50:39','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220557115789313',1,NULL,3,'推送销售订单'),
('1436220557363253249',0,'成功','2021-09-10 14:50:39','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220557300338689',1,NULL,3,'推送销售订单'),
('1436220557459722241',0,'成功','2021-09-10 14:50:39','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220557421973506',1,NULL,3,'推送销售订单'),
('1436220557543608322',0,'成功','2021-09-10 14:50:39','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220557501665282',1,NULL,3,'推送销售订单'),
('1436220557623300097',0,'成功','2021-09-10 14:50:39','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220557585551362',1,NULL,3,'推送销售订单'),
('1436220557736546305',0,'成功','2021-09-10 14:50:39','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220557698797569',1,NULL,3,'推送销售订单'),
('1436220557833015298',0,'成功','2021-09-10 14:50:39','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220557778489345',1,NULL,3,'推送销售订单'),
('1436220557904318465',0,'成功','2021-09-10 14:50:39','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220557858181121',1,NULL,3,'推送销售订单'),
('1436220558185336834',0,'成功','2021-09-10 14:50:39','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220557929484290',1,NULL,3,'推送销售订单'),
('1436220558273417218',0,'成功','2021-09-10 14:50:39','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220558218891265',1,NULL,3,'推送销售订单'),
('1436220558336331778',0,'成功','2021-09-10 14:50:39','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220558298583041',1,NULL,3,'推送销售订单'),
('1436220558399246337',0,'成功','2021-09-10 14:50:39','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220558353108994',1,NULL,3,'推送销售订单'),
('1436220558474743810',0,'成功','2021-09-10 14:50:39','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220558424412161',1,NULL,3,'推送销售订单'),
('1436220558550241282',0,'成功','2021-09-10 14:50:40','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220558504103938',1,NULL,3,'推送销售订单'),
('1436220558617350146',0,'成功','2021-09-10 14:50:40','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220558575407105',1,NULL,3,'推送销售订单'),
('1436220558692847617',0,'成功','2021-09-10 14:50:40','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220558642515969',1,NULL,3,'推送销售订单'),
('1436220558772539394',0,'成功','2021-09-10 14:50:40','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220558718013442',1,NULL,3,'推送销售订单'),
('1436220558848036866',0,'成功','2021-09-10 14:50:40','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220558797705217',1,NULL,3,'推送销售订单'),
('1436220558919340033',0,'成功','2021-09-10 14:50:40','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220558869008386',1,NULL,3,'推送销售订单'),
('1436220558994837505',0,'成功','2021-09-10 14:50:40','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220558952894466',1,NULL,3,'推送销售订单'),
('1436220559057752066',0,'成功','2021-09-10 14:50:40','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220559015809026',1,NULL,3,'推送销售订单'),
('1436220559116472321',0,'成功','2021-09-10 14:50:40','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220559078723585',1,NULL,3,'推送销售订单'),
('1436220559170998274',0,'成功','2021-09-10 14:50:40','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220559133249537',1,NULL,3,'推送销售订单'),
('1436220559233912834',0,'成功','2021-09-10 14:50:40','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220559191969793',1,NULL,3,'推送销售订单'),
('1436220559301021698',0,'成功','2021-09-10 14:50:40','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220559259078657',1,NULL,3,'推送销售订单'),
('1436220559368130561',0,'成功','2021-09-10 14:50:40','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220559326187522',1,NULL,3,'推送销售订单'),
('1436220559447822337',0,'成功','2021-09-10 14:50:40','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220559389102081',1,NULL,3,'推送销售订单'),
('1436220559699480578',0,'成功','2021-09-10 14:50:40','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220559535902721',1,NULL,3,'推送销售订单'),
('1436220560060190722',0,'成功','2021-09-10 14:50:40','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220559804338178',1,NULL,3,'推送销售订单'),
('1436220560198602754',0,'成功','2021-09-10 14:50:40','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220560152465410',1,NULL,3,'推送销售订单'),
('1436220721134047233',0,'成功','2021-09-10 14:51:18','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436220721024995330',1,NULL,4,'推送生产订单'),
('1436220813048025089',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220812989304833',1,NULL,3,'推送销售订单'),
('1436220813152882690',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220813073190914',1,NULL,3,'推送销售订单'),
('1436220813228380161',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220813173854210',1,NULL,3,'推送销售订单'),
('1436220813404540930',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220813366792193',1,NULL,3,'推送销售订单'),
('1436220813463261185',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220813425512449',1,NULL,3,'推送销售订单'),
('1436220813517787138',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220813480038402',1,NULL,3,'推送销售订单'),
('1436220813572313090',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220813530370050',1,NULL,3,'推送销售订单'),
('1436220813626839042',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436220813589090305',1,NULL,3,'推送销售订单'),
('1436220813681364994',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220813643616257',1,NULL,3,'推送销售订单'),
('1436220813740085249',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220813698142209',1,NULL,3,'推送销售订单'),
('1436220813798805505',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220813756862465',1,NULL,3,'推送销售订单'),
('1436220813849137154',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220813815582721',1,NULL,3,'推送销售订单'),
('1436220813907857410',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220813865914369',1,NULL,3,'推送销售订单'),
('1436220813962383361',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220813920440322',1,NULL,3,'推送销售订单'),
('1436220814021103618',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220813979160578',1,NULL,3,'推送销售订单'),
('1436220814071435266',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220814033686530',1,NULL,3,'推送销售订单'),
('1436220814134349825',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220814088212481',1,NULL,3,'推送销售订单'),
('1436220814197264386',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220814159515649',1,NULL,3,'推送销售订单'),
('1436220814251790337',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220814214041601',1,NULL,3,'推送销售订单'),
('1436220814302121986',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220814268567554',1,NULL,3,'推送销售订单'),
('1436220814373425153',0,'成功','2021-09-10 14:51:40','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220814318899202',1,NULL,3,'推送销售订单'),
('1436220814436339714',0,'成功','2021-09-10 14:51:41','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220814390202369',1,NULL,3,'推送销售订单'),
('1436220814495059969',0,'成功','2021-09-10 14:51:41','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220814453116930',1,NULL,3,'推送销售订单'),
('1436220814557974530',0,'成功','2021-09-10 14:51:41','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220814520225793',1,NULL,3,'推送销售订单'),
('1436220814654443521',0,'成功','2021-09-10 14:51:41','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220814574751746',1,NULL,3,'推送销售订单'),
('1436220814763495425',0,'成功','2021-09-10 14:51:41','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220814683803649',1,NULL,3,'推送销售订单'),
('1436220814876741633',0,'成功','2021-09-10 14:51:41','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220814797049858',1,NULL,3,'推送销售订单'),
('1436220814989987841',0,'成功','2021-09-10 14:51:41','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220814914490369',1,NULL,3,'推送销售订单'),
('1436220815078068225',0,'成功','2021-09-10 14:51:41','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220815023542273',1,NULL,3,'推送销售订单'),
('1436220815140982786',0,'成功','2021-09-10 14:51:41','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220815099039745',1,NULL,3,'推送销售订单'),
('1436220815216480257',0,'成功','2021-09-10 14:51:41','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220815170342913',1,NULL,3,'推送销售订单'),
('1436220815296172034',0,'成功','2021-09-10 14:51:41','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436220815245840386',1,NULL,3,'推送销售订单'),
('1436220974922993665',0,'成功','2021-09-10 14:52:19','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436220974801358850',1,NULL,4,'推送生产订单'),
('1436221068342726658',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221068288200705',1,NULL,3,'推送销售订单'),
('1436221068623745025',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221068510498817',1,NULL,3,'推送销售订单'),
('1436221068690853890',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221068653105153',1,NULL,3,'推送销售订单'),
('1436221068783128578',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221068716019714',1,NULL,3,'推送销售订单'),
('1436221068837654530',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221068808294402',1,NULL,3,'推送销售订单'),
('1436221068896374785',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221068854431745',1,NULL,3,'推送销售订单'),
('1436221068967677953',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221068925734913',1,NULL,3,'推送销售订单'),
('1436221069030592514',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221068984455170',1,NULL,3,'推送销售订单'),
('1436221069089312769',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221069043175426',1,NULL,3,'推送销售订单'),
('1436221069156421634',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221069114478594',1,NULL,3,'推送销售订单'),
('1436221069227724802',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221069169004545',1,NULL,3,'推送销售订单'),
('1436221069340971009',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221069294833665',1,NULL,3,'推送销售订单'),
('1436221069408079873',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221069370331138',1,NULL,3,'推送销售订单'),
('1436221069475188737',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221069429051393',1,NULL,3,'推送销售订单'),
('1436221069542297601',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221069500354562',1,NULL,3,'推送销售订单'),
('1436221069609406465',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221069567463425',1,NULL,3,'推送销售订单'),
('1436221069663932418',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221069626183682',1,NULL,3,'推送销售订单'),
('1436221069722652674',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221069689098241',1,NULL,3,'推送销售订单'),
('1436221069777178625',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221069743624194',1,NULL,3,'推送销售订单'),
('1436221069831704578',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221069793955842',1,NULL,3,'推送销售订单'),
('1436221069890424833',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221069852676098',1,NULL,3,'推送销售订单'),
('1436221069944950785',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221069903007746',1,NULL,3,'推送销售订单'),
('1436221070012059649',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221069961728001',1,NULL,3,'推送销售订单'),
('1436221070104334338',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221070049808386',1,NULL,3,'推送销售订单'),
('1436221070175637506',0,'成功','2021-09-10 14:52:41','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221070133694465',1,NULL,3,'推送销售订单'),
('1436221070276300801',0,'成功','2021-09-10 14:52:42','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221070209191938',1,NULL,3,'推送销售订单'),
('1436221070351798273',0,'成功','2021-09-10 14:52:42','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221070305660930',1,NULL,3,'推送销售订单'),
('1436221070410518529',0,'成功','2021-09-10 14:52:42','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221070372769793',1,NULL,3,'推送销售订单'),
('1436221070465044482',0,'成功','2021-09-10 14:52:42','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221070427295746',1,NULL,3,'推送销售订单'),
('1436221070519570434',0,'成功','2021-09-10 14:52:42','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221070481821698',1,NULL,3,'推送销售订单'),
('1436221070569902081',0,'成功','2021-09-10 14:52:42','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221070536347650',1,NULL,3,'推送销售订单'),
('1436221070645399554',0,'成功','2021-09-10 14:52:42','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221070599262209',1,NULL,3,'推送销售订单'),
('1436221070712508418',0,'成功','2021-09-10 14:52:42','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221070666371074',1,NULL,3,'推送销售订单'),
('1436221227462037506',0,'成功','2021-09-10 14:53:19','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436221227403317249',1,NULL,4,'推送生产订单'),
('1436221323683565570',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221323629039617',1,NULL,3,'推送销售订单'),
('1436221323801006081',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221323729702913',1,NULL,3,'推送销售订单'),
('1436221323880697858',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221323834560514',1,NULL,3,'推送销售订单'),
('1436221323956195329',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221323914252289',1,NULL,3,'推送销售订单'),
('1436221324023304194',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221323972972545',1,NULL,3,'推送销售订单'),
('1436221324090413058',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221324052664321',1,NULL,3,'推送销售订单'),
('1436221324149133314',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221324107190274',1,NULL,3,'推送销售订单'),
('1436221324237213697',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221324195270657',1,NULL,3,'推送销售订单'),
('1436221324312711169',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221324266573826',1,NULL,3,'推送销售订单'),
('1436221324400791553',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221324350459906',1,NULL,3,'推送销售订单'),
('1436221324484677633',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221324438540290',1,NULL,3,'推送销售订单'),
('1436221324551786497',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221324505649154',1,NULL,3,'推送销售订单'),
('1436221324635672577',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221324576952321',1,NULL,3,'推送销售订单'),
('1436221324711170050',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221324665032706',1,NULL,3,'推送销售订单'),
('1436221324786667522',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221324740530177',1,NULL,3,'推送销售订单'),
('1436221324849582082',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221324807639041',1,NULL,3,'推送销售订单'),
('1436221324920885250',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221324878942210',1,NULL,3,'推送销售订单'),
('1436221324987994113',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221324941856769',1,NULL,3,'推送销售订单'),
('1436221325130600450',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221325084463106',1,NULL,3,'推送销售订单'),
('1436221325206097922',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221325159960578',1,NULL,3,'推送销售订单'),
('1436221325285789698',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221325239652354',1,NULL,3,'推送销售订单'),
('1436221325361287170',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221325315149825',1,NULL,3,'推送销售订单'),
('1436221325445173249',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221325390647298',1,NULL,3,'推送销售订单'),
('1436221325512282114',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221325466144769',1,NULL,3,'推送销售订单'),
('1436221325596168193',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221325545836546',1,NULL,3,'推送销售订单'),
('1436221325663277057',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221325617139713',1,NULL,3,'推送销售订单'),
('1436221325759746049',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221325705220097',1,NULL,3,'推送销售订单'),
('1436221325893963778',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221325822660610',1,NULL,3,'推送销售订单'),
('1436221326019792898',0,'成功','2021-09-10 14:53:42','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221325952684034',1,NULL,3,'推送销售订单'),
('1436221326145622017',0,'成功','2021-09-10 14:53:43','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221326049153026',1,NULL,3,'推送销售订单'),
('1436221326254673921',0,'成功','2021-09-10 14:53:43','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221326187565058',1,NULL,3,'推送销售订单'),
('1436221326359531522',0,'成功','2021-09-10 14:53:43','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221326296616961',1,NULL,3,'推送销售订单'),
('1436221326430834690',0,'成功','2021-09-10 14:53:43','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221326384697345',1,NULL,3,'推送销售订单'),
('1436221326493749250',0,'成功','2021-09-10 14:53:43','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221326451806210',1,NULL,3,'推送销售订单'),
('1436221480068190210',0,'成功','2021-09-10 14:54:19','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436221479996887041',1,NULL,4,'推送生产订单'),
('1436221579427057666',0,'成功','2021-09-10 14:54:43','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221579359948801',1,NULL,3,'推送销售订单'),
('1436221579561275393',0,'成功','2021-09-10 14:54:43','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221579510943746',1,NULL,3,'推送销售订单'),
('1436221579670327298',0,'成功','2021-09-10 14:54:43','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221579603218433',1,NULL,3,'推送销售订单'),
('1436221579833905154',0,'成功','2021-09-10 14:54:43','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221579770990593',1,NULL,3,'推送销售订单'),
('1436221579959734274',0,'成功','2021-09-10 14:54:43','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221579892625409',1,NULL,3,'推送销售订单'),
('1436221580161060866',0,'成功','2021-09-10 14:54:43','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221580102340609',1,NULL,3,'推送销售订单'),
('1436221580316250113',0,'成功','2021-09-10 14:54:43','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221580228169730',1,NULL,3,'推送销售订单'),
('1436221580437884930',0,'成功','2021-09-10 14:54:43','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221580353998849',1,NULL,3,'推送销售订单'),
('1436221580576296962',0,'成功','2021-09-10 14:54:43','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221580513382402',1,NULL,3,'推送销售订单'),
('1436221580723097602',0,'成功','2021-09-10 14:54:43','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221580672765953',1,NULL,3,'推送销售订单'),
('1436221580853121026',0,'成功','2021-09-10 14:54:43','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221580790206465',1,NULL,3,'推送销售订单'),
('1436221581297717249',0,'成功','2021-09-10 14:54:43','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221580911841282',1,NULL,3,'推送销售订单'),
('1436221581415157762',0,'成功','2021-09-10 14:54:43','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221581360631809',1,NULL,3,'推送销售订单'),
('1436221581545181185',0,'成功','2021-09-10 14:54:43','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221581478072321',1,NULL,3,'推送销售订单'),
('1436221581691981825',0,'成功','2021-09-10 14:54:43','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221581612290050',1,NULL,3,'推送销售订单'),
('1436221581952028673',0,'成功','2021-09-10 14:54:43','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221581780062209',1,NULL,3,'推送销售订单'),
('1436221582375653377',0,'成功','2021-09-10 14:54:44','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221582165938177',1,NULL,3,'推送销售订单'),
('1436221582665060353',0,'成功','2021-09-10 14:54:44','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221582539231234',1,NULL,3,'推送销售订单'),
('1436221582795083778',0,'成功','2021-09-10 14:54:44','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221582732169217',1,NULL,3,'推送销售订单'),
('1436221582904135681',0,'成功','2021-09-10 14:54:44','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221582849609729',1,NULL,3,'推送销售订单'),
('1436221582979633154',0,'成功','2021-09-10 14:54:44','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221582929301505',1,NULL,3,'推送销售订单'),
('1436221583113850882',0,'成功','2021-09-10 14:54:44','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221583034159106',1,NULL,3,'推送销售订单'),
('1436221583231291393',0,'成功','2021-09-10 14:54:44','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221583176765441',1,NULL,3,'推送销售订单'),
('1436221583319371778',0,'成功','2021-09-10 14:54:44','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221583260651521',1,NULL,3,'推送销售订单'),
('1436221583424229377',0,'成功','2021-09-10 14:54:44','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221583373897730',1,NULL,3,'推送销售订单'),
('1436221583575224321',0,'成功','2021-09-10 14:54:44','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221583524892673',1,NULL,3,'推送销售订单'),
('1436221583684276226',0,'成功','2021-09-10 14:54:44','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221583621361666',1,NULL,3,'推送销售订单'),
('1436221583810105345',0,'成功','2021-09-10 14:54:44','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221583751385090',1,NULL,3,'推送销售订单'),
('1436221583906574338',0,'成功','2021-09-10 14:54:44','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221583847854082',1,NULL,3,'推送销售订单'),
('1436221584019820546',0,'成功','2021-09-10 14:54:44','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221583944323074',1,NULL,3,'推送销售订单'),
('1436221584112095234',0,'成功','2021-09-10 14:54:44','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221584053374978',1,NULL,3,'推送销售订单'),
('1436221584212758530',0,'成功','2021-09-10 14:54:44','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221584154038274',1,NULL,3,'推送销售订单'),
('1436221584355364866',0,'成功','2021-09-10 14:54:44','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221584250507265',1,NULL,3,'推送销售订单'),
('1436221584472805378',0,'成功','2021-09-10 14:54:44','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221584422473729',1,NULL,3,'推送销售订单'),
('1436221584636383234',0,'成功','2021-09-10 14:54:44','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221584531525634',1,NULL,3,'推送销售订单'),
('1436221733001498626',0,'成功','2021-09-10 14:55:20','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436221732930195457',1,NULL,4,'推送生产订单'),
('1436221837880070145',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221837808766977',1,NULL,3,'推送销售订单'),
('1436221837997510658',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221837947179009',1,NULL,3,'推送销售订单'),
('1436221838194642945',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221838060425218',1,NULL,3,'推送销售订单'),
('1436221838421135362',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221838337249281',1,NULL,3,'推送销售订单'),
('1436221838567936001',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221838471467009',1,NULL,3,'推送销售订单'),
('1436221838651822081',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221838601490434',1,NULL,3,'推送销售订单'),
('1436221838739902466',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221838685376514',1,NULL,3,'推送销售订单'),
('1436221838815399937',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436221838773456897',1,NULL,3,'推送销售订单'),
('1436221838911868930',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221838857342977',1,NULL,3,'推送销售订单'),
('1436221838987366402',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221838949617665',1,NULL,3,'推送销售订单'),
('1436221839067058177',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221839020920834',1,NULL,3,'推送销售订单'),
('1436221839150944257',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221839109001217',1,NULL,3,'推送销售订单'),
('1436221839243218945',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221839197081602',1,NULL,3,'推送销售订单'),
('1436221839331299330',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221839280967681',1,NULL,3,'推送销售订单'),
('1436221839410991105',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221839369048066',1,NULL,3,'推送销售订单'),
('1436221839486488577',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221839440351234',1,NULL,3,'推送销售订单'),
('1436221839587151874',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221839528431618',1,NULL,3,'推送销售订单'),
('1436221839696203777',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221839629094913',1,NULL,3,'推送销售订单'),
('1436221839767506946',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221839725563905',1,NULL,3,'推送销售订单'),
('1436221839834615810',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221839796867074',1,NULL,3,'推送销售订单'),
('1436221839901724674',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221839855587330',1,NULL,3,'推送销售订单'),
('1436221839964639233',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221839926890498',1,NULL,3,'推送销售订单'),
('1436221840065302530',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221840006582274',1,NULL,3,'推送销售订单'),
('1436221840144994305',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221840094662658',1,NULL,3,'推送销售订单'),
('1436221840224686082',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221840182743041',1,NULL,3,'推送销售订单'),
('1436221840304377857',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221840262434817',1,NULL,3,'推送销售订单'),
('1436221840388263938',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221840350515202',1,NULL,3,'推送销售订单'),
('1436221840480538626',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221840434401282',1,NULL,3,'推送销售订单'),
('1436221840577007618',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221840535064577',1,NULL,3,'推送销售订单'),
('1436221840656699393',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221840610562050',1,NULL,3,'推送销售订单'),
('1436221840732196865',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221840686059521',1,NULL,3,'推送销售订单'),
('1436221840832860162',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221840782528514',1,NULL,3,'推送销售订单'),
('1436221840950300673',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221840895774721',1,NULL,3,'推送销售订单'),
('1436221841029992450',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221840992243713',1,NULL,3,'推送销售订单'),
('1436221841113878529',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221841067741185',1,NULL,3,'推送销售订单'),
('1436221841197764610',0,'成功','2021-09-10 14:55:45','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436221841147432962',1,NULL,3,'推送销售订单'),
('1436221985754451969',0,'成功','2021-09-10 14:56:20','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436221985699926018',1,NULL,4,'推送生产订单'),
('1436222094047186946',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222093992660993',1,NULL,3,'推送销售订单'),
('1436222094118490114',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222094072352770',1,NULL,3,'推送销售订单'),
('1436222094185598977',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222094139461633',1,NULL,3,'推送销售订单'),
('1436222094252707842',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222094210764801',1,NULL,3,'推送销售订单'),
('1436222094386925569',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222094344982530',1,NULL,3,'推送销售订单'),
('1436222094462423041',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222094420480002',1,NULL,3,'推送销售订单'),
('1436222094525337602',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222094483394561',1,NULL,3,'推送销售订单'),
('1436222094584057858',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222094546309121',1,NULL,3,'推送销售订单'),
('1436222094642778114',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222094605029377',1,NULL,3,'推送销售订单'),
('1436222094693109762',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222094659555329',1,NULL,3,'推送销售订单'),
('1436222094756024321',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222094718275585',1,NULL,3,'推送销售订单'),
('1436222094818938881',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222094772801537',1,NULL,3,'推送销售订单'),
('1436222094894436354',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222094839910401',1,NULL,3,'推送销售订单'),
('1436222094974128130',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222094940573697',1,NULL,3,'推送销售订单'),
('1436222095045431297',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222095007682561',1,NULL,3,'推送销售订单'),
('1436222095334838274',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222095250952193',1,NULL,3,'推送销售订单'),
('1436222095456473090',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222095372587009',1,NULL,3,'推送销售订单'),
('1436222095578107906',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222095506804738',1,NULL,3,'推送销售订单'),
('1436222095687159809',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222095620050946',1,NULL,3,'推送销售订单'),
('1436222095812988929',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222095729102850',1,NULL,3,'推送销售订单'),
('1436222095884292097',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222095842349058',1,NULL,3,'推送销售订单'),
('1436222095963983873',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222095909457922',1,NULL,3,'推送销售订单'),
('1436222096064647169',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222096005926914',1,NULL,3,'推送销售订单'),
('1436222096207253505',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222096140144642',1,NULL,3,'推送销售订单'),
('1436222096307916802',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222096265973761',1,NULL,3,'推送销售订单'),
('1436222096429551618',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222096362442753',1,NULL,3,'推送销售订单'),
('1436222096492466178',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222096458911745',1,NULL,3,'推送销售订单'),
('1436222096555380737',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222096517632001',1,NULL,3,'推送销售订单'),
('1436222096626683905',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222096584740865',1,NULL,3,'推送销售订单'),
('1436222096689598465',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222096647655425',1,NULL,3,'推送销售订单'),
('1436222096802844673',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222096739930114',1,NULL,3,'推送销售订单'),
('1436222096869953538',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222096823816193',1,NULL,3,'推送销售订单'),
('1436222096941256705',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222096895119361',1,NULL,3,'推送销售订单'),
('1436222097029337089',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222096983199746',1,NULL,3,'推送销售订单'),
('1436222097109028866',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222097062891522',1,NULL,3,'推送销售订单'),
('1436222097171943426',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222097134194689',1,NULL,3,'推送销售订单'),
('1436222097234857985',0,'成功','2021-09-10 14:56:46','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222097197109249',1,NULL,3,'推送销售订单'),
('1436222238234775554',0,'成功','2021-09-10 14:57:20','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436222238192832513',1,NULL,4,'推送生产订单'),
('1436222351501955074',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222351447429121',1,NULL,3,'推送销售订单'),
('1436222351556481025',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222351518732290',1,NULL,3,'推送销售订单'),
('1436222351606812674',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222351573258242',1,NULL,3,'推送销售订单'),
('1436222351661338625',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222351623589890',1,NULL,3,'推送销售订单'),
('1436222351715864577',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222351682310145',1,NULL,3,'推送销售订单'),
('1436222351774584833',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222351732641793',1,NULL,3,'推送销售订单'),
('1436222351833305089',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222351787167745',1,NULL,3,'推送销售订单'),
('1436222351896219649',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222351850082305',1,NULL,3,'推送销售订单'),
('1436222351950745601',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222351917191169',1,NULL,3,'推送销售订单'),
('1436222352005271554',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222351967522817',1,NULL,3,'推送销售订单'),
('1436222352063991809',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222352022048770',1,NULL,3,'推送销售订单'),
('1436222352139489282',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222352097546242',1,NULL,3,'推送销售订单'),
('1436222352210792449',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222352164655106',1,NULL,3,'推送销售订单'),
('1436222352269512705',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222352231763969',1,NULL,3,'推送销售订单'),
('1436222352319844354',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222352286289921',1,NULL,3,'推送销售订单'),
('1436222352374370305',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222352336621570',1,NULL,3,'推送销售订单'),
('1436222352428896257',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222352391147522',1,NULL,3,'推送销售订单'),
('1436222352483422210',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222352445673473',1,NULL,3,'推送销售订单'),
('1436222352533753857',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222352496005121',1,NULL,3,'推送销售订单'),
('1436222352588279810',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222352550531073',1,NULL,3,'推送销售订单'),
('1436222352638611458',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222352600862721',1,NULL,3,'推送销售订单'),
('1436222352697331713',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222352659582977',1,NULL,3,'推送销售订单'),
('1436222352751857665',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222352722497538',1,NULL,3,'推送销售订单'),
('1436222352810577921',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222352768634882',1,NULL,3,'推送销售订单'),
('1436222352928018434',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222352869298178',1,NULL,3,'推送销售订单'),
('1436222353494249474',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222353452306433',1,NULL,3,'推送销售订单'),
('1436222353565552641',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222353519415297',1,NULL,3,'推送销售订单'),
('1436222353653633026',0,'成功','2021-09-10 14:57:47','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222353599107073',1,NULL,3,'推送销售订单'),
('1436222353724936193',0,'成功','2021-09-10 14:57:48','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222353691381762',1,NULL,3,'推送销售订单'),
('1436222353796239361',0,'成功','2021-09-10 14:57:48','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222353745907713',1,NULL,3,'推送销售订单'),
('1436222353871736834',0,'成功','2021-09-10 14:57:48','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222353817210882',1,NULL,3,'推送销售订单'),
('1436222353943040001',0,'成功','2021-09-10 14:57:48','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222353892708353',1,NULL,3,'推送销售订单'),
('1436222354001760258',0,'成功','2021-09-10 14:57:48','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222353964011521',1,NULL,3,'推送销售订单'),
('1436222354056286210',0,'成功','2021-09-10 14:57:48','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222354018537473',1,NULL,3,'推送销售订单'),
('1436222354110812161',0,'成功','2021-09-10 14:57:48','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222354073063426',1,NULL,3,'推送销售订单'),
('1436222354182115330',0,'成功','2021-09-10 14:57:48','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222354131783681',1,NULL,3,'推送销售订单'),
('1436222354270195714',0,'成功','2021-09-10 14:57:48','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222354228252673',1,NULL,3,'推送销售订单'),
('1436222354333110273',0,'成功','2021-09-10 14:57:48','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222354291167233',1,NULL,3,'推送销售订单'),
('1436222491860144129',0,'成功','2021-09-10 14:58:20','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436222491814006785',1,NULL,4,'推送生产订单'),
('1436222608239497218',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222608201748482',1,NULL,3,'推送销售订单'),
('1436222608294023169',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222608260468738',1,NULL,3,'推送销售订单'),
('1436222608348549121',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222608310800385',1,NULL,3,'推送销售订单'),
('1436222608398880769',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222608361132034',1,NULL,3,'推送销售订单'),
('1436222608524709890',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222608445018113',1,NULL,3,'推送销售订单'),
('1436222608625373186',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222608549875713',1,NULL,3,'推送销售订单'),
('1436222608692482050',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222608658927617',1,NULL,3,'推送销售订单'),
('1436222608742813698',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222608709259265',1,NULL,3,'推送销售订单'),
('1436222608793145346',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222608759590914',1,NULL,3,'推送销售订单'),
('1436222608843476993',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222608805728257',1,NULL,3,'推送销售订单'),
('1436222608889614338',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222608856059906',1,NULL,3,'推送销售订单'),
('1436222608939945985',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222608902197249',1,NULL,3,'推送销售订单'),
('1436222608986083330',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222608952528897',1,NULL,3,'推送销售订单'),
('1436222609103523841',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222609002860546',1,NULL,3,'推送销售订单'),
('1436222609162244097',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222609124495361',1,NULL,3,'推送销售订单'),
('1436222609212575745',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222609183215618',1,NULL,3,'推送销售订单'),
('1436222609258713090',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222609225158657',1,NULL,3,'推送销售订单'),
('1436222609309044737',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222609275490306',1,NULL,3,'推送销售订单'),
('1436222609359376385',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222609325821953',1,NULL,3,'推送销售订单'),
('1436222609405513730',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222609371959298',1,NULL,3,'推送销售订单'),
('1436222609455845377',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222609422290945',1,NULL,3,'推送销售订单'),
('1436222609506177025',0,'成功','2021-09-10 14:58:48','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222609472622594',1,NULL,3,'推送销售订单'),
('1436222609560702978',0,'成功','2021-09-10 14:58:49','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222609522954241',1,NULL,3,'推送销售订单'),
('1436222609611034625',0,'成功','2021-09-10 14:58:49','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222609573285889',1,NULL,3,'推送销售订单'),
('1436222609678143490',0,'成功','2021-09-10 14:58:49','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222609636200449',1,NULL,3,'推送销售订单'),
('1436222609741058050',0,'成功','2021-09-10 14:58:49','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222609707503617',1,NULL,3,'推送销售订单'),
('1436222609791389698',0,'成功','2021-09-10 14:58:49','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222609757835265',1,NULL,3,'推送销售订单'),
('1436222609837527042',0,'成功','2021-09-10 14:58:49','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222609803972610',1,NULL,3,'推送销售订单'),
('1436222609887858690',0,'成功','2021-09-10 14:58:49','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222609854304257',1,NULL,3,'推送销售订单'),
('1436222609942384642',0,'成功','2021-09-10 14:58:49','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222609904635906',1,NULL,3,'推送销售订单'),
('1436222609992716289',0,'成功','2021-09-10 14:58:49','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222609954967553',1,NULL,3,'推送销售订单'),
('1436222610059825154',0,'成功','2021-09-10 14:58:49','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222610013687810',1,NULL,3,'推送销售订单'),
('1436222610114351105',0,'成功','2021-09-10 14:58:49','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222610076602370',1,NULL,3,'推送销售订单'),
('1436222610164682754',0,'成功','2021-09-10 14:58:49','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222610126934017',1,NULL,3,'推送销售订单'),
('1436222610219208705',0,'成功','2021-09-10 14:58:49','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222610181459969',1,NULL,3,'推送销售订单'),
('1436222610269540354',0,'成功','2021-09-10 14:58:49','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222610235985921',1,NULL,3,'推送销售订单'),
('1436222610319872001',0,'成功','2021-09-10 14:58:49','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222610282123265',1,NULL,3,'推送销售订单'),
('1436222610370203650',0,'成功','2021-09-10 14:58:49','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222610332454913',1,NULL,3,'推送销售订单'),
('1436222610600890369',0,'成功','2021-09-10 14:58:49','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222610563141634',1,NULL,3,'推送销售订单'),
('1436222744520822785',0,'成功','2021-09-10 14:59:21','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436222744483074050',1,NULL,4,'推送生产订单'),
('1436222863429341186',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222863383203841',1,NULL,3,'推送销售订单'),
('1436222863488061442',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222863446118402',1,NULL,3,'推送销售订单'),
('1436222863550976002',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222863504838657',1,NULL,3,'推送销售订单'),
('1436222863601307649',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222863567753217',1,NULL,3,'推送销售订单'),
('1436222863655833601',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222863618084865',1,NULL,3,'推送销售订单'),
('1436222863710359554',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222863672610817',1,NULL,3,'推送销售订单'),
('1436222863756496897',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222863722942466',1,NULL,3,'推送销售订单'),
('1436222863806828545',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436222863769079809',1,NULL,3,'推送销售订单'),
('1436222863857160193',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222863823605761',1,NULL,3,'推送销售订单'),
('1436222863907491841',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222863873937410',1,NULL,3,'推送销售订单'),
('1436222864213676033',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222863928463361',1,NULL,3,'推送销售订单'),
('1436222864280784898',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222864234647554',1,NULL,3,'推送销售订单'),
('1436222864343699457',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222864297562114',1,NULL,3,'推送销售订单'),
('1436222864402419713',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222864364670978',1,NULL,3,'推送销售订单'),
('1436222864452751361',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222864419196930',1,NULL,3,'推送销售订单'),
('1436222864503083010',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222864469528577',1,NULL,3,'推送销售订单'),
('1436222864557608961',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222864519860225',1,NULL,3,'推送销售订单'),
('1436222864607940609',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222864574386177',1,NULL,3,'推送销售订单'),
('1436222864658272257',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222864624717826',1,NULL,3,'推送销售订单'),
('1436222864708603905',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222864675049474',1,NULL,3,'推送销售订单'),
('1436222864767324161',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222864725381122',1,NULL,3,'推送销售订单'),
('1436222864817655809',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222864784101377',1,NULL,3,'推送销售订单'),
('1436222864872181761',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222864834433026',1,NULL,3,'推送销售订单'),
('1436222864926707713',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222864888958978',1,NULL,3,'推送销售订单'),
('1436222864972845058',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222864939290626',1,NULL,3,'推送销售订单'),
('1436222865018982402',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222864985427970',1,NULL,3,'推送销售订单'),
('1436222865069314050',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222865035759618',1,NULL,3,'推送销售订单'),
('1436222865123840002',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222865086091266',1,NULL,3,'推送销售订单'),
('1436222865178365953',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222865140617217',1,NULL,3,'推送销售订单'),
('1436222865228697602',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222865195143169',1,NULL,3,'推送销售订单'),
('1436222865283223553',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222865245474817',1,NULL,3,'推送销售订单'),
('1436222865375498242',0,'成功','2021-09-10 14:59:49','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222865295806465',1,NULL,3,'推送销售订单'),
('1436222865455190017',0,'成功','2021-09-10 14:59:50','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222865396469762',1,NULL,3,'推送销售订单'),
('1436222865526493186',0,'成功','2021-09-10 14:59:50','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222865476161537',1,NULL,3,'推送销售订单'),
('1436222865618767873',0,'成功','2021-09-10 14:59:50','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222865547464705',1,NULL,3,'推送销售订单'),
('1436222865681682433',0,'成功','2021-09-10 14:59:50','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222865635545090',1,NULL,3,'推送销售订单'),
('1436222865744596993',0,'成功','2021-09-10 14:59:50','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222865698459650',1,NULL,3,'推送销售订单'),
('1436222865799122946',0,'成功','2021-09-10 14:59:50','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222865757179906',1,NULL,3,'推送销售订单'),
('1436222865862037505',0,'成功','2021-09-10 14:59:50','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222865815900161',1,NULL,3,'推送销售订单'),
('1436222866231136258',0,'成功','2021-09-10 14:59:50','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436222866189193217',1,NULL,3,'推送销售订单'),
('1436222997584154625',0,'成功','2021-09-10 15:00:21','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436222997496074241',1,NULL,4,'推送生产订单'),
('1436223119000866818',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223118963118081',1,NULL,3,'推送销售订单'),
('1436223119059587073',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223119017644034',1,NULL,3,'推送销售订单'),
('1436223119109918721',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223119076364289',1,NULL,3,'推送销售订单'),
('1436223119156056065',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223119126695938',1,NULL,3,'推送销售订单'),
('1436223119206387713',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223119172833281',1,NULL,3,'推送销售订单'),
('1436223119252525057',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223119218970626',1,NULL,3,'推送销售订单'),
('1436223119302856706',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223119269302273',1,NULL,3,'推送销售订单'),
('1436223119353188354',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223119315439618',1,NULL,3,'推送销售订单'),
('1436223119487406082',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223119365771266',1,NULL,3,'推送销售订单'),
('1436223119541932034',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223119508377601',1,NULL,3,'推送销售订单'),
('1436223119592263682',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223119558709250',1,NULL,3,'推送销售订单'),
('1436223119642595330',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223119609040897',1,NULL,3,'推送销售订单'),
('1436223119688732673',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223119655178242',1,NULL,3,'推送销售订单'),
('1436223119743258625',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223119705509889',1,NULL,3,'推送销售订单'),
('1436223119797784577',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223119764230145',1,NULL,3,'推送销售订单'),
('1436223119848116225',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223119814561794',1,NULL,3,'推送销售订单'),
('1436223119902642178',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223119864893441',1,NULL,3,'推送销售订单'),
('1436223119973945346',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223119919419394',1,NULL,3,'推送销售订单'),
('1436223120028471298',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223119986528257',1,NULL,3,'推送销售订单'),
('1436223120082997250',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223120049442818',1,NULL,3,'推送销售订单'),
('1436223120141717505',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223120103968769',1,NULL,3,'推送销售订单'),
('1436223120196243458',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223120158494721',1,NULL,3,'推送销售订单'),
('1436223120254963714',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223120208826369',1,NULL,3,'推送销售订单'),
('1436223120317878274',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223120275935233',1,NULL,3,'推送销售订单'),
('1436223120380792834',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223120334655490',1,NULL,3,'推送销售订单'),
('1436223120456290305',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223120397570049',1,NULL,3,'推送销售订单'),
('1436223120506621953',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223120468873218',1,NULL,3,'推送销售订单'),
('1436223120561147905',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223120523399170',1,NULL,3,'推送销售订单'),
('1436223120619868161',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223120573730817',1,NULL,3,'推送销售订单'),
('1436223120670199810',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223120636645377',1,NULL,3,'推送销售订单'),
('1436223120724725761',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223120686977025',1,NULL,3,'推送销售订单'),
('1436223120775057410',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223120737308674',1,NULL,3,'推送销售订单'),
('1436223120825389058',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223120796028929',1,NULL,3,'推送销售订单'),
('1436223120875720706',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223120842166273',1,NULL,3,'推送销售订单'),
('1436223120926052353',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223120892497921',1,NULL,3,'推送销售订单'),
('1436223120976384002',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223120942829570',1,NULL,3,'推送销售订单'),
('1436223121026715650',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223120993161218',1,NULL,3,'推送销售订单'),
('1436223121081241601',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223121043492865',1,NULL,3,'推送销售订单'),
('1436223121131573249',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223121098018817',1,NULL,3,'推送销售订单'),
('1436223121186099202',0,'成功','2021-09-10 15:00:50','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223121152544769',1,NULL,3,'推送销售订单'),
('1436223121265790977',0,'成功','2021-09-10 15:00:51','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223121211265025',1,NULL,3,'推送销售订单'),
('1436223250240638978',0,'成功','2021-09-10 15:01:21','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436223250190307330',1,NULL,4,'推送生产订单'),
('1436223373989384194',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223373947441153',1,NULL,3,'推送销售订单'),
('1436223374056493058',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223374010355713',1,NULL,3,'推送销售订单'),
('1436223374157156353',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223374073270273',1,NULL,3,'推送销售订单'),
('1436223374211682305',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223374178127874',1,NULL,3,'推送销售订单'),
('1436223374262013954',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223374228459522',1,NULL,3,'推送销售订单'),
('1436223374316539906',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223374278791170',1,NULL,3,'推送销售订单'),
('1436223374366871554',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223374333317121',1,NULL,3,'推送销售订单'),
('1436223374417203201',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223374383648769',1,NULL,3,'推送销售订单'),
('1436223374471729153',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223374433980418',1,NULL,3,'推送销售订单'),
('1436223374522060802',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223374488506369',1,NULL,3,'推送销售订单'),
('1436223374572392450',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223374538838018',1,NULL,3,'推送销售订单'),
('1436223374626918401',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223374589169665',1,NULL,3,'推送销售订单'),
('1436223374677250050',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223374639501313',1,NULL,3,'推送销售订单'),
('1436223374727581697',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223374689832961',1,NULL,3,'推送销售订单'),
('1436223374773719041',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223374740164610',1,NULL,3,'推送销售订单'),
('1436223374824050690',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223374790496257',1,NULL,3,'推送销售订单'),
('1436223374874382338',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223374840827905',1,NULL,3,'推送销售订单'),
('1436223374928908289',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223374891159553',1,NULL,3,'推送销售订单'),
('1436223374996017153',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223374958268418',1,NULL,3,'推送销售订单'),
('1436223375050543105',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223375012794369',1,NULL,3,'推送销售订单'),
('1436223375113457666',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223375067320321',1,NULL,3,'推送销售订单'),
('1436223375167983617',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223375126040577',1,NULL,3,'推送销售订单'),
('1436223375222509569',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223375188955137',1,NULL,3,'推送销售订单'),
('1436223375272841217',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223375239286786',1,NULL,3,'推送销售订单'),
('1436223375327367170',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223375289618434',1,NULL,3,'推送销售订单'),
('1436223375386087426',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223375348338690',1,NULL,3,'推送销售订单'),
('1436223375436419073',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223375402864642',1,NULL,3,'推送销售订单'),
('1436223375495139329',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223375449001986',1,NULL,3,'推送销售订单'),
('1436223375545470978',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223375511916545',1,NULL,3,'推送销售订单'),
('1436223375595802626',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223375558053889',1,NULL,3,'推送销售订单'),
('1436223375675494401',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223375629357058',1,NULL,3,'推送销售订单'),
('1436223375730020353',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223375692271617',1,NULL,3,'推送销售订单'),
('1436223375780352002',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223375742603266',1,NULL,3,'推送销售订单'),
('1436223375834877953',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223375797129217',1,NULL,3,'推送销售订单'),
('1436223375893598209',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223375855849474',1,NULL,3,'推送销售订单'),
('1436223375948124162',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223375910375426',1,NULL,3,'推送销售订单'),
('1436223376086536194',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223376036204546',1,NULL,3,'推送销售订单'),
('1436223376149450754',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223376111702018',1,NULL,3,'推送销售订单'),
('1436223376203976706',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223376174616578',1,NULL,3,'推送销售订单'),
('1436223376258502657',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223376220753921',1,NULL,3,'推送销售订单'),
('1436223376321417217',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223376279474178',1,NULL,3,'推送销售订单'),
('1436223376375943169',0,'成功','2021-09-10 15:01:51','{\"fid\":\"192495\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:01:09\",\"sono\":\"SEORD130527\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223376338194433',1,NULL,3,'推送销售订单'),
('1436223502783877122',0,'成功','2021-09-10 15:02:21','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436223502733545473',1,NULL,4,'推送生产订单'),
('1436223629242142722',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223629175033857',1,NULL,3,'推送销售订单'),
('1436223629326028802',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223629279891458',1,NULL,3,'推送销售订单'),
('1436223629426692097',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223629380554754',1,NULL,3,'推送销售订单'),
('1436223629506383874',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223629460246530',1,NULL,3,'推送销售订单'),
('1436223629602852865',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223629556715522',1,NULL,3,'推送销售订单'),
('1436223629661573121',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223629619630082',1,NULL,3,'推送销售订单'),
('1436223629749653506',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223629707710466',1,NULL,3,'推送销售订单'),
('1436223629955174402',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223629799985153',1,NULL,3,'推送销售订单'),
('1436223630118752258',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223630022283266',1,NULL,3,'推送销售订单'),
('1436223630261358593',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223630148112386',1,NULL,3,'推送销售订单'),
('1436223630387187714',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223630324273153',1,NULL,3,'推送销售订单'),
('1436223630492045313',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223630412353538',1,NULL,3,'推送销售订单'),
('1436223630563348482',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223630517211137',1,NULL,3,'推送销售订单'),
('1436223630630457345',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223630584320002',1,NULL,3,'推送销售订单'),
('1436223630697566209',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223630647234561',1,NULL,3,'推送销售订单'),
('1436223630760480769',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223630714343425',1,NULL,3,'推送销售订单'),
('1436223630831783938',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223630789840897',1,NULL,3,'推送销售订单'),
('1436223630890504194',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223630852755457',1,NULL,3,'推送销售订单'),
('1436223630991167490',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223630924058626',1,NULL,3,'推送销售订单'),
('1436223631075053570',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223631016333314',1,NULL,3,'推送销售订单'),
('1436223631150551042',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223631100219394',1,NULL,3,'推送销售订单'),
('1436223631234437122',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223631184105473',1,NULL,3,'推送销售订单'),
('1436223631351877633',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223631280574466',1,NULL,3,'推送销售订单'),
('1436223631456735233',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223631385432066',1,NULL,3,'推送销售订单'),
('1436223631553204225',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223631502872577',1,NULL,3,'推送销售订单'),
('1436223631632896001',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223631574175746',1,NULL,3,'推送销售订单'),
('1436223631695810562',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223631653867521',1,NULL,3,'推送销售订单'),
('1436223631758725121',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223631716782082',1,NULL,3,'推送销售订单'),
('1436223631813251074',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223631775502338',1,NULL,3,'推送销售订单'),
('1436223631884554241',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223631838416898',1,NULL,3,'推送销售订单'),
('1436223631960051713',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223631909720065',1,NULL,3,'推送销售订单'),
('1436223632027160578',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223631976828929',1,NULL,3,'推送销售订单'),
('1436223632085880834',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223632043937794',1,NULL,3,'推送销售订单'),
('1436223632140406785',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223632102658050',1,NULL,3,'推送销售订单'),
('1436223632199127041',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223632157184001',1,NULL,3,'推送销售订单'),
('1436223632291401730',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223632228487170',1,NULL,3,'推送销售订单'),
('1436223632354316289',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223632308178945',1,NULL,3,'推送销售订单'),
('1436223632429813762',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223632371093506',1,NULL,3,'推送销售订单'),
('1436223632488534017',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223632450785281',1,NULL,3,'推送销售订单'),
('1436223632559837186',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223632517894146',1,NULL,3,'推送销售订单'),
('1436223632618557442',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223632576614402',1,NULL,3,'推送销售订单'),
('1436223632673083393',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192495\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:01:09\",\"sono\":\"SEORD130527\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223632635334657',1,NULL,3,'推送销售订单'),
('1436223632731803649',0,'成功','2021-09-10 15:02:52','{\"fid\":\"192496\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:02:10\",\"sono\":\"SEORD130528\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223632689860610',1,NULL,3,'推送销售订单'),
('1436223755377446913',0,'成功','2021-09-10 15:03:22','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436223755314532353',1,NULL,4,'推送生产订单'),
('1436223885476368386',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223885434425345',1,NULL,3,'推送销售订单'),
('1436223885564448769',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223885505728514',1,NULL,3,'推送销售订单'),
('1436223885635751937',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223885589614594',1,NULL,3,'推送销售订单'),
('1436223885715443714',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223885673500673',1,NULL,3,'推送销售订单'),
('1436223885795135490',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223885753192450',1,NULL,3,'推送销售订单'),
('1436223885862244353',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223885816107010',1,NULL,3,'推送销售订单'),
('1436223885946130433',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223885904187394',1,NULL,3,'推送销售订单'),
('1436223886030016514',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436223885971296258',1,NULL,3,'推送销售订单'),
('1436223886097125378',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223886059376642',1,NULL,3,'推送销售订单'),
('1436223886172622849',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223886130679809',1,NULL,3,'推送销售订单'),
('1436223886239731714',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223886193594370',1,NULL,3,'推送销售订单'),
('1436223886311034881',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223886269091841',1,NULL,3,'推送销售订单'),
('1436223886378143745',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223886340395009',1,NULL,3,'推送销售订单'),
('1436223886462029826',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223886407503873',1,NULL,3,'推送销售订单'),
('1436223886550110210',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223886499778562',1,NULL,3,'推送销售订单'),
('1436223886633996290',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223886587858945',1,NULL,3,'推送销售订单'),
('1436223886713688066',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223886663356418',1,NULL,3,'推送销售订单'),
('1436223886852100097',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223886755631105',1,NULL,3,'推送销售订单'),
('1436223886965346306',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223886877265922',1,NULL,3,'推送销售订单'),
('1436223887057620993',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223887003095042',1,NULL,3,'推送销售订单'),
('1436223887393165313',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223887183450114',1,NULL,3,'推送销售订单'),
('1436223887623852034',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223887518994434',1,NULL,3,'推送销售订单'),
('1436223887829372929',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223887728709634',1,NULL,3,'推送销售订单'),
('1436223887913259009',0,'成功','2021-09-10 15:03:53','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223887854538754',1,NULL,3,'推送销售订单'),
('1436223889934913537',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223887942619138',1,NULL,3,'推送销售订单'),
('1436223890056548354',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223889989439490',1,NULL,3,'推送销售订单'),
('1436223890173988866',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223890102685698',1,NULL,3,'推送销售订单'),
('1436223890278846466',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223890224320513',1,NULL,3,'推送销售订单'),
('1436223890362732546',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223890312400897',1,NULL,3,'推送销售订单'),
('1436223890480173057',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223890421452801',1,NULL,3,'推送销售订单'),
('1436223890589224962',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223890517921793',1,NULL,3,'推送销售订单'),
('1436223890685693954',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223890631168001',1,NULL,3,'推送销售订单'),
('1436223890769580034',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223890710859778',1,NULL,3,'推送销售订单'),
('1436223890899603457',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223890819911682',1,NULL,3,'推送销售订单'),
('1436223891021238274',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223890928963586',1,NULL,3,'推送销售订单'),
('1436223891134484481',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223891063181314',1,NULL,3,'推送销售订单'),
('1436223891239342082',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223891180621826',1,NULL,3,'推送销售订单'),
('1436223891390337026',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223891277090818',1,NULL,3,'推送销售订单'),
('1436223891532943362',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223891440668673',1,NULL,3,'推送销售订单'),
('1436223891608440834',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223891566497793',1,NULL,3,'推送销售订单'),
('1436223891692326913',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223891633606658',1,NULL,3,'推送销售订单'),
('1436223891759435777',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192495\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:01:09\",\"sono\":\"SEORD130527\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223891717492738',1,NULL,3,'推送销售订单'),
('1436223891826544641',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192496\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:02:10\",\"sono\":\"SEORD130528\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223891784601601',1,NULL,3,'推送销售订单'),
('1436223891889459202',0,'成功','2021-09-10 15:03:54','{\"fid\":\"192497\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:03:11\",\"sono\":\"SEORD130529\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436223891843321858',1,NULL,3,'推送销售订单'),
('1436224008352698370',0,'成功','2021-09-10 15:04:22','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436224008306561026',1,NULL,4,'推送生产订单'),
('1436224144868904962',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224144797601794',1,NULL,3,'推送销售订单'),
('1436224145028288513',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224144965373954',1,NULL,3,'推送销售订单'),
('1436224145154117633',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224145066037250',1,NULL,3,'推送销售订单'),
('1436224145250586626',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224145187672065',1,NULL,3,'推送销售订单'),
('1436224145351249922',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224145284141058',1,NULL,3,'推送销售订单'),
('1436224145435136002',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224145397387266',1,NULL,3,'推送销售订单'),
('1436224145519022082',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224145472884738',1,NULL,3,'推送销售订单'),
('1436224145594519553',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224145552576513',1,NULL,3,'推送销售订单'),
('1436224145665822722',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224145619685377',1,NULL,3,'推送销售订单'),
('1436224145758097409',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224145707765762',1,NULL,3,'推送销售订单'),
('1436224145879732226',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224145795846146',1,NULL,3,'推送销售订单'),
('1436224145963618305',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224145913286657',1,NULL,3,'推送销售订单'),
('1436224146043310081',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224145997172738',1,NULL,3,'推送销售订单'),
('1436224146123001857',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224146081058817',1,NULL,3,'推送销售订单'),
('1436224146202693634',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224146160750593',1,NULL,3,'推送销售订单'),
('1436224146273996801',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224146223665153',1,NULL,3,'推送销售订单'),
('1436224146374660098',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224146320134145',1,NULL,3,'推送销售订单'),
('1436224146441768962',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224146395631617',1,NULL,3,'推送销售订单'),
('1436224146513072129',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224146471129089',1,NULL,3,'推送销售订单'),
('1436224146617929729',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224146542432258',1,NULL,3,'推送销售订单'),
('1436224146685038594',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224146647289858',1,NULL,3,'推送销售订单'),
('1436224146764730369',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224146722787329',1,NULL,3,'推送销售订单'),
('1436224146844422146',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224146798284801',1,NULL,3,'推送销售订单'),
('1436224146911531010',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224146873782274',1,NULL,3,'推送销售订单'),
('1436224147008000002',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224146936696834',1,NULL,3,'推送销售订单'),
('1436224147079303170',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224147033165825',1,NULL,3,'推送销售订单'),
('1436224147146412033',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224147100274690',1,NULL,3,'推送销售订单'),
('1436224147213520898',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224147175772162',1,NULL,3,'推送销售订单'),
('1436224147322572802',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224147251269633',1,NULL,3,'推送销售订单'),
('1436224147406458881',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224147351932929',1,NULL,3,'推送销售订单'),
('1436224147473567746',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224147427430402',1,NULL,3,'推送销售订单'),
('1436224147603591169',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224147507122178',1,NULL,3,'推送销售订单'),
('1436224147683282945',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224147641339905',1,NULL,3,'推送销售订单'),
('1436224147767169025',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224147725225985',1,NULL,3,'推送销售订单'),
('1436224147876220930',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224147813306369',1,NULL,3,'推送销售订单'),
('1436224147968495617',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224147913969665',1,NULL,3,'推送销售订单'),
('1436224148085936129',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224148027215873',1,NULL,3,'推送销售订单'),
('1436224148148850689',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224148106907649',1,NULL,3,'推送销售订单'),
('1436224148215959554',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224148169822210',1,NULL,3,'推送销售订单'),
('1436224148274679810',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224148236931074',1,NULL,3,'推送销售订单'),
('1436224148333400065',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224148291457026',1,NULL,3,'推送销售订单'),
('1436224148387926017',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192495\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:01:09\",\"sono\":\"SEORD130527\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224148350177281',1,NULL,3,'推送销售订单'),
('1436224148459229186',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192496\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:02:10\",\"sono\":\"SEORD130528\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224148413091842',1,NULL,3,'推送销售订单'),
('1436224148522143746',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192497\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:03:11\",\"sono\":\"SEORD130529\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224148480200706',1,NULL,3,'推送销售订单'),
('1436224148576669698',0,'成功','2021-09-10 15:04:55','{\"fid\":\"192498\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:04:12\",\"sono\":\"SEORD130530\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224148538920962',1,NULL,3,'推送销售订单'),
('1436224260908519425',0,'成功','2021-09-10 15:05:22','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436224260862382081',1,NULL,4,'推送生产订单'),
('1436224401958768641',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224401900048385',1,NULL,3,'推送销售订单'),
('1436224402055237634',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224401996517378',1,NULL,3,'推送销售订单'),
('1436224402134929410',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224402080403457',1,NULL,3,'推送销售订单'),
('1436224402210426882',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224402155900930',1,NULL,3,'推送销售订单'),
('1436224402294312961',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224402239787010',1,NULL,3,'推送销售订单'),
('1436224402357227522',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224402323673089',1,NULL,3,'推送销售订单'),
('1436224402441113602',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224402386587650',1,NULL,3,'推送销售订单'),
('1436224402524999681',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224402483056642',1,NULL,3,'推送销售订单'),
('1436224402608885762',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224402562748418',1,NULL,3,'推送销售订单'),
('1436224402764075010',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224402638245890',1,NULL,3,'推送销售订单'),
('1436224402835378178',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224402793435137',1,NULL,3,'推送销售订单'),
('1436224402927652866',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224402860544002',1,NULL,3,'推送销售订单'),
('1436224403019927553',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224402965401602',1,NULL,3,'推送销售订单'),
('1436224403116396546',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224403045093377',1,NULL,3,'推送销售订单'),
('1436224403200282625',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224403145756674',1,NULL,3,'推送销售订单'),
('1436224403401609217',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224403300945921',1,NULL,3,'推送销售订单'),
('1436224403594547202',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224403506466817',1,NULL,3,'推送销售订单'),
('1436224403812651010',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224403636490242',1,NULL,3,'推送销售订单'),
('1436224403904925698',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224403858788353',1,NULL,3,'推送销售订单'),
('1436224403972034562',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224403925897218',1,NULL,3,'推送销售订单'),
('1436224404034949121',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224403988811777',1,NULL,3,'推送销售订单'),
('1436224404097863681',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224404055920642',1,NULL,3,'推送销售订单'),
('1436224404215304193',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224404169166850',1,NULL,3,'推送销售订单'),
('1436224404282413057',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224404236275713',1,NULL,3,'推送销售订单'),
('1436224404345327617',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224404299190273',1,NULL,3,'推送销售订单'),
('1436224404500516865',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224404429213698',1,NULL,3,'推送销售订单'),
('1436224404601180162',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224404546654210',1,NULL,3,'推送销售订单'),
('1436224404697649153',0,'成功','2021-09-10 15:05:56','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224404643123201',1,NULL,3,'推送销售订单'),
('1436224404781535233',0,'成功','2021-09-10 15:05:57','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224404714426370',1,NULL,3,'推送销售订单'),
('1436224404861227009',0,'成功','2021-09-10 15:05:57','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224404819283970',1,NULL,3,'推送销售订单'),
('1436224404924141570',0,'成功','2021-09-10 15:05:57','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224404886392833',1,NULL,3,'推送销售订单'),
('1436224404999639041',0,'成功','2021-09-10 15:05:57','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224404949307393',1,NULL,3,'推送销售订单'),
('1436224405108690945',0,'成功','2021-09-10 15:05:57','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224405037387778',1,NULL,3,'推送销售订单'),
('1436224405234520065',0,'成功','2021-09-10 15:05:57','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224405159022593',1,NULL,3,'推送销售订单'),
('1436224405326794754',0,'成功','2021-09-10 15:05:57','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224405272268802',1,NULL,3,'推送销售订单'),
('1436224405385515010',0,'成功','2021-09-10 15:05:57','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224405351960578',1,NULL,3,'推送销售订单'),
('1436224405440040961',0,'成功','2021-09-10 15:05:57','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224405406486530',1,NULL,3,'推送销售订单'),
('1436224405498761218',0,'成功','2021-09-10 15:05:57','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224405461012481',1,NULL,3,'推送销售订单'),
('1436224405557481474',0,'成功','2021-09-10 15:05:57','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224405523927041',1,NULL,3,'推送销售订单'),
('1436224405616201729',0,'成功','2021-09-10 15:05:57','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224405578452994',1,NULL,3,'推送销售订单'),
('1436224405670727681',0,'成功','2021-09-10 15:05:57','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224405632978945',1,NULL,3,'推送销售订单'),
('1436224405729447938',0,'成功','2021-09-10 15:05:57','{\"fid\":\"192495\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:01:09\",\"sono\":\"SEORD130527\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224405691699201',1,NULL,3,'推送销售订单'),
('1436224405788168193',0,'成功','2021-09-10 15:05:57','{\"fid\":\"192496\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:02:10\",\"sono\":\"SEORD130528\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224405750419458',1,NULL,3,'推送销售订单'),
('1436224405842694146',0,'成功','2021-09-10 15:05:57','{\"fid\":\"192497\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:03:11\",\"sono\":\"SEORD130529\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224405809139713',1,NULL,3,'推送销售订单'),
('1436224405897220098',0,'成功','2021-09-10 15:05:57','{\"fid\":\"192498\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:04:12\",\"sono\":\"SEORD130530\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224405867859969',1,NULL,3,'推送销售订单'),
('1436224405947551745',0,'成功','2021-09-10 15:05:57','{\"fid\":\"192499\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:05:13\",\"sono\":\"SEORD130531\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224405918191617',1,NULL,3,'推送销售订单'),
('1436224513476923393',0,'成功','2021-09-10 15:06:22','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436224513439174658',1,NULL,4,'推送生产订单'),
('1436224659031855106',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224658989912065',1,NULL,3,'推送销售订单'),
('1436224659098963970',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224659052826625',1,NULL,3,'推送销售订单'),
('1436224659157684226',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224659119935490',1,NULL,3,'推送销售订单'),
('1436224659212210177',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224659174461441',1,NULL,3,'推送销售订单'),
('1436224659266736130',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224659233181697',1,NULL,3,'推送销售订单'),
('1436224659346427905',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224659312873474',1,NULL,3,'推送销售订单'),
('1436224659400953857',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224659363205121',1,NULL,3,'推送销售订单'),
('1436224659459674114',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224659421925377',1,NULL,3,'推送销售订单'),
('1436224659526782978',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224659480645633',1,NULL,3,'推送销售订单'),
('1436224659610669057',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224659568726018',1,NULL,3,'推送销售订单'),
('1436224659669389313',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224659627446273',1,NULL,3,'推送销售订单'),
('1436224659728109569',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224659686166530',1,NULL,3,'推送销售订单'),
('1436224659791024129',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224659749081089',1,NULL,3,'推送销售订单'),
('1436224659845550081',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224659807801346',1,NULL,3,'推送销售订单'),
('1436224659908464641',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224659866521602',1,NULL,3,'推送销售订单'),
('1436224659971379201',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224659929436161',1,NULL,3,'推送销售订单'),
('1436224660034293761',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224659992350721',1,NULL,3,'推送销售订单'),
('1436224660097208321',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224660055265281',1,NULL,3,'推送销售订单'),
('1436224660160122881',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224660122374145',1,NULL,3,'推送销售订单'),
('1436224660218843138',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224660181094401',1,NULL,3,'推送销售订单'),
('1436224660277563394',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224660239814658',1,NULL,3,'推送销售订单'),
('1436224660332089345',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224660294340609',1,NULL,3,'推送销售订单'),
('1436224660386615298',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224660348866561',1,NULL,3,'推送销售订单'),
('1436224660449529857',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224660407586817',1,NULL,3,'推送销售订单'),
('1436224660508250113',0,'成功','2021-09-10 15:06:57','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224660466307074',1,NULL,3,'推送销售订单'),
('1436224660575358977',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224660537610242',1,NULL,3,'推送销售订单'),
('1436224660634079234',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224660592136194',1,NULL,3,'推送销售订单'),
('1436224660705382402',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224660659245057',1,NULL,3,'推送销售订单'),
('1436224660764102658',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224660726353922',1,NULL,3,'推送销售订单'),
('1436224660831211521',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224660780879874',1,NULL,3,'推送销售订单'),
('1436224660915097601',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224660852183041',1,NULL,3,'推送销售订单'),
('1436224660978012162',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224660936069122',1,NULL,3,'推送销售订单'),
('1436224661032538114',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224660994789377',1,NULL,3,'推送销售订单'),
('1436224661091258369',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224661053509633',1,NULL,3,'推送销售订单'),
('1436224661145784321',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224661112229890',1,NULL,3,'推送销售订单'),
('1436224661313556482',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224661166755842',1,NULL,3,'推送销售订单'),
('1436224661435191298',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224661347110914',1,NULL,3,'推送销售订单'),
('1436224661535854594',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224661468745730',1,NULL,3,'推送销售订单'),
('1436224661640712193',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224661573603329',1,NULL,3,'推送销售订单'),
('1436224661732986881',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224661695238146',1,NULL,3,'推送销售订单'),
('1436224661795901441',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224661753958402',1,NULL,3,'推送销售订单'),
('1436224661858816002',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192495\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:01:09\",\"sono\":\"SEORD130527\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224661816872961',1,NULL,3,'推送销售订单'),
('1436224661921730561',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192496\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:02:10\",\"sono\":\"SEORD130528\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224661888176130',1,NULL,3,'推送销售订单'),
('1436224661993033730',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192497\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:03:11\",\"sono\":\"SEORD130529\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224661942702081',1,NULL,3,'推送销售订单'),
('1436224662047559681',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192498\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:04:12\",\"sono\":\"SEORD130530\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224662009810946',1,NULL,3,'推送销售订单'),
('1436224662102085633',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192499\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:05:13\",\"sono\":\"SEORD130531\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224662064336897',1,NULL,3,'推送销售订单'),
('1436224662165000193',0,'成功','2021-09-10 15:06:58','{\"fid\":\"192500\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:06:14\",\"sono\":\"SEORD130532\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224662123057154',1,NULL,3,'推送销售订单'),
('1436224765927886849',0,'成功','2021-09-10 15:07:23','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436224765890138114',1,NULL,4,'推送生产订单'),
('1436224915488378881',0,'成功','2021-09-10 15:07:58','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224915408687105',1,NULL,3,'推送销售订单'),
('1436224915547099138',0,'成功','2021-09-10 15:07:58','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224915509350401',1,NULL,3,'推送销售订单'),
('1436224915601625089',0,'成功','2021-09-10 15:07:58','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224915568070657',1,NULL,3,'推送销售订单'),
('1436224915660345346',0,'成功','2021-09-10 15:07:58','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224915622596609',1,NULL,3,'推送销售订单'),
('1436224915723259906',0,'成功','2021-09-10 15:07:58','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224915681316865',1,NULL,3,'推送销售订单'),
('1436224915781980161',0,'成功','2021-09-10 15:07:58','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224915740037122',1,NULL,3,'推送销售订单'),
('1436224915836506113',0,'成功','2021-09-10 15:07:58','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224915798757377',1,NULL,3,'推送销售订单'),
('1436224915895226370',0,'成功','2021-09-10 15:07:58','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436224915853283330',1,NULL,3,'推送销售订单'),
('1436224915949752322',0,'成功','2021-09-10 15:07:58','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224915912003586',1,NULL,3,'推送销售订单'),
('1436224916008472578',0,'成功','2021-09-10 15:07:58','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224915966529538',1,NULL,3,'推送销售订单'),
('1436224916075581442',0,'成功','2021-09-10 15:07:58','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224916029444098',1,NULL,3,'推送销售订单'),
('1436224916138496001',0,'成功','2021-09-10 15:07:58','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224916096552961',1,NULL,3,'推送销售订单'),
('1436224916205604866',0,'成功','2021-09-10 15:07:58','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224916155273218',1,NULL,3,'推送销售订单'),
('1436224916268519426',0,'成功','2021-09-10 15:07:58','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224916222382082',1,NULL,3,'推送销售订单'),
('1436224916339822594',0,'成功','2021-09-10 15:07:58','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224916289490946',1,NULL,3,'推送销售订单'),
('1436224916578897922',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224916465651714',1,NULL,3,'推送销售订单'),
('1436224916662784001',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224916612452354',1,NULL,3,'推送销售订单'),
('1436224916729892865',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224916679561218',1,NULL,3,'推送销售订单'),
('1436224916784418818',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224916746670082',1,NULL,3,'推送销售订单'),
('1436224916830556162',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224916801196034',1,NULL,3,'推送销售订单'),
('1436224916885082114',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224916855721986',1,NULL,3,'推送销售订单'),
('1436224916931219457',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224916897665026',1,NULL,3,'推送销售订单'),
('1436224916981551106',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224916947996674',1,NULL,3,'推送销售订单'),
('1436224917031882754',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224916994134017',1,NULL,3,'推送销售订单'),
('1436224917082214401',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224917044465665',1,NULL,3,'推送销售订单'),
('1436224917132546049',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224917098991618',1,NULL,3,'推送销售订单'),
('1436224917182877698',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224917149323265',1,NULL,3,'推送销售订单'),
('1436224917237403649',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224917203849218',1,NULL,3,'推送销售订单'),
('1436224917283540994',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224917249986562',1,NULL,3,'推送销售订单'),
('1436224917333872641',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224917300318210',1,NULL,3,'推送销售订单'),
('1436224917384204290',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224917350649857',1,NULL,3,'推送销售订单'),
('1436224917434535938',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224917400981506',1,NULL,3,'推送销售订单'),
('1436224917489061890',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224917451313154',1,NULL,3,'推送销售订单'),
('1436224917539393537',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224917505839106',1,NULL,3,'推送销售订单'),
('1436224917593919490',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224917560365058',1,NULL,3,'推送销售订单'),
('1436224917640056833',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224917606502401',1,NULL,3,'推送销售订单'),
('1436224917690388481',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224917652639746',1,NULL,3,'推送销售订单'),
('1436224917744914434',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224917707165698',1,NULL,3,'推送销售订单'),
('1436224917799440385',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224917761691649',1,NULL,3,'推送销售订单'),
('1436224917858160641',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224917816217602',1,NULL,3,'推送销售订单'),
('1436224917912686594',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224917870743553',1,NULL,3,'推送销售订单'),
('1436224917967212545',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192495\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:01:09\",\"sono\":\"SEORD130527\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224917929463810',1,NULL,3,'推送销售订单'),
('1436224918046904321',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192496\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:02:10\",\"sono\":\"SEORD130528\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224917983989762',1,NULL,3,'推送销售订单'),
('1436224918118207490',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192497\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:03:11\",\"sono\":\"SEORD130529\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224918067875842',1,NULL,3,'推送销售订单'),
('1436224918256619521',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192498\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:04:12\",\"sono\":\"SEORD130530\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224918210482177',1,NULL,3,'推送销售订单'),
('1436224918311145473',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192499\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:05:13\",\"sono\":\"SEORD130531\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224918273396738',1,NULL,3,'推送销售订单'),
('1436224918378254338',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192500\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:06:14\",\"sono\":\"SEORD130532\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224918332116994',1,NULL,3,'推送销售订单'),
('1436224918432780290',0,'成功','2021-09-10 15:07:59','{\"fid\":\"192501\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:07:15\",\"sono\":\"SEORD130533\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436224918395031554',1,NULL,3,'推送销售订单'),
('1436225018534039553',0,'成功','2021-09-10 15:08:23','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436225018500485122',1,NULL,4,'推送生产订单'),
('1436225171869405185',0,'成功','2021-09-10 15:08:59','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225171827462146',1,NULL,3,'推送销售订单'),
('1436225171936514050',0,'成功','2021-09-10 15:08:59','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225171894571010',1,NULL,3,'推送销售订单'),
('1436225172007817218',0,'成功','2021-09-10 15:08:59','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225171970068482',1,NULL,3,'推送销售订单'),
('1436225172091703297',0,'成功','2021-09-10 15:08:59','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225172045565954',1,NULL,3,'推送销售订单'),
('1436225172158812162',0,'成功','2021-09-10 15:08:59','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225172112674817',1,NULL,3,'推送销售订单'),
('1436225173257719809',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225173211582466',1,NULL,3,'推送销售订单'),
('1436225173333217282',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225173291274242',1,NULL,3,'推送销售订单'),
('1436225173391937537',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225173349994497',1,NULL,3,'推送销售订单'),
('1436225173463240706',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225173408714754',1,NULL,3,'推送销售订单'),
('1436225173517766658',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225173480017922',1,NULL,3,'推送销售订单'),
('1436225173568098305',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225173530349570',1,NULL,3,'推送销售订单'),
('1436225173622624258',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225173584875522',1,NULL,3,'推送销售订单'),
('1436225173672955906',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225173639401473',1,NULL,3,'推送销售订单'),
('1436225173727481857',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225173689733121',1,NULL,3,'推送销售订单'),
('1436225173777813506',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225173744259073',1,NULL,3,'推送销售订单'),
('1436225173823950849',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225173790396418',1,NULL,3,'推送销售订单'),
('1436225173874282498',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225173840728066',1,NULL,3,'推送销售订单'),
('1436225173924614146',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225173886865409',1,NULL,3,'推送销售订单'),
('1436225173983334401',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225173937197057',1,NULL,3,'推送销售订单'),
('1436225174063026177',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225173995917313',1,NULL,3,'推送销售订单'),
('1436225174251769858',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225174205632514',1,NULL,3,'推送销售订单'),
('1436225174314684418',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225174268547074',1,NULL,3,'推送销售订单'),
('1436225174385987585',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225174335655938',1,NULL,3,'推送销售订单'),
('1436225174444707841',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225174402764802',1,NULL,3,'推送销售订单'),
('1436225174503428097',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225174465679362',1,NULL,3,'推送销售订单'),
('1436225174562148353',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225174524399617',1,NULL,3,'推送销售订单'),
('1436225174620868610',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225174583119873',1,NULL,3,'推送销售订单'),
('1436225174679588866',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225174641840130',1,NULL,3,'推送销售订单'),
('1436225174838972418',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225174700560385',1,NULL,3,'推送销售订单'),
('1436225174901886978',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225174864138242',1,NULL,3,'推送销售订单'),
('1436225175078047745',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225174985773058',1,NULL,3,'推送销售订单'),
('1436225175229042689',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225175119990786',1,NULL,3,'推送销售订单'),
('1436225175354871809',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225175312928769',1,NULL,3,'推送销售订单'),
('1436225175413592065',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225175375843329',1,NULL,3,'推送销售订单'),
('1436225175480700930',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225175442952193',1,NULL,3,'推送销售订单'),
('1436225175535226881',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225175501672449',1,NULL,3,'推送销售订单'),
('1436225175593947138',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225175556198402',1,NULL,3,'推送销售订单'),
('1436225175673638914',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225175631695874',1,NULL,3,'推送销售订单'),
('1436225175736553473',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225175694610433',1,NULL,3,'推送销售订单'),
('1436225175803662338',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225175761719297',1,NULL,3,'推送销售订单'),
('1436225175858188290',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225175820439553',1,NULL,3,'推送销售订单'),
('1436225175916908546',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192495\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:01:09\",\"sono\":\"SEORD130527\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225175883354113',1,NULL,3,'推送销售订单'),
('1436225175975628801',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192496\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:02:10\",\"sono\":\"SEORD130528\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225175937880066',1,NULL,3,'推送销售订单'),
('1436225176076292098',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192497\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:03:11\",\"sono\":\"SEORD130529\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225175996600321',1,NULL,3,'推送销售订单'),
('1436225176143400961',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192498\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:04:12\",\"sono\":\"SEORD130530\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225176097263617',1,NULL,3,'推送销售订单'),
('1436225176202121218',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192499\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:05:13\",\"sono\":\"SEORD130531\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225176168566785',1,NULL,3,'推送销售订单'),
('1436225176260841473',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192500\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:06:14\",\"sono\":\"SEORD130532\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225176227287041',1,NULL,3,'推送销售订单'),
('1436225176315367425',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192501\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:07:15\",\"sono\":\"SEORD130533\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225176281812993',1,NULL,3,'推送销售订单'),
('1436225176374087681',0,'成功','2021-09-10 15:09:00','{\"fid\":\"192502\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:08:16\",\"sono\":\"SEORD130534\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225176336338946',1,NULL,3,'推送销售订单'),
('1436225270989197314',0,'成功','2021-09-10 15:09:23','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436225270947254274',1,NULL,4,'推送生产订单'),
('1436225429693272065',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225429651329025',1,NULL,3,'推送销售订单'),
('1436225429760380929',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225429722632193',1,NULL,3,'推送销售订单'),
('1436225429819101185',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225429781352450',1,NULL,3,'推送销售订单'),
('1436225429877821441',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225429835878402',1,NULL,3,'推送销售订单'),
('1436225429932347394',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225429894598657',1,NULL,3,'推送销售订单'),
('1436225429991067650',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225429949124610',1,NULL,3,'推送销售订单'),
('1436225430053982209',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225430012039170',1,NULL,3,'推送销售订单'),
('1436225430108508161',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225430070759426',1,NULL,3,'推送销售订单'),
('1436225430158839809',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225430125285378',1,NULL,3,'推送销售订单'),
('1436225430242725889',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225430196588545',1,NULL,3,'推送销售订单'),
('1436225430502772737',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225430347583490',1,NULL,3,'推送销售订单'),
('1436225430649573377',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225430548910082',1,NULL,3,'推送销售订单'),
('1436225430880260097',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225430720876545',1,NULL,3,'推送销售订单'),
('1436225430964146178',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225430909620226',1,NULL,3,'推送销售订单'),
('1436225431052226561',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225431001894914',1,NULL,3,'推送销售订单'),
('1436225431123529729',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225431077392385',1,NULL,3,'推送销售订单'),
('1436225431215804417',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225431140306945',1,NULL,3,'推送销售订单'),
('1436225431299690498',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225431240970242',1,NULL,3,'推送销售订单'),
('1436225431379382274',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225431333244929',1,NULL,3,'推送销售订单'),
('1436225431450685442',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225431408742402',1,NULL,3,'推送销售订单'),
('1436225431509405697',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225431471656962',1,NULL,3,'推送销售订单'),
('1436225431580708866',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225431534571522',1,NULL,3,'推送销售订单'),
('1436225431668789250',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225431601680386',1,NULL,3,'推送销售订单'),
('1436225431727509506',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225431685566466',1,NULL,3,'推送销售订单'),
('1436225431782035457',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225431752675330',1,NULL,3,'推送销售订单'),
('1436225431840755713',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225431798812673',1,NULL,3,'推送销售订单'),
('1436225431907864577',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225431857532930',1,NULL,3,'推送销售订单'),
('1436225431995944961',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225431928836097',1,NULL,3,'推送销售订单'),
('1436225432104996865',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225432021110786',1,NULL,3,'推送销售订单'),
('1436225432180494338',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225432130162690',1,NULL,3,'推送销售订单'),
('1436225432276963329',0,'成功','2021-09-10 15:10:01','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225432209854465',1,NULL,3,'推送销售订单'),
('1436225432352460801',0,'成功','2021-09-10 15:10:02','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225432302129154',1,NULL,3,'推送销售订单'),
('1436225432423763969',0,'成功','2021-09-10 15:10:02','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225432373432321',1,NULL,3,'推送销售订单'),
('1436225432524427266',0,'成功','2021-09-10 15:10:02','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225432453124098',1,NULL,3,'推送销售订单'),
('1436225432599924738',0,'成功','2021-09-10 15:10:02','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225432545398786',1,NULL,3,'推送销售订单'),
('1436225432721559553',0,'成功','2021-09-10 15:10:02','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225432637673473',1,NULL,3,'推送销售订单'),
('1436225432792862722',0,'成功','2021-09-10 15:10:02','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225432750919681',1,NULL,3,'推送销售订单'),
('1436225432864165889',0,'成功','2021-09-10 15:10:02','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225432822222849',1,NULL,3,'推送销售订单'),
('1436225432927080450',0,'成功','2021-09-10 15:10:02','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225432880943106',1,NULL,3,'推送销售订单'),
('1436225432981606401',0,'成功','2021-09-10 15:10:02','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225432943857665',1,NULL,3,'推送销售订单'),
('1436225433040326657',0,'成功','2021-09-10 15:10:02','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225432998383618',1,NULL,3,'推送销售订单'),
('1436225433140989953',0,'成功','2021-09-10 15:10:02','{\"fid\":\"192495\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:01:09\",\"sono\":\"SEORD130527\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225433090658305',1,NULL,3,'推送销售订单'),
('1436225433212293122',0,'成功','2021-09-10 15:10:02','{\"fid\":\"192496\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:02:10\",\"sono\":\"SEORD130528\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225433161961473',1,NULL,3,'推送销售订单'),
('1436225433291984897',0,'成功','2021-09-10 15:10:02','{\"fid\":\"192497\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:03:11\",\"sono\":\"SEORD130529\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225433233264642',1,NULL,3,'推送销售订单'),
('1436225433396842498',0,'成功','2021-09-10 15:10:02','{\"fid\":\"192498\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:04:12\",\"sono\":\"SEORD130530\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225433338122241',1,NULL,3,'推送销售订单'),
('1436225433476534273',0,'成功','2021-09-10 15:10:02','{\"fid\":\"192499\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:05:13\",\"sono\":\"SEORD130531\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225433426202626',1,NULL,3,'推送销售订单'),
('1436225433547837442',0,'成功','2021-09-10 15:10:02','{\"fid\":\"192500\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:06:14\",\"sono\":\"SEORD130532\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225433501700098',1,NULL,3,'推送销售订单'),
('1436225433673666561',0,'成功','2021-09-10 15:10:02','{\"fid\":\"192501\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:07:15\",\"sono\":\"SEORD130533\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225433568808962',1,NULL,3,'推送销售订单'),
('1436225433744969729',0,'成功','2021-09-10 15:10:02','{\"fid\":\"192502\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:08:16\",\"sono\":\"SEORD130534\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225433698832385',1,NULL,3,'推送销售订单'),
('1436225433812078594',0,'成功','2021-09-10 15:10:02','{\"fid\":\"192503\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:09:17\",\"sono\":\"SEORD130535\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225433778524162',1,NULL,3,'推送销售订单'),
('1436225523641487362',0,'成功','2021-09-10 15:10:23','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436225523494686721',1,NULL,4,'推送生产订单'),
('1436225687756214274',0,'成功','2021-09-10 15:11:02','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225687710076930',1,NULL,3,'推送销售订单'),
('1436225687823323137',0,'成功','2021-09-10 15:11:02','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225687781380098',1,NULL,3,'推送销售订单'),
('1436225687877849090',0,'成功','2021-09-10 15:11:02','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225687844294657',1,NULL,3,'推送销售订单'),
('1436225688062398465',0,'成功','2021-09-10 15:11:02','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225687932375041',1,NULL,3,'推送销售订单'),
('1436225688125313025',0,'成功','2021-09-10 15:11:02','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225688087564289',1,NULL,3,'推送销售订单'),
('1436225688184033281',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225688154673154',1,NULL,3,'推送销售订单'),
('1436225688238559233',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225688205004801',1,NULL,3,'推送销售订单'),
('1436225688297279490',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225688255336449',1,NULL,3,'推送销售订单'),
('1436225688381165569',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225688330833921',1,NULL,3,'推送销售订单'),
('1436225688435691522',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225688397942786',1,NULL,3,'推送销售订单'),
('1436225688494411777',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225688452468737',1,NULL,3,'推送销售订单'),
('1436225688557326338',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225688515383298',1,NULL,3,'推送销售订单'),
('1436225688624435201',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225688574103554',1,NULL,3,'推送销售订单'),
('1436225688762847234',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225688720904194',1,NULL,3,'推送销售订单'),
('1436225688825761793',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225688779624449',1,NULL,3,'推送销售订单'),
('1436225688884482050',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225688846733314',1,NULL,3,'推送销售订单'),
('1436225688939008001',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225688901259266',1,NULL,3,'推送销售订单'),
('1436225689001922561',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225688964173826',1,NULL,3,'推送销售订单'),
('1436225689052254210',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225689018699778',1,NULL,3,'推送销售订单'),
('1436225689106780161',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225689069031426',1,NULL,3,'推送销售订单'),
('1436225689169694721',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225689127751682',1,NULL,3,'推送销售订单'),
('1436225689220026370',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225689186471937',1,NULL,3,'推送销售订单'),
('1436225689278746626',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225689236803586',1,NULL,3,'推送销售订单'),
('1436225689337466881',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225689299718146',1,NULL,3,'推送销售订单'),
('1436225689391992833',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225689358438401',1,NULL,3,'推送销售订单'),
('1436225689450713089',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225689417158657',1,NULL,3,'推送销售订单'),
('1436225689509433346',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225689471684610',1,NULL,3,'推送销售订单'),
('1436225689568153601',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225689530404865',1,NULL,3,'推送销售订单'),
('1436225689631068161',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225689593319425',1,NULL,3,'推送销售订单'),
('1436225689740120066',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225689698177026',1,NULL,3,'推送销售订单'),
('1436225689832394753',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225689777868802',1,NULL,3,'推送销售订单'),
('1436225689899503618',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225689853366274',1,NULL,3,'推送销售订单'),
('1436225689962418178',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225689920475137',1,NULL,3,'推送销售订单'),
('1436225690025332738',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225689979195394',1,NULL,3,'推送销售订单'),
('1436225690075664386',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225690042109954',1,NULL,3,'推送销售订单'),
('1436225690130190337',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225690096635905',1,NULL,3,'推送销售订单'),
('1436225690188910593',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225690151161857',1,NULL,3,'推送销售订单'),
('1436225690243436545',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225690214076417',1,NULL,3,'推送销售订单'),
('1436225690297962498',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225690268602369',1,NULL,3,'推送销售订单'),
('1436225690348294146',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225690318934018',1,NULL,3,'推送销售订单'),
('1436225690398625793',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225690369265665',1,NULL,3,'推送销售订单'),
('1436225690448957441',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192495\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:01:09\",\"sono\":\"SEORD130527\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225690423791617',1,NULL,3,'推送销售订单'),
('1436225690503483394',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192496\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:02:10\",\"sono\":\"SEORD130528\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225690465734657',1,NULL,3,'推送销售订单'),
('1436225690558009345',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192497\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:03:11\",\"sono\":\"SEORD130529\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225690524454913',1,NULL,3,'推送销售订单'),
('1436225690612535297',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192498\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:04:12\",\"sono\":\"SEORD130530\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225690578980865',1,NULL,3,'推送销售订单'),
('1436225690667061250',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192499\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:05:13\",\"sono\":\"SEORD130531\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225690633506817',1,NULL,3,'推送销售订单'),
('1436225690717392897',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192500\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:06:14\",\"sono\":\"SEORD130532\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225690683838465',1,NULL,3,'推送销售订单'),
('1436225690771918849',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192501\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:07:15\",\"sono\":\"SEORD130533\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225690738364418',1,NULL,3,'推送销售订单'),
('1436225690834833410',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192502\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:08:16\",\"sono\":\"SEORD130534\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225690797084674',1,NULL,3,'推送销售订单'),
('1436225690893553666',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192503\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:09:17\",\"sono\":\"SEORD130535\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225690859999234',1,NULL,3,'推送销售订单'),
('1436225690952273922',0,'成功','2021-09-10 15:11:03','{\"fid\":\"192504\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:10:18\",\"sono\":\"SEORD130536\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225690918719489',1,NULL,3,'推送销售订单'),
('1436225776050507778',0,'成功','2021-09-10 15:11:23','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436225776004370433',1,NULL,4,'推送生产订单'),
('1436225944225320962',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225944099491841',1,NULL,3,'推送销售订单'),
('1436225944380510210',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225944296624129',1,NULL,3,'推送销售订单'),
('1436225944535699457',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225944426647554',1,NULL,3,'推送销售订单'),
('1436225944678305794',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225944581836802',1,NULL,3,'推送销售订单'),
('1436225944766386178',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225944728637442',1,NULL,3,'推送销售订单'),
('1436225944816717826',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225944783163393',1,NULL,3,'推送销售订单'),
('1436225944867049473',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225944829300738',1,NULL,3,'推送销售订单'),
('1436225944917381122',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436225944879632386',1,NULL,3,'推送销售订单'),
('1436225944967712769',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225944929964033',1,NULL,3,'推送销售订单'),
('1436225945026433025',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225944984489986',1,NULL,3,'推送销售订单'),
('1436225945076764673',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225945043210242',1,NULL,3,'推送销售订单'),
('1436225945131290626',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225945093541889',1,NULL,3,'推送销售订单'),
('1436225945185816578',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225945143873537',1,NULL,3,'推送销售订单'),
('1436225945244536833',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225945202593794',1,NULL,3,'推送销售订单'),
('1436225945303257090',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225945261314050',1,NULL,3,'推送销售订单'),
('1436225945357783042',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225945320034306',1,NULL,3,'推送销售订单'),
('1436225945408114689',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225945374560258',1,NULL,3,'推送销售订单'),
('1436225945462640642',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225945424891906',1,NULL,3,'推送销售订单'),
('1436225945517166594',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225945479417858',1,NULL,3,'推送销售订单'),
('1436225945588469762',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225945550721026',1,NULL,3,'推送销售订单'),
('1436225945638801409',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225945605246977',1,NULL,3,'推送销售订单'),
('1436225945689133057',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225945659772929',1,NULL,3,'推送销售订单'),
('1436225945743659010',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225945710104578',1,NULL,3,'推送销售订单'),
('1436225945798184962',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225945760436225',1,NULL,3,'推送销售订单'),
('1436225945873682434',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225945831739394',1,NULL,3,'推送销售订单'),
('1436225945953374210',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225945894653954',1,NULL,3,'推送销售订单'),
('1436225946024677378',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225945974345729',1,NULL,3,'推送销售订单'),
('1436225946091786242',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225946045648897',1,NULL,3,'推送销售订单'),
('1436225946167283713',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225946112757761',1,NULL,3,'推送销售订单'),
('1436225946259558402',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225946188255234',1,NULL,3,'推送销售订单'),
('1436225946314084354',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225946276335618',1,NULL,3,'推送销售订单'),
('1436225946368610305',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225946330861569',1,NULL,3,'推送销售订单'),
('1436225946427330561',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225946385387521',1,NULL,3,'推送销售订单'),
('1436225946486050818',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225946448302082',1,NULL,3,'推送销售订单'),
('1436225946544771074',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225946507022338',1,NULL,3,'推送销售订单'),
('1436225946607685634',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225946561548290',1,NULL,3,'推送销售订单'),
('1436225946666405890',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225946624462849',1,NULL,3,'推送销售订单'),
('1436225946796429313',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225946725126145',1,NULL,3,'推送销售订单'),
('1436225946972590082',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225946930647042',1,NULL,3,'推送销售订单'),
('1436225947035504641',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225947001950210',1,NULL,3,'推送销售订单'),
('1436225947090030593',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225947056476161',1,NULL,3,'推送销售订单'),
('1436225947148750850',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192495\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:01:09\",\"sono\":\"SEORD130527\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225947115196418',1,NULL,3,'推送销售订单'),
('1436225947199082497',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192496\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:02:10\",\"sono\":\"SEORD130528\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225947161333762',1,NULL,3,'推送销售订单'),
('1436225947257802754',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192497\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:03:11\",\"sono\":\"SEORD130529\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225947215859713',1,NULL,3,'推送销售订单'),
('1436225947312328705',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192498\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:04:12\",\"sono\":\"SEORD130530\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225947270385666',1,NULL,3,'推送销售订单'),
('1436225947371048962',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192499\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:05:13\",\"sono\":\"SEORD130531\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225947324911618',1,NULL,3,'推送销售订单'),
('1436225947425574914',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192500\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:06:14\",\"sono\":\"SEORD130532\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225947387826178',1,NULL,3,'推送销售订单'),
('1436225947480100866',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192501\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:07:15\",\"sono\":\"SEORD130533\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225947442352130',1,NULL,3,'推送销售订单'),
('1436225947530432513',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192502\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:08:16\",\"sono\":\"SEORD130534\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225947496878081',1,NULL,3,'推送销售订单'),
('1436225947605929985',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192503\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:09:17\",\"sono\":\"SEORD130535\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225947547209729',1,NULL,3,'推送销售订单'),
('1436225947660455938',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192504\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:10:18\",\"sono\":\"SEORD130536\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225947622707202',1,NULL,3,'推送销售订单'),
('1436225947719176193',0,'成功','2021-09-10 15:12:04','{\"fid\":\"192505\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:11:19\",\"sono\":\"SEORD130537\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436225947681427458',1,NULL,3,'推送销售订单'),
('1436226028669243394',0,'成功','2021-09-10 15:12:24','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436226028530831361',1,NULL,4,'推送生产订单'),
('1436226201344544769',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226201277435905',1,NULL,3,'推送销售订单'),
('1436226201407459329',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226201369710594',1,NULL,3,'推送销售订单'),
('1436226201466179585',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226201432625153',1,NULL,3,'推送销售订单'),
('1436226201520705538',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226201482956802',1,NULL,3,'推送销售订单'),
('1436226201587814401',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226201541677058',1,NULL,3,'推送销售订单'),
('1436226201646534658',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226201608785921',1,NULL,3,'推送销售订单'),
('1436226201705254913',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226201663311873',1,NULL,3,'推送销售订单'),
('1436226201768169473',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226201722032130',1,NULL,3,'推送销售订单'),
('1436226201843666945',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226201793335298',1,NULL,3,'推送销售订单'),
('1436226201910775809',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226201868832769',1,NULL,3,'推送销售订单'),
('1436226201969496065',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226201927553026',1,NULL,3,'推送销售订单'),
('1436226202028216322',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226201986273281',1,NULL,3,'推送销售订单'),
('1436226202078547969',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226202040799234',1,NULL,3,'推送销售订单'),
('1436226202128879617',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226202095325185',1,NULL,3,'推送销售订单'),
('1436226202183405569',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226202145656833',1,NULL,3,'推送销售订单'),
('1436226202237931522',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226202200182785',1,NULL,3,'推送销售订单'),
('1436226202296651778',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226202250514433',1,NULL,3,'推送销售订单'),
('1436226202351177730',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226202313428993',1,NULL,3,'推送销售订单'),
('1436226202422480898',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226202380537858',1,NULL,3,'推送销售订单'),
('1436226202489589762',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226202439258114',1,NULL,3,'推送销售订单'),
('1436226202560892930',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226202510561281',1,NULL,3,'推送销售订单'),
('1436226202640584705',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226202598641666',1,NULL,3,'推送销售订单'),
('1436226202703499266',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226202665750529',1,NULL,3,'推送销售订单'),
('1436226202770608130',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226202720276481',1,NULL,3,'推送销售订单'),
('1436226202833522690',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226202787385346',1,NULL,3,'推送销售订单'),
('1436226202888048642',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226202850299905',1,NULL,3,'推送销售订单'),
('1436226202950963202',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226202909020161',1,NULL,3,'推送销售订单'),
('1436226202997100545',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226202963546114',1,NULL,3,'推送销售订单'),
('1436226203047432194',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226203013877761',1,NULL,3,'推送销售订单'),
('1436226203101958146',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226203064209410',1,NULL,3,'推送销售订单'),
('1436226203152289794',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226203118735361',1,NULL,3,'推送销售订单'),
('1436226203211010049',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226203173261313',1,NULL,3,'推送销售订单'),
('1436226203261341697',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226203227787265',1,NULL,3,'推送销售订单'),
('1436226203311673346',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226203278118913',1,NULL,3,'推送销售订单'),
('1436226203362004994',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226203328450562',1,NULL,3,'推送销售订单'),
('1436226203416530945',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226203378782209',1,NULL,3,'推送销售订单'),
('1436226203471056897',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226203433308161',1,NULL,3,'推送销售订单'),
('1436226203525582850',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226203487834113',1,NULL,3,'推送销售订单'),
('1436226203575914498',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226203538165761',1,NULL,3,'推送销售订单'),
('1436226203655606273',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226203601080322',1,NULL,3,'推送销售订单'),
('1436226203718520833',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226203672383490',1,NULL,3,'推送销售订单'),
('1436226203777241090',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192495\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:01:09\",\"sono\":\"SEORD130527\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226203739492353',1,NULL,3,'推送销售订单'),
('1436226203848544258',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192496\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:02:10\",\"sono\":\"SEORD130528\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226203802406914',1,NULL,3,'推送销售订单'),
('1436226203915653122',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192497\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:03:11\",\"sono\":\"SEORD130529\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226203873710081',1,NULL,3,'推送销售订单'),
('1436226203978567682',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192498\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:04:12\",\"sono\":\"SEORD130530\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226203932430338',1,NULL,3,'推送销售订单'),
('1436226204041482242',0,'成功','2021-09-10 15:13:05','{\"fid\":\"192499\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:05:13\",\"sono\":\"SEORD130531\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226203995344897',1,NULL,3,'推送销售订单'),
('1436226204179894274',0,'成功','2021-09-10 15:13:06','{\"fid\":\"192500\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:06:14\",\"sono\":\"SEORD130532\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226204083425281',1,NULL,3,'推送销售订单'),
('1436226204364443650',0,'成功','2021-09-10 15:13:06','{\"fid\":\"192501\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:07:15\",\"sono\":\"SEORD130533\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226204234420225',1,NULL,3,'推送销售订单'),
('1436226204574158850',0,'成功','2021-09-10 15:13:06','{\"fid\":\"192502\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:08:16\",\"sono\":\"SEORD130534\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226204427358209',1,NULL,3,'推送销售订单'),
('1436226204771291137',0,'成功','2021-09-10 15:13:06','{\"fid\":\"192503\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:09:17\",\"sono\":\"SEORD130535\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226204616101890',1,NULL,3,'推送销售订单'),
('1436226205006172162',0,'成功','2021-09-10 15:13:06','{\"fid\":\"192504\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:10:18\",\"sono\":\"SEORD130536\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226204846788609',1,NULL,3,'推送销售订单'),
('1436226205270413314',0,'成功','2021-09-10 15:13:06','{\"fid\":\"192505\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:11:19\",\"sono\":\"SEORD130537\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226205064892417',1,NULL,3,'推送销售订单'),
('1436226205333327873',0,'成功','2021-09-10 15:13:06','{\"fid\":\"192506\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:12:20\",\"sono\":\"SEORD130538\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226205287190529',1,NULL,3,'推送销售订单'),
('1436226281308950529',0,'成功','2021-09-10 15:13:24','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436226281262813185',1,NULL,4,'推送生产订单'),
('1436226458740592641',0,'成功','2021-09-10 15:14:06','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226458686066689',1,NULL,3,'推送销售订单'),
('1436226458866421762',0,'成功','2021-09-10 15:14:06','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226458778341377',1,NULL,3,'推送销售订单'),
('1436226458954502145',0,'成功','2021-09-10 15:14:06','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226458899976194',1,NULL,3,'推送销售订单'),
('1436226459046776834',0,'成功','2021-09-10 15:14:06','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226458979667970',1,NULL,3,'推送销售订单'),
('1436226459118080002',0,'成功','2021-09-10 15:14:06','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226459063554050',1,NULL,3,'推送销售订单'),
('1436226459197771777',0,'成功','2021-09-10 15:14:06','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226459139051522',1,NULL,3,'推送销售订单'),
('1436226459277463553',0,'成功','2021-09-10 15:14:06','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226459218743297',1,NULL,3,'推送销售订单'),
('1436226461303312386',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226461215232001',1,NULL,3,'推送销售订单'),
('1436226461437530113',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226461353644033',1,NULL,3,'推送销售订单'),
('1436226461605302274',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226461496250370',1,NULL,3,'推送销售订单'),
('1436226461735325698',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226461651439618',1,NULL,3,'推送销售订单'),
('1436226462045704194',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226461785657346',1,NULL,3,'推送销售订单'),
('1436226462217670657',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226462125395970',1,NULL,3,'推送销售订单'),
('1436226462381248513',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226462268002305',1,NULL,3,'推送销售订单'),
('1436226462477717506',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226462406414337',1,NULL,3,'推送销售订单'),
('1436226462603546626',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226462536437761',1,NULL,3,'推送销售订单'),
('1436226462716792834',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226462658072577',1,NULL,3,'推送销售订单'),
('1436226462817456130',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226462746152961',1,NULL,3,'推送销售订单'),
('1436226462939090946',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226462855204866',1,NULL,3,'推送销售订单'),
('1436226463035559938',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226462976839682',1,NULL,3,'推送销售订单'),
('1436226463190749185',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226463090085889',1,NULL,3,'推送销售订单'),
('1436226463291412481',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226463224303617',1,NULL,3,'推送销售订单'),
('1436226463404658689',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226463350132737',1,NULL,3,'推送销售订单'),
('1436226463484350465',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226463434018817',1,NULL,3,'推送销售订单'),
('1436226463580819457',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226463526293506',1,NULL,3,'推送销售订单'),
('1436226463652122625',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226463610179585',1,NULL,3,'推送销售订单'),
('1436226463731814401',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226463685677058',1,NULL,3,'推送销售订单'),
('1436226463866032130',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226463769563138',1,NULL,3,'推送销售订单'),
('1436226463983472642',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226463907975170',1,NULL,3,'推送销售订单'),
('1436226464113496065',0,'成功','2021-09-10 15:14:07','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226464037998594',1,NULL,3,'推送销售订单'),
('1436226464197382146',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226464151244801',1,NULL,3,'推送销售订单'),
('1436226464272879618',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226464230936578',1,NULL,3,'推送销售订单'),
('1436226464348377090',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226464310628353',1,NULL,3,'推送销售订单'),
('1436226464423874561',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226464377737218',1,NULL,3,'推送销售订单'),
('1436226464545509377',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226464478400514',1,NULL,3,'推送销售订单'),
('1436226464621006849',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226464570675201',1,NULL,3,'推送销售订单'),
('1436226464725864449',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226464675532802',1,NULL,3,'推送销售订单'),
('1436226464818139138',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226464759418881',1,NULL,3,'推送销售订单'),
('1436226464889442306',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226464851693569',1,NULL,3,'推送销售订单'),
('1436226464948162562',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226464910413826',1,NULL,3,'推送销售订单'),
('1436226465002688514',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226464964939777',1,NULL,3,'推送销售订单'),
('1436226465090768897',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192495\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:01:09\",\"sono\":\"SEORD130527\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226465040437249',1,NULL,3,'推送销售订单'),
('1436226465157877762',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192496\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:02:10\",\"sono\":\"SEORD130528\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226465111740417',1,NULL,3,'推送销售订单'),
('1436226465224986626',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192497\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:03:11\",\"sono\":\"SEORD130529\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226465178849282',1,NULL,3,'推送销售订单'),
('1436226465300484097',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192498\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:04:12\",\"sono\":\"SEORD130530\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226465254346754',1,NULL,3,'推送销售订单'),
('1436226465375981570',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192499\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:05:13\",\"sono\":\"SEORD130531\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226465334038529',1,NULL,3,'推送销售订单'),
('1436226465438896130',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192500\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:06:14\",\"sono\":\"SEORD130532\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226465396953090',1,NULL,3,'推送销售订单'),
('1436226465514393601',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192501\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:07:15\",\"sono\":\"SEORD130533\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226465459867649',1,NULL,3,'推送销售订单'),
('1436226465589891073',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192502\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:08:16\",\"sono\":\"SEORD130534\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226465543753729',1,NULL,3,'推送销售订单'),
('1436226465656999937',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192503\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:09:17\",\"sono\":\"SEORD130535\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226465615056897',1,NULL,3,'推送销售订单'),
('1436226465707331585',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192504\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:10:18\",\"sono\":\"SEORD130536\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226465673777153',1,NULL,3,'推送销售订单'),
('1436226465770246146',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192505\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:11:19\",\"sono\":\"SEORD130537\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226465728303106',1,NULL,3,'推送销售订单'),
('1436226465828966402',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192506\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:12:20\",\"sono\":\"SEORD130538\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226465791217666',1,NULL,3,'推送销售订单'),
('1436226465887686658',0,'成功','2021-09-10 15:14:08','{\"fid\":\"192507\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:13:21\",\"sono\":\"SEORD130539\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226465849937921',1,NULL,3,'推送销售订单'),
('1436226533751525378',0,'成功','2021-09-10 15:14:24','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436226533705388033',1,NULL,4,'推送生产订单'),
('1436226719240425474',0,'成功','2021-09-10 15:15:08','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226719190093826',1,NULL,3,'推送销售订单'),
('1436226719303340034',0,'成功','2021-09-10 15:15:08','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226719261396994',1,NULL,3,'推送销售订单'),
('1436226719374643202',0,'成功','2021-09-10 15:15:08','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226719328505858',1,NULL,3,'推送销售订单'),
('1436226719471112194',0,'成功','2021-09-10 15:15:08','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226719412391938',1,NULL,3,'推送销售订单'),
('1436226719534026754',0,'成功','2021-09-10 15:15:08','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226719496278018',1,NULL,3,'推送销售订单'),
('1436226719592747009',0,'成功','2021-09-10 15:15:08','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226719559192577',1,NULL,3,'推送销售订单'),
('1436226719655661570',0,'成功','2021-09-10 15:15:08','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226719617912833',1,NULL,3,'推送销售订单'),
('1436226719743741953',0,'成功','2021-09-10 15:15:08','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226719705993218',1,NULL,3,'推送销售订单'),
('1436226719819239425',0,'成功','2021-09-10 15:15:08','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226719777296386',1,NULL,3,'推送销售订单'),
('1436226719894736897',0,'成功','2021-09-10 15:15:08','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226719844405250',1,NULL,3,'推送销售订单'),
('1436226719966040065',0,'成功','2021-09-10 15:15:08','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226719919902722',1,NULL,3,'推送销售订单'),
('1436226720049926145',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226720007983105',1,NULL,3,'推送销售订单'),
('1436226720121229314',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226720066703362',1,NULL,3,'推送销售订单'),
('1436226720247058434',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226720175755265',1,NULL,3,'推送销售订单'),
('1436226720351916033',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226720301584386',1,NULL,3,'推送销售订单'),
('1436226720460967937',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226720398053378',1,NULL,3,'推送销售订单'),
('1436226720544854017',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226720498716674',1,NULL,3,'推送销售订单'),
('1436226721039781890',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226721002033153',1,NULL,3,'推送销售订单'),
('1436226721127862273',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226721085919234',1,NULL,3,'推送销售订单'),
('1436226721182388225',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226721144639489',1,NULL,3,'推送销售订单'),
('1436226721241108482',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226721203359746',1,NULL,3,'推送销售订单'),
('1436226721299828738',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226721257885697',1,NULL,3,'推送销售订单'),
('1436226721358548994',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226721316605953',1,NULL,3,'推送销售订单'),
('1436226721421463553',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226721379520513',1,NULL,3,'推送销售订单'),
('1436226721501155329',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226721438240769',1,NULL,3,'推送销售订单'),
('1436226721652150273',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226721555681282',1,NULL,3,'推送销售订单'),
('1436226721777979393',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226721681510402',1,NULL,3,'推送销售订单'),
('1436226721912197122',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226721819922434',1,NULL,3,'推送销售订单'),
('1436226722058997762',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226721966723073',1,NULL,3,'推送销售订单'),
('1436226722109329410',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226722075774978',1,NULL,3,'推送销售订单'),
('1436226722193215489',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226722155466754',1,NULL,3,'推送销售订单'),
('1436226722251935746',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226722205798402',1,NULL,3,'推送销售订单'),
('1436226722306461698',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226722268712962',1,NULL,3,'推送销售订单'),
('1436226722360987650',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226722319044610',1,NULL,3,'推送销售订单'),
('1436226722415513601',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226722377764866',1,NULL,3,'推送销售订单'),
('1436226722465845249',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226722432290817',1,NULL,3,'推送销售订单'),
('1436226722516176898',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226722478428162',1,NULL,3,'推送销售订单'),
('1436226722566508546',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226722532954114',1,NULL,3,'推送销售订单'),
('1436226722637811713',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226722595868673',1,NULL,3,'推送销售订单'),
('1436226722742669313',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226722709114882',1,NULL,3,'推送销售订单'),
('1436226722793000961',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226722759446530',1,NULL,3,'推送销售订单'),
('1436226722847526913',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192495\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:01:09\",\"sono\":\"SEORD130527\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226722813972482',1,NULL,3,'推送销售订单'),
('1436226722906247170',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192496\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:02:10\",\"sono\":\"SEORD130528\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226722868498433',1,NULL,3,'推送销售订单'),
('1436226722964967426',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192497\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:03:11\",\"sono\":\"SEORD130529\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226722923024385',1,NULL,3,'推送销售订单'),
('1436226723015299073',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192498\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:04:12\",\"sono\":\"SEORD130530\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226722981744642',1,NULL,3,'推送销售订单'),
('1436226723074019330',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192499\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:05:13\",\"sono\":\"SEORD130531\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226723032076289',1,NULL,3,'推送销售订单'),
('1436226723128545282',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192500\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:06:14\",\"sono\":\"SEORD130532\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226723086602242',1,NULL,3,'推送销售订单'),
('1436226723183071233',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192501\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:07:15\",\"sono\":\"SEORD130533\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226723145322497',1,NULL,3,'推送销售订单'),
('1436226723237597185',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192502\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:08:16\",\"sono\":\"SEORD130534\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226723195654146',1,NULL,3,'推送销售订单'),
('1436226723287928833',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192503\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:09:17\",\"sono\":\"SEORD130535\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226723254374402',1,NULL,3,'推送销售订单'),
('1436226723338260482',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192504\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:10:18\",\"sono\":\"SEORD130536\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226723304706049',1,NULL,3,'推送销售订单'),
('1436226723401175042',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192505\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:11:19\",\"sono\":\"SEORD130537\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226723350843394',1,NULL,3,'推送销售订单'),
('1436226723480866818',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192506\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:12:20\",\"sono\":\"SEORD130538\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226723413757953',1,NULL,3,'推送销售订单'),
('1436226723556364290',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192507\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:13:21\",\"sono\":\"SEORD130539\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226723497644033',1,NULL,3,'推送销售订单'),
('1436226723627667457',0,'成功','2021-09-10 15:15:09','{\"fid\":\"192508\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:14:22\",\"sono\":\"SEORD130540\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226723577335810',1,NULL,3,'推送销售订单'),
('1436226786252820482',0,'成功','2021-09-10 15:15:24','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436226786215071745',1,NULL,4,'推送生产订单'),
('1436226976875548674',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226976829411329',1,NULL,3,'推送销售订单'),
('1436226976938463234',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226976896520193',1,NULL,3,'推送销售订单'),
('1436226976988794882',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226976955240450',1,NULL,3,'推送销售订单'),
('1436226977047515137',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226977009766401',1,NULL,3,'推送销售订单'),
('1436226977097846786',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226977064292353',1,NULL,3,'推送销售订单'),
('1436226977152372738',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226977114624001',1,NULL,3,'推送销售订单'),
('1436226977211092994',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226977173344258',1,NULL,3,'推送销售订单'),
('1436226977278201858',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436226977227870209',1,NULL,3,'推送销售订单'),
('1436226977404030977',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226977294979074',1,NULL,3,'推送销售订单'),
('1436226977601163266',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226977525665793',1,NULL,3,'推送销售订单'),
('1436226977680855041',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226977630523394',1,NULL,3,'推送销售订单'),
('1436226977747963905',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226977701826561',1,NULL,3,'推送销售订单'),
('1436226977823461378',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226977777324034',1,NULL,3,'推送销售订单'),
('1436226977894764546',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226977844432897',1,NULL,3,'推送销售订单'),
('1436226977982844930',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226977911541762',1,NULL,3,'推送销售订单'),
('1436226978041565185',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226978003816450',1,NULL,3,'推送销售订单'),
('1436226978104479746',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226978062536705',1,NULL,3,'推送销售订单'),
('1436226978167394306',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226978129645570',1,NULL,3,'推送销售订单'),
('1436226978226114562',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226978188365826',1,NULL,3,'推送销售订单'),
('1436226978289029121',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226978251280385',1,NULL,3,'推送销售订单'),
('1436226978347749377',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226978310000642',1,NULL,3,'推送销售订单'),
('1436226978410663938',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226978368720898',1,NULL,3,'推送销售订单'),
('1436226978473578497',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226978431635457',1,NULL,3,'推送销售订单'),
('1436226978544881665',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226978494550018',1,NULL,3,'推送销售订单'),
('1436226978611990530',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226978570047490',1,NULL,3,'推送销售订单'),
('1436226978670710786',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226978628767745',1,NULL,3,'推送销售订单'),
('1436226978729431042',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226978691682306',1,NULL,3,'推送销售订单'),
('1436226978788151297',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226978750402561',1,NULL,3,'推送销售订单'),
('1436226978851065857',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226978817511425',1,NULL,3,'推送销售订单'),
('1436226978901397505',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226978867843073',1,NULL,3,'推送销售订单'),
('1436226978955923457',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226978918174721',1,NULL,3,'推送销售订单'),
('1436226979014643713',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226978976894978',1,NULL,3,'推送销售订单'),
('1436226979073363969',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226979039809538',1,NULL,3,'推送销售订单'),
('1436226979132084226',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226979094335490',1,NULL,3,'推送销售订单'),
('1436226979228553217',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226979186610178',1,NULL,3,'推送销售订单'),
('1436226979283079170',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226979249524738',1,NULL,3,'推送销售订单'),
('1436226979337605122',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226979299856386',1,NULL,3,'推送销售订单'),
('1436226979392131073',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226979354382338',1,NULL,3,'推送销售订单'),
('1436226979450851330',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226979413102593',1,NULL,3,'推送销售订单'),
('1436226979505377281',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226979467628546',1,NULL,3,'推送销售订单'),
('1436226979559903234',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226979522154497',1,NULL,3,'推送销售订单'),
('1436226979614429186',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192495\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:01:09\",\"sono\":\"SEORD130527\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226979576680449',1,NULL,3,'推送销售订单'),
('1436226979673149442',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192496\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:02:10\",\"sono\":\"SEORD130528\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226979635400705',1,NULL,3,'推送销售订单'),
('1436226979740258305',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192497\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:03:11\",\"sono\":\"SEORD130529\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226979694120961',1,NULL,3,'推送销售订单'),
('1436226979798978561',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192498\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:04:12\",\"sono\":\"SEORD130530\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226979761229826',1,NULL,3,'推送销售订单'),
('1436226979874476034',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192499\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:05:13\",\"sono\":\"SEORD130531\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226979832532994',1,NULL,3,'推送销售订单'),
('1436226979937390593',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192500\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:06:14\",\"sono\":\"SEORD130532\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226979899641858',1,NULL,3,'推送销售订单'),
('1436226980004499458',0,'成功','2021-09-10 15:16:10','{\"fid\":\"192501\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:07:15\",\"sono\":\"SEORD130533\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226979966750721',1,NULL,3,'推送销售订单'),
('1436226980067414017',0,'成功','2021-09-10 15:16:11','{\"fid\":\"192502\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:08:16\",\"sono\":\"SEORD130534\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226980029665282',1,NULL,3,'推送销售订单'),
('1436226980138717185',0,'成功','2021-09-10 15:16:11','{\"fid\":\"192503\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:09:17\",\"sono\":\"SEORD130535\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226980088385538',1,NULL,3,'推送销售订单'),
('1436226980201631746',0,'成功','2021-09-10 15:16:11','{\"fid\":\"192504\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:10:18\",\"sono\":\"SEORD130536\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226980159688706',1,NULL,3,'推送销售订单'),
('1436226980264546305',0,'成功','2021-09-10 15:16:11','{\"fid\":\"192505\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:11:19\",\"sono\":\"SEORD130537\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226980222603266',1,NULL,3,'推送销售订单'),
('1436226980348432385',0,'成功','2021-09-10 15:16:11','{\"fid\":\"192506\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:12:20\",\"sono\":\"SEORD130538\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226980298100738',1,NULL,3,'推送销售订单'),
('1436226980407152641',0,'成功','2021-09-10 15:16:11','{\"fid\":\"192507\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:13:21\",\"sono\":\"SEORD130539\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226980369403906',1,NULL,3,'推送销售订单'),
('1436226980465872898',0,'成功','2021-09-10 15:16:11','{\"fid\":\"192508\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:14:22\",\"sono\":\"SEORD130540\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226980428124161',1,NULL,3,'推送销售订单'),
('1436226980574924802',0,'成功','2021-09-10 15:16:11','{\"fid\":\"192509\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:15:23\",\"sono\":\"SEORD130541\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226980503621634',1,NULL,3,'推送销售订单'),
('1436226980637839362',0,'成功','2021-09-10 15:16:11','{\"fid\":\"192510\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:16:04\",\"sono\":\"SEORD130542\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436226980600090625',1,NULL,3,'推送销售订单'),
('1436227041224560641',0,'成功','2021-09-10 15:16:25','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436227041178423297',1,NULL,4,'推送生产订单'),
('1436227237027254274',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227236981116929',1,NULL,3,'推送销售订单'),
('1436227237115334658',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227237060808705',1,NULL,3,'推送销售订单'),
('1436227237182443521',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227237136306178',1,NULL,3,'推送销售订单'),
('1436227237245358081',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227237203415042',1,NULL,3,'推送销售订单'),
('1436227237304078338',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227237266329602',1,NULL,3,'推送销售订单'),
('1436227237366992898',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227237320855554',1,NULL,3,'推送销售订单'),
('1436227237434101762',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227237387964417',1,NULL,3,'推送销售订单'),
('1436227237497016321',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227237455073282',1,NULL,3,'推送销售订单'),
('1436227237580902401',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227237517987842',1,NULL,3,'推送销售订单'),
('1436227237719314433',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227237627039745',1,NULL,3,'推送销售订单'),
('1436227237861920769',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227237765451777',1,NULL,3,'推送销售订单'),
('1436227238012915714',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227237924835329',1,NULL,3,'推送销售订单'),
('1436227238092607489',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227238038081537',1,NULL,3,'推送销售订单'),
('1436227238163910657',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227238121967617',1,NULL,3,'推送销售订单'),
('1436227238251991042',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227238193270786',1,NULL,3,'推送销售订单'),
('1436227238323294209',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227238281351170',1,NULL,3,'推送销售订单'),
('1436227238398791681',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227238356848642',1,NULL,3,'推送销售订单'),
('1436227238553980929',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227238470094850',1,NULL,3,'推送销售订单'),
('1436227238616895490',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227238570758145',1,NULL,3,'推送销售订单'),
('1436227238696587265',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227238654644225',1,NULL,3,'推送销售订单'),
('1436227238763696129',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227238717558786',1,NULL,3,'推送销售订单'),
('1436227238826610690',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227238780473345',1,NULL,3,'推送销售订单'),
('1436227238906302465',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227238847582209',1,NULL,3,'推送销售订单'),
('1436227239078268929',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227238927273985',1,NULL,3,'推送销售订单'),
('1436227239145377794',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227239099240450',1,NULL,3,'推送销售订单'),
('1436227239216680962',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227239162155009',1,NULL,3,'推送销售订单'),
('1436227239283789825',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227239237652481',1,NULL,3,'推送销售订单'),
('1436227239338315778',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227239300567041',1,NULL,3,'推送销售订单'),
('1436227239397036033',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227239359287297',1,NULL,3,'推送销售订单'),
('1436227239451561986',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227239413813249',1,NULL,3,'推送销售订单'),
('1436227239510282242',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227239472533506',1,NULL,3,'推送销售订单'),
('1436227239577391106',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227239527059457',1,NULL,3,'推送销售订单'),
('1436227239636111361',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227239598362626',1,NULL,3,'推送销售订单'),
('1436227239699025921',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227239657082882',1,NULL,3,'推送销售订单'),
('1436227239770329089',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227239719997442',1,NULL,3,'推送销售订单'),
('1436227239950684162',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227239908741122',1,NULL,3,'推送销售订单'),
('1436227239963267073',0,'成功','2021-09-10 15:17:12','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227239967461378',1,NULL,3,'推送销售订单'),
('1436227240084901889',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227240042958850',1,NULL,3,'推送销售订单'),
('1436227240143622146',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227240101679105',1,NULL,3,'推送销售订单'),
('1436227240198148098',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227240160399361',1,NULL,3,'推送销售订单'),
('1436227240261062657',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227240214925314',1,NULL,3,'推送销售订单'),
('1436227240328171521',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192495\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:01:09\",\"sono\":\"SEORD130527\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227240277839874',1,NULL,3,'推送销售订单'),
('1436227240441417729',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192496\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:02:10\",\"sono\":\"SEORD130528\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227240357531649',1,NULL,3,'推送销售订单'),
('1436227240516915201',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192497\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:03:11\",\"sono\":\"SEORD130529\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227240479166465',1,NULL,3,'推送销售订单'),
('1436227240613384194',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192498\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:04:12\",\"sono\":\"SEORD130530\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227240554663938',1,NULL,3,'推送销售订单'),
('1436227240684687362',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192499\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:05:13\",\"sono\":\"SEORD130531\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227240630161410',1,NULL,3,'推送销售订单'),
('1436227240755990529',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192500\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:06:14\",\"sono\":\"SEORD130532\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227240701464577',1,NULL,3,'推送销售订单'),
('1436227240818905090',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192501\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:07:15\",\"sono\":\"SEORD130533\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227240776962050',1,NULL,3,'推送销售订单'),
('1436227240881819649',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192502\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:08:16\",\"sono\":\"SEORD130534\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227240835682306',1,NULL,3,'推送销售订单'),
('1436227240948928513',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192503\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:09:17\",\"sono\":\"SEORD130535\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227240898596865',1,NULL,3,'推送销售订单'),
('1436227241057980418',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192504\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:10:18\",\"sono\":\"SEORD130536\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227240969900033',1,NULL,3,'推送销售订单'),
('1436227241129283586',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192505\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:11:19\",\"sono\":\"SEORD130537\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227241087340546',1,NULL,3,'推送销售订单'),
('1436227241217363970',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192506\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:12:20\",\"sono\":\"SEORD130538\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227241175420929',1,NULL,3,'推送销售订单'),
('1436227241280278530',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192507\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:13:21\",\"sono\":\"SEORD130539\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227241238335489',1,NULL,3,'推送销售订单'),
('1436227241347387393',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192508\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:14:22\",\"sono\":\"SEORD130540\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227241305444354',1,NULL,3,'推送销售订单'),
('1436227241414496258',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192509\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:15:23\",\"sono\":\"SEORD130541\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227241376747521',1,NULL,3,'推送销售订单'),
('1436227241477410818',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192510\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:16:04\",\"sono\":\"SEORD130542\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227241435467778',1,NULL,3,'推送销售订单'),
('1436227241540325377',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192511\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:16:24\",\"sono\":\"SEORD130543\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227241498382337',1,NULL,3,'推送销售订单'),
('1436227241599045633',0,'成功','2021-09-10 15:17:13','{\"fid\":\"192512\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:17:05\",\"sono\":\"SEORD130544\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227241565491202',1,NULL,3,'推送销售订单'),
('1436227297915965442',0,'成功','2021-09-10 15:17:26','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436227297874022402',1,NULL,4,'推送生产订单'),
('1436227496159744002',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227496117800961',1,NULL,3,'推送销售订单'),
('1436227496252018689',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227496189104129',1,NULL,3,'推送销售订单'),
('1436227496327516162',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227496277184514',1,NULL,3,'推送销售订单'),
('1436227496419790850',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227496348487682',1,NULL,3,'推送销售订单'),
('1436227496503676930',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227496444956674',1,NULL,3,'推送销售订单'),
('1436227496566591490',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227496520454145',1,NULL,3,'推送销售订单'),
('1436227496625311746',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227496587563009',1,NULL,3,'推送销售订单'),
('1436227496688226305',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227496642088961',1,NULL,3,'推送销售订单'),
('1436227496759529473',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227496721780738',1,NULL,3,'推送销售订单'),
('1436227496835026946',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227496776306689',1,NULL,3,'推送销售订单'),
('1436227496910524417',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227496855998466',1,NULL,3,'推送销售订单'),
('1436227496998604802',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227496952467457',1,NULL,3,'推送销售订单'),
('1436227497061519361',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227497019576322',1,NULL,3,'推送销售订单'),
('1436227497137016834',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227497090879489',1,NULL,3,'推送销售订单'),
('1436227497199931394',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227497149599746',1,NULL,3,'推送销售订单'),
('1436227497254457345',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227497216708609',1,NULL,3,'推送销售订单'),
('1436227497308983298',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227497271234562',1,NULL,3,'推送销售订单'),
('1436227497371897857',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227497329954818',1,NULL,3,'推送销售订单'),
('1436227497422229505',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227497388675074',1,NULL,3,'推送销售订单'),
('1436227497485144065',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227497447395330',1,NULL,3,'推送销售订单'),
('1436227497556447234',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227497514504193',1,NULL,3,'推送销售订单'),
('1436227497619361793',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227497573224449',1,NULL,3,'推送销售订单'),
('1436227497682276354',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227497636139009',1,NULL,3,'推送销售订单'),
('1436227497887797250',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227497703247874',1,NULL,3,'推送销售订单'),
('1436227497942323202',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227497912963074',1,NULL,3,'推送销售订单'),
('1436227498009432065',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227497959100418',1,NULL,3,'推送销售订单'),
('1436227498055569410',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227498026209281',1,NULL,3,'推送销售订单'),
('1436227498105901057',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227498072346626',1,NULL,3,'推送销售订单'),
('1436227498156232705',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227498122678273',1,NULL,3,'推送销售订单'),
('1436227498223341570',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227498185592833',1,NULL,3,'推送销售订单'),
('1436227498269478914',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227498235924481',1,NULL,3,'推送销售订单'),
('1436227498315616258',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227498286256130',1,NULL,3,'推送销售订单'),
('1436227498365947906',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227498332393473',1,NULL,3,'推送销售订单'),
('1436227498412085249',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227498378530817',1,NULL,3,'推送销售订单'),
('1436227498462416898',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227498428862465',1,NULL,3,'推送销售订单'),
('1436227498521137153',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227498479194113',1,NULL,3,'推送销售订单'),
('1436227498588246017',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227498546302978',1,NULL,3,'推送销售订单'),
('1436227498701492226',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227498600828930',1,NULL,3,'推送销售订单'),
('1436227498760212481',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227498722463746',1,NULL,3,'推送销售订单'),
('1436227498810544129',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227498776989697',1,NULL,3,'推送销售订单'),
('1436227498873458690',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227498835709953',1,NULL,3,'推送销售订单'),
('1436227498923790338',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192495\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:01:09\",\"sono\":\"SEORD130527\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227498886041601',1,NULL,3,'推送销售订单'),
('1436227499003482114',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192496\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:02:10\",\"sono\":\"SEORD130528\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227498936373250',1,NULL,3,'推送销售订单'),
('1436227499058008065',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192497\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:03:11\",\"sono\":\"SEORD130529\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227499020259330',1,NULL,3,'推送销售订单'),
('1436227499120922626',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192498\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:04:12\",\"sono\":\"SEORD130530\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227499074785282',1,NULL,3,'推送销售订单'),
('1436227499179642881',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192499\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:05:13\",\"sono\":\"SEORD130531\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227499150282754',1,NULL,3,'推送销售订单'),
('1436227499229974530',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192500\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:06:14\",\"sono\":\"SEORD130532\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227499196420097',1,NULL,3,'推送销售订单'),
('1436227499313860610',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192501\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:07:15\",\"sono\":\"SEORD130533\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227499276111874',1,NULL,3,'推送销售订单'),
('1436227499372580865',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192502\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:08:16\",\"sono\":\"SEORD130534\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227499326443522',1,NULL,3,'推送销售订单'),
('1436227499422912513',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192503\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:09:17\",\"sono\":\"SEORD130535\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227499389358082',1,NULL,3,'推送销售订单'),
('1436227499473244162',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192504\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:10:18\",\"sono\":\"SEORD130536\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227499435495425',1,NULL,3,'推送销售订单'),
('1436227499523575810',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192505\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:11:19\",\"sono\":\"SEORD130537\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227499490021378',1,NULL,3,'推送销售订单'),
('1436227499578101762',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192506\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:12:20\",\"sono\":\"SEORD130538\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227499540353026',1,NULL,3,'推送销售订单'),
('1436227499649404929',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192507\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:13:21\",\"sono\":\"SEORD130539\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227499615850497',1,NULL,3,'推送销售订单'),
('1436227499699736577',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192508\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:14:22\",\"sono\":\"SEORD130540\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227499666182146',1,NULL,3,'推送销售订单'),
('1436227499750068226',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192509\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:15:23\",\"sono\":\"SEORD130541\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227499720708098',1,NULL,3,'推送销售订单'),
('1436227499804594178',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192510\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:16:04\",\"sono\":\"SEORD130542\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227499766845442',1,NULL,3,'推送销售订单'),
('1436227499867508737',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192511\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:16:24\",\"sono\":\"SEORD130543\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227499829760002',1,NULL,3,'推送销售订单'),
('1436227499930423297',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192512\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:17:05\",\"sono\":\"SEORD130544\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227499884285954',1,NULL,3,'推送销售订单'),
('1436227500022697986',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192513\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:17:25\",\"sono\":\"SEORD130545\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227499963977729',1,NULL,3,'推送销售订单'),
('1436227500089806850',0,'成功','2021-09-10 15:18:14','{\"fid\":\"192514\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:17:56\",\"sono\":\"SEORD130546\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227500052058113',1,NULL,3,'推送销售订单'),
('1436227500190470146',0,'成功','2021-09-10 15:18:15','{\"fid\":\"192515\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:17:57\",\"sono\":\"SEORD130547\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227500127555586',1,NULL,3,'推送销售订单'),
('1436227553697206274',0,'成功','2021-09-10 15:18:27','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436227553659457538',1,NULL,4,'推送生产订单'),
('1436227753987805186',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227753945862145',1,NULL,3,'推送销售订单'),
('1436227754046525442',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227754008776705',1,NULL,3,'推送销售订单'),
('1436227754105245697',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227754063302658',1,NULL,3,'推送销售订单'),
('1436227754168160258',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227754122022913',1,NULL,3,'推送销售订单'),
('1436227754235269122',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227754189131778',1,NULL,3,'推送销售订单'),
('1436227754302377985',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227754256240642',1,NULL,3,'推送销售订单'),
('1436227754361098242',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227754319155201',1,NULL,3,'推送销售订单'),
('1436227754419818498',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227754382069762',1,NULL,3,'推送销售订单'),
('1436227754495315969',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227754440790017',1,NULL,3,'推送销售订单'),
('1436227754554036226',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227754507898881',1,NULL,3,'推送销售订单'),
('1436227754604367874',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227754570813441',1,NULL,3,'推送销售订单'),
('1436227754658893826',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227754621145089',1,NULL,3,'推送销售订单'),
('1436227754734391298',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227754700836865',1,NULL,3,'推送销售订单'),
('1436227754784722945',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227754751168514',1,NULL,3,'推送销售订单'),
('1436227754835054593',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227754801500161',1,NULL,3,'推送销售订单'),
('1436227754885386242',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227754851831810',1,NULL,3,'推送销售订单'),
('1436227754935717889',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227754902163458',1,NULL,3,'推送销售订单'),
('1436227754986049538',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227754948300802',1,NULL,3,'推送销售订单'),
('1436227755032186881',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227754998632450',1,NULL,3,'推送销售订单'),
('1436227755107684354',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227755048964098',1,NULL,3,'推送销售订单'),
('1436227755158016001',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227755120267266',1,NULL,3,'推送销售订单'),
('1436227755250290689',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227755191570434',1,NULL,3,'推送销售订单'),
('1436227755300622337',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227755262873601',1,NULL,3,'推送销售订单'),
('1436227755355148290',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227755317399553',1,NULL,3,'推送销售订单'),
('1436227755401285634',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227755371925506',1,NULL,3,'推送销售订单'),
('1436227755455811586',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227755418062849',1,NULL,3,'推送销售订单'),
('1436227755506143234',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227755472588802',1,NULL,3,'推送销售订单'),
('1436227755552280577',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227755522920449',1,NULL,3,'推送销售订单'),
('1436227755602612226',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227755569057793',1,NULL,3,'推送销售订单'),
('1436227755657138178',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227755623583745',1,NULL,3,'推送销售订单'),
('1436227755707469825',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227755673915393',1,NULL,3,'推送销售订单'),
('1436227755753607169',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227755720052737',1,NULL,3,'推送销售订单'),
('1436227755803938818',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227755766190082',1,NULL,3,'推送销售订单'),
('1436227755854270466',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227755820716033',1,NULL,3,'推送销售订单'),
('1436227755904602114',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227755866853377',1,NULL,3,'推送销售订单'),
('1436227755959128065',0,'成功','2021-09-10 15:19:15','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227755917185025',1,NULL,3,'推送销售订单'),
('1436227756005265410',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227755975905282',1,NULL,3,'推送销售订单'),
('1436227756055597058',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227756022042625',1,NULL,3,'推送销售订单'),
('1436227756105928705',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227756068179969',1,NULL,3,'推送销售订单'),
('1436227756168843266',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227756135288834',1,NULL,3,'推送销售订单'),
('1436227756219174914',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227756185620482',1,NULL,3,'推送销售订单'),
('1436227756269506562',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192495\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:01:09\",\"sono\":\"SEORD130527\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227756235952130',1,NULL,3,'推送销售订单'),
('1436227756345004034',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192496\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:02:10\",\"sono\":\"SEORD130528\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227756294672385',1,NULL,3,'推送销售订单'),
('1436227756403724289',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192497\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:03:11\",\"sono\":\"SEORD130529\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227756365975553',1,NULL,3,'推送销售订单'),
('1436227756466638849',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192498\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:04:12\",\"sono\":\"SEORD130530\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227756428890113',1,NULL,3,'推送销售订单'),
('1436227756542136321',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192499\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:05:13\",\"sono\":\"SEORD130531\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227756487610370',1,NULL,3,'推送销售订单'),
('1436227756588273666',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192500\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:06:14\",\"sono\":\"SEORD130532\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227756554719233',1,NULL,3,'推送销售订单'),
('1436227756684742658',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192501\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:07:15\",\"sono\":\"SEORD130533\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227756605050882',1,NULL,3,'推送销售订单'),
('1436227756739268609',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192502\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:08:16\",\"sono\":\"SEORD130534\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227756705714178',1,NULL,3,'推送销售订单'),
('1436227756785405954',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192503\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:09:17\",\"sono\":\"SEORD130535\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227756756045826',1,NULL,3,'推送销售订单'),
('1436227756990926849',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192504\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:10:18\",\"sono\":\"SEORD130536\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227756953178113',1,NULL,3,'推送销售订单'),
('1436227757045452801',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192505\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:11:19\",\"sono\":\"SEORD130537\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227757007704065',1,NULL,3,'推送销售订单'),
('1436227757099978753',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192506\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:12:20\",\"sono\":\"SEORD130538\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227757062230017',1,NULL,3,'推送销售订单'),
('1436227757150310402',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192507\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:13:21\",\"sono\":\"SEORD130539\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227757112561665',1,NULL,3,'推送销售订单'),
('1436227757196447746',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192508\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:14:22\",\"sono\":\"SEORD130540\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227757162893313',1,NULL,3,'推送销售订单'),
('1436227757246779394',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192509\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:15:23\",\"sono\":\"SEORD130541\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227757209030658',1,NULL,3,'推送销售订单'),
('1436227757292916737',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192510\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:16:04\",\"sono\":\"SEORD130542\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227757259362305',1,NULL,3,'推送销售订单'),
('1436227757343248386',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192511\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:16:24\",\"sono\":\"SEORD130543\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227757309693953',1,NULL,3,'推送销售订单'),
('1436227757389385730',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192512\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:17:05\",\"sono\":\"SEORD130544\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227757364219906',1,NULL,3,'推送销售订单'),
('1436227757443911682',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192513\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:17:25\",\"sono\":\"SEORD130545\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227757406162945',1,NULL,3,'推送销售订单'),
('1436227757494243330',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192514\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:17:56\",\"sono\":\"SEORD130546\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436227757464883201',1,NULL,3,'推送销售订单'),
('1436227757544574978',0,'成功','2021-09-10 15:19:16','{\"fid\":\"192515\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:17:57\",\"sono\":\"SEORD130547\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436227757506826241',1,NULL,3,'推送销售订单'),
('1436227806244638721',0,'成功','2021-09-10 15:19:27','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436227806206889985',1,NULL,4,'推送生产订单'),
('1436228010884730881',0,'成功','2021-09-10 15:20:16','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436228010830204929',1,NULL,3,'推送销售订单'),
('1436228010951839746',0,'成功','2021-09-10 15:20:16','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436228010905702401',1,NULL,3,'推送销售订单'),
('1436228011006365698',0,'成功','2021-09-10 15:20:16','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436228010968616961',1,NULL,3,'推送销售订单'),
('1436228011060891649',0,'成功','2021-09-10 15:20:16','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436228011023142914',1,NULL,3,'推送销售订单'),
('1436228011123806209',0,'成功','2021-09-10 15:20:16','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436228011086057473',1,NULL,3,'推送销售订单'),
('1436228011182526465',0,'成功','2021-09-10 15:20:16','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436228011144777730',1,NULL,3,'推送销售订单'),
('1436228011249635329',0,'成功','2021-09-10 15:20:16','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436228011203497986',1,NULL,3,'推送销售订单'),
('1436228011304161281',0,'成功','2021-09-10 15:20:16','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436228011270606849',1,NULL,3,'推送销售订单'),
('1436228011358687233',0,'成功','2021-09-10 15:20:16','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228011320938497',1,NULL,3,'推送销售订单'),
('1436228011409018881',0,'成功','2021-09-10 15:20:16','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228011371270145',1,NULL,3,'推送销售订单'),
('1436228011459350530',0,'成功','2021-09-10 15:20:16','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228011425796098',1,NULL,3,'推送销售订单'),
('1436228011518070785',0,'成功','2021-09-10 15:20:16','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228011476127745',1,NULL,3,'推送销售订单'),
('1436228011576791042',0,'成功','2021-09-10 15:20:16','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228011539042306',1,NULL,3,'推送销售订单'),
('1436228011648094210',0,'成功','2021-09-10 15:20:16','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228011601956866',1,NULL,3,'推送销售订单'),
('1436228011711008770',0,'成功','2021-09-10 15:20:16','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228011664871425',1,NULL,3,'推送销售订单'),
('1436228011769729026',0,'成功','2021-09-10 15:20:16','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228011731980289',1,NULL,3,'推送销售订单'),
('1436228011820060674',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228011782311937',1,NULL,3,'推送销售订单'),
('1436228011899752449',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228011849420801',1,NULL,3,'推送销售订单'),
('1436228011983638530',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228011916529666',1,NULL,3,'推送销售订单'),
('1436228012059136001',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228012000415745',1,NULL,3,'推送销售订单'),
('1436228012138827777',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228012084301826',1,NULL,3,'推送销售订单'),
('1436228012239491074',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228012163993601',1,NULL,3,'推送销售订单'),
('1436228012302405633',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228012260462593',1,NULL,3,'推送销售订单'),
('1436228012382097409',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228012327571458',1,NULL,3,'推送销售订单'),
('1436228012524703746',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228012449206273',1,NULL,3,'推送销售订单'),
('1436228012637949953',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228012575035394',1,NULL,3,'推送销售订单'),
('1436228012747001857',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228012679892994',1,NULL,3,'推送销售订单'),
('1436228012910579713',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228012814110722',1,NULL,3,'推送销售订单'),
('1436228012973494274',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228012935745538',1,NULL,3,'推送销售订单'),
('1436228013036408833',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228013002854402',1,NULL,3,'推送销售订单'),
('1436228013095129089',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228013061574658',1,NULL,3,'推送销售订单'),
('1436228013149655041',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228013120294914',1,NULL,3,'推送销售订单'),
('1436228013212569602',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:51:59\",\"sono\":\"SEORD130518\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228013174820866',1,NULL,3,'推送销售订单'),
('1436228013304844289',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192487\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:53:00\",\"sono\":\"SEORD130519\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228013254512642',1,NULL,3,'推送销售订单'),
('1436228013380341762',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192488\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:54:01\",\"sono\":\"SEORD130520\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228013338398721',1,NULL,3,'推送销售订单'),
('1436228013451644930',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192489\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:55:02\",\"sono\":\"SEORD130521\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228013409701890',1,NULL,3,'推送销售订单'),
('1436228013543919618',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192490\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:56:03\",\"sono\":\"SEORD130522\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228013485199361',1,NULL,3,'推送销售订单'),
('1436228013632000002',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192491\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:57:04\",\"sono\":\"SEORD130523\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228013585862657',1,NULL,3,'推送销售订单'),
('1436228013715886081',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192492\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:58:05\",\"sono\":\"SEORD130524\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228013678137346',1,NULL,3,'推送销售订单'),
('1436228013782994945',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192493\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:59:07\",\"sono\":\"SEORD130525\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228013745246210',1,NULL,3,'推送销售订单'),
('1436228013841715202',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192494\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:00:08\",\"sono\":\"SEORD130526\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228013803966466',1,NULL,3,'推送销售订单'),
('1436228013896241154',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192495\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:01:09\",\"sono\":\"SEORD130527\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228013862686722',1,NULL,3,'推送销售订单'),
('1436228013996904449',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192496\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:02:10\",\"sono\":\"SEORD130528\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228013954961410',1,NULL,3,'推送销售订单'),
('1436228014068207618',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192497\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:03:11\",\"sono\":\"SEORD130529\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228014030458881',1,NULL,3,'推送销售订单'),
('1436228014152093697',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192498\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:04:12\",\"sono\":\"SEORD130530\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228014105956353',1,NULL,3,'推送销售订单'),
('1436228014219202562',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192499\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:05:13\",\"sono\":\"SEORD130531\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228014177259522',1,NULL,3,'推送销售订单'),
('1436228014277922817',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192500\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:06:14\",\"sono\":\"SEORD130532\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228014240174081',1,NULL,3,'推送销售订单'),
('1436228014345031682',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192501\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:07:15\",\"sono\":\"SEORD130533\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228014307282945',1,NULL,3,'推送销售订单'),
('1436228014416334849',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192502\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:08:16\",\"sono\":\"SEORD130534\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228014374391810',1,NULL,3,'推送销售订单'),
('1436228014491832322',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192503\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:09:17\",\"sono\":\"SEORD130535\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228014445694978',1,NULL,3,'推送销售订单'),
('1436228014575718401',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192504\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:10:18\",\"sono\":\"SEORD130536\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228014533775361',1,NULL,3,'推送销售订单'),
('1436228014655410178',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192505\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:11:19\",\"sono\":\"SEORD130537\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228014609272833',1,NULL,3,'推送销售订单'),
('1436228014714130434',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192506\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:12:20\",\"sono\":\"SEORD130538\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228014676381697',1,NULL,3,'推送销售订单'),
('1436228014877708290',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192507\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:13:21\",\"sono\":\"SEORD130539\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228014735101953',1,NULL,3,'推送销售订单'),
('1436228014965788673',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192508\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:14:22\",\"sono\":\"SEORD130540\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228014898679809',1,NULL,3,'推送销售订单'),
('1436228015502659585',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192509\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:15:23\",\"sono\":\"SEORD130541\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228015464910849',1,NULL,3,'推送销售订单'),
('1436228015565574146',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192510\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:16:04\",\"sono\":\"SEORD130542\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228015523631106',1,NULL,3,'推送销售订单'),
('1436228015620100097',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192511\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:16:24\",\"sono\":\"SEORD130543\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228015586545666',1,NULL,3,'推送销售订单'),
('1436228015670431746',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192512\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:17:05\",\"sono\":\"SEORD130544\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228015636877313',1,NULL,3,'推送销售订单'),
('1436228015720763393',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192513\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:17:25\",\"sono\":\"SEORD130545\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228015691403265',1,NULL,3,'推送销售订单'),
('1436228015775289345',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192514\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:17:56\",\"sono\":\"SEORD130546\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228015741734914',1,NULL,3,'推送销售订单'),
('1436228015829815298',0,'成功','2021-09-10 15:20:17','{\"fid\":\"192515\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 15:17:57\",\"sono\":\"SEORD130547\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436228015800455169',1,NULL,3,'推送销售订单'),
('1436228058947260418',0,'成功','2021-09-10 15:20:28','{\"fid\":\"102241\",\"productmodel\":\" \",\"amount\":\"10.0\",\"planfinishdate\":\"2021-09-11 00:00:00\",\"materialscode\":\"3901528\",\"materialsunit\":\"10101\",\"ipostatus\":\"3\",\"materialsname\":\"物料子项2\",\"planstartdate\":\"2021-09-11 00:00:00\",\"workshopname\":\"356054\",\"ipono\":\"MO002102\",\"datasource\":\"0\",\"datasourcecreatetime\":\"2021-09-10 14:29:20\",\"purchaserhqcode\":\"SGCC\",\"ipotype\":\"6110dca2a8f2d2\",\"productidgrpno\":\"1\",\"productidtype\":\"1\"}','1436228058901123073',1,NULL,4,'推送生产订单'),
('1436228269635538945',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192454\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:19:15\",\"sono\":\"SEORD130486\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436228269572624385',1,NULL,3,'推送销售订单'),
('1436228269694259201',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192455\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:20:20\",\"sono\":\"SEORD130487\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436228269656510465',1,NULL,3,'推送销售订单'),
('1436228269761368065',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192456\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:21:22\",\"sono\":\"SEORD130488\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436228269723619330',1,NULL,3,'推送销售订单'),
('1436228269845254146',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192457\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:22:23\",\"sono\":\"SEORD130489\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436228269811699713',1,NULL,3,'推送销售订单'),
('1436228269929140225',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192458\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:23:24\",\"sono\":\"SEORD130490\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436228269878808577',1,NULL,3,'推送销售订单'),
('1436228270000443393',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192459\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:24:25\",\"sono\":\"SEORD130491\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436228269954306049',1,NULL,3,'推送销售订单'),
('1436228270080135170',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192460\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:25:26\",\"sono\":\"SEORD130492\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436228270025609217',1,NULL,3,'推送销售订单'),
('1436228270151438338',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192461\",\"productcode\":\"1591847\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:26:27\",\"sono\":\"SEORD130493\",\"suppliercode\":\"linqin\",\"productname\":\"LB 螺钉\",\"purchaserhqcode\":\"SGCC\"}','1436228270109495298',1,NULL,3,'推送销售订单'),
('1436228270226935809',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192462\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"C\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:27:28\",\"sono\":\"SEORD130494\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228270180798465',1,NULL,3,'推送销售订单'),
('1436228270294044673',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192463\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:28:29\",\"sono\":\"SEORD130495\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228270247907329',1,NULL,3,'推送销售订单'),
('1436228270344376322',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192464\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:29:32\",\"sono\":\"SEORD130496\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228270310821889',1,NULL,3,'推送销售订单'),
('1436228270403096578',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192465\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:30:34\",\"sono\":\"SEORD130497\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228270369542145',1,NULL,3,'推送销售订单'),
('1436228270466011138',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192466\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:31:35\",\"sono\":\"SEORD130498\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228270432456705',1,NULL,3,'推送销售订单'),
('1436228270520537090',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192467\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:32:36\",\"sono\":\"SEORD130499\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228270486982658',1,NULL,3,'推送销售订单'),
('1436228270570868737',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192468\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:33:37\",\"sono\":\"SEORD130500\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228270537314305',1,NULL,3,'推送销售订单'),
('1436228270617006081',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192469\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:34:39\",\"sono\":\"SEORD130501\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228270583451650',1,NULL,3,'推送销售订单'),
('1436228270705086466',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192470\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:35:40\",\"sono\":\"SEORD130502\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228270642171906',1,NULL,3,'推送销售订单'),
('1436228270763806721',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192471\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:36:41\",\"sono\":\"SEORD130503\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228270721863681',1,NULL,3,'推送销售订单'),
('1436228270814138369',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192472\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:37:42\",\"sono\":\"SEORD130504\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228270780583937',1,NULL,3,'推送销售订单'),
('1436228270881247233',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192473\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:38:44\",\"sono\":\"SEORD130505\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228270830915586',1,NULL,3,'推送销售订单'),
('1436228270944161794',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192474\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:39:45\",\"sono\":\"SEORD130506\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228270898024450',1,NULL,3,'推送销售订单'),
('1436228271023853570',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192475\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:40:46\",\"sono\":\"SEORD130507\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228270960939010',1,NULL,3,'推送销售订单'),
('1436228271082573825',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192476\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:41:47\",\"sono\":\"SEORD130508\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228271044825089',1,NULL,3,'推送销售订单'),
('1436228271141294082',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192477\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:42:49\",\"sono\":\"SEORD130509\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228271107739650',1,NULL,3,'推送销售订单'),
('1436228271195820033',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192478\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:43:50\",\"sono\":\"SEORD130510\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228271162265602',1,NULL,3,'推送销售订单'),
('1436228271267123202',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192479\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:44:51\",\"sono\":\"SEORD130511\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228271212597249',1,NULL,3,'推送销售订单'),
('1436228271330037762',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192480\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:45:52\",\"sono\":\"SEORD130512\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228271283900417',1,NULL,3,'推送销售订单'),
('1436228271397146626',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192481\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:46:53\",\"sono\":\"SEORD130513\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228271359397890',1,NULL,3,'推送销售订单'),
('1436228271464255489',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192482\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:47:54\",\"sono\":\"SEORD130514\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228271418118146',1,NULL,3,'推送销售订单'),
('1436228271531364354',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192483\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:48:55\",\"sono\":\"SEORD130515\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228271481032705',1,NULL,3,'推送销售订单'),
('1436228271594278914',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192484\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:49:57\",\"sono\":\"SEORD130516\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228271552335874',1,NULL,3,'推送销售订单'),
('1436228271657193473',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192485\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus\":\"A\",\"productamount\":\"10.0\",\"datasourcecreatetime\":\"2021-09-10 14:50:58\",\"sono\":\"SEORD130517\",\"suppliercode\":\"linqin\",\"productname\":\"物料子项2\",\"purchaserhqcode\":\"SGCC\"}','1436228271615250434',1,NULL,3,'推送销售订单'),
('1436228271715913729',0,'成功','2021-09-10 15:21:18','{\"fid\":\"192486\",\"productcode\":\"3901551\",\"productunit\":\"10101\",\"datasource\":\"0\",\"sostatus