package org.jeecg.modules.aspect;

import lombok.Data;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.util.RedisLock;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.base.service.BaseCommonService;
import org.jeecg.modules.iost.ims.entity.Vo.ImsRequestVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;


/**
 * 防止短时间内并发提交或者重复提交
 *
 * @Author scott
 * @email jeecgos@163.com
 * @Date 2018年1月14日
 */
@Aspect
@Component
@Data
@Order(2)
public class NotCommitRedisLockAspect {

    @Resource
    private BaseCommonService baseCommonService;

    @Pointcut("@annotation(org.jeecg.modules.aspect.annotation.NotCommitRedisLock)")
    public void logPointCut() {

    }

    @Autowired
    RedisLock redisLock;

    @Around("logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object result = null;
        Object[] args = point.getArgs();
        for (Object arg : args) {
            if (arg instanceof ImsRequestVo) {
                ImsRequestVo request = (ImsRequestVo) arg;
                System.out.println("test-----" + request);
                if (!request.getData().get(0).containsKey("QUEUE_ID")) {
                    //执行方法
                    result = point.proceed();
                    continue;
                }
                String token = redisLock.tryLock(request.getDocType() + request.getData().get(0).get("QUEUE_ID").toString(), 1000 * 60 * 2);
                if (token == null) {
                    return Result.fail("操作失败", "请勿提交相同数据!", request.getDocType());
                }
                Map<String, String> map = ThreadLocalConfig.get();
                if (map == null) {
                    map = new HashMap<>();
                }
                map.put("key", request.getDocType() + request.getData().get(0).get("QUEUE_ID").toString());
                map.put("token", token);
                ThreadLocalConfig.set(map);
                try {
                    //执行方法
                    result = point.proceed();
                } finally {
                    redisLock.unlock(request.getDocType() + request.getData().get(0).get("QUEUE_ID").toString(), token);
                }
            }
        }
        return result;
    }


}
