package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.exception.KingdeeRepeatException;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.entity.ImsBsWplan;
import org.jeecg.modules.iost.ims.kingdeeapi.BsWplanKingdeeApi;
import org.jeecg.modules.iost.ims.service.IImsBsWplanService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;

/**
 * @Description: 主计划基础信息
 * @Author: jeecg-boot
 * @Date: 2021-12-21
 * @Version: V1.0
 */
@Api(tags = "主计划基础信息")
@RestController
@RequestMapping("/imsBsWplan")
@Slf4j
public class ImsBsWplanController extends JeecgController<ImsBsWplan, IImsBsWplanService> {
    @Autowired
    private IImsBsWplanService imsBsWplanService;
    @Autowired
    private BsWplanKingdeeApi bsWplanKingdeeApi;

    /**
     * 分页列表查询
     *
     * @param imsBsWplan
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "主计划基础信息-分页列表查询")
    @ApiOperation(value = "主计划基础信息-分页列表查询", notes = "主计划基础信息-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(ImsBsWplan imsBsWplan,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   String dateString, String codeString, String queueId,
                                   HttpServletRequest req) {
        QueryWrapper<ImsBsWplan> queryWrapper = QueryGenerator.initQueryWrapper(imsBsWplan, req.getParameterMap());
        Page<ImsBsWplan> page = new Page<ImsBsWplan>(pageNo, pageSize);
//		if("null".equals(date)){
//			SimpleDateFormat sdf=new SimpleDateFormat("yyyy_MM_dd");
//			Date parse = null;
//			try {
//				parse = sdf.parse(date);
//			} catch (ParseException e) {
//				e.printStackTrace();
//			}
//			//根据查询日期拿到明天
//			Calendar calendar = Calendar.getInstance();
//			calendar.setTime(parse);
//			calendar.add(Calendar.DATE,1);
//			String parse1=sdf.format(calendar.getTime());
//			queryWrapper.gt("create_time",parse);
//			queryWrapper.lt("create_time",parse1);
//		}
        if (StringUtils.isNotBlank(dateString)) {
            String[] split = dateString.split(",");
            queryWrapper.between("create_time", split[0] + " 00:00:00", split[1] + " 00:00:00");
        }
        if (StringUtils.isNotBlank(codeString)) {
            queryWrapper.eq("wplan_code", codeString);
        }
        queryWrapper.orderByDesc("create_time");
        IPage<ImsBsWplan> pageList = imsBsWplanService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param imsBsWplan
     * @return
     */
    @AutoLog(value = "主计划基础信息-添加")
    @ApiOperation(value = "主计划基础信息-添加", notes = "主计划基础信息-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody ImsBsWplan imsBsWplan) {
        imsBsWplanService.save(imsBsWplan);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param imsBsWplan
     * @return
     */
    @AutoLog(value = "主计划基础信息-编辑")
    @ApiOperation(value = "主计划基础信息-编辑", notes = "主计划基础信息-编辑")
    @PutMapping(value = "/edit")
    public Result<?> edit(@RequestBody ImsBsWplan imsBsWplan) {
        imsBsWplanService.updateById(imsBsWplan);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "主计划基础信息-通过id删除")
    @ApiOperation(value = "主计划基础信息-通过id删除", notes = "主计划基础信息-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name = "id", required = true) String id) {
        imsBsWplanService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "主计划基础信息-批量删除")
    @ApiOperation(value = "主计划基础信息-批量删除", notes = "主计划基础信息-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.imsBsWplanService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    @AutoLog(value = "主计划基础信息-通过id查询")
    @ApiOperation(value = "主计划基础信息-通过id查询", notes = "主计划基础信息-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<?> queryById(@RequestParam(name = "id", required = true) String id) {
        ImsBsWplan imsBsWplan = imsBsWplanService.getById(id);
        if (imsBsWplan == null) {
            return Result.error("未找到对应数据");
        }
        return Result.OK(imsBsWplan);
    }

    /**
     * 导出excel
     *
     * @param request
     * @param imsBsWplan
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ImsBsWplan imsBsWplan) {
        return super.exportXls(request, imsBsWplan, ImsBsWplan.class, "主计划基础信息");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ImsBsWplan.class);
    }

    /**
     * 同步
     *
     * @return
     * @throws ParseException
     */
    @AutoLog(value = "主计划基础信息API-同步")
    @ApiOperation(value = "主计划基础信息API-同步", notes = "主计划基础信息API-同步")
    @PostMapping(value = "/synchronization")
    public Result<?> synchronization(@RequestBody String fBillNo) throws ParseException {
        LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        List<List<Object>> lists = bsWplanKingdeeApi.selectFid(fBillNo);
        if (CollectionUtils.isEmpty(lists)) {
            throw new KingdeeRepeatException("操作失败!", "单据编码为" + fBillNo + "的数据不存在 ", "");
        }
        Boolean flag = false;
        for (List<Object> list : lists) {
            flag = imsBsWplanService.synchronization(list.get(0), null, sysUser);
        }
        if (flag) {
            return Result.OK("同步成功");
        }
        return Result.error("同步失败");
    }

}
