package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.ims.entity.Kingdeelog;
import org.jeecg.modules.iost.ims.service.IKingdeelogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

/**
 * @Description: ims金蝶日志
 * @Author: jeecg-boot
 * @Date: 2021-09-03
 * @Version: V1.0
 */
@Api(tags = "金蝶日志")
@RestController
@RequestMapping("/kingdeelog")
@Slf4j
public class KingdeelogController extends JeecgController<Kingdeelog, IKingdeelogService> {
    @Autowired
    private IKingdeelogService kingdeelogService;

    /**
     * 分页列表查询
     *
     * @param kingdeelog
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "ims金蝶日志-分页列表查询")
    @ApiOperation(value = "ims金蝶日志-分页列表查询", notes = "ims金蝶日志-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(Kingdeelog kingdeelog,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   String dateString, String codeString, String queueId,
                                   HttpServletRequest req, @RequestParam(name = "successStatus") String status,
                                   @RequestParam(name = "date") String date) {
        QueryWrapper<Kingdeelog> queryWrapper = QueryGenerator.initQueryWrapper(kingdeelog, req.getParameterMap());
        Page<Kingdeelog> page = new Page<Kingdeelog>(pageNo, pageSize);
        if (!"null".equals(date)) {
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
            Date parse = null;
            try {
                parse = sdf1.parse(date);
            } catch (ParseException e) {
                e.printStackTrace();
            }
            //根据查询日期拿到明天
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(parse);
            calendar.add(Calendar.DATE, 1);
            String parse1 = sdf1.format(calendar.getTime());
            queryWrapper.gt("createtime", parse);
            queryWrapper.lt("createtime", parse1);
        }
        if (StringUtils.isNotBlank(dateString)) {
            String[] split = dateString.split(",");
            queryWrapper.between("createtime", split[0] + " 00:00:00", split[1] + " 00:00:00");
        }
        if ("1".equals(status)) {
            queryWrapper.eq("synchronization", "true");
        } else if ("2".equals(status)) {
            queryWrapper.eq("synchronization", "false");
        }
        queryWrapper.orderByDesc("createtime");
        IPage<Kingdeelog> pageList = kingdeelogService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param kingdeelog
     * @return
     */
    @AutoLog(value = "ims金蝶日志-添加")
    @ApiOperation(value = "ims金蝶日志-添加", notes = "ims金蝶日志-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody Kingdeelog kingdeelog) {
        kingdeelogService.save(kingdeelog);
        return Result.OK("添加成功！");
    }


    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "ims金蝶日志-批量删除")
    @ApiOperation(value = "ims金蝶日志-批量删除", notes = "ims金蝶日志-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.kingdeelogService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 导出excel
     *
     * @param request
     * @param kingdeelog
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, Kingdeelog kingdeelog) {
        return super.exportXls(request, kingdeelog, Kingdeelog.class, "ims金蝶日志");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, Kingdeelog.class);
    }

}
