package org.jeecg.modules.iost.ims.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.Util.KingdeeLogUtil;
import org.jeecg.modules.iost.ims.entity.Syn;
import org.jeecg.modules.iost.ims.entity.Vo.ConnectParmVo;
import org.jeecg.modules.iost.ims.kingdeeapi.SynKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.SynMapper;
import org.jeecg.modules.iost.ims.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class ISynServiceImpl extends ServiceImpl<SynMapper, Syn> implements ISynService {
    @Autowired
    SynKingdeeApi kingdeeApi;
    @Autowired
    IImsBsSupService bsSupService;
    @Autowired
    IImsBsCustService bsCustService;
    @Autowired
    IImsCompanyService companyService;
    @Autowired
    IImsBsStoreService bsStoreService;
    @Autowired
    IImsBsMtrlService bsMtrlService;
    @Autowired
    IImsBsMtrlTypeService bsMtrlTypeService;
    @Autowired
    IImsBsBomService bsBomService;
    @Autowired
    IImsBsWplanService bsWplanService;
    @Autowired
    IImsBsWplanoutsService bsWplanoutsService;
    @Autowired
    IImsWmsRoService wmsRoService;
    @Autowired
    IImsWmsMnService wmsMnService;
    @Autowired
    IImsWmsAuditService wmsAuditService;
    @Autowired
    IImsSmPoService smPoService;
    @Autowired
    IImsWmsAllotService wmsAllotService;
    @Autowired
    IImsImsNestingAnalysisService nestingAnalysisService;
    @Autowired
    IImsPickingListService iImsPickingListService;

    /**
     * 查询新更新的记录
     *
     * @param connectParmVo
     * @return
     * @throws ParseException
     */
    @Override
    public Boolean synchronization(ConnectParmVo connectParmVo) throws ParseException {

        List<Map<String, String>> maps = kingdeeApi.select(null, null);
        Boolean success = true;
        List<Map<String, Object>> list = new ArrayList<>();
        LoginUser sysUser = null;

        List<Map<String, Object>> uList = new ArrayList<>();
        List<String> collect = maps.stream()
                .filter(m -> !"LQKJ_IMSSync".equals(m.get("formid")))
                .map(m -> m.get("fid"))
                .collect(Collectors.toList());
        collect.forEach(item -> {
            //将金蝶云的数据同步该成1
            Map<String, Object> result = new HashMap<>();
            result.put("FID", item);
            result.put("F_LQKJ_SyncCheck", "1");
            result.put("F_LQKJ_SyndDatetime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            uList.add(result);
        });
        // 修改金蝶云是否同步
        kingdeeApi.batchAdd(uList);

        String logName = "";
        for (Map<String, String> data : maps) {
            try {
                if (!data.get("formid").equals("LQKJ_IMSSync")) {
                    Syn syn = new Syn();
                    //主键
                    syn.setFid(data.get("fid"));
                    //表单名
                    syn.setFormid(data.get("formid"));
                    //表单对应的主键
                    syn.setDataid(data.get("dataid"));
                    syn.setCreatetime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    //把字符串转换成布尔类型
                    syn.setSynchronization("true");
                    this.save(syn);
                    //每次同步一个数据
                    if (data.get("formid").equals("BD_MATERIAL")) {
                        logName = "物料信息同步失败";
                        success = bsMtrlService.synchronization(data.get("dataid"), sysUser);  //物料
                        success = bsMtrlTypeService.synchronization(data.get("dataid"), sysUser);//物料分类
                    } else if (data.get("formid").equals("BD_STOCK")) {
                        logName = "库存管理同步失败";
                        success = bsStoreService.synchronization(data.get("dataid"), sysUser); //库存管理
                    } else if (data.get("formid").equals("BD_Customer")) {
                        logName = "客户同步失败";
                        success = bsCustService.synchronization(data.get("dataid"), sysUser); //客户
                    } else if (data.get("formid").equals("BD_Department")) {
                        logName = "部门同步失败";
                        success = companyService.synchronization(data.get("dataid"), sysUser); //部门
                    } else if (data.get("formid").equals("BD_Supplier")) {
                        logName = "供应商同步失败";
                        success = bsSupService.synchronization(data.get("dataid"), sysUser); //供应商
                    } else if (data.get("formid").equals("PRD_MO")) {
                        logName = "生产订单同步失败";
                        success = bsWplanService.synchronization(data.get("dataid"), data.get("entryId"), sysUser);//生产订单
                    } else if (data.get("formid").equals("SUB_SUBREQORDER")) {
                        logName = "委外订单同步失败";
                        success = bsWplanService.synchronization(data.get("dataid"), data.get("entryId"), sysUser);//委外订单
                    } else if (data.get("formid").equals("ENG_BOM")) {
                        logName = "BOM同步失败";
                        success = bsBomService.synchronization(data.get("dataid"), sysUser);//BOM
                    } else if (data.get("formid").equals("SAL_RETURNNOTICE")) {
                        logName = "退货通知单同步失败";
                        success = wmsRoService.synchronization(data.get("dataid"), sysUser);//退货通知单
                    } else if (data.get("formid").equals("STK_OutStockApply")) {
                        logName = "出库申请单同步失败";
                        success = wmsMnService.synchronization(data.get("dataid"), sysUser);//出库申请单
                    } else if (data.get("formid").equals("SAL_DELIVERYNOTICE")) {
                        logName = "发货通知单同步失败";
                        success = wmsAuditService.synchronization(data.get("dataid"), sysUser);//发货通知单
                    } else if (data.get("formid").equals("PUR_PurchaseOrder")) {
                        logName = "采购订单同步失败";
                        success = smPoService.synchronization(data.get("dataid"), sysUser);//采购订单
                    } else if (data.get("formid").equals("STK_TRANSFERAPPLY")) {
                        logName = "调拨申请单同步失败";
                        success = wmsAllotService.synchronization(data.get("dataid"), sysUser);//调拨申请单
                    } else if (data.get("formid").equals("PRD_MatchAnalyseBill")) {
                        logName = "齐套分析同步失败";
                        success = nestingAnalysisService.synchronization(data.get("dataid"), sysUser);//齐套分析
                    } else if (data.get("formid").equals("LQKJ_ContrastRecord")) {
                        logName = "提料分析同步失败";
                        success = iImsPickingListService.synchronization(data.get("dataid"), sysUser);//提料分析
                    }

                    /*//将金蝶云的数据同步该成1 已同步
                    Map<String, Object> result = new HashMap<>();
                    result.put("FID", data.get("fid"));
                    result.put("F_LQKJ_SyncCheck", "1");
                    result.put("F_LQKJ_SyndDatetime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    kingdeeApi.add(result);*/
                }
            } catch (RuntimeException e) {
                e.printStackTrace();
                new KingdeeLogUtil().synLog(logName, e.getMessage());
            }
        }

        /*//批量保存
        kingdeeApi.batchAdd(list);*/
        return success;
    }

    /**
     * 手动同步查询新更新的记录
     *
     * @param sysUser
     * @return
     * @throws ParseException
     */
    @Override
    public Boolean Manualsynchronization(LoginUser sysUser) throws ParseException {

        List<Map<String, String>> maps = kingdeeApi.select(null, null);
        Boolean success = true;
        List<Map<String, Object>> list = new ArrayList<>();

        List<Map<String, Object>> uList = new ArrayList<>();
        List<String> collect = maps.stream()
                .filter(m -> !"LQKJ_IMSSync".equals(m.get("formid")))
                .map(m -> m.get("fid"))
                .collect(Collectors.toList());
        collect.forEach(item -> {
            //将金蝶云的数据同步该成1
            Map<String, Object> result = new HashMap<>();
            result.put("FID", item);
            result.put("F_LQKJ_SyncCheck", "1");
            result.put("F_LQKJ_SyndDatetime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            uList.add(result);
        });
        // 修改金蝶云是否同步
        kingdeeApi.batchAdd(uList);

        String logName = "";
        for (Map<String, String> data : maps) {
            try {
                if (!data.get("formid").equals("LQKJ_IMSSync")) {
                    Syn syn = new Syn();
                    //主键
                    syn.setFid(data.get("fid"));
                    //表单名
                    syn.setFormid(data.get("formid"));
                    //表单对应的主键
                    syn.setDataid(data.get("dataid"));
                    syn.setCreatetime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    //把字符串转换成布尔类型
                    syn.setSynchronization("true");
                    this.save(syn);
                    //每次同步一个数据
                    if (data.get("formid").equals("BD_MATERIAL")) {
                        logName = "物料信息同步失败";
                        success = bsMtrlService.synchronization(data.get("dataid"), sysUser);  //物料
                        success = bsMtrlTypeService.synchronization(data.get("dataid"), sysUser);//物料分类
                    } else if (data.get("formid").equals("BD_STOCK")) {
                        logName = "库存管理同步失败";
                        success = bsStoreService.synchronization(data.get("dataid"), sysUser); //库存管理
                    } else if (data.get("formid").equals("BD_Customer")) {
                        logName = "客户同步失败";
                        success = bsCustService.synchronization(data.get("dataid"), sysUser); //客户
                    } else if (data.get("formid").equals("BD_Department")) {
                        logName = "部门同步失败";
                        success = companyService.synchronization(data.get("dataid"), sysUser); //部门
                    } else if (data.get("formid").equals("BD_Supplier")) {
                        logName = "供应商同步失败";
                        success = bsSupService.synchronization(data.get("dataid"), sysUser); //供应商
                    } else if (data.get("formid").equals("PRD_MO")) {
                        logName = "生产订单同步失败";
                        success = bsWplanService.synchronization(data.get("dataid"), data.get("entryId"), sysUser);//生产订单
                    } else if (data.get("formid").equals("SUB_SUBREQORDER")) {
                        logName = "委外订单同步失败";
                        success = bsWplanService.synchronization(data.get("dataid"), data.get("entryId"), sysUser);//委外订单
                    } else if (data.get("formid").equals("ENG_BOM")) {
                        logName = "BOM同步失败";
                        success = bsBomService.synchronization(data.get("dataid"), sysUser);//BOM
                    } else if (data.get("formid").equals("SAL_RETURNNOTICE")) {
                        logName = "退货通知单同步失败";
                        success = wmsRoService.synchronization(data.get("dataid"), sysUser);//退货通知单
                    } else if (data.get("formid").equals("STK_OutStockApply")) {
                        logName = "出库申请单同步失败";
                        success = wmsMnService.synchronization(data.get("dataid"), sysUser);//出库申请单
                    } else if (data.get("formid").equals("SAL_DELIVERYNOTICE")) {
                        logName = "发货通知单同步失败";
                        success = wmsAuditService.synchronization(data.get("dataid"), sysUser);//发货通知单
                    } else if (data.get("formid").equals("PUR_PurchaseOrder")) {
                        logName = "采购订单同步失败";
                        success = smPoService.synchronization(data.get("dataid"), sysUser);//采购订单
                    } else if (data.get("formid").equals("STK_TRANSFERAPPLY")) {
                        logName = "调拨申请单同步失败";
                        success = wmsAllotService.synchronization(data.get("dataid"), sysUser);//调拨申请单
                    } else if (data.get("formid").equals("PRD_MatchAnalyseBill")) {
                        logName = "齐套分析同步失败";
                        success = nestingAnalysisService.synchronization(data.get("dataid"), sysUser);//齐套分析
                    } else if (data.get("formid").equals("LQKJ_ContrastRecord")) {
                        logName = "提料分析同步失败";
                        success = iImsPickingListService.synchronization(data.get("dataid"), sysUser);//提料分析
                    }

                    /*//将金蝶云的数据同步该成1 已同步
                    Map<String, Object> result = new HashMap<>();
                    result.put("FID", data.get("fid"));
                    result.put("F_LQKJ_SyncCheck", "1");
                    result.put("F_LQKJ_SyndDatetime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    kingdeeApi.add(result);*/
                }
            } catch (RuntimeException e) {
                e.printStackTrace();
                new KingdeeLogUtil().synLog(logName, e.getMessage());
            }
        }

        /*//批量保存
        kingdeeApi.batchAdd(list);*/
        return success;
    }
}
