package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.common.exception.KingdeeRepeatException;
import org.jeecg.common.exception.kingdeeException;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.MapUtils;
import org.jeecg.modules.iost.ims.entity.ImsProduceOrderClose;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.ErrorsInside;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsProduceOrderCloseApi;
import org.jeecg.modules.iost.ims.mapper.ImsProduceOrderCloseMapper;
import org.jeecg.modules.iost.ims.service.IImsProduceOrderCloseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @Description: ImsProduceOrderClose  工单关单
 * @Author: jeecg-boot
 * @Date: 2021-12-02
 * @Version: V1.0
 */
@Service
public class ImsProduceOrderCloseServiceImpl extends ServiceImpl<ImsProduceOrderCloseMapper, ImsProduceOrderClose> implements IImsProduceOrderCloseService {
    @Autowired
    ImsProduceOrderCloseApi ImsProduceOrderCloseApi;
    private String imsLogName;
    private String DocType;
    private String imsLogOZTNmae;

    public ImsProduceOrderCloseServiceImpl() {
        this.imsLogName = "生产订单关闭";  //ims日志-name
        this.imsLogOZTNmae = "工单关单";//ims日志对应欧智通的标识字段(excal表里面欧智通那一列名字)
        this.DocType = "BS0057";  //调用者传入的标识
    }

    public String setData(List<Map<String, Object>> needLists, String code) {
        //追加参数(上下文对象)
        String kingdeeLogOZTName = ImsProduceOrderCloseApi.getKingdeeLogOZTName();
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingdeeLogOZTName);
        ThreadLocalConfig.set(map2);

        List<ImsProduceOrderClose> ImsProduceOrderCloses = new ArrayList<>();
        //拼接唯一序号重复的返回结果
        List<String> queue_idRepeatResult = new ArrayList<>();
        //添加返回结果Lists
        /*List<String> addResultLists = new ArrayList<>();
        List<String> addResultLists1 = new ArrayList<>();*/
        //请求参数的inputDTOXml里面json格式的参数传入ims同步日志(imslog)
        ImsLogUtil imsLogUtil = new ImsLogUtil();
        imsLogUtil.ImsRequestLog(JSON.toJSONString(needLists), imsLogName, imsLogOZTNmae, DocType);
        List<String> qidList = new ArrayList<>();
        for (Map<String, Object> maps : needLists) {
            qidList.add(maps.get("QUEUE_ID").toString());
        }
        QueryWrapper<ImsProduceOrderClose> qw = new QueryWrapper();
        qw.in("queue_id", qidList);
        StringBuilder builder = new StringBuilder();
        int length = qidList.size();
        for (int i = 0; i < length; i++) {
            if (i == 0) {
                builder.append("'" + qidList.get(i) + "'");
            } else {
                builder.append(",").append("'" + qidList.get(i) + "'");
            }
        }
        qw.orderByAsc("FIELD(queue_id," + builder.toString() + ")");
        List<ImsProduceOrderClose> repeatLists = this.getBaseMapper().selectList(qw);
        if (!CollectionUtils.isEmpty(repeatLists)) {
            queue_idRepeatResult = ResultSplitOne(repeatLists);
        }
        if (!CollectionUtils.isEmpty(queue_idRepeatResult)) {
            throw new KingdeeRepeatException("操作失败!", queue_idRepeatResult.get(0), code);
        }
        //修改金蝶云IMS状态
        Map<String, String> hashMap = ImsProduceOrderCloseApi.addReturnResult(needLists);
        String result = hashMap.get("result");
        if (!StringUtils.isEmpty(result) && "1".equals(result)) {
            for (Map<String, Object> needmap : needLists) {
                needmap.put("FBILL_NO", hashMap.get("FBillNo"));
                needmap.put("FID", hashMap.get("FID"));
                //Map传入参数大写字段转化为实体类字段
                Map<String, Object> map = MapUtils.mapsChange(needmap);
                //map转为实体类对象
                ImsProduceOrderCloses.add(JSON.parseObject(JSON.toJSONString(map), ImsProduceOrderClose.class));
            }
        } else if (StringUtils.isEmpty(result) || "0".equals(result)) {
            throw new kingdeeException("操作失败!修改失败!", Stream.of(hashMap.get("result")).collect(Collectors.toList()), code);
        }

        /*Result resultBySubmit = ImsProduceOrderCloseApi.AutoSubmit(result.getResponseStatus().getSuccessEntitys().get(0).getId());
        addResultLists1 = ResultSplitFour(resultBySubmit);
        if (!CollectionUtils.isEmpty(addResultLists1)) {
            throw new kingdeeException("操作失败!修改失败!", addResultLists1, code);
        }*/

        //保存实体类
        this.saveBatch(ImsProduceOrderCloses);
        return ImsProduceOrderCloses.get(0).getFbillNo();
    }

    public List<String> ResultSplitOne(List<ImsProduceOrderClose> repeatLists) {
        String result = new String();
        LinkedHashSet<String> hashset = new LinkedHashSet<>();
        for (ImsProduceOrderClose ImsProduceOrderClose : repeatLists) {
            String queue_id = String.valueOf(ImsProduceOrderClose.getQueueId());
            result = "QUEUE_ID为(" + queue_id + ")的数据已经提交过!";
            hashset.add(result);
        }
        List<String> rustList = new ArrayList<>();
        for (String s : hashset) {
            rustList.add(s);
        }
        return rustList;
    }

    public List<String> ResultSplitFour(org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result AddResult) {
        List<String> rustList = new ArrayList<>();
        Boolean isSuccess = AddResult.getResponseStatus().getIsSuccess();
        if (!isSuccess) {
            List<ErrorsInside> errors = AddResult.getResponseStatus().getErrors();
            for (ErrorsInside error : errors) {
                rustList.add(error.getMessage());
            }
        }
        return rustList;
    }
}
