package org.jeecg.modules.iost.ims.Util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.ErrorsInside;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result;
import org.jeecg.modules.iost.ims.entity.Kingdeelog;
import org.jeecg.modules.iost.ims.service.IKingdeelogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 金蝶云响应信息日志
 */
@Component
public class KingdeeLogUtil {
    @Autowired
    IKingdeelogService kingdeelogService;
    //单例模式
    private static KingdeeLogUtil uploadRooms;

    //服务器加载Servlet的时候运行，并且只会被服务器执行一次。PostConstruct在构造函数之后执行，init（）方法之前执行。
    @PostConstruct
    public void init() {
        uploadRooms = this;
        uploadRooms.kingdeelogService = this.kingdeelogService;
    }

    public void KingdeeLog(List<List<Object>> list, String name, String content) {
        //获取该线程的存入的变量，在接口开头添加追加的参数
        Map map = ThreadLocalConfig.get();
        Kingdeelog kingdeelog = new Kingdeelog();
        if (!ObjectUtils.isEmpty(map)) {
            long costime = Long.valueOf(map.get("Costime").toString());
            kingdeelog.setCostTime(costime);
        }
        //设置金蝶云请求日志
        kingdeelog.setRequest(content);
        System.out.println("cccccccccccccccccccccccccccc  " + list);
        if (!ObjectUtils.isEmpty(list)) {
            kingdeelog.setResponse(JsonUtil.Listjson(list));
        } else {
            kingdeelog.setFailReason("此单据不存在");
        }
        kingdeelog.setName(name);
        kingdeelog.setOztName(map.get("KingdeeLogOZTName") != null ? map.get("KingdeeLogOZTName").toString() : "");
        kingdeelog.setCreatetime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        //获取result的返回信息的成功状态
        //查询失败则会有报错
        if (ObjectUtils.isEmpty(list)) {
            kingdeelog.setSynchronization("false");
        } else {
            //返回判断
            if (list.get(0).get(0).toString().contains("Errors")) {
                kingdeelog.setSynchronization("false");
                //如果有错误信息则返回
                String message = ImsUtil.getMessage(list.get(0).get(0));
                kingdeelog.setFailReason(message);
            } else {
                kingdeelog.setSynchronization("true");
            }
        }
        KingdeeLogUtil.uploadRooms.kingdeelogService.save(kingdeelog);
    }


    public JSONObject KingdeeLog2(String request, String result, String name) {
        //获取该线程的存入的变量，在接口开头添加追加的参数
        Map map = ThreadLocalConfig.get();
        String kingdeeLogOZTName = map.get("KingdeeLogOZTName").toString();
        Kingdeelog kingdeelog = new Kingdeelog();
        if (!ObjectUtils.isEmpty(map)) {
            long costime = Long.valueOf(map.get("Costime").toString());
            kingdeelog.setCostTime(costime);
        }
        //设置金蝶云请求日志
        kingdeelog.setRequest(request);
        //设置金蝶云响应日志
        kingdeelog.setResponse(result);
        //获取result的返回信息的成功状态
        JSONObject jsonObject = JSON.parseObject(result);
        JSONObject result1 = (JSONObject) jsonObject.get("Result");
        JSONObject responseStatus = (JSONObject) result1.get("ResponseStatus");
        List<JSONObject> successEntitys = (List<JSONObject>) responseStatus.get("SuccessEntitys");
        Boolean isSuccess = (Boolean) responseStatus.get("IsSuccess");
        kingdeelog.setName(name);
        kingdeelog.setOztName(kingdeeLogOZTName);
        kingdeelog.setCreatetime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        if (isSuccess != true) {//返回判断
            kingdeelog.setSynchronization("false");
            Result result2 = KingdeeResultParseUtil.parseAddResult(result);
            List<ErrorsInside> errors = result2.getResponseStatus().getErrors();
            String result3 = new String();
            for (ErrorsInside error : errors) {
                result3 = result3 + error.getMessage() + "-";
            }
            kingdeelog.setFailReason(result3);
        } else {
            kingdeelog.setSynchronization("true");
        }
        KingdeeLogUtil.uploadRooms.kingdeelogService.save(kingdeelog);
        //如果是修改数据就没有SuccessEntitys，就要获取Errors
        if (ObjectUtils.isEmpty(successEntitys)) {
            List<JSONObject> Errors = (List<JSONObject>) responseStatus.get("Errors");
            return (JSONObject) Errors.get(0);
        } else {
            return (JSONObject) successEntitys.get(0);
        }

    }

    public void synLog(String logName, String errorMessage) {
        Kingdeelog kingdeelog = new Kingdeelog();
        kingdeelog.setName(logName);
        kingdeelog.setSynchronization("false");
        kingdeelog.setFailReason(errorMessage);
        kingdeelog.setCreatetime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        Map map = ThreadLocalConfig.get();
        if (!ObjectUtils.isEmpty(map)) {
            long costime = Long.parseLong(map.get("Costime").toString());
            kingdeelog.setCostTime(costime);
        }
        KingdeeLogUtil.uploadRooms.kingdeelogService.save(kingdeelog);
    }

}
