package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.ims.entity.ImsInventorySurplus;
import org.jeecg.modules.iost.ims.service.IImsInventorySurplusService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

/**
 * @Description: 盘点盘盈单
 * @Author: ly
 * @Date: 2021-12-08
 * @Version: V1.0
 */
@Api(tags = "盘点盘盈单")
@RestController
@RequestMapping("/ims/imsInventorySurplus")
@Slf4j
public class ImsInventorySurplusController extends JeecgController<ImsInventorySurplus, IImsInventorySurplusService> {
    @Autowired
    private IImsInventorySurplusService imsInventorySurplusService;

    /**
     * 分页列表查询
     *
     * @param imsInventorySurplus
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "盘点盘盈单-分页列表查询")
    @ApiOperation(value = "盘点盘盈单-分页列表查询", notes = "盘点盘盈单-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(ImsInventorySurplus imsInventorySurplus,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   String dateString, String codeString, String queueId,
                                   HttpServletRequest req) {
        QueryWrapper<ImsInventorySurplus> queryWrapper = QueryGenerator.initQueryWrapper(imsInventorySurplus, req.getParameterMap());
        if (StringUtils.isNotBlank(dateString)) {
            String[] split = dateString.split(",");
            queryWrapper.between("trx_date", split[0] + " 00:00:00", split[1] + " 00:00:00");
        }
        if (StringUtils.isNotBlank(codeString)) {
            queryWrapper.eq("fbill_no", codeString);
        }
        Page<ImsInventorySurplus> page = new Page<ImsInventorySurplus>(pageNo, pageSize);
        IPage<ImsInventorySurplus> pageList = imsInventorySurplusService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param imsInventorySurplus
     * @return
     */
    @AutoLog(value = "盘点盘盈单-添加")
    @ApiOperation(value = "盘点盘盈单-添加", notes = "盘点盘盈单-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody ImsInventorySurplus imsInventorySurplus) {
        imsInventorySurplusService.save(imsInventorySurplus);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param imsInventorySurplus
     * @return
     */
    @AutoLog(value = "盘点盘盈单-编辑")
    @ApiOperation(value = "盘点盘盈单-编辑", notes = "盘点盘盈单-编辑")
    @PutMapping(value = "/edit")
    public Result<?> edit(@RequestBody ImsInventorySurplus imsInventorySurplus) {
        imsInventorySurplusService.updateById(imsInventorySurplus);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "盘点盘盈单-通过id删除")
    @ApiOperation(value = "盘点盘盈单-通过id删除", notes = "盘点盘盈单-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name = "id", required = true) String id) {
        imsInventorySurplusService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "盘点盘盈单-批量删除")
    @ApiOperation(value = "盘点盘盈单-批量删除", notes = "盘点盘盈单-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.imsInventorySurplusService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    @AutoLog(value = "盘点盘盈单-通过id查询")
    @ApiOperation(value = "盘点盘盈单-通过id查询", notes = "盘点盘盈单-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<?> queryById(@RequestParam(name = "id", required = true) String id) {
        ImsInventorySurplus imsInventorySurplus = imsInventorySurplusService.getById(id);
        if (imsInventorySurplus == null) {
            return Result.error("未找到对应数据");
        }
        return Result.OK(imsInventorySurplus);
    }

    /**
     * 导出excel
     *
     * @param request
     * @param imsInventorySurplus
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ImsInventorySurplus imsInventorySurplus) {
        return super.exportXls(request, imsInventorySurplus, ImsInventorySurplus.class, "盘点盘盈单");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ImsInventorySurplus.class);
    }

}
