package org.jeecg.modules.iost.ims.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author Inori
 */
@Data
@TableName("ims_common_syn")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ims_common_syn对象", description = "通用同步类")
public class ImsCommonSyn {

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;


    /**
     * 金蝶标识
     */
    @Excel(name = "主键ID", width = 15)
    @ApiModelProperty(value = "金蝶标识")
    private String formId;


    /**
     * ims标识
     */
    @Excel(name = "ims标识", width = 15)
    @ApiModelProperty(value = "ims标识")
    private String docType;


    /**
     * 日志名称
     */
    @Excel(name = "日志名称", width = 15)
    @ApiModelProperty(value = "日志名称")
    private String name;


    /**
     * 明细内容
     */
    @Excel(name = "明细内容", width = 15)
    @ApiModelProperty(value = "明细内容")
    private String detail;


    /**
     * 创建日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;


    /**
     * 更新日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;


}
