package org.jeecg.modules.iost.ims.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author Inori
 */
@Data
@TableName("ims_picking_list")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ims_picking_list对象", description = "提料单信息")
public class ImsPickingList {

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;


    /**
     * 主键ID
     */
    @Excel(name = "主键ID", width = 15)
    @ApiModelProperty(value = "主键ID")
    private String fid;


    /**
     * 分析单号
     */
    @Excel(name = "分析单号", width = 15)
    @ApiModelProperty(value = "分析单号")
    private String supMtrlDtAnalNo;


    /**
     * 发送总数
     */
    @Excel(name = "发送总数", width = 15)
    @ApiModelProperty(value = "发送总数")
    private Integer pushCount;


    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String createBy;


    /**
     * 创建日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;


    /**
     * 更新人
     */
    @ApiModelProperty(value = "更新人")
    private String updateBy;


    /**
     * 更新日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;


}
