package org.jeecg.modules.iost.ims.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 出库单信息
 * @Author: jeecg-boot
 * @Date:   2021-12-23
 * @Version: V1.0
 */
@Data
@TableName("ims_wms_mn")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="ims_wms_mn对象", description="出库单信息")
public class ImsWmsMn implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private java.lang.String sysOrgCode;
	/**组织代码*/
	@Excel(name = "组织代码", width = 15)
    @ApiModelProperty(value = "组织代码")
    private java.lang.String orgId;
	/**出库单编码*/
	@Excel(name = "出库单编码", width = 15)
    @ApiModelProperty(value = "出库单编码")
    private java.lang.String pmnCode;
	/**租户代码*/
	@Excel(name = "租户代码", width = 15)
    @ApiModelProperty(value = "租户代码")
    private java.lang.String partnerCode;
	/**出库单类型*/
	@Excel(name = "出库单类型", width = 15)
    @ApiModelProperty(value = "出库单类型")
    private java.lang.String pmnType;
	/**成品编码*/
	@Excel(name = "成品编码", width = 15)
    @ApiModelProperty(value = "成品编码")
    private java.lang.String proidCode;
	/**单据实际数量*/
	@Excel(name = "单据实际数量", width = 15)
    @ApiModelProperty(value = "单据实际数量")
    private java.lang.String mnTbQty;
	/**单据计划数量*/
	@Excel(name = "单据计划数量", width = 15)
    @ApiModelProperty(value = "单据计划数量")
    private java.lang.String mnPlanQty;
	/**第三方单据编码*/
	@Excel(name = "第三方单据编码", width = 15)
    @ApiModelProperty(value = "第三方单据编码")
    private java.lang.String refMnCode;
	/**物料编码*/
	@Excel(name = "物料编码", width = 15)
    @ApiModelProperty(value = "物料编码")
    private java.lang.String mtrlCode;
	/**是否主料*/
	@Excel(name = "是否主料", width = 15)
    @ApiModelProperty(value = "是否主料")
    private java.lang.String isMain;
	/**主料编码*/
	@Excel(name = "主料编码", width = 15)
    @ApiModelProperty(value = "主料编码")
    private java.lang.String mainCode;
	/**用量*/
	@Excel(name = "用量", width = 15)
    @ApiModelProperty(value = "用量")
    private java.lang.String dosage;
	/**净需求数量*/
	@Excel(name = "净需求数量", width = 15)
    @ApiModelProperty(value = "净需求数量")
    private java.lang.String nnQty;
	/**实际需求数量*/
	@Excel(name = "实际需求数量", width = 15)
    @ApiModelProperty(value = "实际需求数量")
    private java.lang.String tnQty;
	/**第三方行号*/
	@Excel(name = "第三方行号", width = 15)
    @ApiModelProperty(value = "第三方行号")
    private java.lang.String thirdRwn;
	/**仓库编码*/
	@Excel(name = "仓库编码", width = 15)
    @ApiModelProperty(value = "仓库编码")
    private java.lang.String storeCode;
	/**备注*/
	@Excel(name = "备注", width = 15)
    @ApiModelProperty(value = "备注")
    private java.lang.String remark;
	/**主键ID*/
	@Excel(name = "主键ID", width = 15)
    @ApiModelProperty(value = "主键ID")
    private java.lang.String fid;
}
