package org.jeecg.modules.iost.ims.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: ims响应日志
 * @Author: jeecg-boot
 * @Date:   2021-09-03
 * @Version: V1.0
 */
@Data
@TableName("imslog")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="imslog对象", description="ims响应日志")
public class Imslog implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**业务名字*/
	@Excel(name = "业务名字", width = 15)
    @ApiModelProperty(value = "业务名字")
    private java.lang.String name;
    /**业务对应欧智通的名字*/
    @Excel(name = "业务对应欧智通的名字", width = 15)
    @ApiModelProperty(value = "业务对应欧智通的名字")
    private java.lang.String oztName;
    /**IMS请求信息*/
    @Excel(name = "IMS请求信息", width = 15)
    @ApiModelProperty(value = "IMS请求信息")
    private java.lang.String request;
	/**IMS响应信息*/
	@Excel(name = "IMS响应信息", width = 15)
    @ApiModelProperty(value = "IMS响应信息")
    private java.lang.String response;
    /**创建日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
	/**状态吗*/
	@Excel(name = "状态码", width = 15)
    @ApiModelProperty(value = "状态码")
    private java.lang.String code;
	/**业务是否成功:失败:0,成功:1*/
	@Excel(name = "业务是否成功:“0000”表示成功，“0001”表示部分成功，其他表示失败", width = 15)
    @ApiModelProperty(value = "“0000”表示成功，“0001”表示部分成功，其他表示失败")
    private java.lang.String success;
    /**金蝶请求信息*/
    @Excel(name = "IMS详细信息", width = 15)
    @ApiModelProperty(value = "IMS详细信息")
    private java.lang.String message;
    /**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
    /**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
    /**更新日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
    /**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private java.lang.String sysOrgCode;
}
