package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.*;

/**
 * 查询金蝶云供应商基础信息
 */
@Component
public class BsSupKingdeeApi implements web_api {
    /**
     * 操作的单据体名称
     */
    private String sFormId = "BD_Supplier";//供应商基础信息
    @Autowired
    private CategoryDao categoryDao;
    private Map<String, String> key = new LinkedHashMap<>();

    public BsSupKingdeeApi() {
        /*查询字段*/
        key.put("FSupplierId", "FSupplierId");//单据头实体主键
        key.put("FNumber", "FNumber");//编码
        key.put("FName", "FName");//名称
        key.put("FCountry.Fnumber", "FCountry.Fnumber");//国家编码
        key.put("FContact", "FContact");//联系人
        key.put("FTel", "FTel");//联系电话
        key.put("FCreateDate", "FCreateDate");//创建时间
        key.put("FEMail", "FEMail");//电子邮箱
    }

    @Override
    public String add(Map<String, Object> maps) {
        return null;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        List<List<Object>> list = categoryDao.select(sFormId, key, map, "供应商基本信息");
        return PojoToIMS(list);
    }

    /**
     * 将查询到的数据封装成本地字段
     *
     * @return
     */
    private List<Map<String, String>> PojoToIMS(List<List<Object>> list) {
        List<Map<String, String>> salesorderlist = new ArrayList<>();
        if (!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("supCode", list1.get(1).toString());
                    salesordermap.put("supName", list1.get(2).toString());
                    if (null == list1.get(3) || "".equals(list1.get(3).toString())) {
                        salesordermap.put("countryCode", "");
                    } else {
                        salesordermap.put("countryCode", list1.get(3).toString());
                    }
                    if (null == list1.get(4)) {
                        salesordermap.put("contactsUser", "");
                    } else {
                        salesordermap.put("contactsUser", list1.get(4).toString());
                    }
                    if (null == list1.get(5)) {
                        salesordermap.put("contactsPhone", "");
                    } else {
                        salesordermap.put("contactsPhone", list1.get(5).toString());
                    }
                    if (null == list1.get(7)) {
                        salesordermap.put("contactsEmail", "");
                    } else {
                        salesordermap.put("contactsEmail", list1.get(7).toString());
                    }
                    salesorderlist.add(salesordermap);
                }
            } else {
                //如果有错误信息则返回
                Map<String, Object> o = (Map<String, Object>) list.get(0).get(0);
                Object errors = o.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }

    @Override
    public String update(Object object) {
        return null;
    }
}
