package org.jeecg.modules.iost.ims.kingdeeapi;

import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @author Inori
 */
@Component
public class ImsCommonKingdeeApi {

    @Autowired
    private CategoryDao categoryDao;


    /**
     * 封装金蝶字段
     */
    private Map<String, String> purchaseKingDee(List<Map<String, String>> fieldList) {
        Map<String, String> key = new LinkedHashMap<>();
        for (Map<String, String> map : fieldList) {
            String kingDee = map.get("kingdee");
            if ("true".equals(map.get("isNumber"))) {
                kingDee = kingDee + ".Fnumber";
            } else if ("true".equals(map.get("isName"))) {
                kingDee = kingDee + ".Fname";
            }
            key.put(kingDee, kingDee);
        }
        return key;
    }

    /**
     * 获取金蝶云数据
     */
    public List<Map<String, Object>> selectAndLog(String sFormId, List<Map<String, String>> fieldList, Map<String, String> where, String name) {
        Map<String, String> key = purchaseKingDee(fieldList);
        List<List<Object>> result = categoryDao.selectAndLog(sFormId, key, where, name);
        return purchaseIms(result, fieldList);
    }

    /**
     * 封装第三方字段
     */
    private List<Map<String, Object>> purchaseIms(List<List<Object>> list, List<Map<String, String>> fieldList) {
        List<Map<String, Object>> result = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                Map<String, Object> map = new HashMap<>(fieldList.size());
                List<Map<String, Object>> imsList = new ArrayList<>();
                for (List<Object> objectList : list) {
                    Map<String, Object> tempMap = new HashMap<>(fieldList.size());
                    for (int i = 0; i < fieldList.size(); i++) {
                        //是否是明细字段
                        if ("true".equals(fieldList.get(i).get("isDetail"))) {
                            tempMap.put(fieldList.get(i).get("ims"), String.valueOf(objectList.get(i)));
                        } else {
                            map.put(fieldList.get(i).get("ims"), String.valueOf(objectList.get(i)));
                        }
                    }
                    if (!CollectionUtils.isEmpty(tempMap)) {
                        imsList.add(tempMap);
                    }
                }
                if (!CollectionUtils.isEmpty(imsList)) {
                    map.put("detail_list", imsList);
                }
                result.add(map);
            } else {
                //如果有错误信息则返回
                String message = ImsUtil.getMessage(list.get(0).get(0));

                Map<String, Object> resultMap = new HashMap<>(1);
                resultMap.put("false", message);
                result.add(resultMap);
            }
        }
        return result;
    }


}
