package org.jeecg.modules.iost.ims.kingdeeapi;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.jeecg.modules.iost.ims.entity.ImsCommonSyn;
import org.jeecg.modules.iost.ims.mapper.ImsCommonSynMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author Inori
 */
@Component
public class ImsConstants {

    private Map<String, Map<String, String>> map = new ConcurrentHashMap<>();

    @Autowired
    private ImsCommonSynMapper imsCommonSynMapper;


    @PostConstruct
    public void init() {
        List<ImsCommonSyn> imsCommonSynList = imsCommonSynMapper.selectList(null);
        for (ImsCommonSyn imsCommonSyn : imsCommonSynList) {
            Map<String, String> temp = new HashMap<>(5);
            temp.put("formId", imsCommonSyn.getFormId());
            temp.put("docType", imsCommonSyn.getDocType());
            temp.put("name", imsCommonSyn.getName());
            temp.put("detail", imsCommonSyn.getDetail());
            map.put(imsCommonSyn.getFormId(), temp);
        }
    }

    public Map<String, String> get(String formId) {
        return map.get(formId);
    }

    public void set(String formId) {
        ImsCommonSyn imsCommonSyn = imsCommonSynMapper.selectOne(new QueryWrapper<ImsCommonSyn>().eq("form_id", formId));

        if (imsCommonSyn != null) {
            map.remove(formId);

            Map<String, String> temp = new HashMap<>(4);
            temp.put("formId", imsCommonSyn.getFormId());
            temp.put("docType", imsCommonSyn.getDocType());
            temp.put("name", imsCommonSyn.getName());
            temp.put("detail", imsCommonSyn.getDetail());
            map.put(imsCommonSyn.getFormId(), temp);
        }
    }


}
