package org.jeecg.modules.iost.ims.kingdeeapi;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import lombok.Data;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.*;
import org.jeecg.modules.iost.ims.entity.ImsCustomerPurchaseOrderConfirm;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.*;
/**
 * @Description: ImsCustomerPurchaseOrderConfirm  客退品采购订单收料确认
 * @Author: jeecg-boot
 * @Date:   2021-12-02
 * @Version: V1.0
 */
@Component
@Data
public class ImsCustomerPurchaseOrderConfirmApi implements web_api{
    @Autowired
    private CategoryDao categoryDao;

    private String sFormId;
    private String Father_FEnrtyID;
    private String KingdeeLogPushName;
    private String KingdeeLogName;
    private String KingdeeLogOZTName;
    private String Father_sFormId;
    private String push_Rule;
    private String Son_FEnrtyID;
    private String SeqName;
    private String wipOrdeName;
    public ImsCustomerPurchaseOrderConfirmApi() {
        sFormId = "SAL_RETURNSTOCK";  //子单据Formid
        Father_sFormId = "SAL_RETURNNOTICE";  //父单据Formid
        Son_FEnrtyID = "FEntity_FENTRYID";  //子单据要查询的FEntryId
        Father_FEnrtyID = "FEntity_FENTRYID";  //父单据要查询的FEntryId
        KingdeeLogPushName = "销售退货单(退货通知单-销售退货单)";  //金蝶云下推操作日志名称
        KingdeeLogName = "销售退货单";    //金蝶云修改操作日志-name
        KingdeeLogOZTName = "客退品采购订单收料确认";    //金蝶云修改操作日志对应欧智通-name
        push_Rule = "SalReturnNotice-SalReturnStock";   //父单据下推子单据的规则
        SeqName="FEntity_Link_FSId";  //子单据里面的源单行号(父单据行号); ps:如果子单据不存在源单行号则换成源单分录内码
        wipOrdeName="FSrcBillNo";   //子单据里面的源单编号(父单据工单编号) 或者如果父单据没有工单编号条件改为源单行内码(源单分录内码)
    }

    @Override
    public String add(Map<String, Object> maps) {
        return null;
    }

    public Result addTwo(List<Map<String,Object>> lists) {
        Map<String, Object> stringStringMap = ImsToKingdee(lists);
        Result result = categoryDao.addAndWithFid(KingdeeLogName, sFormId, JsonUtil.Mapjson(stringStringMap),String.valueOf(lists.get(0).get("FID")));
        return result;
    }

    /*ims字段转换成金蝶云待添加(其实都是下推后修改)字段*/
    public Map<String, Object> ImsToKingdee(List<Map<String,Object>> lists) {
        List<Map<String, Object>> list = new ArrayList<>();
        Map<String, Object> ModelMap = new HashMap<>();
        for (Map<String, Object> maps : lists) {
            Map<String, Object> FEntityMap = new HashMap<>();
            FEntityMap.put("FStockId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("STORE_CODE"));
            }}); //仓库编码
            FEntityMap.put("FMaterialId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("MTRL_CODE"));
            }}); //物料编码
            FEntityMap.put("FRealQty", maps.get("QUANTITY")); //数量-实退数量
            FEntityMap.put("FNote", maps.get("REMARK"));//备注
            //修改条件FEntryID
            FEntityMap.put("FEntryID", maps.get("FEntry_ID"));//本单据的FEntryID
            list.add(FEntityMap);
            //修改条件FID
            ModelMap.put("FID", maps.get("FID"));
            ModelMap.put("FStockerId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("USER_CODE"));
            }});  //仓管员
            ModelMap.put("FDate", maps.get("TRX_DATE"));  //交易时间
            //下面两个有些字段单据修改传入会报错
            ModelMap.put("FSaleOrgId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("ORG_ID"));
            }});  //组织代码*/
            ModelMap.put("FRetcustId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("SUP_CODE"));
            }});  //退货客户
        }
        ModelMap.put("FDetailEntity", list);

        return ModelMap;
    }
    /*    *//*根据FID查询FEntity_FEntryId*//*
    public String select(String F,String seq, String FID) {
        if (ObjectUtils.isEmpty(FID)) {
            FID = new String();
        }
        //源单分录内码
        SeqName="FEntity_Link_FSId";
        String FEntity_FEntryId = categoryDao.Son_FindFentryIdSpecial(F,SeqName,Son_FEnrtyID, Integer.valueOf(seq),FID,sFormId );
        return FEntity_FEntryId;
    }*/

    /*查询数据的子单据的FEntryID*/
    public String querySonFEntryID(String F,String seq, String FID) {
        if (ObjectUtils.isEmpty(FID)) {
            FID = new String();
        }
        String FEntity_FEntryId = categoryDao.select_Son_FentryIdSpecial(F,SeqName,Son_FEnrtyID, Integer.valueOf(seq),FID,sFormId,KingdeeLogName+"子单据行内码查询");
        return FEntity_FEntryId;
    }

    /*父单据下推到子单据*/
    public Result push(List<Map<String, Object>> needPushLists,List<String> Father_FEntryIDs) {
        //目标单据为子单据Formid
        String TargetFormId = sFormId;
        //下推父单据的Fromid-EntryID-单据转换规则(写死，客户端查询)-目标单据FormId-
        String result = categoryDao.pushMore(KingdeeLogPushName, Father_sFormId, Father_FEntryIDs, push_Rule, TargetFormId);
        Result pushResult = KingdeeResultParseUtil.parseAddResult(result);
        return pushResult;
    }
    /*查询needLists所有数据的父单据的FEntryID*/
    public List<String> queryFatherFEntryIDs(List<Map<String, Object>> needLists,List<Map<String, Object>> SelectFatherFentryIdFailLists)
    {
        List<String> Father_FEntryIDs = new ArrayList<>(); //父单据FEntryID
        for (Map<String, Object> maps : needLists) {
            ImsCustomerPurchaseOrderConfirm ImsCustomerPurchaseOrderConfirm = JSON.parseObject(JSON.toJSONString(maps), ImsCustomerPurchaseOrderConfirm.class);//map转为实体类对象
            //查询是否有FEntryID传入，没有就其他方法查询出
            if (ObjectUtils.isEmpty(maps.get("SEQ_ENTRY_CODE"))) {
                //根据父单据编码和行号(ERP工单行号)在数据库同步表查出父单据的FEntryID
                List<List<Object>> FEntryIDlist = categoryDao.select_Father_FentryId(Father_FEnrtyID,maps, Father_sFormId,KingdeeLogName+"父单据行内码查询");
                String FEntryID="0";
                //过滤掉查询不到FEntryID的数据返回"0"
                if(!ObjectUtils.isEmpty(FEntryIDlist)) {
                    if (FEntryIDlist.size()>=Integer.valueOf(ImsCustomerPurchaseOrderConfirm.getPoSeq())) {
                        FEntryID = FEntryIDlist.get(Integer.valueOf(ImsCustomerPurchaseOrderConfirm.getPoSeq()) - 1).get(0).toString();
                    }
                }
                else
                {
                    FEntryID="1";
                    maps.put("notExitFbillNo",true);
                    SelectFatherFentryIdFailLists.add(maps);
                }
                //返回FEntryID默认值0说明查不到FEntryID
                if(FEntryID.equals("0"))
                {
                    //查询FEntryID失败后要返结果的lists
                    SelectFatherFentryIdFailLists.add(maps);
                }
                else
                {
                    Father_FEntryIDs.add(FEntryID);
                    maps.put(maps.get(ThreadLocalConfig.get().get("wipOrde")).toString()+maps.get(ThreadLocalConfig.get().get("SEQ")).toString(),FEntryID);
                }

            } else {
                String FEntryID = maps.get("SEQ_ENTRY_CODE").toString();
                Father_FEntryIDs.add(FEntryID);
            }
        }
        return Father_FEntryIDs;
    }
    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }



    @Override
    public String update(
            Object object) {
        return null;
    }

    /*父单据下推到子单据*/
    public Map<String, String> push(Map<String, Object> maps) {
        String FEntryID; //父单据FEntryID
        ImsCustomerPurchaseOrderConfirm ImsCustomerPurchaseOrderConfirm = JSON.parseObject(JSON.toJSONString(maps), ImsCustomerPurchaseOrderConfirm.class);//map转为实体类对象
        //查询是否有FEntryID传入，没有就其他方法查询出
        if (ObjectUtils.isEmpty(maps.get("SEQ_ENTRY_CODE"))) {
            //根据父单据编码和行号(ERP工单行号)在数据库同步表查出父单据的FEntryID
            FEntryID = categoryDao.Father_FindFentryId(Father_FEnrtyID, Integer.valueOf(ImsCustomerPurchaseOrderConfirm.getPoSeq()), maps,Father_sFormId);
        } else {
            FEntryID = maps.get("SEQ_ENTRY_CODE").toString();
        }
        //目标单据为子单据Formid
        String TargetFormId = sFormId;
        //下推父单据的Fromid-EntryID-单据转换规则(写死，客户端查询)-目标单据FormId-
        String pushResult = categoryDao.push(KingdeeLogPushName, Father_sFormId, FEntryID, push_Rule, TargetFormId);
        //解析信息，得到返回的本单据的单据编码FID和FBillNo
        JSONObject jsonObject = JSON.parseObject(pushResult);
        JSONObject result1 = (JSONObject) jsonObject.get("Result");
        JSONObject responseStatus = (JSONObject) result1.get("ResponseStatus");
        List<JSONObject> successEntitys = (List<JSONObject>) responseStatus.get("SuccessEntitys");
        //如果为空说明下推失败没得到成功结果
        if (ObjectUtils.isEmpty(successEntitys)) {
            Map<String, String> map = new HashMap<>();
            return map;
        } else {
            ImsCustomerPurchaseOrderConfirm ImsCustomerPurchaseOrderConfirm2 = JSON.parseObject(JSON.toJSONString(maps), ImsCustomerPurchaseOrderConfirm.class);//map转为实体类对象
            JSONObject SuccessEntitysList = successEntitys.get(0);
            String FID = SuccessEntitysList.get("Id").toString();
            String FBillNo = SuccessEntitysList.get("Number").toString();
            Map<String, String> map = new HashMap<>();
            map.put("FID", FID);
            map.put("FBILL_NO", FBillNo);
            map.put(ImsCustomerPurchaseOrderConfirm.getPoSeq(),FEntryID);
            return map;
        }
    }
    /*父单据下推到子单据*/
    public List<Map<String, String>> pushMore(List<Map<String, Object>> lists) {
        List<String> FEntryIDs = new ArrayList<>(); //父单据FEntryID
        for (Map<String, Object> maps : lists) {
            ImsCustomerPurchaseOrderConfirm ImsCustomerPurchaseOrderConfirm = JSON.parseObject(JSON.toJSONString(maps), ImsCustomerPurchaseOrderConfirm.class);//map转为实体类对象
            //查询是否有FEntryID传入，没有就其他方法查询出
            if (ObjectUtils.isEmpty(maps.get("SEQ_ENTRY_CODE"))) {
                //根据父单据编码和行号(ERP工单行号)在数据库同步表查出父单据的FEntryID
                String FEntryID = categoryDao.Father_FindFentryId(Father_FEnrtyID, Integer.valueOf(ImsCustomerPurchaseOrderConfirm.getPoSeq()), maps, Father_sFormId);
                FEntryIDs.add(FEntryID);
            } else {
                String FEntryID = maps.get("SEQ_ENTRY_CODE").toString();
                FEntryIDs.add(FEntryID);
            }
        }
        System.out.println("===============FEntryIDs============+"+FEntryIDs+"+=====================FEntryIDs================");
        //目标单据为子单据Formid
        String TargetFormId = sFormId;
        //下推父单据的Fromid-EntryID-单据转换规则(写死，客户端查询)-目标单据FormId-
        String pushResult = categoryDao.pushMore(KingdeeLogPushName, Father_sFormId, FEntryIDs, push_Rule, TargetFormId);
        //解析信息，得到返回的本单据的单据编码FID和FBillNo
        JSONObject jsonObject = JSON.parseObject(pushResult);
        JSONObject result1 = (JSONObject) jsonObject.get("Result");
        JSONObject responseStatus = (JSONObject) result1.get("ResponseStatus");
        List<JSONObject> successEntitys = (List<JSONObject>) responseStatus.get("SuccessEntitys");
        Boolean isSuccess = (Boolean) responseStatus.get("IsSuccess");
        if (isSuccess == false) {
            String message = new String();
            List<JSONObject> Errors = (List<JSONObject>) responseStatus.get("Errors");
            for (JSONObject error : Errors) {
                JSONObject messags = Errors.get(0);
                message = message + "---" + String.valueOf(messags.get("Message"));
            }
            List<Map<String, String>> list = new ArrayList<>();
            Map<String, String> map = new HashMap<>();
            map.put("messgae",String.valueOf(message));
            list.add(map);
            return list;
        } else {
            List<Map<String, String>> list=new ArrayList<>();

            for (JSONObject successEntity : successEntitys) {
                String FID = successEntity.get("Id").toString();
                String FBillNo = successEntity.get("Number").toString();
                Map<String, String> map = new HashMap<>();
                map.put("FID", FID);
                map.put("FBILL_NO", FBillNo);
                int i=0;
                for (String fEntryID : FEntryIDs) {
                    Map<String, Object> map1 = lists.get(i);
                    ImsCustomerPurchaseOrderConfirm ImsCustomerPurchaseOrderConfirm = JSON.parseObject(JSON.toJSONString(map1), ImsCustomerPurchaseOrderConfirm.class);//map转为实体类对象
                    map.put(ImsCustomerPurchaseOrderConfirm.getPoSeq(),FEntryIDs.get(i));
                    i++;
                }
                list.add(map);

            }
            System.out.println("===============list============+"+list+"+=====================list================");
            return list;
        }
    }
}
