package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.TimeUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 查询金蝶云采购订单信息
 */
@Component
public class SmPoKingdeeApi implements web_api {
    /**
     * 操作的单据体名称
     */
    private String sFormId = "PUR_PurchaseOrder";//采购订单
    @Autowired
    private CategoryDao categoryDao;
    private Map<String, String> key = new LinkedHashMap<>();

    public SmPoKingdeeApi() {
        /*查询字段*/
        /* 单据头实体主键 */
        key.put("FID", "FID");
        /* 编码 */
        key.put("FBillNo", "FBillNo");
        /* 采购日期 */
        key.put("FDate", "FDate");
        /* 供应商编码 */
        key.put("FSupplierId.Fnumber", "FSupplierId.Fnumber");
        /* 组织编码 */
        key.put("FPurchaseOrgId.Fnumber", "FPurchaseOrgId.Fnumber");
        /* 行号 */
        key.put("FPOOrderEntry_Fseq", "FPOOrderEntry_Fseq");
        /* 物料编码 */
        key.put("FMaterialId.Fnumber", "FMaterialId.Fnumber");
        /* 数量 */
        key.put("FQty ", "FQty ");
        /* 交货数量 */
        key.put("FDeliCommitQty  ", "FDeliCommitQty  ");
        /* 委外组织 */
        key.put("FSubOrgId.Fname", "FSubOrgId.Fname");
        /* 备注 */
        key.put("FEntryNote", "FEntryNote");
        /* 付款条件 */
        key.put("FPayConditionId.Fname", "FPayConditionId.Fname");
        /* 付款方式 */
        key.put("FSettleModeId.Fname", "FSettleModeId.Fname");
        /* 币别 */
        key.put("FSettleCurrId.Fname", "FSettleCurrId.Fname");
        /* 汇率 */
        key.put("FExchangeRate", "FExchangeRate");
        /* 厂商联系人 */
        key.put("FProviderContactId.Fname", "FProviderContactId.Fname");
        /* 供应商电话 */
        key.put("FProviderPhone", "FProviderPhone");
        /* 制表人 */
        key.put("FCreatorId.Fname", "FCreatorId.Fname");
        /* 审核人 */
        key.put("FApproverId.Fname", "FApproverId.Fname");
        /* 料品规格 */
        key.put("FModel", "FModel");
        /* 采购单位 */
        key.put("FUnitId.Fname", "FUnitId.Fname");
        /* 未税价 */
        key.put("FPrice", "FPrice");
        /* 未税金额 */
        key.put("FEntryAmount", "FEntryAmount");
        /* 税额 */
        key.put("FEntryTaxAmount", "FEntryTaxAmount");
        /* 价税合计 */
        key.put("FAllAmount", "FAllAmount");
        /* 价税否 */
        key.put("FIsIncludedTax", "FIsIncludedTax");
        /* 税率 */
        key.put("FEntryTaxRate", "FEntryTaxRate");
        /* 含税单价 */
        key.put("FTaxPrice", "FTaxPrice");
        /* 库存数量 */
        key.put("FStockQty", "FTaxPrice");
        /* 库存单位 */
        key.put("FStockUnitID.Fname", "FTaxPrice");
    }

    @Override
    public String add(Map<String, Object> maps) {
        return null;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        List<List<Object>> list = categoryDao.select(sFormId, key, map, "采购订单信息");
        return PojoToIMS(list);
    }

    /**
     * 查询供应商信息
     */
    public List<List<Object>> getSupplier(String id) {
        List<List<Object>> lists = categoryDao.select("BD_Supplier", new LinkedHashMap<String, String>() {{
            put("FInvoiceType", "FInvoiceType");
            put("FLocFax", "FLocFax");
        }}, new HashMap<String, String>() {{
            put("FNumber", id);
        }});
        if (lists.isEmpty() || ("").equals(lists.get(0).get(0).toString())) {
            return new ArrayList<>();
        } else if (lists.get(0).get(0).toString().contains("Errors")) {
            return new ArrayList<>();
        }
        return lists;
    }

    /**
     * 将查询到的数据封装成本地字段
     *
     * @return
     */
    private List<Map<String, String>> PojoToIMS(List<List<Object>> list) {
        List<Map<String, String>> salesorderlist = new ArrayList<>();
        if (!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("poCode", list1.get(1).toString());
                    Date parse = null;
                    try {
                        parse = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").parse(TimeUtil.timeSSS(list1.get(2).toString()));
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    String indate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(parse);
                    salesordermap.put("indate", indate);
                    salesordermap.put("supCode", list1.get(3).toString());
                    salesordermap.put("companyCode", list1.get(4).toString());
                    salesordermap.put("seq", list1.get(5).toString());
                    salesordermap.put("mtrlCode", list1.get(6).toString());
                    salesordermap.put("poQty", list1.get(7).toString());
                    salesordermap.put("roQty", list1.get(8).toString());
                    if (null == list1.get(9)) {
                        salesordermap.put("isOuts", "N");
                    } else {
                        salesordermap.put("isOuts", "Y");
                    }
                    if (null == list1.get(10)) {
                        salesordermap.put("remark", "");
                    }
                    salesordermap.put("remark", list1.get(10).toString());
                    salesordermap.put("payCon", String.valueOf(list1.get(11)));
                    salesordermap.put("payWay", String.valueOf(list1.get(12)));
                    salesordermap.put("currency", String.valueOf(list1.get(13)));
                    salesordermap.put("curRate", String.valueOf(list1.get(14)));
                    salesordermap.put("factoryContact", String.valueOf(list1.get(15)));
                    salesordermap.put("supPhone", String.valueOf(list1.get(16)));
                    salesordermap.put("lister", String.valueOf(list1.get(17)));
                    salesordermap.put("reviewer", String.valueOf(list1.get(18)));
                    salesordermap.put("poMtrlDescs", String.valueOf(list1.get(19)));
                    salesordermap.put("poUnit", String.valueOf(list1.get(20)));
                    salesordermap.put("poUnitprice", String.valueOf(list1.get(21)));
                    salesordermap.put("tmextax", String.valueOf(list1.get(22)));
                    salesordermap.put("tax", String.valueOf(list1.get(23)));
                    salesordermap.put("totalmoney", String.valueOf(list1.get(24)));
                    List<List<Object>> supplier = getSupplier(list1.get(3).toString());
                    if (!CollectionUtils.isEmpty(supplier)) {
                        String invoiceType = String.valueOf(supplier.get(0).get(0));
                        if (StringUtils.isNotBlank(invoiceType)) {
                            if ("0".equals(invoiceType)) {
                                invoiceType = "普通发票";
                            }
                            if ("1".equals(invoiceType)) {
                                invoiceType = "增值税发票";
                            }
                            if ("2".equals(invoiceType)) {
                                invoiceType = "电子发票";
                            }
                        }
                        salesordermap.put("invoiceType", invoiceType);
                        salesordermap.put("supFax", String.valueOf(supplier.get(0).get(1)));
                    }
                    salesordermap.put("taxSw", String.valueOf(list1.get(25)));
                    salesordermap.put("taxRate", String.valueOf(list1.get(26)));
                    salesordermap.put("taxUnitprice", String.valueOf(list1.get(27)));
                    salesordermap.put("mQty", String.valueOf(list1.get(28)));
                    salesordermap.put("mUnit", String.valueOf(list1.get(29)));
                    salesorderlist.add(salesordermap);
                }
            } else {
                //如果有错误信息则返回
                Map<String, Object> o = (Map<String, Object>) list.get(0).get(0);
                Object errors = o.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }

    @Override
    public String update(Object object) {
        return null;
    }
}
